<?php

## Çıktı için değişken oluşturuyoruz
$result = [];

## Gerekli değişkenleri tanımlıyoruz
$saat_dakika = date("H:i");
$bugunlerden = date("w");

## Cronjob yapılandırmasını alıyoruz
$cronConfig = json_decode(($cron->json ?? "{}"));

## Varsayılan değerler
$yedekleme_saati     = "00:00"; 
$yedek_sayisi        = 7; 
$yedekleme_gunu      = 0;
$yedek_eposta_adresi = developer_email;
$otomatik_oturum_suresi = 30;
$otomatik_oturum_suresi_tipi = "minute";

## Otomatik SQL yedekleme ayarlarını kontrol ediyoruz
if(!empty($cronConfig->yedekleme_saati)): $yedekleme_saati = $cronConfig->yedekleme_saati; endif;
if(!empty($cronConfig->yedek_sayisi)): $yedek_sayisi = $cronConfig->yedek_sayisi; endif;
if(!empty($cronConfig->yedekleme_gunu)): $yedekleme_gunu = $cronConfig->yedekleme_gunu; endif;
if(!empty($cronConfig->yedek_eposta_adresi)): $yedek_eposta_adresi = $cronConfig->yedek_eposta_adresi; endif;
if(!empty($cronConfig->otomatik_oturum_suresi)): $otomatik_oturum_suresi = $cronConfig->otomatik_oturum_suresi; endif;
if(!empty($cronConfig->otomatik_oturum_suresi_tipi)): $otomatik_oturum_suresi_tipi = $cronConfig->otomatik_oturum_suresi_tipi; endif;

## Otomatik SQL yedekleme ayarlarını kontrol ediyoruz
if(isset($cronConfig->otomatik_sql_yedekleme) && $cronConfig->otomatik_sql_yedekleme=="on"):
    if($saat_dakika == $yedekleme_saati && ($yedekleme_gunu == 0 || $bugunlerden == $yedekleme_gunu)):
        $file_name = "../sql_backup_" . date("Y-d-m-") . time() . ".sql";
        $command = "mysqldump --user=".db_user." --password=".db_pass." --host=".db_host." ".db_name." > $file_name";
        shell_exec($command);
        if(file_exists($file_name)):
            $result[] = [
                "status" => "success",
                "process" => "sql_backup",
                "message" => "SQL yedeği başarıyla oluşturuldu: " . basename($file_name),
            ];
        else:
            $result[] = [
                "status" => "error",
                "process" => "sql_backup",
                "message" => "SQL yedeği oluşturulamadı.",
            ];
        endif;
        if(@$cronConfig->sql_yedegini_eposta_gonder=="on"):
            $subject = "SQL Yedeği - " . date("Y-m-d H:i") . " - " . db_name;
            $message = "SQL yedeğiniz başarıyla oluşturuldu ve e-posta ekine eklendi. <br> ". website;
            if(sendMail($yedek_eposta_adresi, $subject, $message, array($file_name))):
                $result[] = [
                    "status" => "success",
                    "process" => "sql_backup_email",
                    "message" => "SQL yedeği e-posta ile gönderildi.",
                ];
            else:
                $result[] = [
                    "status" => "error",
                    "process" => "sql_backup_email",
                    "message" => "SQL yedeği oluşturuldu ancak e-posta gönderilemedi.",
                ];
            endif;
        endif;
    endif;
endif;

## Yöneticilerin oturumlarını kontrol etme
if(isset($cronConfig->otomatik_oturum_sonlandirma) && $cronConfig->otomatik_oturum_sonlandirma=="on"):
    $sessions = fetchAll("user_sessions[id,created,token]",array("status" => 1));
    foreach($sessions as $session):
        $session_time = strtotime($session->created);
        $session_time = strtotime("+".$otomatik_oturum_suresi." ".$otomatik_oturum_suresi_tipi, $session_time);
        if($session_time < time()):
            if(update("user_sessions",array("status" => 0),array("id" => $session->id))):
                $result[] = [
                    "status" => "success",
                    "process" => "session_terminate",
                    "message" => "Oturum başarıyla sonlandırıldı. ID: " . $session->id,
                ];
            endif;
        endif;
    endforeach;
endif;

## Hatırlatma bilgilerini kontrol etme
if(isset($cronConfig->hatirlatma) && $cronConfig->hatirlatma=="on"):
    $stmt = $db->prepare("SELECT * FROM user_calendar WHERE start <= :today_end AND end >= :today_start AND remember = 1");
    $stmt->bindValue(':today_start', date("Y-m-d") . ' 00:00:00', PDO::PARAM_STR);
    $stmt->bindValue(':today_end', date("Y-m-d") . ' 23:59:59', PDO::PARAM_STR);
    $stmt->execute();
    $user_calendar = $stmt->fetchAll(PDO::FETCH_OBJ);
    foreach($user_calendar as $calendar):
        if($calendar->reminder_time ==  $saat_dakika):
            $user = fetch("users[id,name,surname,phone,email]", array("id" => $calendar->user));

            if(isset( $cronConfig->hatirlatma_sms) == "on"):
                $message = "Hatırlatma: " . $calendar->title . " - " . $calendar->description;
                sendSMS($user->phone, $message);
            endif;

            if(isset( $cronConfig->hatirlatma_eposta) == "on"):
                $subject = "Hatırlatma: " . $calendar->title;
                $message = "Hatırlatma: " . $calendar->title . "<br>" . $calendar->description;
                sendMail($user->email, $subject, $message);
            endif;

            if(isset( $cronConfig->hatirlatma_bildirim) == "on"):
                $notification = [
                    "user" => $calendar->user,
                    "title" => "Hatırlatma",
                    "description" => $calendar->title." başlıklı hatırlatmanızı unutmayın.",
                    "icon" => "la la-bell",
                    "color" => "info",
                ];
                create("user_notifications",$notification);
            endif;

            $result[] = [
                "status" => "success",
                "process" => "reminder_notification",
                "message" => "Hatırlatma bildirimi gönderildi. ID: " . $calendar->id,
            ];

        endif;
    endforeach;
endif;

## Fazla Yedekleri Silme
$backups = glob("../sql_backup_*.sql");
if(count($backups) >= $yedek_sayisi):
    $backups = array_slice($backups, 0, count($backups) - $yedek_sayisi);
    foreach($backups as $backup):
        if(file_exists($backup)):
            unlink($backup);
        endif;
    endforeach;
endif;

## Para birimi API'sini kontrol etme
if(date("i") == "00"):
    $currencyData = @json_decode(file_get_contents(currency_api), true);
    if($currencyData && isset($currencyData["USD"]["Buying"]) && isset($currencyData["EUR"]["Buying"])):
        $USD = number_format($currencyData["USD"]["Buying"],2);
        $EUR = number_format($currencyData["EUR"]["Buying"],2);
        $control = fetch("integrations", ["name" => "currency"]);
        if($control):
            $updateCurrency = update("integrations", ["json" => json_encode(["USD" => $USD, "EUR" => $EUR])], ["name" => "currency"]);
        else:
            $insertData = [
                "name" => "currency",
                "json" => json_encode(["USD" => $USD, "EUR" => $EUR]),
            ];
            $updateCurrency = create("integrations", $insertData);
        endif;
        if($updateCurrency):
            $result[] = [
                "status" => "success",
                "process" => "currency_update",
                "message" => "Kur bilgileri başarıyla güncellendi.",
            ];
        else:
            $existingCurrency = json_decode($control->json, true);
            if($existingCurrency["USD"] == $USD && $existingCurrency["EUR"] == $EUR):
                $result[] = [                                                                   
                    "status" => "info",
                    "process" => "currency_no_change",
                    "message" => "Kur bilgileri değişmedi, güncelleme yapılmadı.",
                ];
            else:
                $result[] = [
                    "status" => "error",
                    "process" => "currency_update_error",
                    "message" => "Kur bilgileri güncellenemedi.",
                ];
            endif;
        endif;
    else:
        $result[] = [
            "status" => "error",
            "process" => "currency_update",
            "message" => "Api'den para birimi bilgileri alınamadı.",
        ];
    endif;
endif;

## iletişim formu verilerini mail olarak gönderme
$admin_emails = "";   
$admin_phones = ""; 
foreach(fetchAll("users[permission,email,phone]") as $user):
    if($perm=fetch("user_permissions[authority]", array("id" => $user->permission))):
        if($perm->authority=="*" || strpos($perm->authority, "İletişim Mesajları") !== false):
            if(!empty($user->email) && filter_var($user->email, FILTER_VALIDATE_EMAIL)):
                $admin_emails .= $user->email . ",";
            endif;
            $admin_phones .= $user->phone . ",";
        endif;
    endif;
endforeach;
$admin_emails = trim($admin_emails, ",");
$admin_phones = trim($admin_phones, ",");   
foreach(fetchAll("feedback",array("to_email" =>0)) as $gondereilecek):
    $subject = website . " - İletişim Formu - #".time();
    $message = "Websiteniz üzerinden iletişim formu gönderildi.<br><br>";
    foreach(json_decode($gondereilecek->json, true) as $key => $value):
        if(!empty($value)):
            $message .= "<b>" . ucfirst($key) . ":</b> " . htmlspecialchars($value) . "<br>";
        endif;
    endforeach;
    $send_email = sendMail($admin_emails, $subject, $message);
    sendSms($admin_phones, $message);
    if($send_email):
        $result[] = [
            "status" => "success",
            "process" => "contact_form_email",
            "message" => "İletişim formu e-postası başarıyla gönderildi.",
        ];
        update("feedback", array("to_email" => 1), array("id" => $gondereilecek->id));
    else:
        $result[] = [
            "status" => "error",
            "process" => "contact_form_email_error",
            "message" => "İletişim formu e-postası gönderilemedi.",
        ];
    endif;
endforeach;

## Loglama işlemi
if(!empty($result)):
    $logFile = "../logs/cronjob.log";
    if(!file_exists($logFile)):
        file_put_contents($logFile, str_repeat("-", 40) . "\n");
    endif;
    foreach($result as $log):
        $logData  = "[Mesaj] : " . ($log['message'] ?? '-') . "\n";
        $logData .= "[Durum] : " . ($log['status'] ?? '-') . "\n";
        $logData .= "[İşlem] : " . ($log['process'] ?? '-') . "\n";
        $logData .= "[Tarih] : " . date("Y-m-d H:i:s") . "\n";
        $logData .= str_repeat("-", 40) . "\n";
        file_put_contents($logFile, $logData, FILE_APPEND);
    endforeach;
else:
    $result[] = [
        "status" => "info",
        "process" => "cronjob_no_action",
        "message" => "Cronjob işlemi için herhangi bir işlem yapılmadı.",
    ];
endif;

musteriTelefonlariGuncelle();

## Sonuçları JSON formatında döndürüyoruz
header('Content-Type: application/json');
echo json_encode($result,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
analyticsIPControl();