<?php

function analytics($content)
{
    ## Global
    global $db;

    ## Eğer ziyaretçi bot ise analytics kaydı yapma
    $bots = [
        'Googlebot', 'Bingbot', 'Slurp', 'DuckDuckBot', 'Baiduspider', 'YandexBot', 'Sogou', 'Exabot',
        'facebot', 'ia_archiver', 'pingdom', 'facebookexternalhit', 'Twitterbot'
    ];
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    foreach ($bots as $bot) {
        if (stripos($userAgent, $bot) !== false) {
            return; // Bot tespit edildi, analytics kaydı yapılmayacak
        }
    }

    ## User_Agent
    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    ## visitor - Güvenli bir ID oluşturuluyor
    if (!isset($_COOKIE['visitor'])): 
        $visitor = bin2hex(random_bytes(16)); // Daha güvenli bir Visitor ID
        setcookie('visitor', $visitor, time() + 60 * 60 * 24 * 365, "/"); 
    else: 
        $visitor = $_COOKIE['visitor']; 
    endif;

    ## IP - Proxy ve CDN arkasındaki doğru IP tespiti
    if (!empty($_SERVER['HTTP_CLIENT_IP'])): 
        $ip = $_SERVER['HTTP_CLIENT_IP']; 
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])): 
        // Cloudflare veya başka proxy'lerden gelen IP'yi doğrulama
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        $ip = explode(',', $ip)[0]; // İlk IP'yi al
    else: 
        $ip = $_SERVER['REMOTE_ADDR']; 
    endif;

    ## Referer - Güvenli ve doğru referer tespiti
    if (isset($_SERVER['HTTP_REFERER']) && filter_var($_SERVER['HTTP_REFERER'], FILTER_VALIDATE_URL)): 
        $refererHost = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);
        $currentHost = $_SERVER['HTTP_HOST'] ?? '';
        $referer = ($currentHost !== $refererHost) ? $_SERVER['HTTP_REFERER'] : 'direct';
    else: 
        $referer = 'direct'; 
    endif;

    ## referer içinde bu sitenin linki varsa referer'i direct yap
    if (strpos($referer, $_SERVER['HTTP_HOST']) !== false): 
        $referer = 'direct';
    endif;

    ## Device Detection - Tarayıcı ve cihazın daha doğru tespiti
    $device = 'desktop'; // Default
    if (preg_match('/mobile|iphone|ipod|android|blackberry|mini|windows\sce|palm/i', $user_agent)): 
        $device = 'mobile'; 
    elseif (preg_match('/tablet|ipad|playbook|silk/i', $user_agent)): 
        $device = 'tablet'; 
    endif;

    ## Browser Detection - Güncel tarayıcı tespiti
    $browser = 'Other'; 
    $browserPatterns = [
        'MSIE' => 'explorer',
        'Trident' => 'explorer',
        'Firefox' => 'firefox',
        'Chrome' => 'chrome',
        'Safari' => 'safari',
        'Opera' => 'opera',
        'Netscape' => 'netscape',
        'Edge' => 'edge',
        'Edg' => 'edge',
        'Vivaldi' => 'vivaldi',
        'SamsungBrowser' => 'samsung',
        'UC' => 'uc',
        'Maxthon' => 'maxthon',
    ];
    
    foreach ($browserPatterns as $pattern => $name): 
        if (preg_match("/$pattern/i", $user_agent)): 
            $browser = $name; 
            break; 
        endif; 
    endforeach;

    ## OS Detection - OS tespiti
    $os = 'other'; 
    if (preg_match('/android/i', $user_agent)): 
        $os = 'android'; 
    elseif (preg_match('/linux/i', $user_agent)): 
        $os = 'linux'; 
    elseif (preg_match('/macintosh|mac os x/i', $user_agent)): 
        $os = 'mac'; 
    elseif (preg_match('/windows|win32/i', $user_agent)): 
        $os = 'windows'; 
    elseif (preg_match('/iphone/i', $user_agent)): 
        $os = 'ios'; 
    endif;

    ## Analytics Tablosunda Kontrol Et ve Veri Ekle
    $control = $db->prepare("SELECT * FROM analytics WHERE visitor = :visitor AND content = :content AND created >= CURDATE() AND created < CURDATE() + INTERVAL 1 DAY");
    $control->execute(array("visitor" => $visitor, "content" => $content));

    if ($control->rowCount() == 0): 
        $insert = $db->prepare("INSERT INTO analytics SET visitor = :visitor, ip = :ip, referer = :referer, device = :device, browser = :browser, os = :os, content = :content");
        $insert->execute(array(
            "visitor" => $visitor, 
            "ip" => $ip, 
            "referer" => $referer, 
            "device" => $device, 
            "browser" => $browser, 
            "os" => $os, 
            "content" => $content
        ));
    else: 
        $update = $db->prepare("UPDATE analytics SET count = count + 1 WHERE visitor = :visitor AND content = :content AND created >= CURDATE() AND created < CURDATE() + INTERVAL 1 DAY");
        $update->execute(array("visitor" => $visitor, "content" => $content));    
    endif;
}

function analyticsIPControl()
{
    global $db;
    
    // NULL ülke ve şehir bilgisine sahip IP'leri al
    $query = $db->query("SELECT id, ip FROM analytics WHERE country IS NULL OR city IS NULL")->fetchAll(PDO::FETCH_OBJ);

    // Aynı IP'yi grupla
    $ips = [];
    foreach ($query as $data) {
        $ips[$data->ip][] = $data->id; // IP'yi anahtar olarak kullan ve ID'leri dizide tut
    }

    // IP'lerin ülke ve şehir bilgilerini al
    foreach ($ips as $ip => $ids) {
        // IP için dış API'den bilgi al
        $ip_info = json_decode(file_get_contents("http://ip-api.com/json/".$ip));
        
        // Eğer API başarılı bir sonuç döndürürse
        if($ip_info->status == "success") {
            // IP'ye bağlı tüm kayıtları güncelle
            $update = $db->prepare("UPDATE analytics SET country = :country, city = :city, code = :code WHERE ip = :ip AND id IN (" . implode(',', $ids) . ")");
            $update->execute([
                "country" => $ip_info->country, 
                "city" => $ip_info->city, 
                "code" => $ip_info->countryCode,
                "ip" => $ip
            ]);
        }
    }
}

function encrypt($data)
{
    return openssl_encrypt($data,"AES-128-ECB","29091999");
}

function decrypt($data)
{
    return openssl_decrypt($data,"AES-128-ECB","29091999");
}

function fetch($table, $where)
{
    global $db;

    $placeholders = [];
    $params = [];
    $orClauses = [];

    // Tablo adını ve sütunları ayır
    $tableParts = explode('[', $table);
    $tableName = $tableParts[0];
    $select = '*'; // Varsayılan olarak tüm sütunlar

    if (isset($tableParts[1])) {
        $columns = rtrim($tableParts[1], ']'); // Kapanış köşeli parantezini kaldır
        $select = $columns;
    }

    // WHERE koşullarını oluştur
    foreach ($where as $key => $value) {
        if (strpos($key, '[!]') !== false) {
            // Eşit değil operatörü veya NOT NULL kontrolü
            $column = str_replace('[!]', '', $key);
            if (is_null($value)) {
                $placeholders[] = "$column IS NOT NULL";
            } else {
                $placeholders[] = "$column != :$column";
                $params[$column] = $value;
            }
        } elseif (is_null($value)) {
            // NULL kontrolü
            $placeholders[] = "$key IS NULL";
        } elseif (strpos($key, '[or]') !== false) {
            // OR operatörü
            $columns = explode('[or]', $key);
            foreach ($columns as $column) {
                $orClauses[] = "$column = :$column";
                $params[$column] = $value;
            }
        } elseif (is_array($value)) {
            // IN operatörü
            $column = $key;
            $placeholders[] = "$column IN (" . implode(", ", array_fill(0, count($value), "?")) . ")";
            foreach ($value as $val) {
                $params[] = $val;
            }
        } else {
            // Varsayılan eşitlik kontrolü
            $placeholders[] = "$key = :$key";
            $params[$key] = $value;
        }
    }

    // WHERE cümlesini birleştir
    $whereClause = '';
    if (!empty($placeholders)) {
        $whereClause = implode(' AND ', $placeholders);
    }
    if (!empty($orClauses)) {
        $orCondition = implode(' OR ', $orClauses);
        $whereClause .= (!empty($whereClause) ? ' AND ' : '') . "($orCondition)";
    }

    // Sorguyu oluştur
    $queryStr = "SELECT $select FROM $tableName";
    if (!empty($whereClause)) {
        $queryStr .= " WHERE $whereClause";
    }

    // Veritabanı işlemini gerçekleştir
    try {
        $query = $db->prepare($queryStr);
        $query->execute($params);
        return $query->fetch(PDO::FETCH_OBJ);
    } catch (PDOException $e) {
        // Hata yönetimi
        // Log the error plus the query and params to help debugging
        error_log("Database Error: " . $e->getMessage());
        error_log("Query: " . $queryStr . " Params: " . json_encode($params));
        return false;
    }
}

function fetchAll($table, $where = array(), $order = array(), $limit = null)
{
    global $db;

    $placeholders = [];
    $params = [];
    $orClauses = [];
    $select = "*"; // Varsayılan olarak tüm sütunlar
    $limit = $limit ? "LIMIT $limit" : '';

    // Tablo ve kolon seçim kontrolü
    if (strpos($table, "[") !== false) {
        $tableParts = explode("[", $table);
        $table = $tableParts[0];
        $select = rtrim($tableParts[1], "]"); // Köşeli parantez içeriğini al
    }

    // WHERE şartlarını oluştur
    foreach ($where as $key => $value) {
        if (strpos($key, '[!]') !== false) {
            // Eşit değil operatörü veya NOT NULL kontrolü
            $column = str_replace('[!]', '', $key);
            if (is_null($value)) {
                $placeholders[] = "$column IS NOT NULL";
            } else {
                $placeholders[] = "$column != :$column";
                $params[$column] = $value;
            }
        } elseif (is_null($value)) {
            // NULL kontrolü
            $placeholders[] = "$key IS NULL";
        } elseif (strpos($key, '[or]') !== false) {
            // OR operatörü
            $columns = explode('[or]', $key);
            foreach ($columns as $column) {
                $orClauses[] = "$column = :$column";
                $params[$column] = $value;
            }
        } elseif (is_array($value)) {
            // Birden fazla değer kontrolü (IN operatörü)
            $column = $key;
            $placeholders[] = "$column IN (" . implode(", ", array_fill(0, count($value), "?")) . ")";
            foreach ($value as $index => $val) {
                $params[] = $val; // Parametreleri sırasıyla ekle
            }
        } else {
            // Varsayılan eşitlik kontrolü
            $placeholders[] = "$key = :$key";
            $params[$key] = $value;
        }
    }

    // WHERE cümlesini birleştir
    $whereClause = '';
    if (!empty($placeholders)) {
        $whereClause = implode(' AND ', $placeholders);
    }
    if (!empty($orClauses)) {
        $orCondition = implode(' OR ', $orClauses);
        $whereClause .= (!empty($whereClause) ? ' AND ' : '') . "($orCondition)";
    }

    // ORDER BY cümlesini oluştur
    $orderClause = '';
    if (!empty($order)) {
        $orderParts = [];
        foreach ($order as $column => $direction) {
            // Yön (ASC veya DESC) kontrolü
            $direction = strtoupper($direction);
            if ($direction !== 'ASC' && $direction !== 'DESC') {
                $direction = 'ASC'; // Varsayılan olarak ASC
            }
            $orderParts[] = "$column $direction";
        }
        $orderClause = 'ORDER BY ' . implode(', ', $orderParts);
    }

    // Sorguyu birleştir
    $queryStr = "SELECT $select FROM $table";
    if (!empty($whereClause)) {
        $queryStr .= " WHERE $whereClause";
    }
    if (!empty($orderClause)) {
        $queryStr .= " $orderClause";
    }

    // Veritabanı işlemi
    try {
        $query = $db->prepare($queryStr . " $limit");
        $query->execute($params);
        return $query->fetchAll(PDO::FETCH_OBJ);
    } catch (PDOException $e) {
        // Hata yönetimi
        // Log the error plus the query and params to help debugging
        error_log("Database Error: " . $e->getMessage());
        error_log("Query: " . $queryStr . " $limit Params: " . json_encode($params));
        return false;
    }
}

function rowCount($table,$filter=array())
{
    global $db;
    $placeholders = array();
    $params = array();
    $orClauses = array();
    
    foreach ($filter as $key => $value) {
        if (strpos($key, '[!]') !== false) {
            $column = str_replace('[!]', '', $key);
            $placeholders[] = "$column != :$column";
            $params[$column] = $value;
        } elseif (strpos($key, '[or]') !== false) {
            $columns = explode('[or]', $key);
            foreach ($columns as $column) {
                $orClauses[] = "$column = :$column";
                $params[$column] = $value;
            }
        } else {
            $placeholders[] = "$key = :$key";
            $params[$key] = $value;
        }
    }

    $whereClause = '';
    if (!empty($placeholders)) {
        $whereClause = implode(' AND ', $placeholders);
    }
    if (count($orClauses)) {
        if (!empty($whereClause)) {
            $whereClause .= ' AND (' . implode(' OR ', $orClauses) . ')';
        } else {
            $whereClause = '(' . implode(' OR ', $orClauses) . ')';
        }
    }

    $queryStr = "SELECT COUNT(id) FROM $table" . (strlen($whereClause) ? " WHERE $whereClause" : '');
    $query = $db->prepare($queryStr);
    $query->execute($params);
    return $query->fetchColumn();
 
}

function create($table,$data,$log=1)
{
    global $db;
    $prepare = '';
    foreach ($data as $key => $value) { 
        $prepare .= "$key=:" . $key . ",";
    }
    $prepare = rtrim($prepare, ',');
    $query = $db->prepare("INSERT INTO $table SET $prepare");
    $insert = $query->execute($data);
    if ($insert) {
        
        $lastID = $db->lastInsertId();
        $data['id'] = $lastID;
            if($log):
                record($table,"create",$data);
            endif;
        return $lastID;
    }
    return false;
}

function update($table,$data,$conditions,$log=1)
{
    global $db;
    $set = array();
    $where = array();
    $whereTwo = array();
    foreach ($data as $key => $value) { 
        $set[] = "$key = :{$key}_set"; 
    }
    foreach ($conditions as $key => $value) { 
        $where[] = "$key = :{$key}_where"; 
    }
    foreach ($conditions as $key => $value) { 
        $whereTwo[] = "$key = :{$key}"; 
    }
    $set = implode(', ', $set);
    $where = implode(' AND ', $where);
    $whereTwo = implode(' AND ', $whereTwo);
    $params = array_merge(
        array_combine(array_map(function ($k) { return $k . '_set'; }, array_keys($data)), $data),
        array_combine(array_map(function ($k) { return $k . '_where'; }, array_keys($conditions)), $conditions)
    );
    $previousData = array();
    $query = $db->prepare("SELECT * FROM $table WHERE $whereTwo");
    $query->execute($conditions);
    $previousData = $query->fetch(PDO::FETCH_ASSOC);
    $stmt = $db->prepare("UPDATE $table SET $set WHERE $where");
    $stmt->execute($params); 
    $result = $stmt->rowCount();
    if ($result > 0) {
        $changedData = array();
        foreach ($data as $key => $value) {
            if (isset($previousData[$key]) && $previousData[$key] !== $value) {
                if (!is_numeric($previousData[$key]) && !is_numeric($value)) {
                    if ($previousData[$key] !== $value) {
                        $changedData[$key] = $value;
                    }
                } elseif ($previousData[$key] != $value) {
                    $changedData[$key] = $value;
                }
            }
        }
        if (!empty($changedData)) {
            if (isset($previousData['id'])) {
                $changedData['id'] = $previousData['id'];
            }
            if($log):
                record($table,"update",$changedData);
            endif;
        }
    }
    return $result;
}

function delete($table,$where,$log=1)
{
    global $db;
    $placeholders = array();
    $params = array();
    $orClauses = array();
    foreach ($where as $key => $value) {
        if (strpos($key, '[!]') !== false) {
            $column = str_replace('[!]', '', $key);
            $placeholders[] = "$column != :$column";
            $params[$column] = $value;
        } elseif (strpos($key, '[or]') !== false) {
            $columns = explode('[or]', $key);
            foreach ($columns as $column) {
                $orClauses[] = "$column = :$column";
                $params[$column] = $value;
            }
        } else {
            $placeholders[] = "$key = :$key";
            $params[$key] = $value;
        }
    }
    $whereClause = '';
    if (!empty($placeholders)) {
        $whereClause = implode(' AND ', $placeholders);
    }
    if (count($orClauses)) {
        if (!empty($whereClause)) {
            $whereClause .= ' AND (' . implode(' OR ', $orClauses) . ')';
        } else {
            $whereClause = '(' . implode(' OR ', $orClauses) . ')';
        }
    }
    $queryStr = "DELETE FROM $table" . (strlen($whereClause) ? " WHERE $whereClause" : '');
    $query = $db->prepare($queryStr);
    $query->execute($params);
    $result = $query->rowCount();
    if($result > 0):
        if($log):
            record($table,"delete",$where);
        endif;
    endif;
    return $result;
}

function record($table,$type,$detail)
{
    global $db;
    $not_allowed_types = array();
    $not_allowed_tables = array("user_notifications");
    if(in_array($table,$not_allowed_tables) || in_array($type,$not_allowed_types)) return false;

    $user = null;
    $ip_address = $_SERVER['REMOTE_ADDR'];

    if(isset($_COOKIE['manager'])):
        $session_control = fetch("user_sessions[user]",array("token" => $_COOKIE['manager']));
        if($session_control):
            $user = $session_control->user;
        endif;
    endif;  

    $create_data = array(
        "user" => $user,
        "table_name" => $table,
        "type" => $type,
        "ip_address" => $ip_address,
        "detail" => json_encode($detail,JSON_UNESCAPED_UNICODE),
    );

    create("user_records",$create_data,0);

}

function sendMail($to, $subject, $message, $files = false)
{
    require_once "phpmailer.php";
    $default_smtp = [
        "host" => "mail.baykus.pro",
        "user" => "otomatik@baykus.pro",
        "pass" => "EaVCHl+t}g4+y6JM",
        "port" => 587,
        "secure" => "TLS",
    ];
    $control = fetch("integrations", ["name" => "smtp"]);
    $use_default = true;
    if ($control) {
        @$json = json_decode($control->json, true);
        if (@$json['status']) {
            $use_default = false;
            $smtp_config = [
                "host" => $json['host'],
                "user" => $json['email'],
                "pass" => $json['password'],
                "port" => $json['port'],
                "secure" => $json['secure'],
            ];
        }
    }
    if ($use_default) {
        $smtp_config = $default_smtp;
    }
    $mail = new PHPMailer\PHPMailer\PHPMailer(true);
    try {
        $mail->CharSet = 'UTF-8';
        $mail->setLanguage('tr', 'phpmailer/language');
        $mail->IsSMTP();
        $mail->SMTPDebug = false;
        $mail->Host = $smtp_config['host'];
        $mail->SMTPAuth = true;
        $mail->Username = $smtp_config['user'];
        $mail->Password = $smtp_config['pass'];
        $mail->SMTPSecure = $smtp_config['secure'];
        $mail->Port = $smtp_config['port'];
        $mail->setFrom($smtp_config['user'], $smtp_config['user']);
        if (strpos($to, ",") !== false) {
            $to = explode(",", $to);
            foreach ($to as $email) {
                $mail->addAddress($email);
            }
        } else {
            $mail->addAddress($to);
        }
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;
        if ($files) {
            foreach ($files as $file) {
                $mail->addAttachment($file);
            }
        }
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Mailer Error: " . $mail->ErrorInfo);
        return false;
    }
}

function sendSms($to,$message)
{
    $control = fetch("integrations[json]",array("name"=>"sms"));
    if($control):
        $json = json_decode($control->json,true);
        if(isset($json['status']) && $json['status']):

            if($json['api'] == "Netgsm"):

                function HTTPPoster($prmPostAddress,$prmSendData){
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL,$prmPostAddress); 
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER,TRUE); 
                    curl_setopt($ch, CURLOPT_TIMEOUT, 30); 
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));			
                    curl_setopt($ch, CURLOPT_HEADER, 0);
                    curl_setopt($ch, CURLOPT_POST, TRUE);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $prmSendData); 
                    $result = curl_exec($ch);
                    return $result;
                }

                // print_r($to); Array ( [0] => +90 531 520 89 61 ) string(2) "05"

                // Ensure $to is a comma separated list of digits and sanitize each number
                if (is_array($to)) {
                    $to_numbers = implode(',', array_filter(array_map(function($n){
                        $n = trim($n);
                        $digits = preg_replace('/\D+/', '', $n);
                        return $digits !== '' ? $digits : null;
                    }, $to)));
                } else {
                    $to_numbers = preg_replace('/\D+/', '', trim($to));
                }

                // Wrap message in CDATA to prevent XML parsing issues with special chars
                $message_cdata = "<![CDATA[" . $message . "]]>";

                $post_verisi = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
                    <MainmsgBody>
                        <UserName>".$json['username']."</UserName>
                        <PassWord>".$json['password']."</PassWord>
                        <Action>12</Action>
                        <Mesgbody>".$message_cdata."</Mesgbody>
                        <Numbers>".$to_numbers."</Numbers>
                        <Originator>".$json['title']."</Originator>
                        <SDate></SDate>
                    </MainmsgBody>";


                return $result = HTTPPoster("https://g3.iletimx.com", $post_verisi);
            endif;



        endif;
    endif;
}

function slugify($str)
{
    $defaults = [
        'delimiter' => '-',
        'limit' => null,
        'lowercase' => true,
        'replacements' => [],
        'transliterate' => true
    ];
    $options = array_merge($defaults, is_array($str) ? $str : []);
    $char_map = [
        'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C',
        'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I',
        'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ő' => 'O',
        'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ű' => 'U', 'Ý' => 'Y', 'Þ' => 'TH',
        'ß' => 'ss',
        'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c',
        'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',
        'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'ő' => 'o',
        'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'ű' => 'u', 'ý' => 'y', 'þ' => 'th',
        'ÿ' => 'y',
        '©' => '(c)',
        
        // Greek characters
        'Α' => 'A', 'Β' => 'B', 'Γ' => 'G', 'Δ' => 'D', 'Ε' => 'E', 'Ζ' => 'Z', 'Η' => 'H', 'Θ' => 'TH',
        'Ι' => 'I', 'Κ' => 'K', 'Λ' => 'L', 'Μ' => 'M', 'Ν' => 'N', 'Ξ' => 'X', 'Ο' => 'O', 'Π' => 'P',
        'Ρ' => 'R', 'Σ' => 'S', 'Τ' => 'T', 'Υ' => 'Y', 'Φ' => 'F', 'Χ' => 'CH', 'Ψ' => 'PS', 'Ω' => 'O',
        'α' => 'a', 'β' => 'b', 'γ' => 'g', 'δ' => 'd', 'ε' => 'e', 'ζ' => 'z', 'η' => 'h', 'θ' => 'th',
        'ι' => 'i', 'κ' => 'k', 'λ' => 'l', 'μ' => 'm', 'ν' => 'n', 'ξ' => 'x', 'ο' => 'o', 'π' => 'p',
        'ρ' => 'r', 'σ' => 's', 'τ' => 't', 'υ' => 'y', 'φ' => 'f', 'χ' => 'ch', 'ψ' => 'ps', 'ω' => 'o',

        // Turkish characters
        'Ğ' => 'G', 'ğ' => 'g', 'İ' => 'I', 'ı' => 'i', 'Ş' => 'S', 'ş' => 's', 'Ç' => 'C', 'ç' => 'c',
        'Ö' => 'O', 'ö' => 'o', 'Ü' => 'U', 'ü' => 'u',

        // Russian characters
        'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'E', 'Ж' => 'ZH',
        'З' => 'Z', 'И' => 'I', 'Й' => 'Y', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O',
        'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'KH', 'Ц' => 'TS',
        'Ч' => 'CH', 'Ш' => 'SH', 'Щ' => 'SCH', 'Ы' => 'Y', 'Э' => 'E', 'Ю' => 'YU', 'Я' => 'YA',
        'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'e', 'ж' => 'zh',
        'з' => 'z', 'и' => 'i', 'й' => 'y', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o',
        'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'kh', 'ц' => 'ts',
        'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch', 'ы' => 'y', 'э' => 'e', 'ю' => 'yu', 'я' => 'ya',

        // Ukrainian characters
        'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'H', 'Ґ' => 'G', 'Д' => 'D', 'Е' => 'E', 'Є' => 'Ye',
        'Ж' => 'Zh', 'З' => 'Z', 'И' => 'Y', 'І' => 'I', 'Ї' => 'Yi', 'Й' => 'Y', 'К' => 'K', 'Л' => 'L',
        'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U',
        'Ф' => 'F', 'Х' => 'Kh', 'Ц' => 'Ts', 'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sch', 'Ь' => '', 'Ю' => 'Yu',
        'Я' => 'Ya',
        'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'h', 'ґ' => 'g', 'д' => 'd', 'е' => 'e', 'є' => 'ye',
        'ж' => 'zh', 'з' => 'z', 'и' => 'y', 'і' => 'i', 'ї' => 'yi', 'й' => 'y', 'к' => 'k', 'л' => 'l',
        'м' => 'm', 'н' => 'n', 'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u',
        'ф' => 'f', 'х' => 'kh', 'ц' => 'ts', 'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch', 'ь' => '', 'ю' => 'yu',
        'я' => 'ya',

        // Polish characters
        'Ą' => 'A', 'Ć' => 'C', 'Ę' => 'E', 'Ł' => 'L', 'Ń' => 'N', 'Ó' => 'O', 'Ś' => 'S', 'Ź' => 'Z', 'Ż' => 'Z',
        'ą' => 'a', 'ć' => 'c', 'ę' => 'e', 'ł' => 'l', 'ń' => 'n', 'ó' => 'o', 'ś' => 's', 'ź' => 'z', 'ż' => 'z',

        // Latvian characters
        'Ā' => 'A', 'Č' => 'C', 'Ē' => 'E', 'Ģ' => 'G', 'Ī' => 'I', 'Ķ' => 'K', 'ļ' => 'l', 'Ņ' => 'N', 'Š' => 'S', 'Ū' => 'U',
        'Ž' => 'Z', 'ā' => 'a', 'č' => 'c', 'ē' => 'e', 'ģ' => 'g', 'ī' => 'i', 'ķ' => 'k', 'ļ' => 'l', 'ņ' => 'n', 'š' => 's',
        'ū' => 'u', 'ž' => 'z',

        // Arabic
        'ا' => 'a', 'أ' => 'a', 'إ' => 'i', 'آ' => 'a', 'ؤ' => 'w', 'ئ' => 'y', 'ء' => 'a', 'ب' => 'b', 'ت' => 't',
        'ث' => 'th', 'ج' => 'j', 'ح' => 'h', 'خ' => 'kh', 'د' => 'd', 'ذ' => 'th', 'ر' => 'r', 'ز' => 'z', 'س' => 's',
        'ش' => 'sh', 'ص' => 's', 'ض' => 'd', 'ط' => 't', 'ظ' => 'z', 'ع' => 'a', 'غ' => 'gh', 'ف' => 'f', 'ق' => 'q',
        'ك' => 'k', 'ل' => 'l', 'م' => 'm', 'ن' => 'n', 'ه' => 'h', 'و' => 'w', 'ي' => 'y', 'ى' => 'a', 'ة' => 'a',
        'ﻻ' => 'la', 'ﻷ' => 'laa', 'ﻹ' => 'lai', 'ﻵ' => 'laa',



    ];

    // Apply custom replacements first
    if (!empty($options['replacements'])) {
        $str = strtr($str, $options['replacements']);
    }

    // Transliterate characters to ASCII if enabled
    if ($options['transliterate']) {
        $str = strtr($str, $char_map);
    }

    // Replace non-alphanumeric characters with the delimiter
    $str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);

    // Remove duplicate delimiters
    $str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);

    // Truncate the string to the specified limit
    if ($options['limit']) {
        $str = mb_substr($str, 0, $options['limit'], 'UTF-8');
    }

    // Trim the delimiter from the beginning and end
    $str = trim($str, $options['delimiter']);

    // Convert to lowercase if required
    return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
}

function turkishPhoneNumber($phone)
{
    $cleanedPhone = preg_replace('/\D+/', '', $phone);
    if (strpos($cleanedPhone, '90') === 0) {
        $cleanedPhone = '+' . $cleanedPhone;
    } elseif (strpos($cleanedPhone, '0') === 0) {
        $cleanedPhone = '+90' . substr($cleanedPhone, 1);
    } elseif (strpos($cleanedPhone, '5') === 0) {
        $cleanedPhone = '+90' . $cleanedPhone;
    }
    return preg_replace('/(\+90)(5[0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '$1 $2 $3 $4 $5', $cleanedPhone);
}

function variable($code,$id)
{
    $control = fetch("language_variables",["code"=>$code,"language"=>$id]);
    if($control):
        return $control->translate;
    else:
        return (rowCount("languages") == 1) ? $code : "{" . $code . "}";
    endif;
}

function defaultLanguage()
{
    $is_default = fetch("languages[id,code]",array("is_default"=>1));
    $content_translations = fetchAll("content_translations[id,language,url]");
    foreach ($content_translations as $content_translation):
        $data = array();
        $data['id'] = $content_translation->id;
        $language = fetch("languages[id,code]",array("id"=>$content_translation->language));
        if($language->id == $is_default->id):
            if(strpos($content_translation->url,"/".$language->code."/") === 0):
                $data['url'] = str_replace("/".$language->code."/","/",$content_translation->url);
            endif;
        else:
            if(strpos($content_translation->url,"/".$language->code."/") !== 0):
                $data['url'] = "/".$language->code.$content_translation->url;
            endif;
        endif;
        if(isset($data['url'])):
            $data['url'] = rtrim($data['url'], '/');
        else:
            $data['url'] = "/";
        endif;
        update("content_translations",['url'=>$data['url']],["id"=>$data['id']],0);
    endforeach;
    cacheRoute();
}

function ipBanControl() 
{
    $ip_ban = fetch("integrations[json]",array("name" => "ip_ban"));
    if($ip_ban):
        $ip_ban = json_decode($ip_ban->json);
        if(isset($ip_ban->status)):
            $ip_ban->ips = explode("\n",$ip_ban->ips);
            if($ip_ban->type == 1):
                if(in_array($_SERVER["REMOTE_ADDR"],$ip_ban->ips)):
                    header("HTTP/1.0 404 Not Found");
                    exit;
                endif;
            endif;
            if($ip_ban->type == 2):
                if(!in_array($_SERVER["REMOTE_ADDR"],$ip_ban->ips)):
                    header("HTTP/1.0 404 Not Found");
                    exit;
                endif;
            endif;
        endif;
    endif;
}

function cacheRoute()
{
    $routes = "<?php\n\n";
    $routes .= "Router::post('/ajax', 'frontend@ajax');\n";
    $routes .= "Router::get('/sitemap.xml', 'frontend@sitemap');\n";
    foreach(fetchAll("contents", array("status" => 1)) as $data){
        foreach(fetchAll("content_translations", array("content" => $data->id)) as $translate){
            $url = addslashes($translate->url);
            $type = addslashes($translate->type);
            $routes .= "Router::get('$url', 'frontend@$type');\n";
        }
    }
    file_put_contents('view/frontend/common/router.php', $routes);
}

function musteriTelefonlariGuncelle() {

    global $db;
    $users = $db->query("SELECT * FROM customers")->fetchAll(PDO::FETCH_OBJ);

    $phones = [];

    foreach ($users as $user) {
        $originalPhone = trim($user->phone);
        if (empty($originalPhone)) continue;

        // İlk olarak mevcut formatı regex ile kontrol et
        $isValid = preg_match('/^(\+90\s?|90\s?|0?)?5[0-9]{2}\s?[0-9]{3}\s?[0-9]{2}\s?[0-9]{2}$/', $originalPhone);

        // Eğer doğrudan geçerli değilse, sadece sayıları alıp tekrar dene
        if (!$isValid) {
            $digits = preg_replace('/\D+/', '', $originalPhone);
            if (!empty($digits)) {
                // 5xxxxxxxxx veya 90... şeklinde gelenleri kabul et
                if (preg_match('/^(90)?5[0-9]{9}$/', $digits) || preg_match('/^5[0-9]{9}$/', $digits)) {
                    $originalPhone = $digits;
                    $isValid = 1;
                }
            }
        }

        if ($isValid) {
            // Normalize et
            $normalized = turkishPhoneNumber($originalPhone);
            // Veritabanındaki değeri güncelle (sadece değiştiyse)
            if ($normalized !== $user->phone) {
                update("customers", ["phone" => $normalized], ["id" => $user->id], 0);
            }
            $phones[] = $normalized;
        }
    }

    // Benzersiz ve temiz telefon listesi
    $phones = array_values(array_unique(array_filter($phones)));

    if (empty($phones)) return;

    $groupName = "Müşteriler (Otomatik)";
    $phonesStr = implode(",", $phones);
    $count = count($phones);

    // Var ise güncelle yoksa oluştur
    $existing = fetch("newsletters[id]", ["name" => $groupName]);
    if ($existing) {
        update("newsletters", [
            "phones" => $phonesStr,
            "count" => $count
        ], ["id" => $existing->id], 0);
    } else {
        create("newsletters", [
            "name" => $groupName,
            "phones" => $phonesStr,
            "count" => $count
        ], 0);
    }
}


