<?php

class Router 
{
    private static $error = true;

    public static function get($path, $controller)
    {
        self::run("GET", $path, $controller);
    }

    public static function post($path, $controller)
    {
        self::run("POST", $path, $controller);
    }

    public static function ERROR()
    {
        if (self::$error == true) {
            $error_404 = "../logs/404.log";
            if(!file_exists($error_404)):
                file_put_contents($error_404,"");
            endif;
            $errorMessage = "Hata: " . $_SERVER['REQUEST_METHOD'] . " " . $_SERVER['REQUEST_URI'] . " adresine erişim sağlanamadı.";
            file_put_contents($error_404, date("Y-m-d H:i:s") . " - " . $_SERVER['REMOTE_ADDR'] . " - " . $errorMessage . "\n", FILE_APPEND);
            http_response_code(404);
            require "view/backend/layout/404.php";
            exit;
        }
    }

    public static function run($method, $path, $controller)
    {
        $requestMethod = $_SERVER['REQUEST_METHOD'];
        $requestPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $pattern = str_replace('/', '\/', $path);
        $pattern = '/^' . str_replace('(*)', '([^\/]+)', $pattern) . '\/?$/';
        if ($requestMethod == $method && @preg_match($pattern, $requestPath, $matches)) {
            $controllerParts = explode('@', $controller);
            $className = $controllerParts[0];
            $methodName = $controllerParts[1];
            if (class_exists($className)) {
                $instance = new $className();
                if (method_exists($instance, $methodName)) {
                    array_shift($matches);
                    call_user_func_array([$instance, $methodName], $matches);
                    self::$error = false;
                    
                    return;
                } else {
                    echo '<link rel="stylesheet" href="/view/backend/assets/css/router.css">';
                    die("<h1>Hata: <b>$className</b> sınıfında <b>$methodName</b> yöntemi bulunamadı.</h1>");
                }
            } else {
                echo '<link rel="stylesheet" href="/view/backend/assets/css/router.css">';
                die("<h1>Hata: <b>$className</b> sınıfı bulunamadı.</h1>");
            } 
        }
    }
}


