<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="appointments" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-appointment-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Randevu</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <td><div class="cb"><input class="check-all" type="checkbox"></div></td>
                            <th>ID</th>
                            <th>Müşteri</th>
                            <th>Telefon</th>
                            <th>Tarih / Saat</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                    <input type="date" name="start_date" id="start_date" class="form-control">
                </div>
                <div class="mb-3">
                    <label for="end_date" class="form-label">Bitiş Tarihi</label>
                    <input type="date" name="end_date" id="end_date" class="form-control">
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val()
            };
        }

        $('input,select').change(function() {
            $('#filter-button').click();
        });

        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "appointments",
                        "start_date": filters.start_date,
                        "end_date": filters.end_date
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "id" },
                { "data": "customer_name" },
                { "data": "phone" },
                { "data": "start_at" },
                { "data": "status" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "orderable": false,
                    "searchable": false,
                    "className": "text-center",
                    "render": function(data) {
                       return `<div class="cb"><input class="check-item" type="checkbox" value="${data}"></div>`;
                    }
                },
                {
                    "targets": 1,
                    "className": "text-center",
                    "render": function(data) { return data; }
                },
                {
                    "targets": 2,
                    "className": "text-left"
                },
                {
                    "targets": 3,
                    "className": "text-center"
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "render": function(data) { if(!data) return ''; return data.slice(0,16); }
                },
                {
                    "targets": 5,
                    "className": "text-center",
                    "render": function(data){ return data==1 ? '<span class="badge bg-success">Onaylı</span>' : '<span class="badge bg-secondary">Beklemede</span>'; }
                },
                {
                    "targets": 6,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="editAppointment(${data})" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="appointments" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                    }
                }
            ]
        });

        $('#filter-button').click(function() { table.ajax.reload(); });

        // populate customer select for create modal
        window.loadCustomersToSelect = function(selector, cb) {
            $.post('/baykus/datatable', { action: 'customers', start:0, length:1000, draw:1 }, function(res){
                try{ var json = typeof res === 'string' ? JSON.parse(res) : res; } catch(e){ if(typeof cb === 'function') cb(); return; }
                var data = json.data || [];
                var $sel = $(selector);
                $sel.empty();
                $sel.append('<option value="">Seçiniz</option>');
                data.forEach(function(item){
                    var name = (item.first_name||'') + ' ' + (item.last_name||'');
                    $sel.append(`<option value="${item.id}">${name} (${item.phone||''})</option>`);
                });
                if(typeof cb === 'function') cb();
            });
        }

    // open modal -> load customers
    $('#create-appointment-modal').on('show.bs.modal', function(){ loadCustomersToSelect('#create_customer'); });
    });

    function editAppointment(id){
        $.post('/baykus/ajax',{ action: 'veri-oku', type: 'fetch', table: 'appointments', where: 'id', value: id }, function(res){
            var data;
            try{ data = (typeof res === 'string') ? JSON.parse(res) : res; } catch(e){ return; }
            if(!data) return;

            // set id and other fields (except customer select)
            $('#edit-appointment-modal input[name="id"]').val(data.id);

            // split start_at into date/time
            if(data.start_at){
                var parts = data.start_at.split(' ');
                $('#edit-appointment-modal input[name="date"]').val(parts[0] || '');
                if(parts[1]){
                    var t = parts[1].substring(0,5);
                    $('#edit-appointment-modal input[name="time"]').val(t);
                }
            }

            // compute duration from end_at if present
            if(data.end_at){
                var start = new Date(data.start_at);
                var end = new Date(data.end_at);
                var diffMins = Math.round((end - start) / 60000);
                if(!isNaN(diffMins)) $('#edit-appointment-modal input[name="duration"]').val(diffMins);
            } else {
                $('#edit-appointment-modal input[name="duration"]').val(30);
            }

            $('#edit-appointment-modal textarea[name="note"]').val(data.note || '');
            $('#edit-appointment-modal select[name="status"]').val(data.status || 1);

            // Load customers into edit select, then set value and show modal to avoid race
            loadCustomersToSelect('#edit_customer', function(){
                var $sel = $('#edit_customer');
                $sel.val(data.customer).trigger('change');
                $('#edit-appointment-modal').modal('show');
            });
        });
    }
</script>

<!-- create appointment modal -->
<div class="modal fade" id="create-appointment-modal" tabindex="-1" aria-labelledby="createAppointmentLabel" aria-hidden="true">
    <div class="modal-dialog">
    <form class="ajax-form modal-content" action="randevu-olustur">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="createAppointmentLabel">Randevu Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="customer" class="form-label">Müşteri</label>
                    <select name="customer" id="create_customer" class="form-control" zorunlu></select>
                </div>
                <div class="mb-3">
                    <label for="date" class="form-label">Tarih</label>
                    <input type="date" name="date" id="date" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="time" class="form-label">Saat</label>
                    <input type="time" name="time" id="time" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="duration" class="form-label">Süre (dakika)</label>
                    <input type="number" name="duration" id="duration" class="form-control" value="30">
                </div>
                <div class="mb-3">
                    <label for="note" class="form-label">Not</label>
                    <textarea name="note" id="note" class="form-control"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- edit appointment modal -->
<div class="modal fade" id="edit-appointment-modal" tabindex="-1" aria-labelledby="editAppointmentLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="randevu-guncelle">
            <input type="hidden" name="id" value="">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="editAppointmentLabel">Randevu Düzenle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="customer" class="form-label">Müşteri</label>
                    <select name="customer" id="edit_customer" class="form-control" zorunlu></select>
                </div>
                <div class="mb-3">
                    <label for="date" class="form-label">Tarih</label>
                    <input type="date" name="date" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="time" class="form-label">Saat</label>
                    <input type="time" name="time" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="duration" class="form-label">Süre (dakika)</label>
                    <input type="number" name="duration" class="form-control" value="30">
                </div>
                <div class="mb-3">
                    <label for="note" class="form-label">Not</label>
                    <textarea name="note" class="form-control"></textarea>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Durum</label>
                    <select name="status" class="form-control">
                        <option value="1">Onaylı</option>
                        <option value="0">Beklemede</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Güncelle</div>
                </button>
            </div>
        </form>
    </div>
</div>
