$(document).ready(function() {
    $(document).on('submit', '.ajax-form', function() {
        const form = $(this);
        const formData = new FormData(form[0]);
        const action =  form.attr('action');
        formData.append('action', action);
        form.find('[zorunlu]').each(function(){
            if ($(this).val() === '') {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
        if (form.find('.is-invalid').length > 0) {
            form.find('.is-invalid').first().focus();
            return false;
        }
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            beforeSend: function(){
                form.addClass('loading');
            },
            success: function(response)
            {
                form.removeClass('loading');
                const allowOutsideClickResult = response.location || response.refresh || response.back ? false : true;
                if(response.formReset) form[0].reset();
                if(response.closeModal) $('.modal').modal('hide');
                if(response.datatableReload) { var table = $('table').DataTable(); table.state.save(); table.ajax.reload(null, false); }
                if(response.newslettersAjaxGroups){ newslettersAjaxGroups(); }
                if(response.sweetAlert){
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        html: response.description,
                        timerProgressBar: true,
                        timer: response.timer,
                        showConfirmButton: response.confirmButtonText ? true : false,
                        confirmButtonText: response.confirmButtonText,
                        allowOutsideClick: allowOutsideClickResult,
                        heightAuto: false
                    });
                }
                if (response.download) {
                    const fileUrl = response.download;
                    let overlay = document.getElementById('download-overlay');
                    if (!overlay) {
                        overlay = document.createElement('div');
                        overlay.id = 'download-overlay';
                        overlay.style.position = 'fixed';
                        overlay.style.top = '0';
                        overlay.style.left = '0';
                        overlay.style.width = '100vw';
                        overlay.style.height = '100vh';
                        overlay.style.background = 'rgb(255 255 255 / 50%)';
                        overlay.style.backdropFilter = 'blur(8px)';
                        overlay.style.display = 'flex';
                        overlay.style.alignItems = 'center';
                        overlay.style.justifyContent = 'center';
                        overlay.style.zIndex = '9999';
                        const statusDiv = document.createElement('div');
                        statusDiv.id = 'download-status';
                        statusDiv.style.background = '#0d6efd';
                        statusDiv.style.color = '#fff';
                        statusDiv.style.padding = '20px 40px';
                        statusDiv.style.borderRadius = '10px';
                        statusDiv.style.fontSize = '18px';
                        statusDiv.style.boxShadow = '0px 0px 20px rgb(255 255 255 / 50%)';
                        statusDiv.textContent = 'İndirme başlatılıyor...';

                        overlay.appendChild(statusDiv);
                        document.body.appendChild(overlay);
                    }
                    const statusDiv = document.getElementById('download-status');
                    overlay.style.display = 'flex';
                    statusDiv.textContent = 'İndirme başlatılıyor...';
                    fetch(fileUrl)
                        .then(response => {
                            if (!response.ok) throw new Error("Sunucu hatası");

                            const contentLength = response.headers.get('Content-Length');
                            if (!contentLength) throw new Error("Dosya boyutu bilinmiyor");

                            const total = parseInt(contentLength, 10);
                            let loaded = 0;
                            const reader = response.body.getReader();
                            const chunks = [];

                            function read() {
                                return reader.read().then(({ done, value }) => {
                                    if (done) return;

                                    chunks.push(value);
                                    loaded += value.length;

                                    const percent = Math.floor((loaded / total) * 100);
                                    statusDiv.textContent = `İndiriliyor: %${percent}`;

                                    return read();
                                });
                            }
                            return read().then(() => new Blob(chunks));
                        })
                        .then(blob => {
                            const link = document.createElement('a');
                            const url = URL.createObjectURL(blob);
                            link.href = url;
                            link.download = fileUrl.split('/').pop();
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            URL.revokeObjectURL(url);
                        })
                        .catch(error => {
                            alert('İndirme başarısız: ' + error.message);
                        })
                        .finally(() => {
                            setTimeout(() => {
                                overlay.style.display = 'none';
                                $.ajax({
                                    url: '/baykus/ajax',
                                    type: 'POST',
                                    data: {
                                        action: 'yedek-indir',
                                        type: "temizle",
                                    },
                                    dataType: 'json',
                                    success: function(response) {
                                        if(response.sweetAlert){
                                            Swal.fire({
                                                icon: response.icon,
                                                title: response.title,
                                                html: response.description,
                                                timerProgressBar: true,
                                                timer: response.timer,
                                                showConfirmButton: false,
                                                allowOutsideClick: false,
                                                heightAuto: false
                                            });
                                        }
                                    }
                                });
                            }, 500);
                        });
                }
                if(response.refresh) setTimeout(() => { location.reload(); }, response.timer);
                if(response.location) setTimeout(() => { window.location.href = response.location; }, response.timer);
                if(response.back) setTimeout(() => { window.history.back(); }, response.timer);
                if(response.gRecaptchaReset) { grecaptcha.reset(); }
                
            },
            error: function(response)
            {
                form.removeClass('loading');
                if(response.status != 200){
                    Swal.fire({
                        icon: 'error',
                        title: 'Hata',
                        html: 'Bir hata oluştu. Lütfen tekrar deneyin.',
                        showConfirmButton: false,
                        timerProgressBar: true,
                        timer: 3000,
                    });
                }
            }
        });
        return false;
    });
    $(document).on('input', '[zorunlu]', function()
    {
        if($(this).val().length == 0)
        {
            $(this).addClass('is-invalid');
        }
        else
        {
            $(this).removeClass('is-invalid');
        }
    }
    );
});

$(document).ready(function() {
    $(document).on('click', '[data-delete]', function() {
        var table = $(this).attr('table');
        var where = $(this).attr('where');
        var value = $(this).attr('value');
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu işlemi geri alamazsınız!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, Hemen!',
            cancelButtonText: 'Hayır, Vazgeç!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/baykus/ajax',
                    type: 'POST',
                    data: {
                        action: 'veri-sil',
                        table: table,
                        where: where,
                        value: value
                    },
                    dataType: 'json',
                    beforeSend: function()
                    {
                        Swal.fire({
                            icon: 'info',
                            title: 'Siliniyor...',
                            html: 'Lütfen bekleyin.',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            heightAuto: false
                        });
                    },
                    success: function(response)
                    {
                        Swal.close();

                        if(response.sweetAlert==true)
                        {
                            Swal.fire({
                                title: response.title,
                                icon: response.icon,
                                html: response.description,
                                showConfirmButton: false,
                                timerProgressBar: true,
                                timer: response.timer,
                            });
                        }

                        if(response.calendarItem)
                        {
                            $('.modal').modal('hide');
                            const eventId = response.calendarItem;
                            const event = calendar.getEventById(eventId);
                            event.remove();
                        }

                        if(response.datatableReload)
                        {
                            var table = $('table').DataTable();
                            table.state.save();
                            table.ajax.reload(null, false);
                        }
                        
                        if(response.content_layouts_delete){
                            $("#content_layouts_"+response.content_layouts_delete).remove();
                        }

                        if(response.newslettersAjaxGroups){ newslettersAjaxGroups(); }

                        if(response.refresh)
                        {
                            setTimeout(() => { location.reload(); }, response.timer);
                        }

                    }
                });
            }
        });
    });
});

$(document).ready(function() {
    $(document).on('click', '[data-delete-multiple]', function() {
        let deleteBtnTable = $(this).closest('.card').find('table:first')
        var table = $(this).attr('table');
        var ids = [];
        $('.cb input:checked').each(function() {
            ids = selectedCheckboxes
        });
        if (ids.length == 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Uyarı',
                text: 'Lütfen en az bir kayıt seçiniz.'
            });
            return;
        }
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu işlemi geri alamazsınız!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, Hemen!',
            cancelButtonText: 'Hayır, Vazgeç!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/baykus/ajax',
                    type: 'POST',
                    data: {
                        action: 'veri-sil',
                        table: table,
                        where: "id",
                        value: ids.join(',')
                    },
                    dataType: 'json',
                    beforeSend: function()
                    {
                        Swal.fire({
                            icon: 'info',
                            title: 'Siliniyor...',
                            html: 'Lütfen bekleyin.',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            heightAuto: false
                        });
                    },
                    success: function(response)
                    {
                        Swal.close();

                        if(response.sweetAlert==true)
                        {
                            Swal.fire({
                                title: response.title,
                                icon: response.icon,
                                html: response.description,
                                showConfirmButton: false,
                                timerProgressBar: true,
                                timer: response.timer,
                            });
                        }

                        if(response.calendarItem)
                        {
                            $('.modal').modal('hide');
                            const eventId = response.calendarItem;
                            const event = calendar.getEventById(eventId);
                            event.remove();
                        }

                        if(response.datatableReload)
                        {
                            var table = $('table').DataTable();
                            table.state.save();
                            table.ajax.reload(null, false);
                        }
                        
                        if(response.content_layouts_delete){
                            $("#content_layouts_"+response.content_layouts_delete).remove();
                        }

                        if(response.newslettersAjaxGroups){ newslettersAjaxGroups(); }

                        if(response.refresh)
                        {
                            setTimeout(() => { location.reload(); }, response.timer);
                        }

                        tableMultipleDelete(deleteBtnTable)
                    }
                });
            }
        });
    });
});

$(document).ready(function() {
    tinymce.init({
        selector: '.tinymce',
        height: 400,
        menubar: false,
        language: 'tr',
        skin: isDarkTheme ? 'oxide-dark' : 'oxide',
        content_css: isDarkTheme ? 'dark' : '',
        entity_encoding : "raw",
        plugins: 'lists link image table code',
        toolbar: 'undo redo | h1 h2 h3 styleselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image code',
        images_upload_url: '/view/backend/assets/library/tinymce/upload.php',
        content_style: "img { width: 100%; height: auto; }",
        relative_urls: false,
        setup: function (editor) {
            editor.on('change', function () {
                editor.save();
                $("#content_html").val(editor.getContent());
            });
        },
        content_style: "body { font-family: poppins, sans-serif; font-size: 14px; line-height: 1.6; }",
    });

    $(document).on('change', 'select[name="theme"]', function() {
        const form = $(this).closest('.ajax-form');
        if (form.length > 0) {
            if (this.value === 'special') {
                form.find('#special-theme').show().prop('required', true);
            } else {
                form.find('#special-theme').hide().prop('required', false);
            }
        }
    });
    
});

$(document).ready(function() {
    $("#content-form-create, #content-form-update").each(function() {
        var form = $(this);

        // Dosya seçimi ve dosya yükleme işlemi
        form.find("#files").on("change", function(e) {
            var files = e.target.files;
            var filesArr = Array.prototype.slice.call(files);
            filesArr.forEach(function(f) {
                if (!f.type.match("image.*")) {
                    return;
                }
                var reader = new FileReader();
                reader.onload = function(e) {
                    var html = `
                        <div class="col-6 col-sm-2 mover">
                            <div class="uploaded-file">
                                <input type="hidden" name="gallery[]" value="${e.target.result}">
                                <img src="${e.target.result}" class="img-fluid">
                                <button type="button" class="edit">
                                    <i class="las la-crop"></i>
                                </button>
                                <button type="button" class="delete">
                                    <i class="las la-trash"></i>
                                </button>
                                <button type="button" class="move">
                                    <i class="las la-arrows-alt"></i>
                                </button>
                            </div>
                        </div>
                    `;
                    form.find(".gallery").append(html);
                };
                reader.readAsDataURL(f);
            });
            form.find("#files").val("");
        });

        // Silme işlemi
        form.find(".gallery").on("click", ".delete", function() {
            var id = parseInt($(this).closest(".uploaded-file").find("input").val());
            if (id && !isNaN(id)) {
                var delete_file_ids = form.find("input[name='delete_file_ids']").val();
                
                // Var olan delete_file_ids'yi virgülle ayırıyoruz
                var ids = delete_file_ids ? delete_file_ids.split(",") : [];
                
                // id ve id+1'i kontrol edip ekliyoruz
                if (!ids.includes(id.toString())) {
                    ids.push(id);
                }
                if (!ids.includes((id + 1).toString())) {
                    ids.push(id + 1); // 108'i ekliyoruz
                }
                
                // Yeni id'lerle delete_file_ids'yi güncelliyoruz
                delete_file_ids = ids.join(",");
                form.find("input[name='delete_file_ids']").val(delete_file_ids);
            }
            $(this).closest(".col-6").remove();
        });

        // Sortable işlemi
        var el = form.find('.gallery')[0];
        var sortable = new Sortable(el, {
            handle: '.move',
            animation: 150,
            draggable: ".col-6:not(:first-child)",
        });
    });
});

$(document).ready(function() {

    $(document).on('change', ".single-img-upload input[type='file']", function(e) {
        var singleImgWrapper = $(this).closest('.single-img-upload');
        var input = $(this);

        // Dosya seçimi ve dosya yükleme işlemi
        var files = e.target.files;
        var filesArr = Array.prototype.slice.call(files);
        
        filesArr.forEach(function(f) {
            var html = '';
            if (f.type.match("image.*")) {
                console.log(input)
                console.log(singleImgWrapper)
                var reader = new FileReader();
                reader.onload = function(e) {
                    html = `
                        <div class="uploaded-file no-hover">
                            <input type="hidden" name="data[${input.data('type')}][]" value="${e.target.result}">
                            <img src="${e.target.result}" class="img-fluid">
                            <button type="button" class="edit">
                                <i class="las la-crop"></i>
                            </button>
                            <button type="button" class="delete">
                                <i class="las la-trash"></i>
                            </button>
                        </div>
                    `;
                    singleImgWrapper.find('> input').remove()
                    singleImgWrapper.append(html);
                };
                reader.readAsDataURL(f);
            } else if (f.type.match("video.*")) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    html = `
                        <div class="uploaded-file no-hover">
                            <input type="hidden" name="data[${input.data('type')}][]" value="${e.target.result}">
                            <video src="${e.target.result}" class="img-fluid" controls></video>
                            <button type="button" class="delete">
                                <i class="las la-trash"></i>
                            </button>
                        </div>
                    `;
                    singleImgWrapper.find('> input').remove(); // Eski input'u sil
                    singleImgWrapper.append(html); // Yeni video HTML'ini ekle
                };
                reader.readAsDataURL(f); // Base64 formatında video dosyasını oku
            }
        });
        
        $(this).val("");
    });

    $(document).on('input', ".video-embed-input", function(e) {
        var singleImgWrapper = $(this).closest('.single-img-upload');
        var videoUrl = $(this).val().trim();

        if (videoUrl !== '') {
            singleImgWrapper.find(".uploaded-file").remove();

            // YouTube linkini embed formatına dönüştürme
            var embedUrl = '';
            var match = videoUrl.match(/(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|embed)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/);
            
            if (match && match[1]) {
                embedUrl = `https://www.youtube.com/embed/${match[1]}`;
            } else {
                // Geçerli bir YouTube bağlantısı değil
                // alert('Geçerli bir YouTube bağlantısı giriniz.');
                return;
            }

            var html = `
                <div class="uploaded-file no-hover">
                    <input type="hidden" name="gallery[]" value="${videoUrl}">
                    <iframe src="${embedUrl}" title="YouTube video player" frameborder="0" 
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                            referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    <button type="button" class="delete">
                        <i class="las la-trash"></i>
                    </button>
                </div>
            `;
            singleImgWrapper.prepend(html);
        } else {
            singleImgWrapper.find(".uploaded-file").remove();
        }


    });

    $(document).on("click", ".single-img-upload .delete", function() {
        var singleImgWrapper = $(this).closest(".single-img-upload");
        if($(this).siblings('iframe').length > 0) {
            $(this).closest('.single-img-upload').find('.video-embed-input').val('')
        }else{
            $(this).siblings(".input").val('');
        }
        $(this).closest(".uploaded-file").remove();
        singleImgWrapper.append(`<input type="hidden" name="data[${singleImgWrapper.find('input[type="file"]').data('type')}][]">`);
    });

if($(".single-img-upload").length > 0){
    var el = $('.sortable-wrapper')[0];
    var sortable = new Sortable(el, {
        handle: '.move',
        animation: 150,
    });
}

    $(document).on('click', '.delete-card', function(){
        $(this).closest('.card').remove()
    })
})

$(document).ready(function() {

    var modalHTML = `
    <div class="modal fade" id="crop-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-10">
                            <div class="result"></div>
                        </div>
                        <div class="col-sm-2">
                            <div class="mb-3">
                                <label for="x" class="form-label">X</label>
                                <input type="text" class="form-control" id="x" name="x" disabled>
                            </div>
                            <div class="mb-3">
                                <label for="y" class="form-label">Y</label>
                                <input type="text" class="form-control" id="y" name="y" disabled>
                            </div>
                            <div class="mb-3">
                                <label for="width" class="form-label">Width</label>
                                <input type="text" class="form-control" id="width" name="width" disabled>
                            </div>
                            <div class="mb-3">
                                <label for="height" class="form-label">Height</label>
                                <input type="text" class="form-control" id="height" name="height" disabled>
                            </div>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-secondary active" data-crop="16/9">16:9</button>
                                <button type="button" class="btn btn-secondary" data-crop="4/3">4:3</button>
                                <button type="button" class="btn btn-secondary" data-crop="1/1">1:1</button>
                                <button type="button" class="btn btn-secondary" data-crop="2/3">2:3</button>
                                <button type="button" class="btn btn-secondary" data-crop="free">Free</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                    <button type="button" class="btn btn-primary">Kaydet</button>
                </div>
            </div>
        </div>
    </div>
    `;

    // eğer .gallery varsa
    if($(".gallery").length > 0){
        $('body').append(modalHTML);
    }

    var cropper;
    let imgToCropped;

    $(document).on("click", ".gallery .edit", function() {
        $('body').append(modalHTML);
        var img = $(this).closest(".uploaded-file").find("img").attr("src");
        imgToCropped = $(this).siblings('img')
        $(".modal .result").html(`<img src="${img}" id="crop-image" class="w-100" style="max-height:400px; object-fit:contain;">`);
        $("#crop-modal").modal("show");
    });

    $(document).on("shown.bs.modal", "#crop-modal", function() {
        if (cropper) {
            cropper.destroy();
        }

        cropper = new Cropper(document.getElementById("crop-image"), {
            aspectRatio: 16 / 9,
            viewMode: 1,
            crop: function(event) {
                $("#x").val(event.detail.x);
                $("#y").val(event.detail.y);
                $("#width").val(event.detail.width);
                $("#height").val(event.detail.height);
            }
        });

        $("#crop-modal [data-crop]").click(function() {
            var crop = $(this).attr("data-crop");
            $("#crop-modal [data-crop]").removeClass("active");
            $(this).addClass("active");
            if (crop == "free") {
                cropper.setAspectRatio(NaN);
            } else {
                cropper.setAspectRatio(eval(crop));
            }
        });

        $("#crop-modal .btn-primary").click(function() {
            var canvas = cropper.getCroppedCanvas();
            var dataURL = canvas.toDataURL();
            cropper.destroy();
            imgToCropped.attr("src", dataURL);
        
            // dataURL'yi kullanarak input_value'yi buluyoruz
            var input_value = $(".gallery .uploaded-file img[src='" + dataURL + "']").closest(".uploaded-file").find("input").val();
        
            if (input_value && !isNaN(input_value)) {
                var delete_file_ids = $("input[name='delete_file_ids']").val();
                
                // Var olan delete_file_ids'yi virgülle ayırıyoruz
                var ids = delete_file_ids ? delete_file_ids.split(",") : [];
                
                // input_value ve input_value+1'i kontrol edip ekliyoruz
                if (!ids.includes(input_value.toString())) {
                    ids.push(input_value);
                }
                if (!ids.includes((parseInt(input_value) + 1).toString())) { // input_value'yi sayıya çevirip +1 ekliyoruz
                    ids.push(parseInt(input_value) + 1);
                }
                
                // Yeni id'lerle delete_file_ids'yi güncelliyoruz
                delete_file_ids = ids.join(",");
                $("input[name='delete_file_ids']").val(delete_file_ids);
            }
        
            // dataURL'yi input alanına da ekliyoruz
            imgToCropped.siblings('input').val(dataURL);
        
            // Modalı kapatıyoruz
            $("#crop-modal").modal("hide");
        });
    });

    $(document).on("hidden.bs.modal", "#crop-modal", function() {
        if (cropper) {
            cropper.destroy();
            $('#crop-modal').remove();
            cropper = null;
        }
    });
});

$(document).ready(function(){
    $('.theme-btn').on('click', function(e){
        e.preventDefault()
        $('.theme-btn').toggleClass('active')
        $('.theme-btn .bd-theme-btn').toggleClass('active')
        document.documentElement.classList.add("no-transition");

        setTimeout(() => {
            document.documentElement.classList.toggle("dark-theme");

            if (document.documentElement.classList.contains("dark-theme")) {
                document.documentElement.setAttribute("data-bs-theme", "dark");
            } else {
                document.documentElement.removeAttribute("data-bs-theme");
            }

            setTimeout(() => {
                document.documentElement.classList.remove("no-transition");
            }, 100);
            if (document.documentElement.classList.contains("dark-theme")) {
                localStorage.setItem("darkTheme", true);
                document.cookie = "darkTheme=true; expires=Fri, 31 Dec 9999 23:59:59 GMT; path=/";
            } else {
                localStorage.removeItem("darkTheme");
                document.cookie = "darkTheme=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
            }

         
            $("#device-chart-filter").change();
            $("#line-chart-filter").change();
            $("#city-chart-filter").change();
        }, 1);
    })
    if (isDarkTheme) {
        document.documentElement.classList.add("dark-theme");
        $('.theme-btn').addClass('active')
        $('.theme-btn .bd-theme-btn').toggleClass('active')

      
        $("#device-chart-filter").change();
        $("#line-chart-filter").change();
        $("#city-chart-filter").change();
    }
});

$(document).ready(function(){
    if($(".fancytree").length > 0){
        $('.fancytree').each(function(){
        var action = $(this).attr('action');
        var excluding = $(this).attr('excluding');
        var prefix = $(this).closest("form").find("[name='prefix']").val();
        if(action){
            $(this).fancytree({
                selectMode: 1,
                checkbox: false,
                source: {
                    type: "POST",
                    url: "/baykus/ajax",
                    data: {
                        action: "fancytree",
                        type: action,
                        excluding: excluding,
                    },
                },
                lazyLoad: function(event, data) {
                    var node = data.node;
                    data.result = {
                        type: "POST",
                        url: "/baykus/ajax",
                        data: {
                            action: "fancytree",
                            type: action,
                            key: node.key,
                            excluding: excluding,
                        }
                    };
                },
                strings: {
                    loading: "Yükleniyor ...",
                    loadError: "Hata oluştu",
                    moreData: "Daha fazla veri",
                    noData: "Veri bulunamadı",
                },
                activate: function(event, data) {
                    var node = data.node;
                    var tree = $(this).fancytree("getTree");
                    var path = node.getParentList().map(parentNode => parentNode.key).concat(node.key);
                    $('[name="parent_history"]').val(path.filter(key => !isNaN(key)).join(","));
                    node.setExpanded(true);
                    tree.visit(childNode => {
                        if (childNode !== node && childNode.expanded && childNode.parent === node.parent) {
                            childNode.setExpanded(false);
                        }
                    });

                    // eğer prefix varsa
                    if(prefix=="category")
                    {
                        $('[name="parent"]').val(node.key);
                    }
                    else
                    {
                        $('[name="category"]').val(node.key);
                    }

                    
                    $(".fanctree-clear").show();
                }
            });

            $(document).on('click', '.fanctree-clear', function(){
                $(this).hide();
                var tree = $(this).closest('.card').find('.fancytree').fancytree('getTree');
                tree.clear();
                $('[name="category"]').val('');
                $('[name="parent_history"]').val('');
                var action = $(this).closest('.card').find('.fancytree').attr('action');
                var excluding = $(this).closest('.card').find('.fancytree').attr('excluding');
                tree.reload({
                    type: "POST",
                    url: "/baykus/ajax",
                    data: {
                        action: "fancytree",
                        type: action,
                        excluding: excluding,
                    },
                });
            });
            
        }
    });
    }
});

$(document).ready(function () {

    let slugControl = 0;

    $(".slug-generator").on("change", function () {
        const $input = $(this);
        const $permaLinkControl = $input.closest(".row").find("[permalink]");
        if ($permaLinkControl.val() === "") {
            const slugValue = $input.val();
            const language = $input.attr("id").split("_")[1];
            const prefix = $input.closest("form").find("[name='prefix']").val();
            $.ajax({
                type: "POST",
                url: "/baykus/ajax",
                data: {
                    action: "slug-olustur",
                    value: slugValue,
                    language: language,
                    prefix: prefix,
                },
                success: function (response) {
                    $permaLinkControl.val(response);
                    slugControl = 1;
                    if ($input.data("submitOnResponse")) {
                        $input.closest("form").submit();
                        $input.data("submitOnResponse", false);
                    }
                },
            });
        } else {
            slugControl = 1; // Zaten bir permalink varsa slugControl ayarlanır
        }
    });
    
    $(".slug-generator").on("keypress", function (e) {
        if (e.which === 13) {
            e.preventDefault();
            const $input = $(this);
            const $form = $input.closest("form");
            if ($input.closest(".row").find("[permalink]").val() !== "") {
                // Eğer link zaten varsa, direkt olarak gönder
                $form.submit();
            } else {
                $form.addClass("loading");
                if (slugControl === 1) {
                    $form.submit();
                } else {
                    $input.data("submitOnResponse", true);
                    $input.trigger("change");
                }
            }
        }
    });

    $(".seo").click(function()
    {
        let element = $(this).closest(".card").next();
        if (element.hasClass("d-none")) {
            element.removeClass("d-none").css("display", "block !important");
        } else {
            element.addClass("d-none").css("display", "none !important");
        }
    });


    $(".seo").each(function () {
        let element = $(this).closest(".card").next(); // İlgili kartın altındaki bölümü seç
        let inputs = $(this).closest(".card").find(".form-control"); // title_, desc_, keyw_ inputlarını al
    
        // Herhangi bir input doluysa
        let hasValue = false;
        inputs.each(function () {
            if ($(this).val().trim() !== "") {
                hasValue = true;
                return false; // Döngüyü sonlandır
            }
        });
    
        // Eğer dolu input varsa, gizlenmiş içeriği göster
        if (hasValue) {
            element.removeClass("d-none").css("display", "block !important");
        }
    });


    
});

$(document).ready(function() {
    if($(".fancytree").length > 0){
        var tree = $(".fancytree").fancytree("getTree");
        function fancytreeSelectItems(keys) {
            var timeout = 200;
            var again = 10;
            function retryClickNode(key, attempt) {
                var node = tree.getNodeByKey(key);
                if (node) {
                    node.setActive(true);
                    node.setExpanded(true);
                } else if (attempt < again) {
                    setTimeout(function() {
                        retryClickNode(key, attempt + 1);
                    }, timeout);
                }
            }
            keys.forEach(function(key) {
                retryClickNode(key, 0);
            });
        }
        if (typeof keysToClick !== "undefined"){ fancytreeSelectItems(keysToClick); }
    }
});

$(document).ready(function() {
    $('.sidebar-menu > ul li:has(ul) > a').on('click', function(e) {
        e.preventDefault();
        var $nextElement = $(this).next();
        if ($(this).hasClass('open')) {
            $(this).removeClass('open');
            if (!$('.header-wrapper').hasClass('active-top-header') || window.screen.width <= 1300) {
                $nextElement.slideUp(200);
            }
        } else {
            if (!$(this).parent().parent().prev().hasClass('open')) {
                if (!$('.header-wrapper').hasClass('active-top-header') || window.screen.width <= 1300) {
                    $('.sidebar-menu .open').next().slideUp(200);
                }    
                $('.sidebar-menu .open').removeClass('open');
            }
            $(this).addClass('open');
            if (!$('.header-wrapper').hasClass('active-top-header') || window.screen.width <= 1300) {
                $nextElement.slideDown(200);
            }
        }
    })
    $('.mobile-sidebar-toggle').on('click', function(){
        $('.header-wrapper').toggleClass('mobile-menu')
    })
});

$(document).ready(function() {
    let currentDropdown;
    function checkIncludeDropdown(e) {
        if (!e.composedPath().includes(currentDropdown.parentNode)) {
            setTimeout(() => {
                closeDropdown()
            }, 1);
        }
    }
    function openDropdown() {
        currentDropdown.parentNode.classList.add('open')
        document.addEventListener('click', checkIncludeDropdown, true)
    }
    function closeDropdown() {
        currentDropdown.parentNode.classList.remove('open')
        document.removeEventListener('click', checkIncludeDropdown, true)
    }
    let customDropdowns = document.querySelectorAll('.custom-dropdown .dropdown-btn')
    customDropdowns.forEach(customDropdown => {
        customDropdown.addEventListener('click', () => {
            if (!customDropdown.parentNode.classList.contains('open')) {
                if (currentDropdown) {
                    closeDropdown()
                }
                setTimeout(() => {
                    currentDropdown = customDropdown
                    openDropdown()
                }, 1);
            }else{
                closeDropdown()
            }
        })
    })
});

$(document).ready(function(){
    $(document).on('click', function (e) {
        const $target = $(e.target);
        if (!$target.is('.sidebar-menu.top > ul li:has(ul) > a.open') &&  !$target.is('.sidebar-menu.top > ul li:has(ul) > a.open + ul')) {
            $('.sidebar-menu.top > ul li:has(ul) > a.open').removeClass('open');
        }
    });
    $('.sidebar-toggle-btn').on('click', function(e){
        e.preventDefault()
        $('html').addClass('sidebar-animation')
        if ($('.header-wrapper').hasClass('active-top-header')) {
            $('.header-wrapper').removeClass('active-top-header')
            $('.sidebar-toggle-btn .bd-theme-btn').removeClass('active')
            
            $('.sidebar-menu').addClass('transition hide')
            setTimeout(() => {
                $('.sidebar-menu').removeClass('transition')
                setTimeout(() => {
                    $('.sidebar-menu').removeClass('top hide')
                    $('.sidebar-menu').addClass('left')
    
                    $('.sidebar-menu > ul li:has(ul) > a + ul').removeAttr('style');
                    $('.sidebar-menu > ul li:has(ul) > a.open + ul').slideDown(200);
                    
                    setTimeout(() => {
                        $('.sidebar-menu').addClass('transition')
                        $('.sidebar-menu').removeClass('left')
    
                        setTimeout(() => {
                            $('html').removeClass('sidebar-animation')
                        }, 300);
                    }, 1);
                }, 200);
            }, 200);
        }else{
            $('.sidebar-toggle-btn .bd-theme-btn').addClass('active')
            $('.sidebar-menu').addClass('transition')
            $('.sidebar-menu').addClass('left')
            setTimeout(() => {
                $('.sidebar-menu').removeClass('transition')
                setTimeout(() => {
                    $('.sidebar-menu').removeClass('left')
                    $('.sidebar-menu').addClass('top hide')
                    setTimeout(() => {
                        $('.sidebar-menu').addClass('transition')
                        $('.sidebar-menu').removeClass('hide')
        
                        $('.header-wrapper').addClass('active-top-header')
    
                        setTimeout(() => {
                            $('html').removeClass('sidebar-animation')
                        }, 300);
                    }, 1);
                }, 200);
            }, 200);
        }
        setTimeout(() => {
            if ($('.sidebar-toggle-btn .bd-theme-btn').hasClass("active")) {
                localStorage.setItem("top_sidebar", true);
                document.cookie = "top_sidebar=true; expires=Fri, 31 Dec 9999 23:59:59 GMT; path=/";
            } else {
                localStorage.removeItem("top_sidebar");
                document.cookie = "top_sidebar=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
            }
        }, 1);
    })
});

$(document).ready(function(){
    function messagesControlAnimate(){
        if ($("#feedback_count_id").text() > 0){
            $("#feedback_count_id").parent().parent().find(".dropdown-btn").addClass("animate");
            setTimeout(() => {
                $("#feedback_count_id").parent().parent().find(".dropdown-btn").removeClass("animate");
            }, 2000);
        }
        if ($("#notification_count_id").text() > 0){
            $("#notification_count_id").parent().parent().find(".dropdown-btn").addClass("animate");
            setTimeout(() => {
                $("#notification_count_id").parent().parent().find(".dropdown-btn").removeClass("animate");
            }, 2000);
        }
    }
    messagesControlAnimate();
    setTimeout(() => {
        messagesControlAnimate();
    }, 5000);
});

$(document).ready(function() {
    if($("#dashboard-today-visitor").length > 0){
        function dashboardVisitor() {
            let today = $("#dashboard-today-visitor");
            let last30 = $("#dashboard-last-30-visitor");
            let thisYear = $("#dashboard-this-year-visitor");
            let online = $("#dashboard-online-visitor");
            function formatNumber(number) {
                return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            }
            $.ajax({
                url: '/baykus/ajax',
                type: 'POST',
                data: {
                    action: 'göster-paneli-verileri',
                    type: 'today,last30,thisYear,online'
                },
                dataType: 'json',
                success: function(response) {
                    today.text(formatNumber(response.today));
                    last30.text(formatNumber(response.last30));
                    thisYear.text(formatNumber(response.thisYear));
                    online.text(formatNumber(response.online));
                }
            });
        }
        let mouseMoved = false;
        let keyboardActivity = false;
        let windowActive = true;
        $(document).on('mousemove', function() {
            mouseMoved = true;
        });
        $(document).on('keydown', function() {
            keyboardActivity = true;
        });
        $(window).on('focus', function() {
            windowActive = true;
        });
        $(window).on('blur', function() {
            windowActive = false;
        });
        function checkUserActivity() {
            if (mouseMoved || keyboardActivity || windowActive) {
                mouseMoved = false;
                keyboardActivity = false;
                dashboardVisitor();
            }
        }
        setInterval(checkUserActivity, 1000);
        dashboardVisitor();
    }
});

$(document).ready(function() {
    $("#device-chart-filter").on('change', function(){
        if($("#device-chart").length > 0){
            $("#device-chart").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'devices',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let labels = Object.keys(response);
                let series = Object.values(response);
                var options = {
                    chart:
                    {
                        type: 'donut',
                        height: 279,
                        fontFamily: 'Poppins',
                    },
                    // colors: ['#000000','#333333'],
                    colors: getChartColors(),
                    labels: labels,
                    series: series,
                    legend:
                    {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                        fontSize: '14px',
                        fontFamily: 'Poppins'
                    }
                };
                var chartBrowser = new ApexCharts(document.querySelector("#device-chart"), options);
                chartBrowser.render();
            }
        })
    });
    $("#device-chart-filter").change();
});

$(document).ready(function() {
    $("#line-chart-filter").on('change', function(){
        if($("#line-chart").length > 0){
            $("#line-chart").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'line',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let labels = Object.keys(response);
                let series = [{
                    name: 'Ziyaretçi',
                    data: Object.values(response)
                }];
                var options = {
                    chart: {
                        type: 'line',
                        height: 265,
                        fontFamily: 'Poppins',
                        toolbar: {
                            show: false,
                        },
                    },
                    colors: getChartColors(),
                    labels: labels,
                    series: series,
                    legend: {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                        fontSize: '14px',
                        fontFamily: 'Poppins'
                    },
                    
                };
                var chartBrowser = new ApexCharts(document.querySelector("#line-chart"), options);
                chartBrowser.render();
            }
        })
    });
    $("#line-chart-filter").change();
});

$(document).ready(function() {
    $("#city-chart-filter").on('change', function(){
        if($("#city-chart").length > 0){
            $("#city-chart").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'citys',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {

                let labels = Object.keys(response);
                let series = Object.values(response);
                var options = {
                    chart:
                    {
                        type: 'donut',
                        height: 279,
                        fontFamily: 'Poppins',
                    },
                    colors: getChartColors(),
                    labels: labels,
                    series: series,
                    legend:
                    {
                        show: true,
                        position: 'bottom',
                        horizontalAlign: 'center',
                        fontSize: '14px',
                        fontFamily: 'Poppins'
                    }
                };
                var chartBrowser = new ApexCharts(document.querySelector("#city-chart"), options);
                chartBrowser.render();
            }
        })
    });
    $("#city-chart-filter").change();
});

$(document).ready(function() {
    $("#browser-analytics-filter").on('change', function(){
        if($("#browser-analytics").length > 0){
            $("#browser-analytics").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'browsers',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let labels = Object.keys(response);
                var html = '';
                labels.forEach(function(item){
                    
                    if(item == 'chrome'){
                        var title = 'Google Chrome';
                        var desct = 'Google, Inc.';
                    }

                    if(item == 'firefox'){
                        var title = 'Mozilla Firefox';
                        var desct = 'Mozilla Foundation';
                    }

                    if(item == 'safari'){
                        var title = 'Safari';
                        var desct = 'Apple Inc.';
                    }

                    if(item == 'edge'){
                        var title = 'Microsoft Edge';
                        var desct = 'Microsoft Corporation';
                    }
                   
                    if(item == 'explorer'){
                        var title = 'Microsoft Edge';
                        var desct = 'Microsoft Corporation';
                    }

                    if(item == 'opera'){
                        var title = 'Opera';
                        var desct = 'Opera Software';
                    }

                    if(item == 'other'){
                        var title = 'Bilinmeyen';
                        var desct = 'Bilinmeyen tarayıcılar';
                    }

                    html += `<div class="item" >
                        <div class="icon"><img class="${item == 'other' ? 'icon-img' : ''}" src="/view/backend/assets/img/browsers/${item}.svg"></div>
                        <div class="txt"><strong>${title}</strong><span>${desct}</span></div>
                        <div class="val">${response[item]}</div>
                        <div class="percent text-success"><i class="las la-long-arrow-alt-down"></i><span>0%</span></div>
                    </div>`;

                    
                });

                // eğer çıkan veri 3 tane ise
                if(labels.length == 3){
                    html += `<div class="item"><div class="icon"><img class="other" src="/view/backend/assets/img/browsers/opera.svg"></div>
                    <div class="txt"><strong>Bilinmeyen</strong><span>Bilinmeyen tarayıcılar</span></div>
                    <div class="val">0</div>
                    <div class="percent text-dark"><i class="las la-long-arrow-alt-down"></i><span>0%</span></div>
                </div>`;
                }

                $("#browser-analytics").append(html);
                var total = 0;
                labels.forEach(function(item){
                    total += response[item];
                });
                labels.forEach(function(item){
                    var percent = (response[item] / total) * 100;
                    if(percent < 20){
                        $("#browser-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-danger').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else if(percent < 50){
                        $("#browser-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-warning').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else {
                        $("#browser-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-success').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    }
                    $("#browser-analytics .item").eq(labels.indexOf(item)).find('.percent span').text(percent.toFixed(2) + '%'); 
                });
            }
        })
    });
    $("#browser-analytics-filter").change();
});

$(document).ready(function() {
    $("#country-analytics-filter").on('change', function(){
        if($("#country-analytics").length > 0){
            $("#country-analytics").html('');
        }
        let value = $(this).val();
        const countries = {
            af: { title: 'Afganistan', desc: 'Islamic Republic of Afghanistan' },
            al: { title: 'Arnavutluk', desc: 'Republic of Albania' },
            dz: { title: 'Cezayir', desc: 'People\'s Democratic Republic of Algeria' },
            as: { title: 'Amerikan Samoası', desc: 'American Samoa' },
            ad: { title: 'Andorra', desc: 'Principality of Andorra' },
            ao: { title: 'Angola', desc: 'Republic of Angola' },
            ai: { title: 'Anguilla', desc: 'Anguilla' },
            aq: { title: 'Antarktika', desc: 'Antarctica' },
            ag: { title: 'Antigua ve Barbuda', desc: 'Antigua and Barbuda' },
            ar: { title: 'Arjantin', desc: 'Argentine Republic' },
            am: { title: 'Ermenistan', desc: 'Republic of Armenia' },
            aw: { title: 'Aruba', desc: 'Aruba' },
            au: { title: 'Avustralya', desc: 'Commonwealth of Australia' },
            at: { title: 'Avusturya', desc: 'Republic of Austria' },
            az: { title: 'Azerbaycan', desc: 'Republic of Azerbaijan' },
            bs: { title: 'Bahamalar', desc: 'Commonwealth of the Bahamas' },
            bh: { title: 'Bahreyn', desc: 'Kingdom of Bahrain' },
            bd: { title: 'Bangladeş', desc: 'People\'s Republic of Bangladesh' },
            bb: { title: 'Barbados', desc: 'Barbados' },
            by: { title: 'Belarus', desc: 'Republic of Belarus' },
            be: { title: 'Belçika', desc: 'Kingdom of Belgium' },
            bz: { title: 'Belize', desc: 'Belize' },
            bj: { title: 'Benin', desc: 'Republic of Benin' },
            bm: { title: 'Bermuda', desc: 'Bermuda' },
            bt: { title: 'Bhutan', desc: 'Kingdom of Bhutan' },
            bo: { title: 'Bolivya', desc: 'Plurinational State of Bolivia' },
            ba: { title: 'Bosna-Hersek', desc: 'Bosnia and Herzegovina' },
            bw: { title: 'Botsvana', desc: 'Republic of Botswana' },
            br: { title: 'Brezilya', desc: 'Federative Republic of Brazil' },
            io: { title: 'Britanya Hint Okyanusu Toprakları', desc: 'British Indian Ocean Territory' },
            bn: { title: 'Brunei', desc: 'Nation of Brunei, Abode of Peace' },
            bg: { title: 'Bulgaristan', desc: 'Republic of Bulgaria' },
            bf: { title: 'Burkina Faso', desc: 'Burkina Faso' },
            bi: { title: 'Burundi', desc: 'Republic of Burundi' },
            cv: { title: 'Cape Verde', desc: 'Republic of Cabo Verde' },
            kh: { title: 'Kamboçya', desc: 'Kingdom of Cambodia' },
            cm: { title: 'Kamerun', desc: 'Republic of Cameroon' },
            ca: { title: 'Kanada', desc: 'Canada' },
            ky: { title: 'Cayman Adaları', desc: 'Cayman Islands' },
            cf: { title: 'Orta Afrika Cumhuriyeti', desc: 'Central African Republic' },
            td: { title: 'Çad', desc: 'Republic of Chad' },
            cl: { title: 'Şili', desc: 'Republic of Chile' },
            cn: { title: 'Çin', desc: 'People\'s Republic of China' },
            cx: { title: 'Christmas Adası', desc: 'Christmas Island' },
            cc: { title: 'Cocos (Keeling) Adaları', desc: 'Cocos (Keeling) Islands' },
            co: { title: 'Kolombiya', desc: 'Republic of Colombia' },
            km: { title: 'Komorlar', desc: 'Union of the Comoros' },
            cg: { title: 'Kongo', desc: 'Republic of the Congo' },
            cd: { title: 'Demokratik Kongo Cumhuriyeti', desc: 'Democratic Republic of the Congo' },
            ck: { title: 'Cook Adaları', desc: 'Cook Islands' },
            cr: { title: 'Kosta Rika', desc: 'Republic of Costa Rica' },
            ci: { title: 'Fildişi Sahili', desc: 'Republic of Côte d\'Ivoire' },
            hr: { title: 'Hırvatistan', desc: 'Republic of Croatia' },
            cu: { title: 'Küba', desc: 'Republic of Cuba' },
            cw: { title: 'Curaçao', desc: 'Country of Curaçao' },
            cy: { title: 'Kıbrıs', desc: 'Republic of Cyprus' },
            cz: { title: 'Çekya', desc: 'Czech Republic' },
            dk: { title: 'Danimarka', desc: 'Kingdom of Denmark' },
            dj: { title: 'Cibuti', desc: 'Republic of Djibouti' },
            dm: { title: 'Dominika', desc: 'Commonwealth of Dominica' },
            do: { title: 'Dominik Cumhuriyeti', desc: 'Dominican Republic' },
            ec: { title: 'Ekvador', desc: 'Republic of Ecuador' },
            eg: { title: 'Mısır', desc: 'Arab Republic of Egypt' },
            sv: { title: 'El Salvador', desc: 'Republic of El Salvador' },
            gq: { title: 'Ekvator Ginesi', desc: 'Republic of Equatorial Guinea' },
            er: { title: 'Eritre', desc: 'State of Eritrea' },
            ee: { title: 'Estonya', desc: 'Republic of Estonia' },
            sz: { title: 'Eswatini', desc: 'Kingdom of Eswatini' },
            et: { title: 'Etiyopya', desc: 'Federal Democratic Republic of Ethiopia' },
            fk: { title: 'Falkland Adaları', desc: 'Falkland Islands (Malvinas)' },
            fo: { title: 'Faroe Adaları', desc: 'Faroe Islands' },
            fj: { title: 'Fiji', desc: 'Republic of Fiji' },
            fi: { title: 'Finlandiya', desc: 'Republic of Finland' },
            fr: { title: 'Fransa', desc: 'French Republic' },
            gf: { title: 'Fransız Guyanası', desc: 'French Guiana' },
            pf: { title: 'Fransız Polinezyası', desc: 'French Polynesia' },
            ga: { title: 'Gabon', desc: 'Gabonese Republic' },
            gm: { title: 'Gambiya', desc: 'Republic of The Gambia' },
            ge: { title: 'Gürcistan', desc: 'Georgia' },
            de: { title: 'Almanya', desc: 'Federal Republic of Germany' },
            gh: { title: 'Gana', desc: 'Republic of Ghana' },
            gi: { title: 'Cebelitarık', desc: 'Gibraltar' },
            gr: { title: 'Yunanistan', desc: 'Hellenic Republic' },
            gl: { title: 'Grönland', desc: 'Greenland' },
            gd: { title: 'Grenada', desc: 'Grenada' },
            gp: { title: 'Guadeloupe', desc: 'Guadeloupe' },
            gu: { title: 'Guam', desc: 'Guam' },
            gt: { title: 'Guatemala', desc: 'Republic of Guatemala' },
            gg: { title: 'Guernsey', desc: 'Bailiwick of Guernsey' },
            gn: { title: 'Gine', desc: 'Republic of Guinea' },
            gw: { title: 'Gine-Bissau', desc: 'Republic of Guinea-Bissau' },
            gy: { title: 'Guyana', desc: 'Co-operative Republic of Guyana' },
            ht: { title: 'Haiti', desc: 'Republic of Haiti' },
            hn: { title: 'Honduras', desc: 'Republic of Honduras' },
            hk: { title: 'Hong Kong', desc: 'Hong Kong Special Administrative Region of China' },
            hu: { title: 'Macaristan', desc: 'Hungary' },
            is: { title: 'İzlanda', desc: 'Republic of Iceland' },
            in: { title: 'Hindistan', desc: 'Republic of India' },
            id: { title: 'Endonezya', desc: 'Republic of Indonesia' },
            ir: { title: 'İran', desc: 'Islamic Republic of Iran' },
            iq: { title: 'Irak', desc: 'Republic of Iraq' },
            ie: { title: 'İrlanda', desc: 'Ireland' },
            im: { title: 'Man Adası', desc: 'Isle of Man' },
            il: { title: 'İsrail', desc: 'State of Israel' },
            it: { title: 'İtalya', desc: 'Italian Republic' },
            jm: { title: 'Jamaika', desc: 'Jamaica' },
            jp: { title: 'Japonya', desc: 'Japan' },
            je: { title: 'Jersey', desc: 'Bailiwick of Jersey' },
            jo: { title: 'Ürdün', desc: 'Hashemite Kingdom of Jordan' },
            kz: { title: 'Kazakistan', desc: 'Republic of Kazakhstan' },
            ke: { title: 'Kenya', desc: 'Republic of Kenya' },
            ki: { title: 'Kiribati', desc: 'Republic of Kiribati' },
            kp: { title: 'Kuzey Kore', desc: 'Democratic People\'s Republic of Korea' },
            kr: { title: 'Güney Kore', desc: 'Republic of Korea' },
            kw: { title: 'Kuveyt', desc: 'State of Kuwait' },
            kg: { title: 'Kırgızistan', desc: 'Kyrgyz Republic' },
            la: { title: 'Laos', desc: 'Lao People\'s Democratic Republic' },
            lv: { title: 'Letonya', desc: 'Republic of Latvia' },
            lb: { title: 'Lübnan', desc: 'Lebanese Republic' },
            ls: { title: 'Lesotho', desc: 'Kingdom of Lesotho' },
            lr: { title: 'Liberya', desc: 'Republic of Liberia' },
            ly: { title: 'Libya', desc: 'State of Libya' },
            li: { title: 'Lihtenştayn', desc: 'Principality of Liechtenstein' },
            lt: { title: 'Litvanya', desc: 'Republic of Lithuania' },
            lu: { title: 'Lüksemburg', desc: 'Grand Duchy of Luxembourg' },
            mo: { title: 'Makao', desc: 'Macao Special Administrative Region of China' },
            mk: { title: 'Kuzey Makedonya', desc: 'Republic of North Macedonia' },
            mg: { title: 'Madagaskar', desc: 'Republic of Madagascar' },
            mw: { title: 'Malavi', desc: 'Republic of Malawi' },
            my: { title: 'Malezya', desc: 'Malaysia' },
            mv: { title: 'Maldivler', desc: 'Republic of Maldives' },
            ml: { title: 'Mali', desc: 'Republic of Mali' },
            mt: { title: 'Malta', desc: 'Republic of Malta' },
            mh: { title: 'Marshall Adaları', desc: 'Republic of the Marshall Islands' },
            mq: { title: 'Martinik', desc: 'Martinique' },
            mr: { title: 'Moritanya', desc: 'Islamic Republic of Mauritania' },
            mu: { title: 'Mauritius', desc: 'Republic of Mauritius' },
            yt: { title: 'Mayotte', desc: 'Department of Mayotte' },
            mx: { title: 'Meksika', desc: 'United Mexican States' },
            fm: { title: 'Mikronezya', desc: 'Federated States of Micronesia' },
            md: { title: 'Moldova', desc: 'Republic of Moldova' },
            mc: { title: 'Monako', desc: 'Principality of Monaco' },
            mn: { title: 'Moğolistan', desc: 'Mongolia' },
            me: { title: 'Karadağ', desc: 'Montenegro' },
            ms: { title: 'Montserrat', desc: 'Montserrat' },
            ma: { title: 'Fas', desc: 'Kingdom of Morocco' },
            mz: { title: 'Mozambik', desc: 'Republic of Mozambique' },
            mm: { title: 'Myanmar', desc: 'Republic of the Union of Myanmar' },
            na: { title: 'Namibya', desc: 'Republic of Namibia' },
            nr: { title: 'Nauru', desc: 'Republic of Nauru' },
            np: { title: 'Nepal', desc: 'Federal Democratic Republic of Nepal' },
            nl: { title: 'Hollanda', desc: 'Kingdom of the Netherlands' },
            nc: { title: 'Yeni Kaledonya', desc: 'New Caledonia' },
            nz: { title: 'Yeni Zelanda', desc: 'New Zealand' },
            ni: { title: 'Nikaragua', desc: 'Republic of Nicaragua' },
            ne: { title: 'Nijer', desc: 'Republic of Niger' },
            ng: { title: 'Nijerya', desc: 'Federal Republic of Nigeria' },
            nu: { title: 'Niue', desc: 'Niue' },
            nf: { title: 'Norfolk Adası', desc: 'Norfolk Island' },
            mp: { title: 'Kuzey Mariana Adaları', desc: 'Northern Mariana Islands' },
            no: { title: 'Norveç', desc: 'Kingdom of Norway' },
            om: { title: 'Umman', desc: 'Sultanate of Oman' },
            pk: { title: 'Pakistan', desc: 'Islamic Republic of Pakistan' },
            pw: { title: 'Palau', desc: 'Republic of Palau' },
            ps: { title: 'Filistin', desc: 'State of Palestine' },
            pa: { title: 'Panama', desc: 'Republic of Panama' },
            pg: { title: 'Papua Yeni Gine', desc: 'Independent State of Papua New Guinea' },
            py: { title: 'Paraguay', desc: 'Republic of Paraguay' },
            pe: { title: 'Peru', desc: 'Republic of Peru' },
            ph: { title: 'Filipinler', desc: 'Republic of the Philippines' },
            pl: { title: 'Polonya', desc: 'Republic of Poland' },
            pt: { title: 'Portekiz', desc: 'Portuguese Republic' },
            pr: { title: 'Porto Riko', desc: 'Commonwealth of Puerto Rico' },
            qa: { title: 'Katar', desc: 'State of Qatar' },
            ro: { title: 'Romanya', desc: 'Romania' },
            ru: { title: 'Rusya', desc: 'Russian Federation' },
            rw: { title: 'Ruanda', desc: 'Republic of Rwanda' },
            bl: { title: 'Saint Barthélemy', desc: 'Collectivity of Saint Barthélemy' },
            sh: { title: 'Saint Helena', desc: 'Saint Helena, Ascension and Tristan da Cunha' },
            kn: { title: 'Saint Kitts ve Nevis', desc: 'Federation of Saint Kitts and Nevis' },
            lc: { title: 'Saint Lucia', desc: 'Saint Lucia' },
            mf: { title: 'Saint Martin', desc: 'Collectivity of Saint Martin' },
            pm: { title: 'Saint Pierre ve Miquelon', desc: 'Saint Pierre and Miquelon' },
            vc: { title: 'Saint Vincent ve Grenadinler', desc: 'Saint Vincent and the Grenadines' },
            ws: { title: 'Samoa', desc: 'Independent State of Samoa' },
            sm: { title: 'San Marino', desc: 'Republic of San Marino' },
            st: { title: 'São Tomé ve Príncipe', desc: 'Democratic Republic of São Tomé and Príncipe' },
            sa: { title: 'Suudi Arabistan', desc: 'Kingdom of Saudi Arabia' },
            sn: { title: 'Senegal', desc: 'Republic of Senegal' },
            rs: { title: 'Sırbistan', desc: 'Republic of Serbia' },
            sc: { title: 'Seyşeller', desc: 'Republic of Seychelles' },
            sl: { title: 'Sierra Leone', desc: 'Republic of Sierra Leone' },
            sg: { title: 'Singapur', desc: 'Republic of Singapore' },
            sx: { title: 'Sint Maarten', desc: 'Country of Sint Maarten' },
            sk: { title: 'Slovakya', desc: 'Slovak Republic' },
            si: { title: 'Slovenya', desc: 'Republic of Slovenia' },
            sb: { title: 'Solomon Adaları', desc: 'Solomon Islands' },
            so: { title: 'Somali', desc: 'Federal Republic of Somalia' },
            za: { title: 'Güney Afrika', desc: 'Republic of South Africa' },
            ss: { title: 'Güney Sudan', desc: 'Republic of South Sudan' },
            es: { title: 'İspanya', desc: 'Kingdom of Spain' },
            lk: { title: 'Sri Lanka', desc: 'Democratic Socialist Republic of Sri Lanka' },
            sd: { title: 'Sudan', desc: 'Republic of the Sudan' },
            sr: { title: 'Surinam', desc: 'Republic of Suriname' },
            sj: { title: 'Svalbard ve Jan Mayen', desc: 'Svalbard and Jan Mayen' },
            se: { title: 'İsveç', desc: 'Kingdom of Sweden' },
            ch: { title: 'İsviçre', desc: 'Swiss Confederation' },
            sy: { title: 'Suriye', desc: 'Syrian Arab Republic' },
            tw: { title: 'Tayvan', desc: 'Taiwan, Province of China' },
            tj: { title: 'Tacikistan', desc: 'Republic of Tajikistan' },
            tz: { title: 'Tanzanya', desc: 'United Republic of Tanzania' },
            th: { title: 'Tayland', desc: 'Kingdom of Thailand' },
            tl: { title: 'Timor-Leste', desc: 'Democratic Republic of Timor-Leste' },
            tg: { title: 'Togo', desc: 'Togolese Republic' },
            tk: { title: 'Tokelau', desc: 'Tokelau' },
            to: { title: 'Tonga', desc: 'Kingdom of Tonga' },
            tt: { title: 'Trinidad ve Tobago', desc: 'Republic of Trinidad and Tobago' },
            tn: { title: 'Tunus', desc: 'Republic of Tunisia' },
            tr: { title: 'Türkiye', desc: 'Republic of Turkey' },
            tm: { title: 'Türkmenistan', desc: 'Turkmenistan' },
            tc: { title: 'Turks ve Caicos Adaları', desc: 'Turks and Caicos Islands' },
            tv: { title: 'Tuvalu', desc: 'Tuvalu' },
            ug: { title: 'Uganda', desc: 'Republic of Uganda' },
            ua: { title: 'Ukrayna', desc: 'Ukraine' },
            ae: { title: 'Birleşik Arap Emirlikleri', desc: 'United Arab Emirates' },
            gb: { title: 'Birleşik Krallık', desc: 'United Kingdom of Great Britain and Northern Ireland' },
            us: { title: 'Amerika Birleşik Devletleri', desc: 'United States of America' },
            uy: { title: 'Uruguay', desc: 'Eastern Republic of Uruguay' },
            uz: { title: 'Özbekistan', desc: 'Republic of Uzbekistan' },
            vu: { title: 'Vanuatu', desc: 'Republic of Vanuatu' },
            ve: { title: 'Venezuela', desc: 'Bolivarian Republic of Venezuela' },
            vn: { title: 'Vietnam', desc: 'Socialist Republic of Vietnam' },
            wf: { title: 'Wallis ve Futuna', desc: 'Territory of the Wallis and Futuna Islands' },
            eh: { title: 'Batı Sahra', desc: 'Sahrawi Arab Democratic Republic' },
            ye: { title: 'Yemen', desc: 'Republic of Yemen' },
            zm: { title: 'Zambiya', desc: 'Republic of Zambia' },
            zw: { title: 'Zimbabve', desc: 'Republic of Zimbabwe' }
        };
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'country',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let labels = Object.keys(response);
                var html = '';
                labels.forEach(function(item){
                    if(countries[item]){
                        var title = countries[item].title;
                        var desc = countries[item].desc.length > 35 ? countries[item].desc.substring(0, 35) + '...' : countries[item].desc;
                    }
                    html += `<div class="item" >
                        <div class="icon"><img src="/view/backend/assets/img/flags/${item}.svg"></div>
                        <div class="txt"><strong>${title}</strong><span>${desc}</span></div>
                        <div class="val">${response[item]}</div>
                        <div class="percent text-success"><i class="las la-long-arrow-alt-down"></i><span>0%</span></div>
                    </div>`;
                });
                $("#country-analytics").append(html);
                var total = 0;
                labels.forEach(function(item){
                    total += response[item];
                });
                labels.forEach(function(item){
                    var percent = (response[item] / total) * 100;
                    if(percent < 20){
                        $("#country-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-danger').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else if(percent < 50){
                        $("#country-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-warning').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else {
                        $("#country-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-success').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    }
                    $("#country-analytics .item").eq(labels.indexOf(item)).find('.percent span').text(percent.toFixed(2) + '%'); 
                });
            }
        })
    });
    $("#country-analytics-filter").change();
});

$(document).ready(function() {
    $("#referral-analytics-filter").on('change', function(){
        if($("#referral-analytics").length > 0){
            $("#referral-analytics").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'referer',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let labels = Object.keys(response);
                var html = '';
                labels.forEach(function(item){
                    html += `<div class="item" >
                        <div class="icon"><img class="icon-img" src="/view/backend/assets/img/profile/referral.svg"></div>
                        <div class="txt"><strong>${item}</strong><span>${item}</span></div>
                        <div class="val">${response[item]}</div>
                        <div class="percent text-success"><i class="las la-long-arrow-alt-down"></i><span>0%</span></div>
                    </div>`;
                });
                $("#referral-analytics").append(html);
                var total = 0;
                labels.forEach(function(item){
                    total += response[item];
                });
                labels.forEach(function(item){
                    var percent = (response[item] / total) * 100;
                    if(percent < 20){
                        $("#referral-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-danger').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else if(percent < 50){
                        $("#referral-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-warning').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    } else {
                        $("#referral-analytics .item").eq(labels.indexOf(item)).find('.percent').addClass('text-success').find('i').removeClass('la-long-arrow-alt-down').addClass('la-long-arrow-alt-up');
                    }
                    $("#referral-analytics .item").eq(labels.indexOf(item)).find('.percent span').text(percent.toFixed(2) + '%'); 
                });
            }
        })
    });
    $("#referral-analytics-filter").change();
});

$(document).ready(function() {
    $("#ip-analytics-filter").on('change', function(){
        if($("#ip-analytics").length > 0){
            $("#ip-analytics textarea").html('');
        }
        let value = $(this).val();
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: 'göster-paneli-verileri',
                type: 'ips',
                value: value
            },
            dataType: 'json',
            success: function(response)
            {
                let html = '';
                response.forEach(function(item){
                    html += item.ip + "\n";
                });
                $("#ip-analytics textarea").val(html);
            }
        })
    });
    $("#ip-analytics-filter").change();
});