﻿function onTablePaginate() {
    let currentTable = $(this.api().table().node());
    
    $(currentTable).find('tbody input[type="checkbox"]').each(function () {
        const value = $(this).val();
        $(this).prop('checked', selectedCheckboxes.includes(value));
    });
    
    updateCheckAllState(currentTable);
}

function updateCheckedInputs(currentTable) {
    currentTable.closest('.card').find('.total-selected-items').html(selectedCheckboxes.length)

    if (selectedCheckboxes.length > 0) {
        currentTable.closest('.card').addClass('has-selected-items')
    }else{
        currentTable.closest('.card').removeClass('has-selected-items')
    }
    $('#checked-inputs').val(selectedCheckboxes.join(','));
}

function updateCheckAllState(currentTable) {
    if (currentTable.find('tbody .cb input[type="checkbox"]:not(:checked)').length == 0) {
        currentTable.find('.check-all').prop('checked', true)
    }else{
        currentTable.find('.check-all').prop('checked', false)
    }
}

function clearSelectedItems() {
    selectedCheckboxes = [];
    $('.cb input[type="checkbox"]').prop('checked', false);
    updateCheckedInputs($(this).closest('table'));
    $('.check-all').prop('checked', false);
    $('.total-selected-items').html(0);
    $('.card').removeClass('has-selected-items');
}

function timeAgo(dateString) {
    const now = new Date();
    const givenDate = new Date(dateString);
    const diffInSeconds = Math.floor((now - givenDate) / 1000);

    if (diffInSeconds < 60) {
        return `${diffInSeconds} saniye önce`;
    } else if (diffInSeconds < 3600) {
        const minutes = Math.floor(diffInSeconds / 60);
        return `${minutes} dakika önce`;
    } else if (diffInSeconds < 86400) {
        const hours = Math.floor(diffInSeconds / 3600);
        return `${hours} saat önce`;
    } else {
        const days = Math.floor(diffInSeconds / 86400);
        return `${days} gün önce`;
    }
}

function add_container(content){
    console.log("add_container ÇALIŞTI")
    $.ajax({
        type: "POST",
        url: "/baykus/ajax",
        data: {
            action: "kapsayici-olustur",
            content: content
        },
        dataType: "json",
        success: function(response){
            var container = `
            <div class="card mb-3" id="content_layouts_${response.id}">
            <div class="card-header">
                <div class="left">${response.class}</div>
                <div class="actions">
                    <button class="btn btn-sm btn-light icon square" onclick="add_update_module_layout(${response.id})"><i class="las la-plus"></i></button>
                    <button class="btn btn-sm btn-light icon square" onclick="update_layout(${response.id})"><i class="las la-edit"></i></button>
                    <button class="btn btn-sm btn-light icon square" table="content_layouts" where="id" value="${response.id}" data-delete=""><i class="las la-trash"></i></button>
                    <button class="btn btn-sm btn-light icon square container_move"><i class="las la-arrows-alt"></i></button>
                </div>
            </div>
            <div class="card-body">
                <div class="row gy-4 container_items" id="${response.id}">
                    <div class="col-12">
                        <div class="alert alert-warning mb-0">Bu alana modül ekleyebilirsiniz.</div>
                    </div>
                </div>
            </div>
        </div>
        `;
            $("#containers").append(container);
        }
    })
}

let selectedCheckboxes = [];

function tableMultipleDelete(currentTable) {
    selectedCheckboxes = []
    updateCheckedInputs(currentTable);
}

$(document).on('change', 'table .cb input[type="checkbox"]', function () {
    let checkboxValue = $(this).val();
    let currentTable = $(this).closest('table')

    if ($(this).hasClass('check-all')) {
        let isChecked = $(this).prop('checked');
        currentTable.find('tbody .cb input[type="checkbox"]').prop('checked', isChecked);
        if (isChecked) {
            currentTable.find('tbody .cb input[type="checkbox"]').each(function () {
                let value = $(this).val();
                if (!selectedCheckboxes.includes(value)) {
                    selectedCheckboxes.push(value);
                }
            });
        } else {
            currentTable.find('tbody .cb input[type="checkbox"]').each(function () {
                let value = $(this).val();
                selectedCheckboxes = selectedCheckboxes.filter(item => item !== value);
            });
        }
    } else {
        if (currentTable.find('tbody .cb input[type="checkbox"]:not(:checked)').length == 0) {
            currentTable.find('thead .cb input').prop('checked', true)
        }else{
            currentTable.find('thead .cb input').prop('checked', false)
        }
        if ($(this).prop('checked')) {
            if (!selectedCheckboxes.includes(checkboxValue)) {
                selectedCheckboxes.push(checkboxValue);
            }
        } else {
            selectedCheckboxes = selectedCheckboxes.filter(item => item !== checkboxValue);
        }
    }
    updateCheckedInputs(currentTable);
});

let isDarkTheme = JSON.parse(localStorage.getItem("darkTheme")) === true;

function getChartColors() {
    if (document.documentElement.classList.contains("dark-theme")) {
        return ['#fff', '#ddd', '#999', '#666', '#333', '#000'];
    } else {
        return ['#000000','#333333','#666666','#999999','#CCCCCC','#FFFFFF']
    }
}

function notification_count()
{
    $.ajax({
        type: "POST",
        url: "/baykus/ajax",
        data: {
            action: "bildirim-sayisi"
        },
        dataType: "json",
        success: function(response){
            if (response.count > 0) {
                $("#notification_count_id").html(response.count);
                $("#notification_count_id").show();
            } else {
                $("#notification_count_id").hide();
            }
        }
    });
}
notification_count();