<?php 
    $captcha = fetch("integrations[json]", ["name" => "captcha"]);
    if ($captcha):
        $captcha = json_decode($captcha->json, true);
        if (isset($captcha['status'])):
            echo '<!-- reCAPTCHA -->';
            echo "\n";
            echo '    <script src="https://www.google.com/recaptcha/api.js" async defer></script>';
        else:
            $captcha = false;
        endif;
    else:
        $captcha = false;
    endif;
?>
<div id="authentication-container">
    <div class="d-flex justify-content-center align-items-center" id="authentication">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="title">Şifremi Hatırlayamıyorum?</div>
                    <div class="description "><small>Lütfen hesabınızla ilgili hatırladığınız bir bilginizi giriniz</small></div>
                    <form action="sifremi-unuttum" class="ajax-form">
                        <input type="text" name="username" class="form-control mb-4" placeholder="Kullanıcı adı veya e-posta" zorunlu>
                        <?php if(isset($captcha)): ?>
                                <div class="g-recaptcha mt-3 mb-3" data-sitekey="<?=$captcha['site_key']?>" ></div>
                            <?php endif; ?>
                        <div class="text-end">
                            <button type="submit" class="btn btn-sm btn-primary icon">
                                <div><i class="las la-question-circle"></i></div>
                                <div>Şifremi Hatırla</div>
                            </button>
                            <a href="/<?=manager_path?>" class="btn btn-sm btn-light icon">
                                <div><i class="las la-angle-left"></i></div>
                                <div>Geri Dön</div>
                            </a>
                        </div>
                    </form>
                    <hr>
                    <div><small><strong>Hesab bilgileriniz yok mu?</strong></small></div>
                    <div>
                        <a href="https://www.baykus.pro" target="_blank" ><small>Baykuş ®</small></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>