<?php 
    $captcha = fetch("integrations[json]", ["name" => "captcha"]);
    if ($captcha):
        $captcha = json_decode($captcha->json, true);
        if (isset($captcha['status'])):
            echo '<!-- reCAPTCHA -->';
            echo "\n";
            echo '    <script src="https://www.google.com/recaptcha/api.js" async defer></script>';
        else:
            $captcha = false;
        endif;
    else:
        $captcha = false;
    endif;
?>

<div id="authentication-container">
    <div class="d-flex justify-content-center align-items-center" id="authentication">
        <div class="container">
            <div class="card">
                <div class="card-body">
                    <div class="title">Yönetim Paneli</div>
                    <div class="description"><small>Lütfen bilgilerinizi girin ve giriş yapın.</small></div>
                    <form action="giris-yap" class="ajax-form">
                        <input type="text" name="username" class="form-control mb-4" placeholder="Kullanıcı adı veya e-posta" zorunlu>
                        <input type="password" name="password" class="form-control mb-4" placeholder="Şifre" zorunlu>

                        <?php if(isset($captcha)): ?>
                            <div class="g-recaptcha mt-3 mb-3" data-sitekey="<?=$captcha['site_key']?>" ></div>
                        <?php endif; ?>

                        <div class="text-end">
                            <small><a href="/<?=manager_path?>/forgot/password" >Şifremi hatırlayamıyorum?</a></small>
                        </div>
                        <div class="form-group mb-3">
                            <button type="submit" class="btn btn-sm btn-primary icon">
                                <div><i class="las la-sign-in-alt"></i></div>
                                <div>Giriş Yap</div>
                            </button>
                        </div>
                    </form>
                    <hr>
                    <div><small><strong>Hesab bilgileriniz yok mu?</strong></small></div>
                    <div>
                        <small><a href="https://www.baykus.pro" target="_blank" >Baykuş ®</a></small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

