<div class="my-profile">
    <div class="container">
        <div class="flex-control">
            <div class="image <?=(fetch("users[image]",array("id"=>$user->id)))->image ? 'active' : '' ?>">
                <img src="<?=$user->image?>">
                <label class="edit" for="profile_image"><i class="las la-edit"></i></label>
                <label class="delete"><i class="las la-trash"></i></label>
            </div>
            <div class="name"><?=$user->name?> <?=$user->surname?> <img src="/view/backend/assets/img/profile/veryfiy.svg" ></div>
            <div class="info">
                <div><?=$user->username?>,</div>
                <div><?=$user->email?>,</div>
                <div><?=$user->phone?></div>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <div class="row gy-4">
        <div class="col-sm-4">
            <div class="card h-100">
                <div class="card-header">Profil Bilgilerim</div>
                <div class="card-body">
                    <table class="profile-info-table">
                        <?php 
                            function calculate_time_difference($verilenZaman)
                            {
                                if($verilenZaman=="") return '-';

                                $zaman = strtotime($verilenZaman);
                                $simdi = time();
                                $fark = $simdi - $zaman;
                                $saniye = $fark;
                                $dakika = round($fark / 60);
                                $saat = round($fark / 3600);
                                $gun = round($fark / 86400);
                                $hafta = round($fark / 604800);
                                $ay = round($fark / 2419200);
                                $yil = round($fark / 29030400);
                                if ($saniye < 60) {
                                    if ($saniye == 0) {
                                        return "az önce";
                                    } else {
                                        return $saniye . ' saniye önce';
                                    }
                                } else if ($dakika < 60) {
                                    return $dakika . ' dakika önce';
                                } else if ($saat < 24) {
                                    return $saat . ' saat önce';
                                } else if ($gun < 7) {
                                    return $gun . ' gün önce';
                                } else if ($hafta < 4) {
                                    return $hafta . ' hafta önce';
                                } else if ($ay < 12) {
                                    return $ay . ' ay önce';
                                } else {
                                    return $yil . ' yıl önce';
                                }
                            }
                        ?>
                        <tr><td>Kullanıcı Adı</td><td>:</td><td><?=$user->username?></td><td></td></tr>
                        <tr><td>Yetki Grubu</td><td>:</td><td><?=$permission->name?></td><td></td></tr>
                        <tr><td>Adı</td><td>:</td><td><?=$user->name?></td><td><i class="las la-edit profile-edit-btn"></i></td></tr>
                        <tr><td>Soyadı</td><td>:</td><td><?=$user->surname?></td><td><i class="las la-edit profile-edit-btn"></i></td></tr>
                        <tr><td>Email</td><td>:</td><td><?=$user->email?></td><td><i class="las la-edit profile-edit-btn"></i></td></tr>
                        <tr><td>Telefon</td><td>:</td><td><?=$user->phone?></td><td><i class="las la-edit profile-edit-btn"></i></td></tr>
                        <tr><td>Oluşturulma</td><td>:</td><td title="<?=calculate_time_difference($user->created)?>" ><?=$user->created?></td><td></td></tr>
                        <tr><td>Şifre Değiştirme</td><td>:</td><td><?=calculate_time_difference($user->last_password_change)?></td><td><i class="las la-edit profile-password-btn"></i></td></tr>
                    </table>
                </div>
            </div> 
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-header">Bildirimler</div>
                <div class="card-body">
                    <table class="notification-kayitlari">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Başlık</td>
                                <td>Açıklama</td>
                                <td>Tarih</td>
                                <td></td>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- datatable -->
<script>
    $(".notification-kayitlari").DataTable({
        "processing": true,
        "serverSide": true,
        "responsive": true,
        responsive: {
            details: true
        },
        "pageLength": 5,
        "lengthMenu": [5, 10, 25, 50, 100],
        "ajax": {
            "url": "/baykus/datatable",
            "type": "POST",
            "data": {
                "action": "user_notifications"
            }
        },
        "columns": [
            {data:"id"},
            {data:"title"},
            {data:"description"},
            {data:"created"},
            {data:"id"}
        ],
        "order": [[0, "desc"]],
        
        "language": {
            "url": "/view/backend/assets/library/datatable/datatable-tr.json"
        },

        // data status = 0 olanları kırmızı yap
        "createdRow": function(row, data, dataIndex) {
            if (data.status == 0) {
                $(row).addClass('bg-danger text-white');
            }
        },
        "drawCallback": function(settings) {
            // Tüm satırları döngüye al
            $('.notification-kayitlari tbody tr').each(function() {
                // Satırın ID'sini al
                var id = $(this).find('td').eq(0).text();
                // ID'yi butonlara ata
                $(this).find('.btn-light').attr('onclick', 'notification_detail(' + id + ')');
                $(this).find('.btn-danger').attr('onclick', 'notification_support(' + id + ')');
            });
        },

        "columnDefs": [
            {
                "targets": 0,
                "responsivePriority":0,
                "className": "text-center"
            },
            {
                "targets": 1,
                "responsivePriority":10,
                "className": "text-start"
            },
            {
                "targets": 2,
                "responsivePriority": 2,
                "orderable": false,
                "className": "text-start",
                "render": function(data, type, row) {
                    if (type === 'display' && data.length > 25) {
                        return '<span title="' + data + '">' + data.slice(0, 25) + '...</span>';
                    }
                    return data;
                }
            },
            {
                "targets": 3,
                "responsivePriority":1,
                "className": "text-center",
                "render": function(data, type, row) {
                    return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                }
            },
            {
                "targets": 4,
                "responsivePriority":3,
                "orderable": false,
                "render": function(data, type, row) {
                    return `
                        <div class="text-end">
                            <button class="btn btn-light btn-sm icon" onclick="notification_detail(${data})">
                                <div>İncele</div>
                                <div><i class="la la-eye"></i></div>
                            </button>
                            <button class="btn btn-danger btn-sm icon" onclick="notification_support(${data})">
                                <div><i class="la la-bell"></i></div>
                                <div>Bildir</div>
                            </button>
                        </div>
                    `;
                }
            }

            
        ]
    });
</script>

<!-- profile crop and modal -->
<div class="modal fade" id="crop-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <input type="file" id="profile_image" name="image" class="d-none">
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="result"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="button" class="btn btn-primary icon">
                    <div><i class="la la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </div>
    </div>
    <script>
        var cropper;
        $("#profile_image").on("change", function() {
            $(".result").html(`<img src="${URL.createObjectURL(this.files[0])}" id="crop-image" class="w-100" style="max-height:400px; object-fit:contain;">`);
            $("#crop-modal").modal("show");
        });
        $("#crop-modal").on("shown.bs.modal", function() {
            if(cropper){
                cropper.destroy();
            }
            cropper = new Cropper(document.getElementById("crop-image"), {
                aspectRatio: 1 / 1,
                viewMode: 1,
                crop: function(event) {
                    $("#x").val(event.detail.x);
                    $("#y").val(event.detail.y);
                    $("#width").val(event.detail.width);
                    $("#height").val(event.detail.height);
                }
            });
            $("#crop-modal [data-crop]").click(function() {
                var crop = $(this).attr("data-crop");
                $("#crop-modal [data-crop]").removeClass("active");
                $(this).addClass("active");
                if (crop == "free") {
                    cropper.setAspectRatio(NaN);
                } else {
                    cropper.setAspectRatio(eval(crop));
                }
            });
            $("#crop-modal .btn-primary").click(function() {
                var canvas = cropper.getCroppedCanvas();
                var dataURL = canvas.toDataURL();
                cropper.destroy();
                cropper = null;
                $(".user-avatar").attr("src", dataURL);
                $(".my-profile .image img").attr("src", dataURL);
                $(".my-profile .image").addClass("active");
                $("#crop-modal").modal("hide");
                $.ajax({
                    url: "/baykus/ajax",
                    type: "POST",
                    data: {
                        action: "profil-resminini-guncelle",
                        image: dataURL
                    }
                })
            });
        });
        $("#crop-modal").on("hidden.bs.modal", function() {
            if (cropper) {
                cropper.destroy();
                cropper = null;
            }
        });
        $(".my-profile .image .delete").click(function() {
            $(".user-avatar").attr("src", "<?=$apiAvatans?>");
            $(".my-profile .image img").attr("src", "<?=$apiAvatans?>");
            $(".my-profile .image").removeClass("active");
            $("#crop-modal [name=image]").val("");
            $.ajax({
                url: "/baykus/ajax",
                type: "POST",
                data: {
                    action: "profil-resminini-guncelle",
                    image: "delete"
                }
            })
        });
    </script>
</div>

<!-- edit modal -->
<div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="modal-content ajax-form" action="profil-bilgileri-guncelle">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Profil Güncelle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="username" class="form-label">Kullanıcı Adı</label>
                    <input type="text" class="form-control" name="username" value="<?=$user->username?>" disabled>
                </div>
                <div class="mb-3">
                    <label for="name" class="form-label">Adınız</label>
                    <input type="text" class="form-control" name="name" value="<?=$user->name?>" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="surname" class="form-label">Soyadınız</label>
                    <input type="text" class="form-control" name="surname" value="<?=$user->surname?>" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">E-Posta</label>
                    <input type="text" class="form-control" name="email" value="<?=$user->email?>" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon</label>
                    <input type="text" class="form-control" name="phone" value="<?=$user->phone?>" zorunlu>
                    <small class="text-danger">numaranızı +90 532 307 19 99 şeklinde giriniz.</small>
                </div>
                <div class="mb-3">
                    <label for="current_password" class="form-label">Mevcut Şifre</label>
                    <input type="password" class="form-control" name="current_password" zorunlu>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="la la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
    <script>
        $(".profile-edit-btn").click(function() {
            $("#edit-modal").modal("show");
        });
    </script>
</div>

<!-- password modal -->
<div class="modal fade" id="password-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="modal-content ajax-form" action="profil-sifre-degistir">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Şifre Değiştir</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="current_password" class="form-label">Mevcut Şifre</label>
                    <input type="password" class="form-control" name="current_password" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Yeni Şifre</label>
                    <input type="password" class="form-control" name="password" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="password_again" class="form-label">Yeni Şifre Tekrar</label>
                    <input type="password" class="form-control" name="password_again" zorunlu>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="la la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
    <script>
        $(".profile-password-btn").click(function() {
            $("#password-modal").modal("show");
        });
    </script>
</div>

<!-- notification view modal -->
<div class="modal fade" id="notification-view-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Bildirim Detayı</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="result"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
            </div>
        </div>
    </div>
    <script>
        function notification_detail(id)
        {
            $.ajax({
                url: "/baykus/ajax",
                type: "POST",
                data: {
                    action: "veri-oku",
                    type: "fetch",
                    table: "user_notifications",
                    where: "id",
                    value: id
                },
                success: function(data) {

                    // tabloyu yenile
                    $(".notification-kayitlari").DataTable().ajax.reload();
                    notification_count();

                    data = JSON.parse(data);
                    var html = `
                        <table class="w-100 table table-bordered">
                            <tr><td>ID</td><td>${data.id}</td></tr>
                            <tr><td>Başlık</td><td>${data.title}</td></tr>
                            <tr><td>Açıklama</td><td>${data.description}</td></tr>
                            ${
                                data.logs
                                    ? `<tr>
                                            <td>Log</td>
                                            <td><pre style="white-space: pre-wrap;margin-bottom:0;" >${typeof data.logs === 'string' 
                                            ? JSON.stringify(JSON.parse(data.logs), null, 4) 
                                            : JSON.stringify(data.logs, null, 4)}</pre></td>
                                    </tr>`
                                    : ''
                            }
                            <tr><td>Oluşturulma</td><td>${data.created}</td></tr>
                        </table>
                    `;
                    $("#notification-view-modal .result").html(html);
                    $("#notification-view-modal").modal("show");
                }
            });
            $.ajax({
                url: "/baykus/ajax",
                type: "POST",
                data: {
                    action: "bildirim-okundu",
                    id: id
                }
            })
        } 
    </script>
</div>

<!-- notification support modal -->
<div class="modal fade" id="notification-support-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="profil-bildirim-bildir">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Bildirim Bildir</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Bildirim ID</label>
                    <input type="text" class="form-control" name="notification_id" disabled>
                </div>
                <div class="mb-3">
                    <label for="notification" class="form-label">Bildirim</label>
                    <textarea class="form-control" name="notification" rows="5" zorunlu></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-danger icon">
                    <div><i class="la la-bell"></i></div>
                    <div>Bildir</div>
                </button>
            </div>
        </form>
    </div>
    <script>
        function notification_support(id)
        {
            $("#notification-support-modal [name=notification_id]").val(id);
            $("#notification-support-modal [name=id]").val(id);
            $("#notification-support-modal").modal("show");
        }
    </script>
</div>

<?php
    if(isset($_GET['log'])):
        echo "<script>notification_detail(".$_GET['log'].")</script>";
        echo "<script>
            var url = new URL(window.location.href);
            url.searchParams.delete('log'); // 'notification' parametresini sil
            window.history.replaceState({}, '', url); // URL'yi güncelle
        </script>";
    endif;
?>

