<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left"><?=$title?></div>
                <div class="actions">
                    <a class="btn btn-sm btn-light icon" onclick="window.history.back()">
                        <div><i class="las la-arrow-left"></i></div>
                        <div>Geri Dön</div>
                    </a>
                    <a href="/<?=manager_path?>/category/<?=$type?>/create" class="btn btn-sm btn-light icon">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Kategori</div>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Adı</th>
                            <th>Oluşturulma</th>
                            <th>Sıra</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="language" class="form-label">Dil</label>
                        <select name="language" id="language" class="form-select">
                            <?php foreach($dil_secenekleri as $dil): ?>
                                <option value="<?=$dil->id?>"><?=$dil->code?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                theme: $('#theme').val(),
                status: $('#status').val(),
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                language: $('#language').val()
            };
        }
        $('input,select').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "category_contents",
                        "type": "<?=$type?>_category",
                        "theme": filters.theme,
                        "status": filters.status,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date,
                        "language": filters.language
                    });
                }
            },
            "order": [[3, "asc"]],
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                {"data": "id"},
                {"data": "name"},
                {"data": "created"},
                {"data": "sort"},
                {"data": "status"},
                {"data": "id"}
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center"
                },
                {
                    "targets": 1,
                    "className": "text-left"
                },
                {
                    "targets": 2,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": 3,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span class="badge bg-secondary">${data}</span>`;
                    }
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "render": function(data) {
                        return data == 1 ? '<div class="badge bg-success">Aktif</div>' : '<div class="badge bg-warning">Taslak</div>';
                    }
                },
                {
                    "targets": 5,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="window.location.href='/<?=manager_path?>/category/<?=$type?>/edit/${data}'">
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="contents" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>