<?php

switch($action):

    case "giris-yap":

        if ($captcha = fetch("integrations[json]", ["name" => "captcha"])):
            $captcha = json_decode($captcha->json, true);
            if (isset($captcha['status'])):
                if(isset($_POST['g-recaptcha-response'])):
                    $captcha_response = $_POST['g-recaptcha-response'];
                    $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$captcha['secret_key']."&response=".$captcha_response);
                    $response = json_decode($response);
                    if(!$response->success):
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "error",
                            "title" => "İşlem Başarısız!",
                            "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                            "timer" => 3000,
                        ));
                        return;
                    endif;
                else:
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "İşlem Başarısız!",
                        "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                        "timer" => 3000,
                    ));
                    return;
                endif;
            endif;
        endif;

        ## Bilgileri kontrol et
        $control = fetch("users",array("username[or]email" => $username,"password" => encrypt($password)));

        ## Eğer kontrol başarılı ise
        if($control):
            if($control->multiple != 1 && fetch("user_sessions[id]",array("status"=>1,"user" => $control->id))):
                update("user_sessions",array("status" => 0),array("user" => $control->id));
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Aktif oturum kapatıldı. Lütfen tekrar deneyiniz.",
                    "gRecaptchaReset" => ($captcha) ? true : false,
                    "timer" => 3000,
                ));
                return;
            endif;
            $token = md5(uniqid());
            $_COOKIE['manager'] = $token;
            setcookie("manager",$token,time()+60*60*24*365,"/");
            create("user_sessions",array("user"=>$control->id,"token"=>$token,"ip_address"=>$_SERVER['REMOTE_ADDR'],"user_agent"=>$_SERVER['HTTP_USER_AGENT']));
            echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "success",
            "title" => "İşlem Başarılı!",
            "description" => "Giriş işlemi başarılı bir şekilde gerçekleşti.",
            "timer" => 1500,
            "location" => "/".manager_path."/dashboard",
            ));
            return;
        endif;

        ## Eğer kullanıcı adı ve şifre hatalı ise
        if($control = fetch("users",array("username[or]email" => $username))):
            create("user_notifications",array(
                "user" => $control->id,
                "title" => "Hatalı Giriş Denemesi",
                "description" => "Yönetim paneline hatalı şifre denemesi yapıldı. Log kayıtlarını kontrol etmenizi öneririz.",
                "icon" => "lab la-keycdn",
                "color" => "danger",
                "logs" => json_encode(array("ip_address"=>$_SERVER['REMOTE_ADDR'],"user_agent"=>$_SERVER['HTTP_USER_AGENT'],"username"=>$username,"password"=>$password))
            ));
            $mail_konu = website ." Yönetim Paneli Hatalı Giriş Denemesi - #".time();
            $mail_icerik = "<p>Merhaba,</p>";
            $mail_icerik .= "<p>Yönetim paneline hatalı giriş denemesi yapıldı.</p>";
            $mail_icerik .= "<p><b>Kullanıcı Adı:</b> ".$username."</p>";
            $mail_icerik .= "<p><b>Şifre:</b> ".$password."</p>";
            $mail_icerik .= "<p><b>IP Adresi:</b> ".$_SERVER['REMOTE_ADDR']."</p>";
            $mail_icerik .= "<p><b>Kullanıcı Ajanı:</b> ".$_SERVER['HTTP_USER_AGENT']."</p>";
            $mail_icerik .= "<p>Bu e-posta, sistem tarafından otomatik olarak gönderilmiştir.</p>";
            $mail_icerik .= "<p>Eğer bu giriş denemesini siz yapmadıysanız, lütfen şifrenizi değiştirin ve hesabınızı güvence altına alın.</p>";
            $mail_icerik .= "<p>İyi günler dileriz.</p>";
            $mail_icerik .= "<p><a href='".website."/".manager_path."'>Yönetim Paneline Git</a></p>";
            $mail_icerik .= "<p>Not: Bu e-posta, sistem tarafından otomatik olarak gönderilmiştir.</p>";
            sendMail($control->email,$mail_konu,$mail_icerik);
            sendSms($control->phone,$mail_konu."\nKullanıcı Adı: ".$username."\nŞifre: ".$password."\nIP Adresi: ".$_SERVER['REMOTE_ADDR']."\nKullanıcı Ajanı: ".$_SERVER['HTTP_USER_AGENT']);
        endif;

        ## Eğer kullanıcı adı ve şifre hatalı ise
        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "error",
            "title" => "Hatalı Giriş!",
            "description" => "Kullanıcı adı veya şifre hatalı.",
            "gRecaptchaReset" => ($captcha) ? true : false,
            "timer" => 3000,
        ));

    break;

    case "randevu-olustur":

        // required: customer, date, time
        if(!isset($customer) || empty($customer) || !isset($date) || empty($date) || !isset($time) || empty($time)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Müşteri, tarih ve saat alanları zorunludur.",
                "timer" => 3000
            ));
            return;
        endif;

        // combine date and time into datetime
        $start_at = $date . ' ' . $time . ':00';

        // compute end_at from duration (minutes)
        $end_at = null;
        if(isset($duration) && is_numeric($duration) && $duration > 0):
            try{
                $dt = new DateTime($start_at);
                $dt->modify('+'.intval($duration).' minutes');
                $end_at = $dt->format('Y-m-d H:i:s');
            } catch(Exception $e){
                $end_at = null;
            }
        endif;

        $createData = array(
            "customer" => $customer,
            "start_at" => $start_at,
            "end_at" => $end_at,
            "note" => isset($note) ? $note : null,
            "status" => isset($status) ? $status : 1,
            "created" => date("Y-m-d H:i:s")
        );

        $create = create("appointments", $createData);
        if($create):

            $customer_info = fetch("customers[phone,first_name,last_name]", array("id" => $customer));



            sendSms($customer_info->phone, "Sayın ".$customer_info->first_name." ".$customer_info->last_name.", ".$date." tarihinde saat ".$time." için randevunuz oluşturulmuştur. Zamanında gelmenizi önemle rica eder, ilginiz için teşekkür ederiz. Saygılarımızla.");

            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Randevu başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "randevu-guncelle":

        if(!isset($id) || empty($id)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Geçersiz randevu id.",
                "timer" => 3000
            ));
            return;
        endif;

        if(!isset($customer) || empty($customer) || !isset($date) || empty($date) || !isset($time) || empty($time)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Müşteri, tarih ve saat alanları zorunludur.",
                "timer" => 3000
            ));
            return;
        endif;

        $start_at = $date . ' ' . $time . ':00';

        $end_at = null;
        if(isset($duration) && is_numeric($duration) && $duration > 0):
            try{
                $dt = new DateTime($start_at);
                $dt->modify('+'.intval($duration).' minutes');
                $end_at = $dt->format('Y-m-d H:i:s');
            } catch(Exception $e){
                $end_at = null;
            }
        endif;

        $updateData = array(
            "customer" => $customer,
            "start_at" => $start_at,
            "end_at" => $end_at,
            "note" => isset($note) ? $note : null,
            "status" => isset($status) ? $status : 1,
        );

        $update = update("appointments", $updateData, array("id" => $id));
        if($update):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Randevu başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "sifremi-unuttum":

        if ($captcha = fetch("integrations[json]", ["name" => "captcha"])):
            $captcha = json_decode($captcha->json, true);
            if (isset($captcha['status'])):
                if(isset($_POST['g-recaptcha-response'])):
                    $captcha_response = $_POST['g-recaptcha-response'];
                    $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$captcha['secret_key']."&response=".$captcha_response);
                    $response = json_decode($response);
                    if(!$response->success):
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "error",
                            "title" => "İşlem Başarısız!",
                            "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                            "timer" => 3000,
                        ));
                        return;
                    endif;
                else:
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "İşlem Başarısız!",
                        "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                        "timer" => 3000,
                    ));
                    return;
                endif;
            endif;
        endif;

        ## Bilgileri kontrol et
        $control = fetch("users",array("username[or]email" => $username));

        ## Eğer kontrol başarılı ise
        if($control):
            $rand = rand(100000,999999);
            $rand = md5($rand);
            update("users",array("reset"=>$rand),array("id" => $control->id),0);

            $email_html = '<p>Merhaba '.$control->name.' '.$control->surname.',</p>';
            $email_html .= '<p>Şifrenizi sıfırlamak için aşağıdaki bağlantıya tıklayınız.</p>';
            $email_html .= '<p><a href="'.website.'/'.manager_path.'/reset/password/'.$rand.'">Şifremi Sıfırla</a></p>';
            $email_html .= '<p>Şifre sıfırlama bağlantısı 24 saat geçerlidir.</p>';
            $email_html .= '<p>Şifre sıfırlama işlemi hakkında herhangi bir bilginiz yoksa bu e-postayı dikkate almayınız.</p>';
            $email_html .= '<p>İyi günler dileriz.</p>';

            sendMail($control->email,"Şifre Sıfırlama",$email_html);
            sendSms($control->phone,website."/".manager_path."/reset/password/".$rand);

            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Sıfırlama bağlantısı e-posta adresinize gönderildi.",
                "formReset" => true,
                "timer" => 3000,
                "location" => "/".manager_path
            ));

            return;
        endif;

        ## Eğer bilgiler yanlış ise
        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "error",
            "title" => "İşlem Başarısız!",
            "description" => "Kullanıcı adı veya e-posta adresi hatalı.",
            "gRecaptchaReset" => ($captcha) ? true : false,
            "timer" => 3000
        ));

    break;

    case "sifremi-unuttum-degistir":

        ## Bilgileri kontrol et
        $control = fetch("users",array("reset" => $token));

        ## Eğer şifreler uyuşmuyorsa
        if($password != $password_again):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Şifreler uyuşmuyor.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Eğer kontrol başarılı ise
        if($control):
            update("users",array("password"=>encrypt($password),"reset"=>null),array("id" => $control->id),0);
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Şifreniz başarılı bir şekilde değiştirildi.",
                "formReset" => true,
                "timer" => 1500,
                "location" => "/".manager_path
            ));
            return;
        endif;

        ## Eğer kontrol başarısız ise
        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "error",
            "title" => "İşlem Başarısız!",
            "description" => "Şifre sıfırlama bağlantısı geçersiz.",
            "timer" => 3000
        ));

    break;

    case "profil-bilgileri-guncelle":

        ## mevcut şifre kontrolü
        if($active_user->password!=encrypt($current_password)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Mevcut şifreniz hatalı.",
                "timer" => 3000,
                "formReset" => true
            ));
            return;
        endif;

        ## bilgileri güncelle
        if(update("users",array("name" => $name,"surname" => $surname,"email" => $email,"phone" => $phone),array("id" => $active_user->id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Profil bilgileriniz başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "refresh" => true
            ));
            return;
        endif;

    break;

    case "profil-resminini-guncelle":

        if($image == "delete"):
            if(update("users",array("image" => null),array("id" => $active_user->id))):
                
                return;
            endif;
        endif;

        require "app/upload.php";
        $upload = new Upload($image);
        if($upload->uploaded):
            $upload->file_new_name_body = slugify($active_user->name." ".$active_user->surname);
            $upload->image_convert = 'webp';
            $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/users');
            if($upload->processed):
                $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/users/'.$upload->file_dst_name);
                $path = "/view/frontend/assets/img/users/".$upload->file_dst_name;
                if(update("users",array("image" => $path),array("id" => $active_user->id))):
                    
                    return;
                endif;
            endif;
        endif;

    break;

    case "profil-sifre-degistir":

        ## mevcut şifre kontrolü
        if($active_user->password!=encrypt($current_password)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Mevcut şifreniz hatalı.",
                "timer" => 3000,
            ));
            return;
        endif;

        ## şifreler uyuşmuyorsa
        if($password != $password_again):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Şifreler uyuşmuyor.",
                "timer" => 3000,
            ));
            return;
        endif;

        ## şifre güncelle
        if(update("users",array("password" => encrypt($password)),array("id" => $active_user->id))):
            update("users",array("last_password_change" => date("Y-m-d H:i:s")),array("id" => $active_user->id));
            update("user_sessions",array("status" => 0),array("user" => $active_user->id));
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Şifreniz başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "refresh" => true
            ));
            return;
        endif;

    break;

    case "profil-bildirim-bildir":

        $bildirim = fetch("user_notifications",array("id" => $id));

        $html  = "<p> <b> Bildirim Başlığı: </b> ".$bildirim->title." </p>";
        $html .= "<p> <b> Bildirim Açıklaması: </b> ".$bildirim->description." </p>";
        $html .= "<p> <b> Bildirim Tarihi: </b> ".date("d.m.Y H:i",strtotime($bildirim->created))." </p>";

        $html .= "<p> <b> Bildirimde bulunan kişi:</b> ".$active_user->name." ".$active_user->surname."<p>";
        $html .= "<p> <b> Bildirimde bulunan kişinin e-posta adresi:</b> ".$active_user->email."<p>";
        $html .= "<p> <b> Bildirimde bulunan kişinin telefon numarası:</b> ".$active_user->phone."<p>";
        $html .= "<p> <b> Bildirimde bulunan kişinin IP adresi:</b> ".$_SERVER['REMOTE_ADDR']."<p>";
        $html .= "<p> <b> Bildirimde bulunan kişinin tarayıcı bilgisi:</b> ".$_SERVER['HTTP_USER_AGENT']."<p>";
        $html .= "<p> <b> Bildirimde bulunan kişinin mesaajı:</b> ".$notification."<p>";

        $html .= "<pre>".$bildirim->logs."</pre>";

        $html .= website;

        $subject = "#".time()." Log Bildirimi";

        if(sendMail(developer_email,$subject,$html)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Bildiriminiz başarılı bir şekilde iletildi.",
                "timer" => 1500,
                "closeModal" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "bildirim-okundu":

        ## log kaydını okundu olarak işaretle
        update("user_notifications",array("status" => 1),array("id" => $id));

    break;

    case "slug-olustur":

        function generateSlug($value, $language, $default_language, $prefix = null) {
            // Eğer value boş ise hemen döndür
            if (empty($value)) {
                echo "";
                return;
            }
        
            // Prefix'e göre kategoriler
            $typeMappings = [
                "category" => ["tr" => "kategori", "default" => "category"],
                "service"  => ["tr" => "hizmet", "default" => "service"],
                "blog"     => ["tr" => "blog", "default" => "blog"],
                "product"  => ["tr" => "urun", "default" => "product"],
                "reference" => ["tr" => "referans", "default" => "reference"],
            ];
        
            // Varsayılan dilde mi?
            $isDefaultLanguage = $default_language->id == $language;
        
            // Dil kodunu al
            $lang = $isDefaultLanguage ? $default_language : fetch("languages[code]", ["id" => $language]);
            $langCode = $isDefaultLanguage ? "" : "/" . $lang->code;
        
            // Prefix kontrolü
            if ($prefix && isset($typeMappings[$prefix])) {
                $slugPrefix = ($lang->code == "tr") 
                    ? $typeMappings[$prefix]["tr"] 
                    : $typeMappings[$prefix]["default"];
                $slug = "$langCode/$slugPrefix/" . slugify($value);
            } else {
                $slug = $isDefaultLanguage 
                    ? "/" . slugify($value) 
                    : "$langCode/" . slugify($value);
            }
        
            // Sonucu yazdır
            echo $slug;
        }

        echo generateSlug($value, $language, $default_language, @$prefix);

    break;

    case "veri-oku":

        if($type=="fetch"):
            $data = fetch($table,array($where => $value));
                echo json_encode($data);
            return;
        endif;

        if($type=="fetchAll"):

            if(isset($order)): $order = array($orderColumn=>$orderType); else: $order = null; endif;

            $data = fetchAll($table,array($where => $value),$order);
                echo json_encode($data);
            return;
        endif;

    break;

    case "veri-sil":

        if(!isset($table) || !isset($where) || !isset($value) || empty($table) || empty($where) || empty($value)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Gerekli parametreler eksik.",
                "timer" => 3000
            ));
            return;
        endif;

        if($table == "user_calendar"):
            $delete = delete("user_calendar",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "calendarItem" => $value,
                ));
                return;
            endif;
        endif;

        if($table == "contents"):

            if($value == 1):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Açılış sayfası silinemez.",
                    "timer" => 3000
                ));
                return;
            endif;

            $parent_control = fetch("contents[parent]",array("parent" => $value));
            if($parent_control):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu kategoriye bağlı alt kategoriler var.",
                    "timer" => 3000
                ));
                return;
            endif;

            $content_control = fetch("contents[id]",array("category" => $value));
            if($content_control):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu kategoriye bağlı içerikler var.",
                    "timer" => 3000
                ));
                return;
            endif;

            $value = explode(",",$value);
            foreach($value as $val):
                $delete = delete("contents",array($where => $val));
                if($delete):
                    delete("content_products",array("content" => $val));
                    delete("content_translations",array("content" => $val));
                    delete("content_layouts",array("content" => $val));
                    delete("files",array("master_table"=>"content","master_id" => $val));
                endif;
            endforeach;
            cacheRoute();
            echo json_encode(array(
                "datatableReload" => true,
            ));
        endif;
        
        if($table == "languages"):

            ## eğer varsayılan dil ise
            if($value == @$default_language->id):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Varsayılan dil silinemez.",
                    "timer" => 3000
                ));
                return;
            endif;

            ## eğer son dil ise
            if(count(fetchAll("languages")) == 1):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Son dil silinemez.",
                    "timer" => 3000
                ));
                return;
            endif;

            $delete = delete("languages",array($where => $value));
            if($delete):
                delete("language_variables",array("language" => $value));
                delete("content_translations",array("language" => $value));
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                cacheRoute();   
                return;
            endif;
           
        endif;

        if($table == "customers"):

            // randevu varsa silme
            $appointment_control = fetch("appointments[id]", array("customer" => $value));
            if($appointment_control):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu müşteriye ait randevular var. Öncelikle randevuları silmelisiniz.",
                    "timer" => 3000
                ));
                return;
            endif;

            $value = explode(",", $value);
            foreach($value as $val):
                $delete = delete("customers", array($where => $val));
            endforeach;
            if(isset($delete) && $delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;

        endif;

        if($table == "appointments"):

            // 

            $value = explode(",", $value);
            foreach($value as $val):
                $delete = delete("appointments", array($where => $val));
            endforeach;
            if(isset($delete) && $delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;

        endif;

        if($table == "language_variables"):
            $delete = delete("language_variables",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;
        endif;

        if($table == "newsletters"):
            $delete = delete("newsletters",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "newslettersAjaxGroups" => true,
                ));
                return;
            endif;
        endif;

        if($table == "cronjob_logs"):

            $dosya = $_SERVER['DOCUMENT_ROOT']."/".$where;

            // dosya varmı kontrol et ve sil
            if(file_exists($dosya)):
                unlink($dosya);
            endif;

            echo json_encode(array(
                "refresh" => true,
            ));
        endif;

        if($table == "users"):

            if($value == 1):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Yönetici hesabı silinemez.",
                    "timer" => 3000
                ));
                return;
            endif;
            
            if($value == $active_user->id):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Kendi hesabınızı silemezsiniz.",
                    "timer" => 3000
                ));
                return;
            endif;

            $delete = delete("users",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;
        
        endif;

        if($table == "user_permissions"):

            ## eğer bi kullanıcıya aitse
            if(fetch("users[id]",array("permission" => $value))):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu yetkiye sahip bir kullanıcı var.",
                    "timer" => 3000
                ));
                return;
            endif;

            $delete = delete("user_permissions",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;

        endif;

        if($table == "content_layouts"):

            $delete = delete("content_layouts",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "content_layouts_delete" => $value,
                ));
                return;
            endif;

        endif;

        if($table == "content_modules"):
            
            $delete = delete("content_modules",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;

        endif;

        if($table == "banners" ):
            $delete = delete("banners",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;
        endif;

        if($table == "feedback"):
            $delete = delete("feedback",array($where => $value));
            if($delete):
                echo json_encode(array(
                    "datatableReload" => true,
                ));
                return;
            endif;
        endif;

    break;

    case "veri-sira-guncelle":

        if(!isset($table) || !isset($where) || !isset($value) || empty($table) || empty($where) || empty($value)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Gerekli parametreler eksik.",
                "timer" => 3000
            ));
            return;
        endif;

       foreach($value as $key => $item):
            update($table,array("sort" => $key),array($where => $item));
        endforeach;

        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "success",
            "title" => "İşlem Başarılı!",
            "description" => "Sıralama başarılı bir şekilde güncellendi.",
            "timer" => 1500
        ));

    break;

    case "fancytree":

        switch($type):

            case "page_category_parents":

                ## boş bir dizi oluşturuyoruz
                $data = array();
            
                ## Eğer key değeri set edilmemişse
                if (!isset($key)):
                    $key_condition = "contents.parent IS NULL";
                else:
                    $key_condition = "contents.parent = :key";
                endif;
            
                ## Eğer excluding set edilirse, sorguya ekliyoruz
                if (isset($excluding)):
                    $excluding_condition = "AND contents.id != :excluding";
                else:
                    $excluding_condition = "";
                endif;
            
                ## Sorguyu oluşturuyoruz
                $query = "
                    SELECT 
                        contents.id,
                        COALESCE(
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            AND content_translations.language = :default_language 
                            LIMIT 1),
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            ORDER BY language ASC 
                            LIMIT 1)
                        ) AS name
                    FROM contents
                    WHERE contents.type = :type
                    AND $key_condition
                    $excluding_condition
                    ORDER BY contents.sort ASC;
                ";
            
                ## Sorguyu çalıştırıyoruz
                $categories = $db->prepare($query);
            
                ## Parametreleri oluştur
                $params = [
                    "type" => "page_category",
                    "default_language" => $default_language->id
                ];
            
                if (isset($key)) {
                    $params["key"] = $key; // Eğer $key varsa, bunu parametre olarak ekliyoruz
                }
            
                if (isset($excluding)) {
                    $params["excluding"] = $excluding; // Eğer $excluding varsa, bunu parametre olarak ekliyoruz
                }
            
                ## Sorguyu çalıştır
                $categories->execute($params);
            
                ## Sonuçları al
                $categories = $categories->fetchAll(PDO::FETCH_OBJ);
            
                ## Eğer kategori varsa
                if(count($categories) > 0):
                    foreach($categories as $category):
            
                        ## Eğer alt kategori varsa
                        $children = fetch("contents[id]", array("parent" => $category->id));
            
                        ## Eğer alt kategori varsa
                        if($children):
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => true,
                                "lazy" => true
                            );
                        else:
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => false,
                                "lazy" => false
                            );
                        endif;
            
                    endforeach;
                endif;
            
                ## Yazdır
                echo json_encode($data);
            
            break;
            
            case "page_category":

                ## boş bir dizi oluşturuyoruz
                $data = array();
            
                ## Eğer key değeri set edilmemişse
                if (!isset($key)):
                    $key_condition = "contents.parent IS NULL";
                else:
                    $key_condition = "contents.parent = :key";
                endif;
            
                ## Eğer excluding set edilirse, sorguya ekliyoruz
                if (isset($excluding)):
                    $excluding_condition = "AND contents.id != :excluding";
                else:
                    $excluding_condition = "";
                endif;
            
                ## Sorguyu oluşturuyoruz
                $query = "
                    SELECT 
                        contents.id,
                        COALESCE(
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            AND content_translations.language = :default_language 
                            LIMIT 1),
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            ORDER BY language ASC 
                            LIMIT 1)
                        ) AS name
                    FROM contents
                    WHERE contents.type = :type
                    AND $key_condition
                    $excluding_condition
                    ORDER BY contents.sort ASC;
                ";
            
                ## Sorguyu çalıştırıyoruz
                $categories = $db->prepare($query);
            
                ## Parametreleri oluştur
                $params = [
                    "type" => "page_category",
                    "default_language" => $default_language->id
                ];
            
                if (isset($key)) {
                    $params["key"] = $key; // Eğer $key varsa, bunu parametre olarak ekliyoruz
                }
            
                if (isset($excluding)) {
                    $params["excluding"] = $excluding; // Eğer $excluding varsa, bunu parametre olarak ekliyoruz
                }
            
                ## Sorguyu çalıştır
                $categories->execute($params);
            
                ## Sonuçları al
                $categories = $categories->fetchAll(PDO::FETCH_OBJ);
            
                ## Eğer kategori varsa
                if(count($categories) > 0):
                    foreach($categories as $category):
            
                        ## Eğer alt kategori varsa
                        $children = fetch("contents[id]", array("parent" => $category->id));
            
                        ## Eğer alt kategori varsa
                        if($children):
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => true,
                                "lazy" => true
                            );
                        else:
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => false,
                                "lazy" => false
                            );
                        endif;
            
                    endforeach;
                endif;
            
                ## Yazdır
                echo json_encode($data);

            break;

            case "service_category":

                ## boş bir dizi oluşturuyoruz
                $data = array();
            
                ## Eğer key değeri set edilmemişse
                if (!isset($key)):
                    $key_condition = "contents.parent IS NULL";
                else:
                    $key_condition = "contents.parent = :key";
                endif;
            
                ## Eğer excluding set edilirse, sorguya ekliyoruz
                if (isset($excluding)):
                    $excluding_condition = "AND contents.id != :excluding";
                else:
                    $excluding_condition = "";
                endif;
            
                ## Sorguyu oluşturuyoruz
                $query = "
                    SELECT 
                        contents.id,
                        COALESCE(
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            AND content_translations.language = :default_language 
                            LIMIT 1),
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            ORDER BY language ASC 
                            LIMIT 1)
                        ) AS name
                    FROM contents
                    WHERE contents.type = :type
                    AND $key_condition
                    $excluding_condition
                    ORDER BY contents.sort ASC;
                ";
            
                ## Sorguyu çalıştırıyoruz
                $categories = $db->prepare($query);
            
                ## Parametreleri oluştur
                $params = [
                    "type" => "service_category",
                    "default_language" => $default_language->id
                ];
            
                if (isset($key)) {
                    $params["key"] = $key; // Eğer $key varsa, bunu parametre olarak ekliyoruz
                }
            
                if (isset($excluding)) {
                    $params["excluding"] = $excluding; // Eğer $excluding varsa, bunu parametre olarak ekliyoruz
                }
            
                ## Sorguyu çalıştır
                $categories->execute($params);
            
                ## Sonuçları al
                $categories = $categories->fetchAll(PDO::FETCH_OBJ);
            
                ## Eğer kategori varsa
                if(count($categories) > 0):
                    foreach($categories as $category):
            
                        ## Eğer alt kategori varsa
                        $children = fetch("contents[id]", array("parent" => $category->id));
            
                        ## Eğer alt kategori varsa
                        if($children):
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => true,
                                "lazy" => true
                            );
                        else:
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => false,
                                "lazy" => false
                            );
                        endif;
            
                    endforeach;
                endif;
            
                ## Yazdır
                echo json_encode($data);

            break;

            case "blog_category":

                ## boş bir dizi oluşturuyoruz
                $data = array();
            
                ## Eğer key değeri set edilmemişse
                if (!isset($key)):
                    $key_condition = "contents.parent IS NULL";
                else:
                    $key_condition = "contents.parent = :key";
                endif;
            
                ## Eğer excluding set edilirse, sorguya ekliyoruz
                if (isset($excluding)):
                    $excluding_condition = "AND contents.id != :excluding";
                else:
                    $excluding_condition = "";
                endif;
            
                ## Sorguyu oluşturuyoruz
                $query = "
                    SELECT 
                        contents.id,
                        COALESCE(
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            AND content_translations.language = :default_language 
                            LIMIT 1),
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            ORDER BY language ASC 
                            LIMIT 1)
                        ) AS name
                    FROM contents
                    WHERE contents.type = :type
                    AND $key_condition
                    $excluding_condition
                    ORDER BY contents.sort ASC;
                ";
            
                ## Sorguyu çalıştırıyoruz
                $categories = $db->prepare($query);
            
                ## Parametreleri oluştur
                $params = [
                    "type" => "blog_category",
                    "default_language" => $default_language->id
                ];
            
                if (isset($key)) {
                    $params["key"] = $key; // Eğer $key varsa, bunu parametre olarak ekliyoruz
                }
            
                if (isset($excluding)) {
                    $params["excluding"] = $excluding; // Eğer $excluding varsa, bunu parametre olarak ekliyoruz
                }
            
                ## Sorguyu çalıştır
                $categories->execute($params);
            
                ## Sonuçları al
                $categories = $categories->fetchAll(PDO::FETCH_OBJ);
            
                ## Eğer kategori varsa
                if(count($categories) > 0):
                    foreach($categories as $category):
            
                        ## Eğer alt kategori varsa
                        $children = fetch("contents[id]", array("parent" => $category->id));
            
                        ## Eğer alt kategori varsa
                        if($children):
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => true,
                                "lazy" => true
                            );
                        else:
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => false,
                                "lazy" => false
                            );
                        endif;
            
                    endforeach;
                endif;
            
                ## Yazdır
                echo json_encode($data);

            break;

            case "product_category":

                ## boş bir dizi oluşturuyoruz
                $data = array();
            
                ## Eğer key değeri set edilmemişse
                if (!isset($key)):
                    $key_condition = "contents.parent IS NULL";
                else:
                    $key_condition = "contents.parent = :key";
                endif;
            
                ## Eğer excluding set edilirse, sorguya ekliyoruz
                if (isset($excluding)):
                    $excluding_condition = "AND contents.id != :excluding";
                else:
                    $excluding_condition = "";
                endif;
            
                ## Sorguyu oluşturuyoruz
                $query = "
                    SELECT 
                        contents.id,
                        COALESCE(
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            AND content_translations.language = :default_language 
                            LIMIT 1),
                            (SELECT name 
                            FROM content_translations 
                            WHERE content_translations.content = contents.id 
                            ORDER BY language ASC 
                            LIMIT 1)
                        ) AS name
                    FROM contents
                    WHERE contents.type = :type
                    AND $key_condition
                    $excluding_condition
                    ORDER BY contents.sort ASC;
                ";
            
                ## Sorguyu çalıştırıyoruz
                $categories = $db->prepare($query);
            
                ## Parametreleri oluştur
                $params = [
                    "type" => "product_category",
                    "default_language" => $default_language->id
                ];
            
                if (isset($key)) {
                    $params["key"] = $key; // Eğer $key varsa, bunu parametre olarak ekliyoruz
                }
            
                if (isset($excluding)) {
                    $params["excluding"] = $excluding; // Eğer $excluding varsa, bunu parametre olarak ekliyoruz
                }
            
                ## Sorguyu çalıştır
                $categories->execute($params);
            
                ## Sonuçları al
                $categories = $categories->fetchAll(PDO::FETCH_OBJ);
            
                ## Eğer kategori varsa
                if(count($categories) > 0):
                    foreach($categories as $category):
            
                        ## Eğer alt kategori varsa
                        $children = fetch("contents[id]", array("parent" => $category->id));
            
                        ## Eğer alt kategori varsa
                        if($children):
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => true,
                                "lazy" => true
                            );
                        else:
                            $data[] = array(
                                "title" => $category->name,
                                "key" => $category->id,
                                "folder" => false,
                                "lazy" => false
                            );
                        endif;
            
                    endforeach;
                endif;
            
                ## Yazdır
                echo json_encode($data);

            break;

        endswitch;

    break;

    case "icerik-olustur":

        $content = array();
        $_empty_language = 0;
        require "app/upload.php";
    
        ## Genel içerik oluşturması
        $content["type"] = $type;
        $content["theme"] = isset($theme) ? (empty($theme) ? null : $theme) : null;
        $content["category"] = isset($category) ? (empty($category) ? null : $category) : null;
        $content["showcase"] = isset($showcase) ? (empty($showcase) ? null : $showcase) : null;
        $content["status"] = isset($status) ? $status : 1;
        $content["sort"] = isset($sort) ? (empty($sort) ? null : $sort) : null;
        $content["parent"] = isset($parent) ? (empty($parent) ? null : $parent) : null;
        $content["parent_history"] = isset($parent_history) ? (empty($parent_history) ? null : $parent_history) : null;
        $content["published"] = isset($published) ? (empty($published) ? null : $published) : null;

        ## Eğer Tema Özel İse
        if($content["theme"] == "special"):
            $content["theme"] = $content["theme"] = $special;
        endif;

        ## Eğer içerik tipi product ise ve code dolu ise kontorol ediyoruz
        if($type == "product" && isset($_POST['code']) && !empty($_POST['code'])):
            if(fetch("content_products",array("code" => $_POST['code']))):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu ürün kodu zaten mevcut.",
                    "timer" => 3000
                ));
                return;
            endif;
        endif;

        ## Gerekli kontrolleri yapıyoruz
        foreach($active_languages as $ajax_lang):
            $name = $_POST['name_'.$ajax_lang->id];
            $url = $_POST['url_'.$ajax_lang->id];
            if(fetch("content_translations",array("url" => $url))):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu URL <b><a class='text-danger' href='".$url."' target='_blank'>".$url."</a></b> zaten mevcut.",
                    "timer" => 3000
                ));
                return;
            endif;
            if(empty($name) || empty($url)):
                $_empty_language++;
            endif;
        endforeach;

        ## Eğer tüm diller boş geliyorsa
        if($_empty_language == rowCount("languages")):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "En az bir dil için işlem yapmalısınız.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Eğer herşey yolunda ise içeriği oluşturuyoruz
        $create = create("contents",$content);

        ## Eğer resim varsa
        if(isset($_POST['gallery'])):
    
            foreach($_POST['gallery'] as $key => $value):
                $upload = new Upload($value);
                if($upload->uploaded):
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();

                    ## WEBP
                    $upload->image_convert = 'webp';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);
                        create("files",array(
                            "master_table" => "contents",
                            "master_id" => $create,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "webp",
                            "file_size" => $file_size,
                            "sort" => $key
                        ));
                    endif;

                    ## JPG
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();
                    $upload->image_convert = 'jpg';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);

                        ## Eğer ilk resim varsa
                        if($key == 0):
                            $image = "/view/frontend/assets/img/$type/".$upload->file_dst_name;
                            update("contents",array("image" => $image),array("id" => $create),0);
                        endif;

                        create("files",array(
                            "master_table" => "contents",
                            "master_id" => $create,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "jpg",
                            "file_size" => $file_size,
                            "sort" => $key
                        ));
                    endif;

                endif;
            endforeach;
        endif;

        ## Dil çevirilerini oluşturuyoruz
        foreach($active_languages as $ajax_lang):

            $name = $_POST['name_'.$ajax_lang->id];
            $url = $_POST['url_'.$ajax_lang->id];
            $html = ($_POST['html_'.$ajax_lang->id]) ? $_POST['html_'.$ajax_lang->id] : null;
            $title = ($_POST['title_'.$ajax_lang->id]) ? $_POST['title_'.$ajax_lang->id] : null;
            $description = ($_POST['description_'.$ajax_lang->id]) ? $_POST['description_'.$ajax_lang->id] : null;
            $keywords = ($_POST['keywords_'.$ajax_lang->id]) ? $_POST['keywords_'.$ajax_lang->id] : null;
            $is_index = ($_POST['is_index_'.$ajax_lang->id]) ? 1 : 0;


            ## eğer dil çevirisi boş ise
            if(empty($name) || empty($url)):
                continue;
            endif;

            ## eğer dil çevirisi dolu ise
            create("content_translations",array(
                "type" => $type,
                "content" => $create,
                "language" => $ajax_lang->id,
                "name" => $name,
                "url" => $url,
                "html" => $html,
                "title" => $title,
                "description" => $description,
                "keywords" => $keywords,
                "is_index" => $is_index
            ));

        endforeach;

        ## Eğer içerik product ise
        if($type == "product" && $create):
            $productArray = array(
                "content" => $create,
                "price" => isset($_POST['price']) ? (empty($_POST['price']) ? 0.00 : $_POST['price']) : 0.00,
                "code" => isset($_POST['code']) ? (empty($_POST['code']) ? null : $_POST['code']) : null,
            );
            if($_FILES['pdf']['name']):
                $upload = new Upload($_FILES['pdf']);
                if($upload->uploaded):
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/pdf/products');
                    if($upload->processed):
                        $productArray["pdf"] = "/view/frontend/assets/pdf/products/".$upload->file_dst_name;
                    endif;
                endif;
            endif;
            create("content_products",$productArray);
        endif;

        ## Eğer herşey yolunda ise
        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "İçerik başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "back" => true
            ));
            cacheRoute();
            return;
        endif;
               

    break;

    case "icerik-guncelle":

        $content = array();
        $_empty_language = 0;
    
        ## Genel içerik oluşturması
        $content["type"] = $type;
        $content["theme"] = isset($theme) ? (empty($theme) ? null : $theme) : null;
        $content["category"] = isset($category) ? (empty($category) ? null : $category) : null;
        $content["showcase"] = isset($showcase) ? (empty($showcase) ? null : $showcase) : null;
        $content["status"] = isset($status) ? $status : 1;
        $content["sort"] = isset($sort) ? (empty($sort) ? null : $sort) : null;
        $content["parent"] = isset($parent) ? (empty($parent) ? null : $parent) : null;
        $content["parent_history"] = isset($parent_history) ? (empty($parent_history) ? null : $parent_history) : null;
        $content["published"] = isset($published) ? (empty($published) ? null : $published) : null;

        ## Eğer Tema Özel İse
        if($content["theme"] == "special"):
            $content["theme"] = $content["theme"] = $special;
        endif;

        ## Eğer içerik tipi product ise ve code dolu ise kontorol ediyoruz
        if($type == "product" && isset($_POST['code']) && !empty($_POST['code'])):
            if(fetch("content_products",array("code" => $_POST['code'] , "content[!]" => $id))):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu ürün kodu zaten mevcut.",
                    "timer" => 3000
                ));
                return;
            endif;
        endif;

        ## Gerekli kontrolleri yapıyoruz
        foreach($active_languages as $ajax_lang):
            $name = $_POST['name_'.$ajax_lang->id];
            $url = $_POST['url_'.$ajax_lang->id];
            if(fetch("content_translations",array("url" => $url,"content[!]" => $id))):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız!",
                    "description" => "Bu URL <b><a class='text-danger' href='".$url."' target='_blank'>".$url."</a></b> zaten mevcut.",
                    "timer" => 3000
                ));
                return;
            endif;
            if(empty($name) || empty($url)):
                $_empty_language++;
            endif;
        endforeach;

        if($_empty_language == rowCount("languages")):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "En az bir dil için işlem yapmalısınız.",
                "timer" => 3000
            ));
            return;
        endif;

        $update = update("contents",$content,array("id"=>$id));
        if($update): 
            define("update",true);
        endif;

        if(isset($_POST['delete_file_ids'])):
            foreach(explode(",",$_POST['delete_file_ids']) as $file_id):
                $file = fetch("files",array("id" => $file = $file_id));
                if($file):
                    if(delete("files",array("id" => $file->id))):
                        if(!defined("update")):
                            define("update",true);
                        endif;
                    endif;
                endif;
            endforeach;
        endif;

        if(isset($_POST['gallery'])):
            require "app/upload.php";
            foreach($_POST['gallery'] as $key => $value):
                if(is_numeric($value)):
                    if(update("files",array("sort" => $key),array("id" => $value),0)):
                       if(!defined("update")):
                            define("update",true);
                        endif;
                    endif;
                    if($key==0):
                        $image = fetch("files",array("id" => $value));
                        if(update("contents",array("image" => $image->path),array("id" => $id),0)):
                           if(!defined("update")):
                                define("update",true);
                            endif;
                        endif;
                    endif;
                    continue;
                endif;
                $upload = new Upload($value);
                if($upload->uploaded):
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();
                    $upload->image_convert = 'webp';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);
                        if(create("files",array(
                            "master_table" => "contents",
                            "master_id" => $id,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "webp",
                            "file_size" => $file_size,
                            "sort" => $key
                        ))):
                            if(!defined("update")):
                                define("update",true);
                            endif;
                        endif;
                    endif;
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();
                    $upload->image_convert = 'jpg';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);
                        if($key == 0):
                            $image = "/view/frontend/assets/img/$type/".$upload->file_dst_name;
                            if(update("contents",array("image" => $image),array("id" => $id))):
                                if(!defined("update")):
                                    define("update",true);
                                endif;
                            endif;
                        endif;
                        if(create("files",array(
                            "master_table" => "contents",
                            "master_id" => $id,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "jpg",
                            "file_size" => $file_size,
                            "sort" => $key
                        ))):
                            if(!defined("update")):
                                define("update",true);
                            endif;
                        endif;
                    endif;
                endif;
            endforeach;
        else:
            if(update("contents",array("image" => null),array("id" => $id))): 
                if(!defined("update")):
                    define("update",true);
                endif;
            endif;
        endif;

        foreach($active_languages as $ajax_lang):

            $name = $_POST['name_'.$ajax_lang->id];
            $url = $_POST['url_'.$ajax_lang->id];
            $html = ($_POST['html_'.$ajax_lang->id]) ? $_POST['html_'.$ajax_lang->id] : null;
            $title = ($_POST['title_'.$ajax_lang->id]) ? $_POST['title_'.$ajax_lang->id] : null;
            $description = ($_POST['description_'.$ajax_lang->id]) ? $_POST['description_'.$ajax_lang->id] : null;
            $keywords = ($_POST['keywords_'.$ajax_lang->id]) ? $_POST['keywords_'.$ajax_lang->id] : null;
            $is_index = ($_POST['is_index_'.$ajax_lang->id]) ? 1 : 0;

            $translation_control = fetch("content_translations",array("content" => $id,"language" => $ajax_lang->id));

            $translation = array(
                "type" => $type,
                "content" => $id,
                "language" => $ajax_lang->id,
                "name" => $name,
                "url" => $url,
                "html" => $html,
                "title" => $title,
                "description" => $description,
                "keywords" => $keywords,
                "is_index" => $is_index
            );

            if(!$translation_control):
                if(empty($name) || empty($url)):
                    continue;
                endif;
            endif;

            if($translation_control):
                if(empty($name) || empty($url)):
                    if(delete("content_translations",array("content" => $id,"language" => $ajax_lang->id))):
                        if(!defined("update")):
                            define("update",true);
                            continue;
                        endif;
                    endif;
                endif;
            endif;

            if($translation_control):
                if(update("content_translations",$translation,array("content" => $id,"language" => $ajax_lang->id))):
                    if(!defined("update")):
                        define("update",true);
                    endif;
                endif;
            endif;

            if(!$translation_control):
                if(create("content_translations",$translation)):
                    if(!defined("update")):
                        define("update",true);
                    endif;
                endif;
            endif;

        endforeach;

        ## Eğer içerik product ise
        if($type == "product" && $id):

            $productArray = array(
                "content" => $id,
                "price" => isset($_POST['price']) ? (empty($_POST['price']) ? 0.00 : $_POST['price']) : 0.00,
                "code" => isset($_POST['code']) ? (empty($_POST['code']) ? null : $_POST['code']) : null,
            );

            if(isset($pdf_delete) && $pdf_delete == 1):
                $productArray["pdf"] = null;
            endif;

            if($_FILES['pdf']['name']):
                $upload = new Upload($_FILES['pdf']);
                if($upload->uploaded):
                    $upload->file_new_name_body = ($_POST['name_'.$default_language->id]) ? slugify($_POST['name_'.$default_language->id]) : uniqid();
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/pdf/products');
                    if($upload->processed):
                        $productArray["pdf"] = "/view/frontend/assets/pdf/products/".$upload->file_dst_name;
                    endif;
                endif;
            endif;

            if(fetch("content_products",array("content" => $id))):
                if(update("content_products",$productArray,array("content" => $id))):
                    if(!defined("update")):
                        define("update",true);
                    endif;
                endif;
            else:
                if(create("content_products",$productArray)):
                    if(!defined("update")):
                        define("update",true);
                    endif;
                endif;
            endif;
            
        endif;

        if(defined("update")): 
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "İçerik başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "back" => true
            ));
            cacheRoute();
            return;
        endif;
       
    break;

    case "dil-olustur":

    case "musteri-olustur":

        ## Basit validation
        if(empty($first_name)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Ad alanı boş olamaz.",
                "timer" => 3000
            ));
            return;
        endif;

        // normalize phone using helper if available
        $clean_phone = null;
        if (isset($phone) && !empty(trim($phone))) {
            if (function_exists('turkishPhoneNumber')) {
                $clean_phone = turkishPhoneNumber(trim($phone));
            } else {
                $clean_phone = trim($phone);
            }
        }

        $createData = array(
            "first_name" => isset($first_name) ? $first_name : null,
            "last_name" => isset($last_name) ? $last_name : null,
            "gender" => isset($gender) ? $gender : null,
            "phone" => $clean_phone,
            "dob" => isset($dob) && !empty($dob) ? $dob : null,
            "status" => isset($status) ? $status : 1,
            "created" => date("Y-m-d H:i:s")
        );

        $create = create("customers", $createData);
        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Müşteri başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "musteri-guncelle":

        if(!isset($id) || empty($id)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Geçersiz kayıt.",
                "timer" => 3000
            ));
            return;
        endif;

        // normalize phone for update
        $clean_phone = null;
        if (isset($phone) && !empty(trim($phone))) {
            if (function_exists('turkishPhoneNumber')) {
                $clean_phone = turkishPhoneNumber(trim($phone));
            } else {
                $clean_phone = trim($phone);
            }
        }

        $updateData = array(
            "first_name" => isset($first_name) ? $first_name : null,
            "last_name" => isset($last_name) ? $last_name : null,
            "gender" => isset($gender) ? $gender : null,
            "phone" => $clean_phone,
            "dob" => isset($dob) && !empty($dob) ? $dob : null,
            "status" => isset($status) ? $status : 1,
        );

        $update = update("customers", $updateData, array("id" => $id));
        if($update):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Müşteri başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

        ## eğer bu dil zaten varsa
        if(fetch("languages",array("code" => $code))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu dil zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## dil oluştur
        $create = create("languages",array(
            "name" => $name,
            "code" => $code,
            "phone_code" => $phone_code,
            "status" => $status,
            "is_default" => isset($is_default) ? 1 : 0
        ));

        ## eğer herşey yolunda ise
        if($create):
            create("content_translations",array("type" => "page","content" => 1, "language" => $create,"name" => $name , "url" => "/".$code,"is_index" => 1));
            if(isset($is_default)):
                $db->query("UPDATE languages SET is_default = 0 WHERE id != $create");
                defaultLanguage();
            endif;
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Dil başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

        
    break;
    
    case "dil-guncelle":

        ## eğer bu dil zaten varsa
        if(fetch("languages",array("code" => $code)) && fetch("languages",array("code" => $code))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu dil zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## dil güncelle
        $update = update("languages",array(
            "name" => $name,
            "code" => $code,
            "phone_code" => $phone_code,
            "status" => $status,
            "is_default" => isset($is_default) ? 1 : 0
        ),array("id" => $id));

        ## eğer herşey yolunda ise
        if($update):
            if(isset($is_default)):
                $db->query("UPDATE languages SET is_default = 0 WHERE id != $id");
                defaultLanguage();
            endif;
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Dil başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "degisken-olustur":

        ## eğer bu dil zaten varsa
        if(fetch("language_variables",array("code" => $code))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu değişken zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $translations = array();
        foreach($active_languages as $lang):
            if(empty($_POST['translate_'.$lang->id])): continue; endif;
            $translations[$lang->id] = $_POST['translate_'.$lang->id];
        endforeach;

        ## eğer translations boş ise
        if(empty($translations)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "En az bir dil için çeviri yapmalısınız.",
                "timer" => 3000
            ));
            return;
        endif;

        ## dil oluştur
        foreach($translations as $lang => $translate):
            create("language_variables",array(
                "code" => $code,
                "language" => $lang,
                "translate" => $translate
            ));
        endforeach;

        ## eğer herşey yolunda ise
        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "success",
            "title" => "İşlem Başarılı!",
            "description" => "Değişken başarılı bir şekilde oluşturuldu.",
            "timer" => 1500,
            "closeModal" => true,
            "datatableReload" => true,
            "formReset" => true
        ));

    break;

    case "degisken-guncelle":

        ## Değişkenleri alıyoruz
        foreach($active_languages as $lang):

            $translate = $_POST['translate_'.$lang->id];
            $variable = fetch("language_variables",array("code" => $code,"language" => $lang->id));

            ## Eğer çeviri varsa
            if($translate):
                if($variable):
                    if(update("language_variables",array("translate" => $translate),array("id" => $variable->id))):
                        @define("update",true);
                    endif;
                endif;
            endif;

            ## Eğer var olan çeviri silinmişse
            if($variable):
                if(empty($translate)):
                    if(delete("language_variables",array("id" => $variable->id))):
                        @define("update",true);
                    endif;
                endif;
            endif;

            ## Eğer çeviri yoksa
            if(!$variable):
                if($translate):
                    if(create("language_variables",array(
                        "code" => $code,
                        "language" => $lang->id,
                        "translate" => $translate
                    ))):
                        @define("update",true);
                    endif;
                endif;
            endif;

        endforeach;

        ## Eğer herşey yolunda ise
        if(defined("update")):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Değişken başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "toplu-e-posta-grup-olustur":

        if(fetch("newsletters[id]",array("name" => $name))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu grup zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $emails = explode(",",str_replace("\n",",",$_POST['emails']));
        $emails = array_filter($emails,function($email){
            return filter_var(trim($email),FILTER_VALIDATE_EMAIL);
        });

        $emails = array_unique($emails);

        if(empty($emails)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir mail adresi bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;
        $emails = array_map("trim",$emails);
        $emails = array_unique($emails);
        $create = create("newsletters",array(
            "name" => $name,
            "emails" => implode(",",$emails),
            "count" => count($emails)
        ));

        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "newslettersAjaxGroups" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "toplu-e-posta-grup-guncelle":

        if(fetch("newsletters[id]",array("name" => $name)) && fetch("newsletters[id]",array("name" => $name))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu grup zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $emails = explode(",",str_replace("\n",",",$_POST['emails']));
        $emails = array_filter($emails,function($email){
            return filter_var(trim($email),FILTER_VALIDATE_EMAIL);
        });

        $emails = array_unique($emails);

        if(empty($emails)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir mail adresi bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;

        $emails = array_map("trim",$emails);
        $emails = array_unique($emails);
        $update = update("newsletters",array(
            "name" => $name,
            "emails" => implode(",",$emails),
            "count" => count($emails)
        ),array("id" => $id));

        if($update):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "newslettersAjaxGroups" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "toplu-e-posta":

        ## Gerekli değişkenleri oluşturuyoruz
        $mail_adresleri = [];

        ## Eğer grup seçilmişse
        if(isset($group)):
            foreach($group as $group_id):
                $group = fetch("newsletters",array("id" => $group_id));
                if($group):
                    $group_emails = explode(",",$group->emails);
                    $group_emails = array_filter($group_emails,function($mail){
                        return filter_var(trim($mail),FILTER_VALIDATE_EMAIL);
                    });
                    $mail_adresleri = array_merge($mail_adresleri,$group_emails);
                endif;
            endforeach;
        endif;

        ## Eğer mail adresi eklenmişse
        if(isset($to)):
            $to = explode(",",str_replace("\n",",",$_POST['to']));
            $to = array_filter($to,function($mail){
                return filter_var(trim($mail),FILTER_VALIDATE_EMAIL);
            });
            $mail_adresleri = array_merge($mail_adresleri,$to);
        endif;

        ## Eğer mail adresi eklenmemişse
        if(empty($mail_adresleri)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir mail adresi bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Eğer mesaj boş ise
        if(empty($message)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Mesaj alanı boş bırakılamaz.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Eğer dosya eklenmişse ve dosya yüklenmişse
        $files = array();
        if(isset($_FILES['files']['name']) && is_array($_FILES['files']['name']) && array_filter($_FILES['files']['name'])):
            $allowed = array("pdf","doc","docx","xls","xlsx","ppt","pptx","txt","jpg","jpeg","png","gif","zip","rar","gz","tar","7z");
            require "app/upload.php";
            foreach($_FILES['files']['name'] as $key => $file):
                $file_name = $_FILES['files']['name'][$key];
                $file_size = $_FILES['files']['size'][$key];
                $file_tmp = $_FILES['files']['tmp_name'][$key];
                $file_type = $_FILES['files']['type'][$key];
                $file_ext = @strtolower(end(explode('.',$file_name)));
                if(!empty($file_name) && in_array($file_ext, $allowed)):
                    $upload = new Upload($file_tmp);
                    $upload->file_new_name_body = uniqid();
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/email');
                    if($upload->processed):
                        $files[] = "view/frontend/assets/email/".$upload->file_dst_name;
                    else:
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "error",
                            "title" => "İşlem Başarısız!",
                            "description" => "Dosya yüklenirken bir hata oluştu.",
                            "timer" => 3000
                        ));
                        return;
                    endif;
                elseif(!empty($file_name)):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "İşlem Başarısız!",
                        "description" => "Yalnızca ".implode(", ",$allowed)." uzantılı dosyalar yükleyebilirsiniz.",
                        "timer" => 3000
                    ));
                    return;
                endif;
            endforeach;
        endif;

        $mail_adresleri = implode(",",$mail_adresleri);
        $sendMail = sendMail($mail_adresleri,$subject,$message,$files);

        if($sendMail):

            ## Log kaydı oluşturuyoruz
            record("bulk_email","bulk",array(
                "subject" => $subject,
                "message" => $message,
                "files" => implode(",",$files),
                "to" => $mail_adresleri
            ));

            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde gönderildi.",
                "timer" => 1500,
                "closeModal" => true,
                "formReset" => true,
            ));
            return;
        endif;

    break;

    case "toplu-sms-grup-olustur":

        if(fetch("newsletters[id]",array("name" => $name))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu grup zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $phones = explode(",",str_replace("\n",",",$_POST['phones']));
        $phones = array_filter($phones,function($phone){
            $cleanedPhone = str_replace(' ', '', $phone);
            return preg_match('/^(\+90\s?|90\s?|0?)?5[0-9]{2}\s?[0-9]{3}\s?[0-9]{2}\s?[0-9]{2}$/', trim($phone));
        });

        $phones = array_unique($phones);

        if(empty($phones)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir telefon numarası bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;

        $phones = array_map("trim",$phones);
        $phones = array_unique($phones);

        $phones = array_map("turkishPhoneNumber",$phones);

        $create = create("newsletters",array(
            "name" => $name,
            "phones" => implode(",",$phones),
            "count" => count($phones)
        ));

        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "newslettersAjaxGroups" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "toplu-sms-grup-guncelle":

        if(fetch("newsletters[id]",array("name" => $name)) && fetch("newsletters[id]",array("name" => $name))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu grup zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $phones = explode(",",str_replace("\n",",",$_POST['phones']));
        $phones = array_filter($phones,function($phone){
            $cleanedPhone = str_replace(' ', '', $phone);
            return preg_match('/^(\+90\s?|90\s?|0?)?5[0-9]{2}\s?[0-9]{3}\s?[0-9]{2}\s?[0-9]{2}$/', trim($phone));
        });

        $phones = array_unique($phones);

        if(empty($phones)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir telefon numarası bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;

        $phones = array_map("trim",$phones);
        $phones = array_unique($phones);

        $phones = array_map("turkishPhoneNumber",$phones);

        $update = update("newsletters",array(
            "name" => $name,
            "phones" => implode(",",$phones),
            "count" => count($phones)
        ),array("id" => $id));

        if($update):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "newslettersAjaxGroups" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "toplu-sms":

        ## Gerekli değişkenleri oluşturuyoruz
        $phone_numbers = [];

        ## Eğer grup seçilmişse
        if(isset($group)):
            foreach($group as $group_id):
                $group = fetch("newsletters",array("id" => $group_id));
                if($group):
                    $group_phones = explode(",",$group->phones);
                    $group_phones = array_filter($group_phones,function($phone){
                        $cleanedPhone = str_replace(' ', '', $phone);
                        return preg_match('/^(\+90\s?|90\s?|0?)?5[0-9]{2}\s?[0-9]{3}\s?[0-9]{2}\s?[0-9]{2}$/', trim($phone));
                    });
                    $phone_numbers = array_merge($phone_numbers,$group_phones);
                endif;
            endforeach;
        endif;

        ## Eğer telefon numarası eklenmişse
        if(isset($to)):
            $to = explode(",",str_replace("\n",",",$_POST['to']));
            $to = array_filter($to,function($phone){
                $cleanedPhone = str_replace(' ', '', $phone);
                return preg_match('/^(\+90\s?|90\s?|0?)?5[0-9]{2}\s?[0-9]{3}\s?[0-9]{2}\s?[0-9]{2}$/', trim($phone));
            });
            $phone_numbers = array_merge($phone_numbers,$to);
        endif;

        ## Eğer telefon numarası eklenmemişse
        if(empty($phone_numbers)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Hiçbir telefon numarası bulunamadı.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Eğer mesaj boş ise
        if(empty($message)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Mesaj alanı boş bırakılamaz .",
                "timer" => 3000
            ));
            return;
        endif;

        $phone_numbers = array_map("trim",$phone_numbers);
        $phone_numbers = array_unique($phone_numbers);

        $phone_numbers = array_map("turkishPhoneNumber",$phone_numbers);
        

        $sendSms = sendSms($phone_numbers,$message);

        var_dump($sendSms); exit;
        
        if($sendSms):
            record("bulk_sms","bulk",array(
                "message" => $message,
                "to" => $phone_numbers
            ));
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Başarılı bir şekilde gönderildi.",
                "timer" => 1500,
                "closeModal" => true,
                "formReset" => true,
            ));
            return;
        else:
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "SMS gönderilirken bir hata oluştu.",
                "timer" => 3000
            ));
            return;
        endif;

        
    
    break;

    case "yedek-indir":

        foreach(glob("*.{tar.gz,sql}", GLOB_BRACE) as $file):
            $deleteSuccess = unlink($file);
        endforeach;

        switch($type):

            case "sql":

                ## SQL dosya yolu
                $sql_file = $_SERVER['DOCUMENT_ROOT']."/";
                $sql_name = db_name."-".date("Y-m-d").".sql";
                shell_exec("mysqldump --user=".db_user." --password=".db_pass." --host=".db_host." --default-character-set=utf8mb4 --skip-set-charset ".db_name." > ".$sql_file.$sql_name);

                echo json_encode(array(
                    
                    "icon" => "success",
                    "title" => "İşlem Başarılı!",
                    "description" => "SQL dosyanız başarılı bir şekilde oluşturuldu ve indirme işlemi başladı.",
                    "timer" => 1500,
                    "download" => website."/".$sql_name
                ));

            break;

            case "files":

                ## SQL dosya yolu
                $sql_file = $_SERVER['DOCUMENT_ROOT']."/";
                $sql_name = db_name."-".date("Y-m-d").".sql";
                $filename = "backup-".date("Y-m-d").".tar.gz";

                ## Dosyaların yedeğini alacağımız dizin ve dosya yolu
                shell_exec("tar -zcvf ".$filename." view/frontend/assets/");

                echo json_encode(array(
                    
                    "icon" => "success",
                    "title" => "İşlem Başarılı!",
                    "description" => "Sistem yedeğiniz başarılı bir şekilde oluşturuldu ve indirme işlemi başladı.",
                    "timer" => 1500,
                    "download" => website."/".$filename
                ));

            break;

            case "system":

                if(md5($password)=="a52e827466c970278a7342e2d0214c9e"):

                    ## SQL dosya yolu
                    $sql_file = $_SERVER['DOCUMENT_ROOT']."/";
                    $sql_name = db_name."-".date("Y-m-d").".sql";
                    $backup_folder = $_SERVER['DOCUMENT_ROOT']; // Yedeklenecek ana dizin
                    $filename = "backup-".date("Y-m-d").".tar.gz";

                    // SQL yedeğini alıyoruz
                    shell_exec("mysqldump --user=".db_user." --password=".db_pass." --host=".db_host." --default-character-set=utf8mb4 --skip-set-charset ".db_name." > ".$sql_file.$sql_name);

                    // Tüm dosyaları tarayıp sıkıştırıyoruz
                    shell_exec("tar -czvf ".$sql_file.$filename." -C ".$backup_folder." .");

                    // Geri bildirim
                    echo json_encode(array(
                        
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Sistem yedeğiniz başarılı bir şekilde oluşturuldu ve indirme işlemi başladı.",
                        "timer" => 1500,
                        "download" => website."/".$filename
                    ));

                endif;

            break;
            
        endswitch;

    break;

    case "cron-ayarlari":
        
        $cronJob = fetch("integrations",array("name" => "cronjob"));
        $json = json_decode($cronJob->json);
        $json = new stdClass();
        $json->son_calisma_saati = date("Y-m-d H:i");
        foreach($_POST as $key => $value):
            if($key=="action"): continue; endif;
            $json->{$key} = $value;
        endforeach;
        if(update("integrations",array("json" => json_encode($json)),array("name" => "cronjob"))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Cronjob ayarları başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "refresh" => true
            ));
            return;
        endif;

    break;

    case "kullanici-olustur":

        ## Eğer bu kullanıcı zaten varsa
        if(fetch("users",array("email" => $email))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu e-posta adresi zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## eğer bu username varsa
        if(fetch("users",array("username" => $username))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu kullanıcı adı zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## Kullanıcı oluştur
        $create = create("users",array(
            "name" => $name,
            "surname" => $surname,
            "email" => $email,
            "phone" => $phone,
            "username" => $username,
            "password" => encrypt($password),
            "permission" => $permission,
            "multiple" => $multiple
        ));

        ## Eğer herşey yolunda ise
        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Kullanıcı başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "kullanici-guncelle":

        ## Eğer bu kullanıcı zaten varsa
        if(fetch("users",array("email" => $email)) && fetch("users",array("email" => $email))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu e-posta adresi zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## eğer bu username varsa
        if(fetch("users",array("username" => $username)) && fetch("users",array("username" => $username))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu kullanıcı adı zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        $array = array(
            "name" => $name,
            "surname" => $surname,
            "email" => $email,
            "phone" => $phone,
            "username" => $username,
            "permission" => $permission,
            "multiple" => $multiple
        );

        ## Eğer şifre değişecekse
        if(!empty($password)):
            $array['password'] = encrypt($password);
        endif;

        ## Kullanıcı güncelle
        $update = update("users",$array,array("id" => $id));

        ## Eğer herşey yolunda ise
        if($update):
            if(!empty($password)):
                update("user_sessions",array("status" => 0),array("user" => $id));
            endif;
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Kullanıcı başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "yetki-grubu-olustur":

        ## Eğer bu yetki grubu zaten varsa
        if(fetch("user_permissions",array("name" => $name))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu yetki grubu zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## authority kontrol et
        if(empty($authority)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "En az bir yetki seçmelisiniz.",
                "timer" => 3000
            ));
            return;
        endif;

        ## , ile ayrılmış yetkileri diziye çevir
        $authority = implode(",",$authority);

        ## Yetki grubu oluştur
        $create = create("user_permissions",array(
            "name" => $name,
            "authority" => $authority
        ));

        ## Eğer herşey yolunda ise
        if($create):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Yetki grubu başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true,
                "formReset" => true
            ));
            return;
        endif;

    break;

    case "yetki-grubu-guncelle":

        ## Eğer bu yetki grubu zaten varsa
        if(fetch("user_permissions",array("name" => $name)) && fetch("user_permissions",array("name" => $name))->id != $id):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "Bu yetki grubu zaten mevcut.",
                "timer" => 3000
            ));
            return;
        endif;

        ## authority kontrol et
        if(empty($authority)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => "En az bir yetki seçmelisiniz.",
                "timer" => 3000
            ));
            return;
        endif;

        ## , ile ayrılmış yetkileri diziye çevir
        $authority = implode(",",$authority);

        ## Yetki grubu güncelle
        $update = update("user_permissions",array(
            "name" => $name,
            "authority" => $authority
        ),array("id" => $id));

        ## Eğer herşey yolunda ise
        if($update):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Yetki grubu başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
            return;
        endif;

    break;

    case "takvim-not-olustur":

        if($active_user):
            if(empty($reminder_time)) $reminder_time = null;
            $create = create("user_calendar",array(
                "user" => $active_user->id,
                "title" => $title,
                "description" => $description,
                "color" => $color,
                "start" => $start,
                "remember" => $remember,
                "reminder_time" => $reminder_time,
                "end" => empty($end) ? null : $end
            ));
            if($create):
                echo $create;
            endif;
        endif;

    break;

    case "takvim-not-guncelle":

        if($active_user):
            if(empty($reminder_time)): $reminder_time = null; $remember = 0; endif;
            $update = update("user_calendar",array(
                "title" => $title,
                "description" => $description,
                "color" => $color,
                "start" => $start,
                "end" => $end,
                "remember" => $remember,
                "reminder_time" => $reminder_time
            ),array("id" => $id));
            if($update):
                echo $update;
            endif;
        endif;

    break;

    case "destek-bildirimi-gonder":

        $id = time();
        $subject = "#".$id." "."Yeni Destek Bildirimi";
        $html = "<p><b>Ad Soyad:</b> ".$active_user->name." ".$active_user->surname."</p>";
        $html .= "<p><b>E-Posta:</b> ".$active_user->email."</p>";
        $html .= "<p><b>Telefon:</b> ".$active_user->phone."</p>";
        $html .= "<p><b>Konu:</b> Yardım Talebi</p>";
        $html .= "<p><b>Mesaj:</b> ".$message."</p>";
        $html .= "<p><b>IP Adresi:</b> ".$_SERVER['REMOTE_ADDR']."</p>";
        $html .= website;
        if(sendMail(developer_email,$subject,$html)):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "#$id Destek Bildirimi",
                "description" => "Destek bildiriminiz başarılı bir şekilde gönderildi.",
                "timer" => 5000,
                "formReset" => true
            ));
            return;
        else:
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "#$id Destek Bildirimi",
                "description" => "Destek bildiriminiz gönderilirken bir hata oluştu.",
                "timer" => 5000
            ));
            return;
        endif;

    break;

    case "smtp-test":

        require_once "app/phpmailer.php";
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->CharSet = 'UTF-8';
            $mail->setLanguage('tr', 'phpmailer/language');
            $mail->IsSMTP();
            $mail->Host = $host;
            $mail->Username = $email;
            $mail->Password = $password;
            $mail->Port = $port;
            $mail->SMTPAuth = true;
            $mail->SMTPSecure = ($secure === 'ssl') ? 'ssl' : 'tls';
            $mail->setFrom($email, $email);
            $mail->addAddress(developer_email); // Geliştirici e-posta adresine test e-postası gönderiyoruz
            $mail->addAddress($email);
            $mail->isHTML(true);
            $mail->Subject = "#".time()." E-Posta SMTP Test";
            $mail->Body = "Bu bir e-posta testidir. <br> Eğer bu e-postayı aldıysanız, SMTP ayarlarınız başarılı bir şekilde yapılmıştır. <br> <br> ".website;
            $mail->SMTPDebug = 0;
            $mail->send();
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "SMTP ayarlarınız başarılı bir şekilde test edildi.",
                "timer" => 3000
            ));
            return;
        } catch (Exception $e) {
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız!",
                "description" => $mail->ErrorInfo,
                "timer" => 3000
            ));
            return;
        }


    break;

    case "genel-ayarlar": 

        if($type=="logos"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "logos"));

            ## Eğer save set edilmişse
            if(isset($save)):

                    if(!$control): $control = create("integrations",array("name" => "logos")); endif;
                    $newData = empty($control->json) ? array() : json_decode($control->json,true);

                    require "app/upload.php";

                    $upload_dir = $_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/img/logos/';

                    // Klasör yoksa oluştur
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }

                    foreach ($_FILES['files']['name'] as $field => $name):
                        if (!empty($name)):
                            $file_name = $field;
                            $file_tmp = $_FILES['files']['tmp_name'][$field];
                            $file_extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
                            $base_filename = $file_name;

                            // Aynı isimde dosya varsa -1, -2 gibi sayı ekle
                            $counter = 1;
                            $final_name = $base_filename . '.' . $file_extension;
                            while (file_exists($upload_dir . $final_name)) {
                                $final_name = $base_filename . '-' . $counter . '.' . $file_extension;
                                $counter++;
                            }

                            if ($file_extension === 'svg'):
                                $target_path = $upload_dir . $final_name;
                                if (move_uploaded_file($file_tmp, $target_path)):
                                    $newData[$file_name] = "/view/frontend/assets/img/logos/" . $final_name;
                                else:
                                    echo "SVG dosyası taşınırken bir hata oluştu: " . $name;
                                endif;
                            else:
                                $upload = new Upload($file_tmp);
                                if ($upload->uploaded):
                                    $upload->allowed = ['image/svg+xml', 'image/jpeg', 'image/png', 'image/gif'];
                                    $upload->file_new_name_body = pathinfo($final_name, PATHINFO_FILENAME);
                                    $upload->file_new_name_ext = pathinfo($final_name, PATHINFO_EXTENSION);
                                    $upload->process($upload_dir);
                                    if ($upload->processed):
                                        $newData[$file_name] = "/view/frontend/assets/img/logos/" . $upload->file_dst_name;
                                    else:
                                        echo "Hata oluştu: " . $upload->error;
                                    endif;
                                else:
                                    echo "Dosya yüklenemedi: " . $name;
                                endif;
                            endif;
                        endif;
                    endforeach;

    
                    if(update("integrations",array("json" => json_encode($newData)),array("name" => "logos"))):
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "success",
                            "title" => "İşlem Başarılı!",
                            "description" => "Logo başarılı bir şekilde güncellendi.",
                            "timer" => 1500,
                            "closeModal" => true
                        ));
                        return;
                    endif;

                return;
            endif;


                $html = '
                    <div class="mb-3">
                        <label class="form-label">Logo</label>
                        <input type="file" name="files[logo]" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Favicon</label>
                        <input type="file" name="files[favicon]" class="form-control">
                    </div>
                ';
                echo json_encode($html);

        endif;

        if($type=="contacts"):

            $control = fetch("integrations",array("name" => "contacts"));

            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "contacts")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(!empty($newData['map']) && strpos($newData['map'],"iframe")!==false):
                    $newData['map'] = explode('src="',$newData['map'])[1];
                    $newData['map'] = explode('"',$newData['map'])[0];
                endif;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "contacts"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "İletişim bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                <div class="mb-3">
                    <label class="form-label" >Telefon</label>
                    <input class="form-control" data="phone" telephone value="'.@$json->phone.'">
                    <input type="hidden" name="data[phone]" value="'.@$json->phone.'">
                </div>
                <div class="mb-3">
                    <label class="form-label" >Gsm</label>
                    <input class="form-control" data="gsm" telephone value="'.@$json->gsm.'">
                    <input type="hidden" name="data[gsm]" value="'.@$json->gsm.'">
                </div>
                <div class="mb-3">
                    <label class="form-label" >Whatsapp</label>
                    <input class="form-control" data="whatsapp" telephone value="'.@$json->whatsapp.'">
                    <input type="hidden" name="data[whatsapp]" value="'.@$json->whatsapp.'">
                </div>
                <div class="mb-3">
                    <label class="form-label" >E-Posta</label>
                    <input class="form-control" name="data[email]" value="'.@$json->email.'">
                </div>
                <div class="mb-3">
                    <label class="form-label" >Adres</label>
                    <input class="form-control" name="data[address]" value="'.@$json->address.'">
                </div>
                <div class="mb-3">
                    <label class="form-label" >Google Maps</label>
                    <textarea class="form-control" name="data[map]" style="height:123px">'.@$json->map.'</textarea>
                </div>
            ';

            $html .= '
                <script>
                    $(document).ready(function () {
                        var inputs = document.querySelectorAll("input[telephone]"); // Çift tırnak kullanımı
                        inputs.forEach(function(input) {
                            input.addEventListener("keypress", function (e) { // Çift tırnak
                                if (!/[0-9]/.test(e.key)) {
                                    e.preventDefault();
                                }
                            });
                            var iti = window.intlTelInput(input, {
                              
                                separateDialCode: true,
                                placeholderNumberType: "MOBILE",
                                utilsScript: "/view/backend/assets/js/utils.js" // Çift tırnak
                            });
                            var name = input.getAttribute("data"); // data-name olarak değiştirdim
                            
                            input.addEventListener("change", function () { // Çift tırnak
                                if (iti.isValidNumber()) {
                                var code = iti.s.dialCode;
                                    var value = "+" + code + " " + this.value;
                                  $(\'input[name="data[\' + name + \']"]\').val(value);
                                } else {
                                    $(this).val("");
                                    $(\'input[name="data[\' + name + \']"]\').val("");
                                }
                            });
                        });
                    });
                </script>
            ';

            echo json_encode($html);

        endif;

        if($type=="socials"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "socials"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "socials")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "socials"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Sosyal medya bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                    <div class="mb-4">
                        <label class="form-label">Facebook</label>
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white"><i class="lab la-facebook"></i></span>
                            <input class="form-control shadow-sm" name="data[facebook]" value="'.@$json->facebook.'" placeholder="Facebook URL">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Twitter</label>
                        <div class="input-group">
                            <span class="input-group-text bg-info text-white"><i class="lab la-twitter"></i></span>
                            <input class="form-control shadow-sm" name="data[twitter]" value="'.@$json->twitter.'" placeholder="Twitter URL">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Instagram</label>
                        <div class="input-group">
                            <span class="input-group-text bg-danger text-white"><i class="lab la-instagram"></i></span>
                            <input class="form-control shadow-sm" name="data[instagram]" value="'.@$json->instagram.'" placeholder="Instagram URL">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">LinkedIn</label>
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white"><i class="lab la-linkedin"></i></span>
                            <input class="form-control shadow-sm" name="data[linkedin]" value="'.@$json->linkedin.'" placeholder="LinkedIn URL">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">YouTube</label>
                        <div class="input-group">
                            <span class="input-group-text bg-danger text-white"><i class="lab la-youtube"></i></span>
                            <input class="form-control shadow-sm" name="data[youtube]" value="'.@$json->youtube.'" placeholder="YouTube URL">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Pinterest</label>
                        <div class="input-group">
                            <span class="input-group-text bg-danger text-white"><i class="lab la-pinterest"></i></span>
                            <input class="form-control shadow-sm" name="data[pinterest]" value="'.@$json->pinterest.'" placeholder="Pinterest URL">
                        </div>
                    </div>
                ';

            echo json_encode($html);

        endif;

        if($type=="banks"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "banks"));

            ## Eğer save set edilmişse
            if(isset($save)):

                $newData = [];

                if(!$control):
                    $control = create("integrations",["name" => "banks"]);
                endif;

                $control = $control ? empty($control->json) ? array() : json_decode($control->json) : array();

                
                require "app/upload.php";
                
                $oldDataById = [];
                foreach ($control as $value):
                    $oldDataById[$value->id] = $value;
                endforeach;
                
                if (isset($id)):
                    foreach ($_POST['id'] as $key => $id):
                
                        if (!empty($_FILES['image']['name'][$key])):
                            $file_name = slugify($_POST['bank_name'][$key]);
                            $file = $_FILES['image']['tmp_name'][$key];
                            $upload = new Upload($file);
                            if ($upload->uploaded):
                                $upload->file_new_name_body = $file_name;
                                $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/banks/');
                                if ($upload->processed):
                                    $image = "/view/frontend/assets/img/banks/" . $upload->file_dst_name;
                                endif;
                            endif;
                        else:
                            $image = (isset($oldDataById[$id]->image)) ? $oldDataById[$id]->image : '';
                        endif;
                
                        if (isset($oldDataById[$id])):
                            $newData[] = [
                                "id" => $id,
                                "image" => $image,
                                "bank_name" => $_POST['bank_name'][$key],
                                "branch_name" => $_POST['branch_name'][$key],
                                "account_owner" => $_POST['account_owner'][$key],
                                "iban" => $_POST['iban'][$key]
                            ];
                        else:
                            $newData[] = [
                                "id" => $id,
                                "image" => $image,
                                "bank_name" => $_POST['bank_name'][$key],
                                "branch_name" => $_POST['branch_name'][$key],
                                "account_owner" => $_POST['account_owner'][$key],
                                "iban" => $_POST['iban'][$key]
                            ];
                        endif;
                
                    endforeach;
                endif;
                
                if (update("integrations", ["json" => json_encode($newData)], ["name" => "banks"])):
                    echo json_encode([
                        "sweetAlert" => true,
                        "closeModal" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Banka hesapları başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                    ]);
                    return;
                endif;

                return;
                
            endif;

            $json = empty($control->json) ? array() : json_decode($control->json);

            $item_start = '<div class="banka-hesaplari">';
            $item = '
                <div class="hesap">
                    <input type="hidden" name="id[]" value="">
                    <div class="sil"><i class="las la-trash"></i></div>
                    <div class="surukle"><i class="las la-arrows-alt"></i></div>
                    <div class="mb-3">
                        <label class="form-label">Görsel</label>
                        <input class="form-control" type="file" accept="image/*" name="image[]">
                    </div>
                    <div class="row">
                        <div class="col-sm-6 mb-3">
                            <label class="form-label">Banka Adı</label>
                            <input class="form-control" name="bank_name[]">
                        </div>
                        <div class="col-sm-6 mb-3">
                            <label class="form-label">Şube Adı</label>
                            <input class="form-control" name="branch_name[]">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Hesap Sahibi</label>
                        <input class="form-control" name="account_owner[]">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">IBAN</label>
                        <input class="form-control" name="iban[]">
                    </div>
                </div>
            ';
            $item_end = '</div>';
            $item_end .= '<button type="button" class="btn btn-light w-100 icon" id="hesap-ekle"> <div><i class="las la-plus"></i></div> <div>Hesap Ekle</div> </button>';
            $item_end .= '
            <script>
                    $(document).ready(function () {
                        $("#hesap-ekle").click(function () {
                            $(".banka-hesaplari").append(`'. $item.'`);
                            var random = Math.floor(Math.random() * 90000000) + 10000000;
                            $(".banka-hesaplari .hesap:last-child input[name=\'id[]\']").val(random);
                        });
                        $(document).on("click", ".sil", function () {
                            let hesap = $(this).closest(".hesap");
                            hesap.slideUp(300, function () {
                                hesap.remove();
                            });
                        });
                        var sortable = new Sortable(document.querySelector(".banka-hesaplari"), {
                            handle: ".surukle",
                            animation: 150,
                            draggable: ".hesap"
                        });
                    });
                </script>'
            ;

            $result = "";
            if(empty($json)):
                $result ="<script> $(document).ready(function () { setTimeout(function () { $('#hesap-ekle').click(); },100); }); </script>";
            endif;

            foreach($json as $bank):
                $result .= '
                    <div class="hesap">
                        <input type="hidden" name="id[]" value="'.$bank->id.'">
                        <div class="sil"><i class="las la-trash"></i></div>
                        <div class="surukle"><i class="las la-arrows-alt"></i></div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize">Görsel</label>
                            <input class="form-control" type="file" accept="image/*" name="image[]">
                        </div>
                        <div class="row">
                            <div class="col-sm-6 mb-3">
                                <label class="form-label text-capitalize">Banka Adı</label>
                                <input class="form-control" name="bank_name[]" value="'.$bank->bank_name.'">
                            </div>
                            <div class="col-sm-6 mb-3">
                                <label class="form-label text-capitalize">Şube Adı</label>
                                <input class="form-control" name="branch_name[]" value="'.$bank->branch_name.'">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize">Hesap Sahibi</label>
                            <input class="form-control" name="account_owner[]" value="'.$bank->account_owner.'">
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize">IBAN</label>
                            <input class="form-control" name="iban[]" value="'.$bank->iban.'">
                        </div>
                    </div>
                ';
            endforeach;

            echo json_encode($item_start.$result.$item_end);

        endif;

        if($type=="stores"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "stores"));

            ## Eğer save set edilmişse
            if(isset($save)):

                $newData = [];

                if(!$control):
                    $control = create("integrations",["name" => "stores"]);
                endif;

                $control = $control ? empty($control->json) ? array() : json_decode($control->json) : array();

                
                require "app/upload.php";
                
                $oldDataById = [];
                foreach ($control as $value):
                    $oldDataById[$value->id] = $value;
                endforeach;
                
                if (isset($id)):
                    foreach ($_POST['id'] as $key => $id):
                
                        if (isset($oldDataById[$id])):
                            $newData[] = [
                                "id" => $id,
                                "title" => $_POST['title'][$key],
                                "phone" => $_POST['phone'][$key],
                                "gsm" => $_POST['gsm'][$key],
                                "address" => $_POST['address'][$key],
                                "maps" => $_POST['maps'][$key]
                            ];
                        else:
                            $newData[] = [
                                "id" => $id,
                                "title" => $_POST['title'][$key],
                                "phone" => $_POST['phone'][$key],
                                "gsm" => $_POST['gsm'][$key],
                                "address" => $_POST['address'][$key],
                                "maps" => $_POST['maps'][$key]
                            ];
                        endif;
                
                    endforeach;
                endif;
                
                if (update("integrations", ["json" => json_encode($newData)], ["name" => "stores"])):
                    echo json_encode([
                        "sweetAlert" => true,
                        "closeModal" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Mağaza bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                    ]);
                    return;
                endif;

                return;
                
            endif;

            $json = empty($control->json) ? array() : json_decode($control->json);

            $item_start = '<div class="magazalar">';
            $item = '
                <div class="hesap">
                    <input type="hidden" name="id[]" value="">
                    <div class="sil"><i class="las la-trash"></i></div>
                    <div class="surukle"><i class="las la-arrows-alt"></i></div>
                    <div class="mb-3">
                        <label class="form-label" >Başlık</label>
                        <input class="form-control" name="title[]">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" >Telefon</label>
                        <input class="form-control" name="phone[]" telephon">
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-capitalize" >Gsm</label>
                        <input class="form-control" name="gsm[]">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" >Adres</label>
                        <input class="form-control" name="address[]">
                    </div>
                    <div class="mb-3">
                        <label class="form-label" >Google Maps</label>
                        <textarea class="form-control" name="maps[]"></textarea>
                    </div>
                </div>
            ';
            $item_end = '</div>';
            $item_end .= '<button type="button" class="btn btn-light w-100 icon" id="hesap-ekle"> <div><i class="las la-plus"></i></div> <div>Mağaza Ekle</div> </button>';
            $item_end .= '
            <script>
                    $(document).ready(function () {
                        $("#hesap-ekle").click(function () {
                            $(".magazalar").append(`'. $item.'`);
                            var random = Math.floor(Math.random() * 90000000) + 10000000;
                            $(".magazalar .hesap:last-child input[name=\'id[]\']").val(random);
                        });
                        $(document).on("click", ".sil", function () {
                            let hesap = $(this).closest(".hesap");
                            hesap.slideUp(300, function () {
                                hesap.remove();
                            });
                        });
                        var sortable = new Sortable(document.querySelector(".magazalar"), {
                            handle: ".surukle",
                            animation: 150,
                            draggable: ".hesap"
                        });
                    });
                </script>'
            ;

            $result = "";
            if(empty($json)):
                $result ="<script> $(document).ready(function () { setTimeout(function () { $('#hesap-ekle').click(); },100); }); </script>";
            endif;

            foreach($json as $item):
                $result .= '
                    <div class="hesap">
                        <input type="hidden" name="id[]" value="'.$item->id.'">
                        <div class="sil"><i class="las la-trash"></i></div>
                        <div class="surukle"><i class="las la-arrows-alt"></i></div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize" >Başlık</label>
                            <input class="form-control" name="title[]" value="'.$item->title.'">
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize" >Telefon</label>
                            <input class="form-control" name="phone[]" value="'.$item->phone.'">
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize" >Gsm</label>
                            <input class="form-control" name="gsm[]" value="'.$item->gsm.'">
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize" >Adres</label>
                            <input class="form-control" name="address[]" value="'.$item->address.'">
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-capitalize" >Google Maps</label>
                            <textarea class="form-control" name="maps[]">'.$item->maps.'</textarea>
                        </div>
                    </div>   
                ';
            endforeach;

            echo json_encode($item_start.$result.$item_end);

        endif;
        
        if($type=="smtp"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "smtp"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "smtp")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    if($key == "status"):
                        $value = $value == "1" ? 1 : 0;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "smtp"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "SMTP bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMTP Sunucu</label>
                    <input class="form-control" name="data[host]" value="'.@$json->host.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMTP Port</label>
                    <input class="form-control" name="data[port]" value="'.@$json->port.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMTP E-Posta</label>
                    <input class="form-control" name="data[email]" value="'.@$json->email.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMTP Şifre</label>
                    <input class="form-control" name="data[password]" value="'.@$json->password.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMTP Güvenlik</label>
                    <select class="form-control" name="data[secure]" >
                        <option value="ssl" '.(@$json->secure == "ssl" ? "selected" : "").'>SSL</option>
                        <option value="tls" '.(@$json->secure == "tls" ? "selected" : "").'>TLS</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>

                <div class="text-end">
                    <button type="button" class="btn btn-light icon w-100 fx-2" id="test-smtp" ><i class="las la-plug"></i></button>
                </div>

                <script>
                    $("#test-smtp").click(function () {
                        $.ajax({
                            type: "POST",
                            url: "/baykus/ajax",
                            data: {
                            action: "smtp-test",
                            host: $("input[name=\'data[host]\']").val(),
                            port: $("input[name=\'data[port]\']").val(),
                            email: $("input[name=\'data[email]\']").val(),
                            password: $("input[name=\'data[password]\']").val(),
                            secure: $("select[name=\'data[secure]\']").val()},
                            beforeSend: function () {
                                Swal.fire({
                                    icon: "info",
                                    title: "SMTP Test",
                                    html: "SMTP bilgileri test ediliyor...",
                                    showCloseButton: false,
                                    showConfirmButton: false
                                });
                            },
                            success: function (response) {
                                response = JSON.parse(response);
                                if (response.sweetAlert) {
                                    Swal.fire({
                                        icon: response.icon,
                                        title: response.title,
                                        text: response.description,
                                        timer: response.timer,
                                        showConfirmButton: false
                                    });
                                }
                            }
                        });
                    });

            ';

            echo json_encode($html);

        endif;

        if($type=="sms"):
            
            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "sms"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "sms")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    if($key == "status"):
                        $value = $value == "1" ? 1 : 0;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "sms"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "SMS bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                
                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMS Servisi</label>
                    <select class="form-control" name="data[api]" >
                        <option value="Netgsm" '.(@$json->api == "Netgsm" ? "selected" : "").'>Netgsm</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMS Kullanıcı Adı</label>
                    <input class="form-control" name="data[username]" value="'.@$json->username.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMS Şifre</label>
                    <input class="form-control" name="data[password]" value="'.@$json->password.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >SMS Başlık</label>
                    <input class="form-control" name="data[title]" value="'.@$json->title.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>';

            echo json_encode($html);

        endif;

        if($type=="payment"):
            
            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "payment"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "payment")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    if($key == "status"):
                        $value = $value == "1" ? 1 : 0;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "payment"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Ödeme bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
               <div class="mb-3">
                    <label class="form-label text-capitalize" >Merchant ID</label>
                    <input class="form-control" name="data[merchant_id]" value="'.@$json->merchant_id.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Merchant Key</label>
                    <input class="form-control" name="data[merchant_key]" value="'.@$json->merchant_key.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Merchant Salt</label>
                    <input class="form-control" name="data[merchant_salt]" value="'.@$json->merchant_salt.'">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Ödeme Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>
                <small class="text-danger">'.website.'/paytr/callback</small>';

            echo json_encode($html);

        endif;

        if($type=="manager_path"):
        
            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "manager_path"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "manager_path")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "manager_path"))):

                    // eğer newData içerisinde manager_path varsa
                    if(isset($newData['manager_path'])):
                        $url = "/".$newData['manager_path']."/settings";
                    else:
                        $url = "/manager/settings";
                    endif;

                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "İşlem başarılı bir şekilde gerçekleştirildi.",
                        "timer" => 1500,
                        "closeModal" => true,
                        "location" => $url
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Yönetim Paneli Yolu</label>
                    <input class="form-control" name="data[manager_path]" placeholder="manager" value="'.@$json->manager_path.'">
                </div>

                <script>
                    $(document).ready(function () {
                        $("input[name=\'data[manager_path]\']").on("keypress", function (e) {
                            if (e.which === 32 || e.which === 0) {
                                return false;
                            }
                        });
                        $("input[name=\'data[manager_path]\']").on("input", function () {
                            var regexp = /[^a-z]/g;
                            if ($(this).val().match(regexp)) {
                                $(this).val($(this).val().replace(regexp, ""));
                            }
                        });
                    });
                </script>

            ';

            echo json_encode($html);
            
        endif;

        if($type=="captcha"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "captcha"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "captcha")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "captcha"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Captcha bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Captcha Site Key</label>
                    <input class="form-control" name="data[site_key]" value="'.@$json->site_key.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Captcha Secret Key</label>
                    <input class="form-control" name="data[secret_key]" value="'.@$json->secret_key.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>

            ';

            echo json_encode($html);

        endif;

        if($type=="ip_ban"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations", array("name" => "ip_ban"));
        
            ## Eğer save set edilmişse
            if(isset($save)):
        
                if(!$control): 
                    $control = create("integrations", array("name" => "ip_ban")); 
                endif;
        
                $newData = empty($control->json) ? array() : json_decode($control->json, true);
        
                foreach($data as $key => $value):
                    if($key === "ips"):
                        // Enter ve virgülle ayrılan IP'leri parçala
                        $ips = preg_split('/[\s,]+/', $value, -1, PREG_SPLIT_NO_EMPTY);
                        $existingIps = isset($newData[$key]) ? preg_split('/[\s,]+/', $newData[$key], -1, PREG_SPLIT_NO_EMPTY) : [];
                        $mergedIps = array_unique(array_merge($existingIps, $ips)); // Tekrarlayanları kaldır
                        
                        if (empty($value)): // IP listesi boşsa
                            unset($newData["status"]); // status alanını kaldır
                            $newData[$key] = ""; // ips alanını boş kaydet
                        else:
                            $newData[$key] = implode("\n", $mergedIps); // Satır bazlı kaydet
                        endif;
        
                        continue;
                    endif;
        
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
        
                    $newData[$key] = $value;
                endforeach;

                if(empty($newData["ips"])):
                    unset($newData["status"]);
                endif;
        
                if(update("integrations", array("json" => json_encode($newData)), array("name" => "ip_ban"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "IP Ban bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;
        
                return;
            endif;
        
            $json = empty($control->json) ? (object)array() : json_decode($control->json);
        
            $html = '
        
                <div class="mb-3">
                    <label class="form-label text-capitalize">Banlanmış IP Adresleri</label>
                    <textarea class="form-control" name="data[ips]" rows="5">'.@$json->ips.'</textarea>
                </div>
        
                <div class="mb-3">
                    <label class="form-label text-capitalize">Seçilenleri</label>
                    <select class="form-control" name="data[type]">
                        <option value="1" '.(@$json->type == 1 ? "selected" : "").'>Seçilenleri Engelle</option>
                        <option value="2" '.(@$json->type == 2 ? "selected" : "").'>Seçilenleri Geçir</option>
                    </select>
                </div>
        
                <div class="mb-3">
                    <label class="form-label text-capitalize">Durumu</label>
                    <select class="form-control" name="data[status]">
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>
        
            ';
        
            echo json_encode($html);
        
        endif;
        
        if($type=="google_analytics"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "google_analytics"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "google_analytics")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "google_analytics"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Google Analytics bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Ölçüm Kimliği</label>
                    <input class="form-control" name="data[google_analytics_id]" value="'.@$json->google_analytics_id.'"> 
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>

            ';

            echo json_encode($html);

        endif;

        if($type=="google_tag_manager"):
            
            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "google_tag_manager"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "google_tag_manager")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "google_tag_manager"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Google Tag Manager bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Kapsayıcı Kimliği ID</label>
                    <input class="form-control" name="data[google_tag_manager_id]" value="'.@$json->google_tag_manager_id.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Durumu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>
            ';

            echo json_encode($html);

        endif;

        if($type=="head_body_footer"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "head_body_footer"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "head_body_footer")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "head_body_footer"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Head, Body ve Footer bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Head</label>
                    <textarea code class="form-control" name="data[head]" rows="5">'.@$json->head.'</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Body</label>
                    <textarea code class="form-control" name="data[body]" rows="5">'.@$json->body.'</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Footer</label>
                    <textarea code class="form-control" name="data[footer]" rows="5">'.@$json->footer.'</textarea>
                </div>

            ';

            echo json_encode($html);

        endif;

        if($type=="css_js"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "css_js"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "css_js")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "css_js"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "CSS ve JS bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >CSS</label>
                    <textarea css class="form-control" name="data[css]" rows="5">'.@$json->css.'</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >JS</label>
                    <textarea js class="form-control" name="data[js]" rows="5">'.@$json->js.'</textarea>
                </div>

            ';

            echo json_encode($html);

        endif;

        if($type=="maintenance"):
            
            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "maintenance"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "maintenance")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "maintenance"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Bakım Modu bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Bakım Modu</label>
                    <select class="form-control" name="data[status]" >
                        <option value="1" '.(@$json->status == 1 ? "selected" : "").'>Aktif</option>
                        <option value="0" '.(@$json->status == 0 ? "selected" : "").'>Pasif</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Başlık</label>
                    <input class="form-control" name="data[title]" value="'.@$json->title.'">
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Açıklama</label>
                    <textarea class="form-control" name="data[description]" rows="5">'.@$json->description.'</textarea>
                </div>

                <input type="hidden" name="data[maintenance]" value="1">

            ';

            echo json_encode($html);

        endif;

        if($type=="currency"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "currency"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "currency")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "currency"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Para Birimi bilgileri başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '

                <div class="mb-3">
                    <label class="form-label text-capitalize" >API</label>
                    <input class="form-control"  value="'.currency_api.'" disabled>
                    <small class="text-muted">Bu alanı sadece yazılım geliştiricileri değiştirebilir.</small>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Dolar</label>
                    <input class="form-control" value="'.@$json->USD.'" disabled>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Euro</label>
                    <input class="form-control" value="'.@$json->EUR.'" disabled>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Gram Altın</label>
                    <input class="form-control" value="'.@$json->XAU.'" disabled>
                </div>

                <div class="mb-3">
                    <label class="form-label text-capitalize" >Son Güncelleme</label>
                    <input class="form-control" value="'.@$control->updated.'" disabled>
                </div>

            ';

            echo json_encode($html);



        endif;

        if($type=="dashboard"):

            ## Veritabanından kontrolü alıyoruz
            $control = fetch("integrations",array("name" => "dashboard"));

            ## Eğer save set edilmişse
            if(isset($save)):

                if(!$control): $control = create("integrations",array("name" => "dashboard")); endif;
                $newData = empty($control->json) ? array() : json_decode($control->json,true);

                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($newData[$key]);
                        continue;
                    endif;
                    $newData[$key] = $value;
                endforeach;

                if(update("integrations",array("json" => json_encode($newData)),array("name" => "dashboard"))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Bilgiler başarılı bir şekilde güncellendi.",
                        "timer" => 1500,
                        "closeModal" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $json = empty($control->json) ? (object)array() : json_decode($control->json);

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize" >Analiz Verileri</label>
                    <select class="form-control" name="data[analytics]" >
                        <option value="default" ' . (@$json->analytics == "default" ? "selected" : "") . '>Tümü</option>
                        <option value="google" ' . (@$json->analytics == "google" ? "selected" : "") . '>google</option>
                    </select>
                </div>
            ';

            echo json_encode($html);

        endif;

    break;

    case "menu-sayfa-secimi":

        $data = [];
        $search = $_POST['search'] ?? '';
        $lang = $_POST['lang'] ?? null;
    
        $search = htmlspecialchars($search, ENT_QUOTES, 'UTF-8');
        $lang = htmlspecialchars($lang, ENT_QUOTES, 'UTF-8');
    
        $query = $db->prepare("
            SELECT id, name, type 
            FROM content_translations 
            WHERE name LIKE ? AND language = ? ORDER BY (type = 'page') DESC
        ");
        $query->execute(['%' . $search . '%', $lang]);
        $results = $query->fetchAll(PDO::FETCH_OBJ);
    
        foreach ($results as $result) {
            $data[] = [
                'value' => $result->id,
                'name' => $result->name,
                'type' => $result->type,
            ];
        }
        
        echo json_encode($data);
    
    break;

    case "menu-guncelle":

        ## önce integrations tablosunda name header_menu varmı kontrol et
        $control = fetch("integrations",array("name" => $layout));

        ## eğer yoksa
        if(!$control):
            $control = create("integrations",array("name" => $layout ,"json" => $menu));
        endif;

        ## eğer varsa
        if($control):
            update("integrations",array("json" => $menu),array("name" => $layout));
        endif;

    break;
    
    case "modul-olustur":

        ## eğer aynı isimde modül varsa
        if(fetch("content_modules",array("name" => $name))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "Hata!",
                "description" => "Bu isimde bir modül zaten mevcut.",
                "timer" => 1500
            ));
            return;
        endif;

        if(create("content_modules",array("name"=>$name,"type"=>$type))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Modül başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true,
                "formReset" => true
            ));
        endif;

    break;

    case "modul-guncelle":

        $module = fetch("content_modules",array("id" => $id));
        $json = empty($module->json) ? array() : json_decode($module->json,true) ;

        if($module->type == "services" || $module->type == "blogs" || $module->type == "products"):

            if(isset($save)):

                    // eğer aynı isimde modül varsa
                    if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "error",
                            "title" => "Hata!",
                            "description" => "Bu isimde bir modül zaten mevcut.",
                            "timer" => 1000
                        ));
                        return;
                    endif;

                    // boş verileri temizle
                    foreach($data as $key => $value):
                        if(empty($value)):
                            unset($data[$key]);
                        endif;
                    endforeach;

                    if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                        echo json_encode(array(
                            "sweetAlert" => true,
                            "icon" => "success",
                            "title" => "İşlem Başarılı!",
                            "description" => "Modül başarılı bir şekilde güncellendi.",
                            "timer" => 1500,
                            "closeModal" => true,
                            "datatableReload" => true
                        ));
                        return;
                    endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Tasarım</label>
                    <select class="form-control" name="data[design]">
                        <option value="1" ' . (isset($json['design']) && $json['design'] == 1 ? "selected" : "") . '>1. Tasarım</option>
                        <option value="2" ' . (isset($json['design']) && $json['design'] == 2 ? "selected" : "") . '>2. Tasarım</option>
                        <option value="3" ' . (isset($json['design']) && $json['design'] == 3 ? "selected" : "") . '>3. Tasarım</option>
                    </select>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label text-capitalize">Sıralama</label>
                            <select class="form-control" name="data[order]">
                                <option value="oldest" ' . (isset($json['order']) && $json['order'] == "oldest" ? "selected" : "") . '>Son Eklenen</option>
                                <option value="latest" ' . (isset($json['order']) && $json['order'] == "latest" ? "selected" : "") . '>İlk Eklenen</option>
                                <option value="random" ' . (isset($json['order']) && $json['order'] == "random" ? "selected" : "") . '>Rastgele</option>
                                <option value="custom" ' . (isset($json['order']) && $json['order'] == "custom" ? "selected" : "") . '>Özel</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label text-capitalize">Limit</label>
                            <input class="form-control" name="data[limit]" value="' . (isset($json['limit']) ? htmlspecialchars($json['limit']) : '') . '">
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Seçim Türü</label>
                    <select class="form-control" name="data[selection_type]">
                        <option value="all" ' . (isset($json['selection_type']) && $json['selection_type'] == "all" ? "selected" : "") . '>Tümü</option>
                        <option value="category" ' . (isset($json['selection_type']) && $json['selection_type'] == "category" ? "selected" : "") . '>Katagoriye Göre</option>
                        <option value="single" ' . (isset($json['selection_type']) && $json['selection_type'] == "single" ? "selected" : "") . '> Tekil Seçim</option>
                    </select>
                </div>
                <div class="mb-3" style="display:none">
                    <label class="form-label text-capitalize">Seçilen ID numaraları</label>
                    <input class="form-control" name="data[selection_ids]" value="' . (isset($json['selection_ids']) ? htmlspecialchars($json['selection_ids']) : '') . '">
                    <small class="text-muted">Örnek: 1,2,3,4</small>
                </div>

                <script>
                    $("select[name=\'data[selection_type]\']").change(function () {
                        if ($(this).val() == "category" || $(this).val() == "single") {
                            $("input[name=\'data[selection_ids]\']").parent().show();
                        } else {
                            $("input[name=\'data[selection_ids]\']").parent().hide();
                        }
                    });
                    if ($("select[name=\'data[selection_type]\']").val() == "category" || $("select[name=\'data[selection_type]\']").val() == "single") {
                        $("input[name=\'data[selection_ids]\']").parent().show();
                    }
                </script>

            ';
        
            echo json_encode($html);
        
        endif;

        if($module->type == 'html'):
            
            if(isset($save)):

                // eğer aynı isimde modül varsa
                if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "Hata!",
                        "description" => "Bu isimde bir modül zaten mevcut.",
                        "timer" => 1500
                    ));
                    return;
                endif;

                // boş verileri temizle
                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($data[$key]);
                    endif;
                endforeach;

                if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Modül başarılı bir şekilde güncellendi.",
                        "timer" => 1000,
                        "closeModal" => true,
                        "datatableReload" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '">
                </div>
            ';
            
            foreach($active_languages as $lang):
                $html .= '
                    <div class="mb-3">
                        <label class="form-label">HTML ('.$lang->code.')</label>
                        <textarea class="form-control" name="data['.$lang->id.'][html]" rows="5" code>'.@$json[$lang->id]['html'].'</textarea>
                    </div>
                ';
            endforeach;

            echo json_encode($html);

        endif;

        if($module->type == 'banner'):
            
            if(isset($save)):

                // eğer aynı isimde modül varsa
                if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "Hata!",
                        "description" => "Bu isimde bir modül zaten mevcut.",
                        "timer" => 1500
                    ));
                    return;
                endif;

                // boş verileri temizle
                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($data[$key]);
                    endif;
                endforeach;

                if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Modül başarılı bir şekilde güncellendi.",
                        "timer" => 1000,
                        "closeModal" => true,
                        "datatableReload" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '" required>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Tasarım</label>
                    <select class="form-control" name="data[design]">
                        <option value="1" ' . (isset($json['design']) && $json['design'] == 1 ? "selected" : "") . '>1. Tasarım</option>
                        <option value="2" ' . (isset($json['design']) && $json['design'] == 2 ? "selected" : "") . '>2. Tasarım</option>
                        <option value="3" ' . (isset($json['design']) && $json['design'] == 3 ? "selected" : "") . '>3. Tasarım</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Banner</label>
                    <select class="form-control" name="data[banner]" required>';
                        $html .= '<option value="">--- sec ---</option>';
                        $banners = fetchAll("banners[id,name]");
                        foreach($banners as $banner):
                            $html .= '<option value="'.$banner->id.'" '.(@$json["banner"] == $banner->id ? "selected" : "").'>'.$banner->name.'</option>';
                        endforeach;
                   $html .= '</select>
                </div>
            ';

            echo json_encode($html);

        endif;

        if($module->type == 'categories'):
            
            if(isset($save)):

                // eğer aynı isimde modül varsa
                if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "Hata!",
                        "description" => "Bu isimde bir modül zaten mevcut.",
                        "timer" => 1500
                    ));
                    return;
                endif;

                // boş verileri temizle
                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($data[$key]);
                    endif;
                endforeach;

                if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Modül başarılı bir şekilde güncellendi.",
                        "timer" => 1000,
                        "closeModal" => true,
                        "datatableReload" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '" required>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Tasarım</label>
                    <select class="form-control" name="data[design]">
                        <option value="1" ' . (isset($json['design']) && $json['design'] == 1 ? "selected" : "") . '>1. Tasarım</option>
                        <option value="2" ' . (isset($json['design']) && $json['design'] == 2 ? "selected" : "") . '>2. Tasarım</option>
                        <option value="3" ' . (isset($json['design']) && $json['design'] == 3 ? "selected" : "") . '>3. Tasarım</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Seçilen ID numaraları</label>
                    <input class="form-control" name="data[selection_ids]" value="' . (isset($json['selection_ids']) ? htmlspecialchars($json['selection_ids']) : '') . '">
                    <small class="text-muted">Örnek: 1,2,3,4</small>
                </div>
            ';

            echo json_encode($html);

        endif;

        if($module->type == 'breadcrumb'):
        

            if(isset($save)):

                // eğer aynı isimde modül varsa
                if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "Hata!",
                        "description" => "Bu isimde bir modül zaten mevcut.",
                        "timer" => 1500
                    ));
                    return;
                endif;

                // boş verileri temizle
                foreach($data as $key => $value):

                    // eğer resim varsa
                    if(strpos($value[0], 'data:image') !== false):
                        require "app/upload.php";
                        $upload = new Upload($value[0]);
                        if($upload->uploaded):
                            $upload->file_new_name_body = "breadcrumb";
                            $upload->process("view/frontend/assets/img/breadcrumb/");
                            if($upload->processed):
                                $data[$key] = "/view/frontend/assets/img/breadcrumb/".$upload->file_dst_name;
                            endif;
                            $upload->clean();
                        endif;
                    endif;

                    if(empty($value)):
                        unset($data[$key]);
                    endif;

                endforeach;

                if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Modül başarılı bir şekilde güncellendi.",
                        "timer" => 1000,
                        "closeModal" => true,
                        "datatableReload" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '" required>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Tasarım</label>
                    <select class="form-control" name="data[design]">
                        <option value="1" ' . (isset($json['design']) && $json['design'] == 1 ? "selected" : "") . '>1. Tasarım</option>
                        <option value="2" ' . (isset($json['design']) && $json['design'] == 2 ? "selected" : "") . '>2. Tasarım</option>
                        <option value="3" ' . (isset($json['design']) && $json['design'] == 3 ? "selected" : "") . '>3. Tasarım</option>
                    </select>
                </div>
                <div class="mb-3 gallery row col-sm-3">
                    <label class="form-label text-capitalize">Varsayılan Görsel</label>
                        <div class="single-img-upload">
                            <label class="item-upload">
                                <div class="las la-image"></div>
                                <input type="file" id="mobile-img" accept="image/*" data-type="image">
                            </label>';
                            if(isset($json['image'])):
                                $html .= '<div class="uploaded-file no-hover">
                                <img src="'.@$json['image'].'" alt="">
                                <button type="button" class="edit">
                                    <i class="las la-crop"></i>
                                </button>
                                <button type="button" class="delete">
                                    <i class="las la-trash"></i>
                                </button>
                                <input type="hidden" name="data[image]" value="'.@$json['image'].'">
                            </div>';
                            else:
                        $html .= '
                            <input type="hidden" name="data[image]" value="'.@$json['image'].'">
                        </div>
                    </div>
                </div>
            ';

            endif;

            echo json_encode($html);

        endif;

        if($module->type == 'newsletter'):

            if(isset($save)):

                // eğer aynı isimde modül varsa
                if(fetch("content_modules",array("name" => $name,"id[!]"=>$id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "Hata!",
                        "description" => "Bu isimde bir modül zaten mevcut.",
                        "timer" => 1500
                    ));
                    return;
                endif;

                // boş verileri temizle
                foreach($data as $key => $value):
                    if(empty($value)):
                        unset($data[$key]);
                    endif;
                endforeach;

                if(update("content_modules",array("name"=>$name,"json" => json_encode($data)),array("id" => $id))):
                    echo json_encode(array(
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı!",
                        "description" => "Modül başarılı bir şekilde güncellendi.",
                        "timer" => 1000,
                        "closeModal" => true,
                        "datatableReload" => true
                    ));
                    return;
                endif;

                return;
            endif;

            $html = '
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Tipi</label>
                    <input class="form-control"  value="' . htmlspecialchars($module->type) . '" disabled>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Modül Adı</label>
                    <input class="form-control" name="name" value="' . htmlspecialchars($module->name) . '" required>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Tasarım</label>
                    <select class="form-control" name="data[design]">
                        <option value="1" ' . (isset($json['design']) && $json['design'] == 1 ? "selected" : "") . '>1. Tasarım</option>
                        <option value="2" ' . (isset($json['design']) && $json['design'] == 2 ? "selected" : "") . '>2. Tasarım (popup)</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Başlık</label>
                    <input class="form-control" name="data[title]" value="' . (isset($json['title']) ? htmlspecialchars($json['title']) : '') . '">
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Açıklama</label>
                    <textarea class="form-control" name="data[description]" rows="5">' . (isset($json['description']) ? htmlspecialchars($json['description']) : '') . '</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label text-capitalize">Buton Metni</label>
                    <input class="form-control" name="data[button_text]" value="' . (isset($json['button_text']) ? htmlspecialchars($json['button_text']) : '') . '">
                </div>
            ';

            echo json_encode($html);

        endif;

    break;

    case "kapsayici-olustur":

        $create = create("content_layouts",array("content"=>$content,"class"=>"container-fluid"));
        echo json_encode(array(
            "id" => $create,
            "class" => "container-fluid",
        ));

    break;

    case "kapsayici-duzenle":

        if(update("content_layouts",array("class"=>$class),array("id" => $id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Kapsayıcı başarılı bir şekilde güncellendi.",
                "timer" => 1000,
                "refresh" => true,
                "closeModal" => true
            ));
        endif;

    break;

    case "kapsayici-modul-olustur":

        $content_layouts = fetch("content_layouts", array("id" => $id));
        $result = empty($content_layouts->json) ? array() : json_decode($content_layouts->json, true);

        ## Datayı oluşturuyoruz
        $keys = array_keys($data);
        $count = count($data[$keys[0]]);
        for ($i = 0; $i < $count; $i++) :
            $newItem = [];
            foreach ($keys as $key) :
                $newItem[$key] = $data[$key][$i];
            endforeach;
            $result[] = $newItem; // Mevcut verilerin üzerine ekleniyor
        endfor;

        if(update("content_layouts", array("json" => json_encode($result)), array("id" => $id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Modül başarılı bir şekilde eklendi.",
                "timer" => 1000,
                "refresh" => true,
                "closeModal" => true
            ));
        endif;

    break;

    case "kapsayici-modul-sil":

        $kapsayici = fetch("content_layouts", array("id" => $content));
        $result = empty($kapsayici->json) ? array() : json_decode($kapsayici->json, true);

        unset($result[$key]);

        if(update("content_layouts", array("json" => json_encode(array_values($result))), array("id" => $content))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Modül başarılı bir şekilde silindi.",
                "timer" => 1000,
                "refresh" => true
            ));
        endif;

    break;

    case "kapsayici-modul-sira-guncelle":

        $kapsayici = fetch("content_layouts", array("id" => $content));
        $result = empty($kapsayici->json) ? array() : json_decode($kapsayici->json, true);
    
        $newResult = [];
        foreach ($value as $v) {
            $newResult[] = $result[$v['id']];
        }
    
        $updatedJson = json_encode($newResult);
        update("content_layouts", array("json" => $updatedJson), array("id" => $content));
    
    break;

    case "kapsayici-modul-oku":

        $kapsayici = fetch("content_layouts", array("id" => $content));
        $result = empty($kapsayici->json) ? array() : json_decode($kapsayici->json, true);

        echo json_encode($result[$key]);

    break;

    case "kapsayici-modul-guncelle":

        $kapsayici = fetch("content_layouts", array("id" => $id));
        $old_json = empty($kapsayici->json) ? array() : json_decode($kapsayici->json, true);

        $keys = array_keys($data);
        $count = count($data[$keys[0]]);
        for ($i = 0; $i < $count; $i++) :
            $newItem = [];
            foreach ($keys as $keyItem) :
                $newItem[$keyItem] = $data[$keyItem][$i];
            endforeach;
            $result = $newItem;
        endfor;

        $old_json[$key] = $result;

        if(update("content_layouts", array("json" => json_encode($old_json)), array("id" => $id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Modül başarılı bir şekilde güncellendi.",
                "timer" => 1000,
                "refresh" => true,
                "closeModal" => true
            ));
        endif;


    break;
    
    case "banner-olustur":

        ## dataları topluyoruz
        $newData = array();

        ## dosya yükleme fonksiyonu
        require "app/upload.php"; 

        ## eğer dosya yüklenmişse
        $result = [];

        error_reporting(0);

        ## Datayı oluşturuyoruz
        $keys = array_keys($data);
        $count = count($data[$keys[0]]);
        for ($i = 0; $i < $count; $i++) :

            $result[$i] = [];


            foreach ($keys as $key) :
                $result[$i][$key] = $data[$key][$i];
            endforeach;

            ## eğer resim dosyası yüklenmişse
            if ($result[$i]['type'] === 'image' && !empty($result[$i]['file_desktop'])):
                $fileData = $result[$i]['file_desktop']; 
                if (isset($fileData)): 
                    $upload = new Upload($fileData);
                    if ($upload->uploaded):
                        $upload->file_new_name_body = "banner";
                        $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/img/banners/');
                        if ($upload->processed):
                            $result[$i]['file_desktop'] = "/view/frontend/assets/img/banners/".$upload->file_dst_name;
                        endif;
                    endif;
                endif;
            endif;

            ## eğer resim dosyası yüklenmişse
            if ($result[$i]['type'] === 'image' && !empty($result[$i]['file_mobile'])):
                $fileData = $result[$i]['file_mobile']; 
                if (isset($fileData)): 
                    $upload = new Upload($fileData);
                    if ($upload->uploaded):
                        $upload->file_new_name_body = "banner";
                        $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/img/banners/');
                        if ($upload->processed):
                            $result[$i]['file_mobile'] = "/view/frontend/assets/img/banners/".$upload->file_dst_name;
                        endif;
                    endif;
                endif;
            endif;

            ## eğer video dosyası yüklenmişse
            if ($result[$i]['type'] === 'video' && !empty($result[$i]['file_desktop'])):
                $fileData = $result[$i]['file_desktop']; 
                if (isset($fileData)): 
                    $upload = new Upload($fileData);
                    if ($upload->uploaded):
                        $upload->file_new_name_body = "banner";
                        $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/videos/');
                        if ($upload->processed):
                            $result[$i]['file_desktop'] = "/view/frontend/assets/videos/".$upload->file_dst_name;
                        endif;
                    endif;
                endif;
            endif;

            ## eğer video dosyası yüklenmişse
            if ($result[$i]['type'] === 'video' && !empty($result[$i]['file_mobile'])):
                $fileData = $result[$i]['file_mobile']; 
                if (isset($fileData)): 
                    $upload = new Upload($fileData);
                    if ($upload->uploaded):
                        $upload->file_new_name_body = "banner";
                        $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/videos/');
                        if ($upload->processed):
                            $result[$i]['file_mobile'] = "/view/frontend/assets/videos/".$upload->file_dst_name;
                        endif;
                    endif;
                endif;
            endif;

        endfor;

        ## datayı jsona çeviriyoruz
        $newData = json_encode($result);

        ## eğer aynı isimde banner varsa
        if(fetch("banners",array("name" => $name))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "Hata!",
                "description" => "Bu isimde bir banner zaten mevcut.",
                "timer" => 1500
            ));
            return;
        endif;

        if(create("banners",array("name"=>$name,"json" => $newData))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Banner başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "back" => true
            ));
        endif;

    break;

    case "banner-guncelle":

        ## dataları topluyoruz
        $newData = array();
    
        ## dosya yükleme fonksiyonu
        require "app/upload.php"; 
    
        ## eğer dosya yüklenmişse
        $result = [];
    
        error_reporting(0);
    
        ## Datayı oluşturuyoruz
        $keys = array_keys($data);
        $count = count($data[$keys[0]]);
        for ($i = 0; $i < $count; $i++) :
    
            $result[$i] = [];
    
            foreach ($keys as $key) :
                $result[$i][$key] = $data[$key][$i];
            endforeach;
    
            ## eğer resim dosyası yüklenmişse (desktop)
            if ($result[$i]['type'] === 'image' && !empty($result[$i]['file_desktop'])):
                $fileData = $result[$i]['file_desktop']; 
                if (isset($fileData)) { 
                    // Eğer base64 verisi gelmişse, base64'ü yükle
                    if (strpos($fileData,'base64')) {
                        // Base64 verisi
                        $upload = new Upload($fileData);
                        if ($upload->uploaded) {
                            $upload->file_new_name_body = "banner";
                            $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/img/banners/');
                            if ($upload->processed) {
                                $result[$i]['file_desktop'] = "/view/frontend/assets/img/banners/" . $upload->file_dst_name;
                            }
                        }
                    } else {
                        // Eğer sadece dosya yolu geliyorsa, direk olarak onu kullan
                        $result[$i]['file_desktop'] = $fileData;
                    }
                }
            endif;
    
            ## eğer resim dosyası yüklenmişse (mobile)
            if ($result[$i]['type'] === 'image' && !empty($result[$i]['file_mobile'])):
                $fileData = $result[$i]['file_mobile']; 
                if (isset($fileData)) { 
                    // Eğer base64 verisi gelmişse, base64'ü yükle
                    if (strpos($fileData,'base64')) {
                        // Base64 verisi
                        $upload = new Upload($fileData);
                        if ($upload->uploaded) {
                            $upload->file_new_name_body = "banner";
                            $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/img/banners/');
                            if ($upload->processed) {
                                $result[$i]['file_mobile'] = "/view/frontend/assets/img/banners/" . $upload->file_dst_name;
                            }
                        }
                    } else {
                        // Eğer sadece dosya yolu geliyorsa, direk olarak onu kullan
                        $result[$i]['file_mobile'] = $fileData;
                    }
                }
            endif;
    
            ## eğer video dosyası yüklenmişse (desktop)
            if ($result[$i]['type'] === 'video' && !empty($result[$i]['file_desktop'])):
                $fileData = $result[$i]['file_desktop']; 
                if (isset($fileData)) { 
                    // Eğer base64 verisi gelmişse, base64'ü yükle
                    if (strpos($fileData,'base64')) {
                        // Base64 verisi
                        $upload = new Upload($fileData);
                        if ($upload->uploaded) {
                            $upload->file_new_name_body = "banner";
                            $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/videos/');
                            if ($upload->processed) {
                                $result[$i]['file_desktop'] = "/view/frontend/assets/videos/" . $upload->file_dst_name;
                            }
                        }
                    } else {
                        // Eğer sadece dosya yolu geliyorsa, direk olarak onu kullan
                        $result[$i]['file_desktop'] = $fileData;
                    }
                }
            endif;
    
            ## eğer video dosyası yüklenmişse (mobile)
            if ($result[$i]['type'] === 'video' && !empty($result[$i]['file_mobile'])):
                $fileData = $result[$i]['file_mobile']; 
                if (isset($fileData)) { 
                    // Eğer base64 verisi gelmişse, base64'ü yükle
                    if (strpos($fileData,'base64')) {
                        // Base64 verisi
                        $upload = new Upload($fileData);
                        if ($upload->uploaded) {
                            $upload->file_new_name_body = "banner";
                            $upload->process($_SERVER['DOCUMENT_ROOT'] . '/view/frontend/assets/videos/');
                            if ($upload->processed) {
                                $result[$i]['file_mobile'] = "/view/frontend/assets/videos/" . $upload->file_dst_name;
                            }
                        }
                    } else {
                        // Eğer sadece dosya yolu geliyorsa, direk olarak onu kullan
                        $result[$i]['file_mobile'] = $fileData;
                    }
                }
            endif;
    
        endfor;
    
        ## datayı jsona çeviriyoruz
        $newData = json_encode($result);
    
        ## Eğer aynı isimde banner varsa
        if(fetch("banners",array("name" => $name , "id[!]"=>$id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "Hata!",
                "description" => "Bu isimde bir banner zaten mevcut.",
                "timer" => 1500
            ));
            return;
        endif;
    
        if(update("banners",array("name"=>$name,"json" => $newData),array("id" => $id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "Banner başarılı bir şekilde oluşturuldu.",
                "timer" => 1500,
                "closeModal" => true,
                "back" => true
            ));
        endif;
    
    break;

    case "bildirim-kontrol":

        $notifications = fetchAll("user_notifications",array("user" => $active_user->id,"status" => 0),array(),8);
        $count = count($notifications);

        echo json_encode(array(
            "count" => $count,
            "data" => $notifications
        ));

    break;

    case "sistem-sifirlama":

        if(md5($password) != "a52e827466c970278a7342e2d0214c9e"):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "Hata!",
                    "description" => "Şifre hatalı.",
                    "timer" => 1500
                ));
            return;
        endif;

        // Disable foreign key checks to allow truncating tables that have FK constraints
        try {
            $db->exec("SET FOREIGN_KEY_CHECKS = 0");
            $tables = $db->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
            foreach ($tables as $table) {
                if (!in_array($table, ['cities', 'city_districts'])) {
                    // Sanitize table name and use backticks to avoid SQL syntax issues
                    $tableName = str_replace('`', '', $table);
                    $db->exec("TRUNCATE TABLE `{$tableName}`");
                }
            }
            $db->exec("SET FOREIGN_KEY_CHECKS = 1");
        } catch (Exception $e) {
            // Ensure FK checks are re-enabled and return an error instead of a 500
            @ $db->exec("SET FOREIGN_KEY_CHECKS = 1");
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "Hata!",
                "description" => "Veritabanı sıfırlanırken bir hata oluştu: " . $e->getMessage(),
                "timer" => 3000
            ));
            return;
        }

        $rootPath = $_SERVER['DOCUMENT_ROOT'] . "/view/frontend/assets";
        $allowedExtensions = ['js', 'css', 'json', 'ttf' , 'woff' , 'woff2' , 'eot'];
        function processDirectory($directory, $allowedExtensions) {
            $files = glob($directory . '/*');
            foreach ($files as $file):
                if (is_dir($file)):
                    processDirectory($file, $allowedExtensions);
                    if (count(glob($file . '/*')) === 0):
                        rmdir($file);
                    endif;
                elseif (is_file($file)):
                    $extension = pathinfo($file, PATHINFO_EXTENSION);
                    if (!in_array($extension, $allowedExtensions)):
                        unlink($file);
                    endif;
                endif;
            endforeach;
        }

        processDirectory($rootPath, $allowedExtensions);

        $files = glob($rootPath . '/*');
        foreach ($files as $file):
            if (is_dir($file)):
                $directory = new RecursiveDirectoryIterator($file, RecursiveDirectoryIterator::SKIP_DOTS);
                $files = new RecursiveIteratorIterator($directory, RecursiveIteratorIterator::SELF_FIRST);
                foreach ($files as $file):
                    @touch($file, strtotime(date("Y-m-d H:i:s")));
                endforeach;
            else:
                touch($file, strtotime(date("Y-m-d H:i:s")));
            endif;
        endforeach;

        if(file_exists("view/backend/cronjob/cron_log.txt")):
            unlink("view/backend/cronjob/cron_log.txt");
        endif;

        $user_permissions = create("user_permissions",array(
            "name" => "Developer",
            "authority" => "*"
        ));

        $users = create("users",array(
            "name" => "Fırat",
            "surname" => "Ateşdağlı",
            "phone" => "+90 532 307 19 99",
            "email" => "owlfunction@gmail.com",
            "username" => "baykus",
            "password" => "wQyORMypLbvsqWuLo1gBBQ==",
            "permission" => 1,
            "multiple" => 1,
        ));

        $languages = create("languages",array(
            "code" => "tr",
            "name" => "Türkçe",
            "phone_code" => "+90",
            "is_default" => 1,
            "sort" => 0
        ));

        $integrations = create("integrations",array(
            "name" => "maintenance",
            "json" => json_encode([
                "status" => 1,
                "maintenance" => 1,
                "title" => "Bakımdayız!",
                "description" => "Web sitemiz şu an bakım çalışmaları nedeniyle geçici olarak hizmet dışıdır. En kısa sürede tekrar sizlerle olacağız. Gösterdiğiniz anlayış için teşekkür ederiz."
            ],JSON_UNESCAPED_UNICODE)
        ));

        $contents = create("contents",array(
            "type" => "page",
            "theme" => "home.php",
            "status" => 1,
        ));

        $content_translations = create("content_translations",array(
            "content" => 1,
            "language" => 1,
            "is_index" => 1,
            "type" => "page",
            "name" => "Anasayfa",
            "url" => "/",
        ));

        echo json_encode(array(
            "sweetAlert" => true,
            "icon" => "success",
            "title" => "İşlem Başarılı!",
            "description" => "Sistem başarılı bir şekilde sıfırlandı.",
            "timer" => 1500,
            "refresh" => true
        ));

        if(file_exists("app/error.logg")):
            unlink("app/error.logg");
        endif;

    break;

    case "iletisim-formu-oku-guncelle":

        if(update("feedback",array("status"=>$status),array("id"=>$id))):
            echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı!",
                "description" => "İletişim formu başarılı bir şekilde güncellendi.",
                "timer" => 1500,
                "closeModal" => true,
                "datatableReload" => true
            ));
        endif;

    break;

    case "göster-paneli-verileri":

        $control = fetch("integrations", ["name" => "dashboard"]);
        if ($control && $control->json && json_decode($control->json, true)['analytics'] === "google") {
            define("ANALYTICS_INTEGRATION", "google");
        }

        function getTimeCond($v) {
            return [
                "today" => "created >= CURDATE() AND created < CURDATE() + INTERVAL 1 DAY",
                "yesterday" => "created >= CURDATE() - INTERVAL 1 DAY AND created < CURDATE()",
                "thisWeek" => "YEARWEEK(created,1) = YEARWEEK(CURDATE(),1)",
                "lastWeek" => "YEARWEEK(created,1) = YEARWEEK(CURDATE() - INTERVAL 1 WEEK,1)",
                "last7days" => "created >= NOW() - INTERVAL 7 DAY",
                "last30days" => "created >= NOW() - INTERVAL 30 DAY",
                "thisMonth" => "created >= DATE_FORMAT(CURDATE(),'%Y-%m-01') AND created < DATE_FORMAT(CURDATE() + INTERVAL 1 MONTH,'%Y-%m-01')",
                "lastMonth" => "created >= DATE_FORMAT(CURDATE() - INTERVAL 1 MONTH,'%Y-%m-01') AND created < DATE_FORMAT(CURDATE(),'%Y-%m-01')",
                "thisYear" => "YEAR(created) = YEAR(CURDATE())",
                "lastYear" => "YEAR(created) = YEAR(CURDATE() - INTERVAL 1 YEAR)",
                "all" => "1"
            ][$v] ?? '1';
        }

        function getCount($db, $where='', $group='', $sel='COUNT(DISTINCT visitor) c') {
            $conds = array_filter([$where, defined('ANALYTICS_INTEGRATION') && ANALYTICS_INTEGRATION === "google" ? "referer LIKE '%goog%'" : null]);
            $q = "SELECT $sel FROM analytics" . ($conds ? " WHERE ".implode(" AND ", $conds) : "") . ($group ? " GROUP BY $group" : "");
            return $db->query($q)->fetchAll(PDO::FETCH_OBJ);
        }

        function getGrouped($rows, $key, $val='c') {
            $out = [];
            foreach ($rows as $r) $out[$r->$key] = $r->$val;
            return $out;
        }

        function outJson($data) {
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($data);
            exit;
        }

        if ($type === "today,last30,thisYear,online") {
            outJson([
                "today" => getCount($db, "DATE(created) = CURDATE()")[0]->c ?? 0,
                "last30" => getCount($db, "DATE(created) BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()")[0]->c ?? 0,
                "thisYear" => getCount($db, "YEAR(created) = YEAR(CURDATE())")[0]->c ?? 0,
                "online" => getCount($db, "updated >= NOW() - INTERVAL 1 MINUTE")[0]->c ?? 0
            ]);
        }

        if ($type === "devices") {
            $c = getTimeCond($value);
            $data = [
                "Masaüstü" => getCount($db, "$c AND device='desktop'")[0]->c ?? 0,
                "Mobil" => getCount($db, "$c AND device='mobile'")[0]->c ?? 0
            ];
            arsort($data);
            outJson($data);
        }

        if (in_array($type, ["browsers","citys","country","referer"])) {
            $map = ["browsers"=>"browser","citys"=>"city","country"=>"code","referer"=>"referer"];
            $c = getTimeCond($value);
            $rows = getCount($db, $c, $map[$type], "COUNT(DISTINCT visitor) c, {$map[$type]}");
            usort($rows, fn($a,$b) => $b->c <=> $a->c);
            outJson(array_change_key_case(array_slice(getGrouped($rows, $map[$type]), 0, $type=="citys"?3:4), CASE_LOWER));
        }

        if ($type === "ips") {
            $c = getTimeCond($value);
            if (defined('ANALYTICS_INTEGRATION') && ANALYTICS_INTEGRATION === "google") $c .= " AND referer LIKE '%goog%'";
            outJson($db->query("SELECT ip FROM analytics WHERE $c GROUP BY ip")->fetchAll(PDO::FETCH_OBJ));
        }

        if ($type === "line") {
            $c = getTimeCond($value);
            $data = [];

            switch ($value) {
                case "today":
                case "yesterday":
                    $rows = getCount($db, $c, "HOUR(created)", "COUNT(DISTINCT visitor) c, HOUR(created) h");
                    for ($i=0; $i<24; $i++) $data[$i]=0;
                    foreach($rows as $r) $data[$r->h]=$r->c;
                    break;

                case "thisWeek":
                case "lastWeek":
                    $rows = getCount($db, $c, "DAYNAME(created)", "COUNT(DISTINCT visitor) c, DAYNAME(created) d");
                    $days = ["Monday"=>"Pazartesi","Tuesday"=>"Salı","Wednesday"=>"Çarşamba","Thursday"=>"Perşembe","Friday"=>"Cuma","Saturday"=>"Cumartesi","Sunday"=>"Pazar"];
                    foreach($days as $tr) $data[$tr]=0;
                    foreach($rows as $r) if(isset($days[$r->d])) $data[$days[$r->d]] = $r->c;
                    break;

                case "last7days":
                case "last30days":
                    $daysCount = $value=="last7days"?7:30;
                    $rows = getCount($db, $c, "DATE(created)", "COUNT(DISTINCT visitor) c, DATE(created) d");
                    for ($i=0;$i<$daysCount;$i++) $data[date("Y-m-d", strtotime("-$i days"))]=0;
                    foreach($rows as $r) if(isset($data[$r->d])) $data[$r->d]=$r->c;
                    $data = array_reverse($data);
                    break;

                case "thisMonth":
                case "lastMonth":
                    $daysCount = $value=="thisMonth"?date("t"):date("t", strtotime("-1 month"));
                    $rows = getCount($db, $c, "DAY(created)", "COUNT(DISTINCT visitor) c, DAY(created) d");
                    for ($i=1;$i<=$daysCount;$i++) $data[$i]=0;
                    foreach($rows as $r) $data[$r->d]=$r->c;
                    break;

                case "thisYear":
                case "lastYear":
                    $rows = getCount($db, $c, "MONTH(created)", "COUNT(DISTINCT visitor) c, MONTH(created) m");
                    for ($i=1;$i<=12;$i++) $data[$i]=0;
                    foreach($rows as $r) $data[$r->m]=$r->c;
                    break;

                case "all":
                    $rows = getCount($db, "created >= CURDATE() - INTERVAL 7 YEAR", "YEAR(created)", "COUNT(DISTINCT visitor) c, YEAR(created) y");
                    for ($i=0;$i<7;$i++) $data[date("Y", strtotime("-$i years"))]=0;
                    foreach($rows as $r) $data[$r->y]=$r->c;
                    break;
            }
            outJson($data);
        }

    break;

    case "toplu-urun-olustur":

        $eklenen = 0;
        $eklenemeyen = 0;
        $eklenemeyenler = array();


        require "app/upload.php";


        ## eğer parent yoksa uyar
        if(!$_POST['category']):
             echo json_encode(array(
                "sweetAlert" => true,
                "icon" => "warning",
                "title" => "Hata!",
                "description" => "Lütfen bir kategori seçin.",
                "timer" => 2000,
            ));
            return;
        endif;


        ## fotorafları dön
        foreach ($_FILES['files']['name'] as $key => $value):

            $file = $_FILES['files']['tmp_name'][$key];
            $filename = $_FILES['files']['name'][$key];
            $filetype = $_FILES['files']['type'][$key];
            $filesize = $_FILES['files']['size'][$key];

            ## uzantısını kaldır
            $ext = pathinfo($filename, PATHINFO_EXTENSION);
            $filename = pathinfo($filename, PATHINFO_FILENAME);
            $filename = str_replace(" ", "-", $filename);
            $filename = strtolower($filename);

            if($filename):

                // daha önce var mı kontrol et
                $check = $db->query("SELECT * FROM content_translations WHERE name = '$filename' AND type = 'product'")->fetch(PDO::FETCH_OBJ);
                if($check):
                    $eklenemeyen++;
                    $eklenemeyenler[] = $filename;
                    continue;
                endif;

                $create = create("contents",
                    array(
                        "category" => $_POST['category'],
                        "type" => $_POST['type'],
                        "parent" => $_POST['parent'],
                        "parent_history" => $_POST['parent_history'],
                    )
                );
                $create_translation = create("content_translations",
                    array(
                        "type" => $_POST['type'],
                        "content" => $create,
                        "language" => 1,
                        "name" => $filename,
                        "url" => "/urun/".slugify($filename),
                        "is_index" => 1,
                    )
                );
                create("content_products",
                    array(
                        "content" => $create,
                        "code" => $filename,
                        "price" => 0,
                    )
                );

                $eklenen++;

                $upload = new Upload($file);
                if($upload->uploaded):

                    $upload->file_new_name_body = slugify($filename);

                    ## WEBP
                    $upload->image_convert = 'webp';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);
                        create("files",array(
                            "master_table" => "contents",
                            "master_id" => $create,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "webp",
                            "file_size" => $file_size,
                            "sort" => $key
                        ));
                    endif;

                    ## JPG
                    $upload->file_new_name_body = slugify($filename);
                    $upload->image_convert = 'jpg';
                    $upload->process($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type);
                    if($upload->processed):
                        
                        $file_size = filesize($_SERVER['DOCUMENT_ROOT'].'/view/frontend/assets/img/'.$type.'/'.$upload->file_dst_name);

                        ## Eğer ilk resim varsa
                       
                            $image = "/view/frontend/assets/img/$type/".$upload->file_dst_name;
                            update("contents",array("image" => $image),array("id" => $create),0);
                      

                        create("files",array(
                            "master_table" => "contents",
                            "master_id" => $create,
                            "path" => "/view/frontend/assets/img/$type/".$upload->file_dst_name,
                            "file_type" => "jpg",
                            "file_size" => $file_size,
                            "sort" => $key
                        ));
                    endif;
                endif;

            endif;

            endforeach;


            // eklenemeyen varsa onlarla birlikte kaç tane eklendi ona göre durum bildir
            if($eklenemeyen > 0):
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "warning",
                    "title" => "Hata!",
                    "description" => "$eklenen tane ürün eklendi, $eklenemeyen tane ürün eklenemedi. Eklenemeyenler: ".implode(", ",$eklenemeyenler),
                    "timer" => 2000,
                ));
            else:
                echo json_encode(array(
                    "sweetAlert" => true,
                    "icon" => "success",
                    "title" => "Başarılı!",
                    "description" => "$eklenen tane ürün eklendi.",
                    "timer" => 2000,
                ));
            endif;


      

    break;

    case "bildirim-sayisi":

        $notifications = fetchAll("user_notifications", array("user" => $active_user->id, "status" => 0));
        $count = count($notifications);

        echo json_encode(array(
            "count" => $count
        ));

    break;
    
endswitch;