<?php Class backend {

    public function login()
    {
        ipBanControl();
        $title = "Giriş Yap";
        if(isset($_COOKIE['manager'])):  header('Location: /'.manager_path."/dashboard"); return; endif;
        require "view/backend/layout/head.php";
        require "view/backend/authentication/login.php";
        require "view/backend/layout/footer.php";
    }

    public function forgotPassword()
    {
        ipBanControl();
        $title = "Şifremi Unuttum";
        if(isset($_COOKIE['manager'])):  header('Location: /'.manager_path."/dashboard"); return; endif;
        require "view/backend/layout/head.php";
        require "view/backend/authentication/forgot.php";
        require "view/backend/layout/footer.php";
    }

    public function resetPassword($token)
    {
        ipBanControl();
        $title = "Şifre Sıfırla";
        if(isset($_COOKIE['manager'])):  header('Location: /'.manager_path."/dashboard"); return; endif;
        require "view/backend/layout/head.php";
        require "view/backend/authentication/reset.php";
        require "view/backend/layout/footer.php";
    }

    public function logout()
    {
        update("user_sessions",array("status"=>0),array("token"=>$_COOKIE['manager']));
        setcookie('manager', '', time() - 3600, '/');
        header('Location: /'.manager_path."");
    }

    public function profile()
    {
        $title = "Profilim";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/authentication/profile.php";
        require "view/backend/layout/footer.php";
    }

    public function datatable()
    {
        global $db;
        extract($_POST);
        $active_languages = fetchAll("languages[id,code,is_default]");
        $default_language = fetch("languages[id,code]",array("is_default"=>1));
        $active_session = fetch("user_sessions[user]",array("token" => isset($_COOKIE["manager"]) ? $_COOKIE["manager"] : null ,"ip_address" => $_SERVER["REMOTE_ADDR"], "status" => 1));
        $active_user = (isset($active_session->user)) ? fetch("users",array("id" => $active_session->user)) : null;
        require "view/backend/common/datatable.php";
    }

    public function ajax()
    {
        global $db;
        extract($_POST);
        $active_languages = fetchAll("languages[id,code,is_default]");
        $default_language = fetch("languages[id,code]",array("is_default"=>1));
        $active_session = fetch("user_sessions[user]",array("token" => isset($_COOKIE["manager"]) ? $_COOKIE["manager"] : null ,"ip_address" => $_SERVER["REMOTE_ADDR"], "status" => 1));
        $active_user = (isset($active_session->user)) ? fetch("users",array("id" => $active_session->user)) : null;
        require "view/backend/common/ajax.php";
    }

    public function categoryList($type)
    {
        $title = "Kategoriler";
        $allowed_types = ["page","service","product","blog"];
        if($type=="page"): $title = "Sayfa Kategorileri"; endif;
        if($type=="service"): $title = "Hizmet Kategorileri"; endif;
        if($type=="product"): $title = "Ürün Kategorileri"; endif;
        if($type=="blog"): $title = "Blog Kategorileri"; endif;
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        if(!in_array($type,$allowed_types)): header("Location: /".manager_path."/dashboard"); exit; endif;
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/category/list.php";
        require "view/backend/layout/footer.php";
    }

    public function categoryCreate($type)
    {
        $title = "Kategori Ekle";
        $allowed_types = ["page","service","product","blog"];
        if($type=="page"): $title = "Sayfa Kategori Ekle"; endif;
        if($type=="service"): $title = "Hizmet Kategori Ekle"; endif;
        if($type=="product"): $title = "Ürün Kategori Ekle"; endif;
        if($type=="blog"): $title = "Blog Kategori Ekle"; endif;
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        if(!in_array($type,$allowed_types)): header("Location: /".manager_path."/dashboard"); exit; endif;
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/category/new.php";
        require "view/backend/layout/footer.php";
    }

    public function categoryEdit($type,$id)
    {
        $title = "Kategori Düzenle";
        $allowed_types = ["page","service","product","blog"];
        if($type=="page"): $title = "Sayfa Kategori Düzenle"; endif;
        if($type=="service"): $title = "Hizmet Kategori Düzenle"; endif;
        if($type=="product"): $title = "Ürün Kategori Düzenle"; endif;
        if($type=="blog"): $title = "Blog Kategori Düzenle"; endif;
        $content = fetch("contents",array("id" => $id));
        if(!$content): header("Location: /".manager_path."/404"); endif;
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        if(!in_array($type,$allowed_types)): header("Location: /".manager_path."/dashboard"); exit; endif;
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/category/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function dashboard()
    {
        $title = "Gösterge Paneli";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Gösterge Paneli",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/dashboard.php";
        require "view/backend/layout/footer.php";
    }

    public function menuList()
    {
        $title = "Menü Yönetimi";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        if($authority != "*" && !in_array("Menü",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/menu.php";
        require "view/backend/layout/footer.php";
    }

    public function bulkSms()
    {
        $title = "Toplu SMS Gönderimi";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Toplu SMS",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/sms-bulk.php";
        require "view/backend/layout/footer.php";
    } 

    public function bulkEmail()
    {
        $title = "Toplu E-Posta Gönderimi";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Toplu E-Posta",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/email-bulk.php";
        require "view/backend/layout/footer.php";
    }

    public function backup()
    {
        $title = "Yedekleme";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Yedekleme",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        if(!function_exists('shell_exec')):
            echo "<div class='alert alert-danger'>shell_exec fonksiyonu çalışmıyor. Lütfen hosting firmanızla iletişime geçin.</div>";
            require "view/backend/layout/footer.php";
            return;
        endif;
        require "view/backend/common/backup.php";
        require "view/backend/layout/footer.php";
    }

    public function cronjob()
    {
        $title = "Cronjob";
        $cronJob = fetch("integrations",array("name" => "cronjob"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        
            ## Eğer cronjob yapılandırması yoksa
            if(isset($_GET["create"]) && $_GET["create"]=="cronJob"):
                if($cronJob==false):
                    create("integrations",array("name" => "cronjob","json" => json_encode(array("son_calisma_saati" => null))));
                    echo "<div class='alert alert-success'>Cronjob yapılandırması başarıyla oluşturuldu.</div>";
                    header("refresh:0;url=/".manager_path."/cronjob");
                endif;
                require "view/backend/layout/footer.php";
                return;
            endif;
    
            ## Cronjob integrations tablosunda var mı kontrolü
            if(!$cronJob):
                echo "<div class='alert alert-danger'>Cronjob yapılandırması veritabanında bulunamadı. <a href='?create=cronJob' class='text-danger'> Buraya tıklayarak</a> oluşturabilirsiniz.</div>";
                require "view/backend/layout/footer.php";
                return;
            endif;
    
            ## Cron
            $cronJob = json_decode($cronJob->json,true);
            $cronJob = (object) $cronJob;

            ## eğer shell_exec fonksiyonu çalışmıyorsa
            if(!function_exists('shell_exec')):
                echo "<div class='alert alert-danger gap-1 d-flex align-items-center'> <i class='la la-ban fs-4 me-2'></i> Yedekleme sistemi <strong> shell_exec </strong> fonksiyonu etkin olmadan çalışmaz. Lütfen hosting firmanızla iletişime geçin.</div>";
            endif;

            if($cronJob->son_calisma_saati==null):
                echo "<div class='alert alert-warning'>Cron job çalışmamış. Lütfen cron jobun çalıştığından emin olun.</div>";
                echo "<div class='alert alert-info'>wget -q -O /dev/null '<a href='".website."/cronjob' target='_blank' >".website."/cronjob</a>' >/dev/null 2>&1</div>";
                require "view/backend/layout/footer.php";
                return;
            else:
                $formattedDate = date("d.m.Y H:i",strtotime($cronJob->son_calisma_saati));
                if(strtotime($cronJob->son_calisma_saati) > strtotime("-120 second")):
                    echo "<div class='alert alert-success gap-1 d-flex align-items-center'> <i class='la la-clock fs-4 me-2'></i> Son cron job çalışması, <strong>{$formattedDate}</strong> saatlerinde gerçekleşti. </div>";
                else:
                    echo "<div class='alert alert-danger'>Cron job çalışmamış. Lütfen cron jobun çalıştığından emin olun.</div>";
                    echo "<div class='alert alert-info'>wget -q -O /dev/null '<a href='".website."/cronjob' target='_blank' >".website."/cronjob</a>' >/dev/null 2>&1</div>";
                endif;
            endif;

            $log_file = "../logs/cronjob.log";
            
            ## Log doyasını kontrol et yoksa veya boş ise
            if(!file_exists($log_file) || filesize($log_file)==0):
                $cronjobLogs = "Cronjob log dosyası bulunamadı.";
            endif;

            ## Logd dosyası varsa
            if(file_exists($log_file) && filesize($log_file)>0):
                $cronjobLogs = file_get_contents($log_file);
                $cronjobLogs = explode("\n",$cronjobLogs);
                $cronjobLogs = array_reverse($cronjobLogs);
                $cronjobLogs = implode("\n",$cronjobLogs);
            endif;

        require "view/backend/common/cronjob.php";
        require "view/backend/layout/footer.php";
    }

    public function cronProcess()
    {
        global $db;
        $cron = fetch("integrations[json]",array("name"=>"cronjob"));
        if($cron):
            $setting = json_decode($cron->json);
            $setting->son_calisma_saati = date("Y-m-d H:i:s");
            update("integrations",array("json"=>json_encode($setting)),array("name"=>"cronjob"),0);
        endif;
        require "app/cronjob.php";
    }

    public function users()
    {
        $title = "Kullanıcılar";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Kullanıcılar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/user/list.php";
        require "view/backend/layout/footer.php";
    }

    public function userPermissions()
    {
        $title = "Yetki Grupları";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        $perm_set = [
            "Gösterge Paneli",
            "Sayfalar",
            "Hizmetler",
            "Bloglar",
            "Ürünler",
            "Referanslar",
            "Bannerlar",
            "Menü",
            "Dil Seçenekleri",
            "Değişkenler",
            "Toplu E-Posta",
            "Toplu SMS",
            "Yedekleme",
            "Cronjob",
            "Kullanıcılar",
            "Yetki Grupları",
            "Notlar",
            "Genel Ayarlar",
            "İletişim Mesajları",
            "Log Kayıtları",
        ]; 
        if($authority != "*" && !in_array("Yetki Grupları",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/user/permissions.php";
        require "view/backend/layout/footer.php";
    }

    public function userNotes()
    {
        $title = "Notlar";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Notlar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        $events = []; 
        foreach(fetchAll("user_calendar",array("user"=>$user->id)) as $note):
            $events[] = [
                'id' => $note->id,
                'title' => $note->title,
                "description" => $note->description,
                'start' => $note->start,
                'end' => $note->end,
                'backgroundColor' => $note->color,
                'borderColor' => $note->color,
                "remember" => $note->remember,
                "reminder_time" => $note->reminder_time,
            ];
        endforeach;
        $events = json_encode($events);
        require "view/backend/user/notes.php";
        require "view/backend/layout/footer.php";
    }

    public function languages()
    {
        $title = "Dil Seçenekleri";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Dil Seçenekleri",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/language/list.php";
        require "view/backend/layout/footer.php";
    }

    public function languageVariables()
    {
        $title = "Dil Değişkenleri";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        if($authority != "*" && !in_array("Değişkenler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/language/variable_list.php";
        require "view/backend/layout/footer.php";
    }

    public function pageList()
    {
        $title = "Sayfalar";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Sayfalar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/page/list.php";
        require "view/backend/layout/footer.php";
    }

    public function pageCreate()
    {
        $title = "Sayfa Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Sayfalar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/page/new.php";
        require "view/backend/layout/footer.php";
    }

    public function pageEdit($id)
    {
        $title = "Sayfa Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/page/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Sayfalar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/page/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function referenceList()
    {
        $title = "Referanslar";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Referanslar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/reference/list.php";
        require "view/backend/layout/footer.php";
    }

    public function referenceCreate()
    {
        $title = "Referans Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Referanslar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/reference/new.php";
        require "view/backend/layout/footer.php";
    }

    public function referenceEdit($id)
    {
        $title = "Referans Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/reference/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Referanslar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/reference/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function serviceList()
    {
        $title = "Hizmetler";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Hizmetler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/service/list.php";
        require "view/backend/layout/footer.php";
    }

    public function serviceCreate()
    {
        $title = "Hizmet Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Hizmetler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/service/new.php";
        require "view/backend/layout/footer.php";
    }

    public function serviceEdit($id)
    {
        $title = "Hizmet Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/service/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Hizmetler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/service/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function blogList()
    {
        $title = "Blog";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bloglar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/blog/list.php";
        require "view/backend/layout/footer.php";
    }

    public function blogCreate()
    {
        $title = "Blog Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bloglar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/blog/new.php";
        require "view/backend/layout/footer.php";
    }

    public function blogEdit($id)
    {
        $title = "Blog Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/blog/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bloglar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/blog/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function productList()
    {
        $title = "Ürünler";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Ürünler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/product/list.php";
        require "view/backend/layout/footer.php";
    }

    public function productCreate()
    {
        $title = "Ürün Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Ürünler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/product/new.php";
        require "view/backend/layout/footer.php";
    }

    public function productEdit($id)
    {
        $title = "Ürün Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/product/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Ürünler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/product/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function productBulkCreate()
    {
        $title = "Toplu Ürün Oluştur";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Ürünler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/product/bulk.php";
        require "view/backend/layout/footer.php";
    }   

    public function bannerList()
    {
        $title = "Banner Yönetimi";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bannerlar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/banner/list.php";
        require "view/backend/layout/footer.php";
    }

    public function bannerCreate()
    {
        $title = "Banner Ekle";
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bannerlar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/banner/new.php";
        require "view/backend/layout/footer.php";
    }
    
    public function bannerEdit($id)
    {
        $title = "Banner Düzenle";
        $banner = fetch("banners",array("id"=>$id));
        if(!$banner){
           header("Location: /".manager_path."/banner/list");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Bannerlar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/banner/edit.php";
        require "view/backend/layout/footer.php";
    }

    public function settings()
    {
        global $db;
        $title = "Genel Ayarlar";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Genel Ayarlar",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/settings.php";
        require "view/backend/layout/footer.php";
    }

    public function help()
    {
        global $db;
        $title = "Yardım";

        $requirements = [
            'PHP Versiyon' => [
                'value' => phpversion(),
                'status' => version_compare(phpversion(), '7.2', '>=')
            ],
            'MySQL Versiyon' => [
                'value' => $db->getAttribute(PDO::ATTR_SERVER_VERSION),
                'status' => version_compare($db->getAttribute(PDO::ATTR_SERVER_VERSION), '5.7', '>=')
            ],
            'PHP Memory Limit' => [
                'value' => ini_get('memory_limit'),
                'status' => ($this->ini_get_bytes(ini_get('memory_limit')) >= 128 * 1024 * 1024 || $this->ini_get_bytes(ini_get('memory_limit')) == -1)
            ],
            'PHP Max Upload Size' => [
                'value' => ini_get('upload_max_filesize'),
                'status' => ($this->ini_get_bytes(ini_get('upload_max_filesize')) >= 32 * 1024 * 1024)
            ],
            'PHP Max Post Size' => [
                'value' => ini_get('post_max_size'),
                'status' => ($this->ini_get_bytes(ini_get('post_max_size')) >= 32 * 1024 * 1024)
            ],
            'PHP Max Execution Time' => [
                'value' => ini_get('max_execution_time'),
                'status' => (intval(ini_get('max_execution_time')) >= 1800 || ini_get('max_execution_time') == '-1')
            ],
            'PHP Fileinfo' => [
                'status' => extension_loaded('fileinfo')
            ],
            'PHP Zip' => [
                'status' => extension_loaded('zip')
            ],
            'PHP GD' => [
                'status' => extension_loaded('gd')
            ],
            'PHP Curl' => [
                'status' => extension_loaded('curl')
            ],
            'PHP OpenSSL' => [
                'status' => extension_loaded('openssl')
            ],
            'PHP PDO' => [
                'status' => extension_loaded('pdo')
            ],
            'PHP PDO MySQL' => [
                'status' => extension_loaded('pdo_mysql')
            ],
            'PHP SOAP' => [
                'status' => extension_loaded('soap')
            ],
            'PHP MBString' => [
                'status' => extension_loaded('mbstring')
            ],
                'PHP XML' => [
                    'status' => extension_loaded('xml')
                ],
                'Shell_Exec' => [
                    'status' => function_exists('shell_exec') && is_callable('shell_exec') && !in_array('shell_exec', explode(',', ini_get('disable_functions')))
                ]
            ];

        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/common/help.php";
        require "view/backend/layout/footer.php";
    }

    private function ini_get_bytes($val)
    {
        $val = trim($val);
        if ($val === '-1') {
            return -1; // sınırsız
        }

        $last = strtolower(substr($val, -1));
        $num = (int) $val;

        switch ($last) {
            case 'g':
                return $num * 1024 * 1024 * 1024;
            case 'm':
                return $num * 1024 * 1024;
            case 'k':
                return $num * 1024;
            default:
                return (int) $val;
        }
    }

    public function contentEditTheme($id)
    {
        $title = "İçerik Düzenle";
        $content = fetch("contents",array("id"=>$id));
        if(!$content){
           header("Location: /".manager_path."/404");
           exit;
        }
        $dil_secenekleri = fetchAll("languages[id,code]",array(),array("is_default"=>"desc","sort"=>"asc"));
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/content/design.php";
        require "view/backend/layout/footer.php";
    }

    public function contentModules()
    {
        $title = "Modüller";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/content/modules.php";
        require "view/backend/layout/footer.php";
    }

    public function uninstall()
    {
        $title = "Sistem Sıfırlama";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        require "view/backend/common/uninstall.php";
        require "view/backend/layout/footer.php";
    }

    public function feedback()
    {
        $title = "İletişim Mesajları";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("İletişim Mesajları",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/feedback.php";
        require "view/backend/layout/footer.php";
    }

    public function logs()
    {
        $title = "Log Kayıtları";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Log Kayıtları",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/common/logs.php";
        require "view/backend/layout/footer.php";
    }

    public function customerList()
    {
        $title = "Müşteriler";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Müşteriler",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/customer/list.php";
        require "view/backend/layout/footer.php";
    }

    public function appointmentList()
    {
        $title = "Randevular";
        require "view/backend/layout/main.php";
        require "view/backend/layout/header.php";
        if($authority != "*" && !in_array("Randevular",explode(",",$authority))): require "view/backend/layout/no-access.php"; return; endif;
        require "view/backend/appointment/list.php";
        require "view/backend/layout/footer.php";
    }


}