<form class="row gy-4 ajax-form" action="cron-ayarlari" style="user-select:none">
    <div class="col-sm-4">
        <div class="card mb-3">
            <div class="card-header">Otomatik Yedekleme</div>
            <div class="card-body">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="otomatik_sql_yedekleme" name="otomatik_sql_yedekleme">
                    <label class="form-check-label" for="otomatik_sql_yedekleme">Otomatik SQL Yedeklemeyi Aktif Et</label>
                </div>
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="sql_yedegini_eposta_gonder" name="sql_yedegini_eposta_gonder">
                    <label class="form-check-label" for="sql_yedegini_eposta_gonder">SQL Yedeğini E-Posta ile Gönder</label>
                </div>
                <div class="mb-3">
                    <label for="yedek_eposta_adresi" class="form-label">E-Posta Adresi</label>
                    <input type="email" class="form-control" id="yedek_eposta_adresi" name="yedek_eposta_adresi">
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label for="yedekleme_saati" class="form-label">Yedekleme Saati</label>
                            <input type="time" class="form-control" name="yedekleme_saati" id="yedekleme_saati">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label for="yedek_sayisi" class="form-label">Kaç yedek saklansın?</label>
                            <input type="number" class="form-control" name="yedek_sayisi" id="yedek_sayisi" min="1" max="100">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label for="yedekleme_gunu" class="form-label">Yedekleme Günü</label>
                            <select class="form-control" name="yedekleme_gunu" id="yedekleme_gunu">
                                <option value="0">Her Gün</option>
                                <option value="1">Pazartesi</option>
                                <option value="2">Salı</option>
                                <option value="3">Çarşamba</option>
                                <option value="4">Perşembe</option>
                                <option value="5">Cuma</option>
                                <option value="6">Cumartesi</option>
                                <option value="7">Pazar</option>
                            </select>
                        </div>
                    </div>
                </div>
                <small class="text-muted">Sistemde saklanacak maksimum yedek dosyası sayısı. Örneğin 7 girerseniz, sadece son 7 yedek tutulur ve en eski yedek otomatik silinir.</small>
            </div>
        </div>
        <div class="card mb-3">
            <div class="card-header">Otomatik Oturum Sonlandırma</div>
            <div class="card-body">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="otomatik_oturum_sonlandirma" name="otomatik_oturum_sonlandirma">
                    <label class="form-check-label" for="otomatik_oturum_sonlandirma">Otomatik Oturum Sonlandırmayı Aktif Et</label>
                </div>
                <div class="mb-3">
                    <div class="input-group">
                        <input type="number" class="form-control" name="otomatik_oturum_suresi" id="otomatik_oturum_suresi">
                        <div class="input-group-text">
                            <select name="otomatik_oturum_suresi_tipi" class="form-select">
                                <option value="minute">Dakika</option>
                                <option value="hour">Saat</option>
                                <option value="day">Gün</option>
                                <option value="week">Hafta</option>
                                <option value="month">Ay</option>
                                <option value="year">Yıl</option>
                            </select>
                        </div>
                    </div>
                    <div class="mt-2">
                        <small>
                            Oturumun otomatik olarak sonlandırılacağı süreyi ayarlayın. Örneğin, 30 dakika sonra oturum sonlandırılacaksa, "30" girin ve "Dakika" seçeneğini seçin.
                        </small>
                    </div>
                </div>
            </div>
        </div>
        <div class="card mb-3">
            <div class="card-header">Hatırlatma Bildirimleri</div>
            <div class="card-body">
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="hatirlatma" name="hatirlatma">
                    <label class="form-check-label" for="hatirlatma">Hatırlatma Mesajlarını Aktif Et</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="hatirlatma_sms" name="hatirlatma_sms">
                    <label class="form-check-label" for="hatirlatma_sms">SMS</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="hatirlatma_eposta" name="hatirlatma_eposta">
                    <label class="form-check-label" for="hatirlatma_eposta">E-Posta</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" id="hatirlatma_bildirim" name="hatirlatma_bildirim">
                    <label class="form-check-label" for="hatirlatma_bildirim">Bildirim</label>
                </div>
            </div>
        </div>
        <div class="card mt-3 mb-3">
            <div class="card-header">Güncelleme</div>
            <div class="card-body">
                <div class="text-end">
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                    <button type="button" class="btn btn-danger icon" table="cronjob_logs" where="../logs/cronjob.log" value="ok" data-delete>
                        <div>Logları Temizle</div>
                        <div><i class="las la-trash"></i></div>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-8 mb-3">
        <div class="card h-100">
            <div class="card-header">Log Kayıtları</div>
            <div class="card-body">
                <textarea class="form-control h-100" disabled style=" font-family: monospace; background: #000000; color: #00ff89; " ><?=$cronjobLogs?></textarea>
            </div>
        </div>
    </div>
</form>

<script>
    var cronJob = <?=json_encode($cronJob)?>;
    $(document).ready(function() {

        // Otomatik yedekleme ayarlarını doldur
        $('#otomatik_sql_yedekleme').prop('checked', cronJob.otomatik_sql_yedekleme == "on");
        $('#sql_yedegini_eposta_gonder').prop('checked', cronJob.sql_yedegini_eposta_gonder == "on");
        $('#yedek_eposta_adresi').val(cronJob.yedek_eposta_adresi);
        $('#yedekleme_saati').val(cronJob.yedekleme_saati);
        $('#yedek_sayisi').val(cronJob.yedek_sayisi);

        // Otomatik oturum sonlandırma ayarlarını doldur
        $('#otomatik_oturum_sonlandirma').prop('checked', cronJob.otomatik_oturum_sonlandirma == "on");
        $('#otomatik_oturum_suresi').val(cronJob.otomatik_oturum_suresi);

        // Hatırlatma ayarlarını doldur
        $('#hatirlatma').prop('checked', cronJob.hatirlatma == "on");
        $('#hatirlatma_sms').prop('checked', cronJob.hatirlatma_sms == "on");
        $('#hatirlatma_eposta').prop('checked', cronJob.hatirlatma_eposta == "on");
        $('#hatirlatma_bildirim').prop('checked', cronJob.hatirlatma_bildirim == "on");

        // Yedekleme günü ve otomatik oturum süresi tipi ayarlarını doldur
        $('#yedekleme_gunu').val(cronJob.yedekleme_gunu || '0');
        $('select[name="otomatik_oturum_suresi_tipi"]').val(cronJob.otomatik_oturum_suresi_tipi || 'hour');
        
    });
</script>