<?php

switch($action):

    case "contents":

        $data = array();
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        $whereClauses = [];
        $params = [];

        if(isset($_POST['theme']) && $_POST['theme'] != ""):
            if($_POST['theme'] == "default"):
                $whereClauses[] = "(contents.theme IS NULL OR contents.theme = '')";
            endif;
            if($_POST['theme'] == "custom"):
                $whereClauses[] = "contents.theme = 'custom'";
            endif;
            if($_POST['theme'] != "default" && $_POST['theme'] != "custom"):
                $whereClauses[] = "(contents.theme IS NOT NULL AND contents.theme != 'custom')";
            endif;
        endif;

        if(isset($_POST['status']) && $_POST['status'] != ""):$whereClauses[] = "contents.status = ".$_POST['status']; endif;
        if(isset($_POST['start_date']) && $_POST['start_date'] != ""): $whereClauses[] = "contents.created >= '".$_POST['start_date']."'"; endif;
        if(isset($_POST['end_date']) && $_POST['end_date'] != ""): $whereClauses[] = "contents.created <= '".$_POST['end_date']."'"; endif;

        if($search != ""):
            $whereClauses[] = "( 
                content_translations.name LIKE '%$search%' OR 
                contents.theme LIKE '%$search%' OR 
                contents.id LIKE '%$search%'
            )";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";
        $total = $db->query("SELECT COUNT(*) FROM contents INNER JOIN content_translations ON content_translations.content = contents.id $where AND contents.type = '{$type}'");
        $total = $total->fetchColumn();
        $query = $db->query("
            SELECT 
                contents.id,
                contents.parent,
                content_translations.name, 
                content_translations.url, 
                contents.theme, 
                contents.created, 
                contents.status
            FROM contents
                INNER JOIN content_translations ON content_translations.content = contents.id
            $where AND contents.type = '{$type}' $orderBy
            LIMIT $start, $length
        ");
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if(strpos($type, "category") !== false):
            foreach($rows as $key => $row):
                $parentNames = [];
                $currentContent = $row;

                while($currentContent['parent'] != null):
                    $parentQuery = $db->prepare("SELECT name FROM content_translations WHERE content_translations.content = :parent LIMIT 1");
                    $parentQuery->execute(['parent' => $currentContent['parent']]);
                    $parent = $parentQuery->fetch(PDO::FETCH_ASSOC);

                    if($parent):
                        array_unshift($parentNames, $parent['name']);
                    endif;

                    $currentContentQuery = $db->prepare("SELECT parent FROM contents WHERE id = :id");

                    $currentContentQuery->execute(['id' => $currentContent['parent']]);
                    $currentContent = $currentContentQuery->fetch(PDO::FETCH_ASSOC);
                endwhile;

                if(!empty($parentNames)):
                    $rows[$key]['name'] = implode(' > ', $parentNames) . ' > ' . $row['name'];
                endif;

            endforeach;
        endif;

        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);


    break;

    case "customers":

        $data = array();
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "customers.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "customers.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "(customers.first_name LIKE :search OR customers.last_name LIKE :search OR customers.phone LIKE :search OR customers.email LIKE :search)";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        $total = $db->prepare("SELECT COUNT(*) FROM customers $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        $query = $db->prepare("SELECT customers.id, customers.first_name, customers.last_name, customers.gender, customers.phone, customers.dob, customers.created FROM customers $where $orderBy LIMIT $start, $length");
        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "appointments":

        $data = array();
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "appointments.start_at >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "appointments.start_at <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "(customers.first_name LIKE :search OR customers.last_name LIKE :search OR customers.phone LIKE :search OR appointments.note LIKE :search)";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        $total = $db->prepare("SELECT COUNT(*) FROM appointments LEFT JOIN customers ON customers.id = appointments.customer $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        $query = $db->prepare("SELECT appointments.id, appointments.customer, CONCAT(COALESCE(customers.first_name,''),' ',COALESCE(customers.last_name,'')) AS customer_name, COALESCE(customers.phone,'') AS phone, appointments.start_at, appointments.end_at, appointments.status, appointments.note FROM appointments LEFT JOIN customers ON customers.id = appointments.customer $where $orderBy LIMIT $start, $length");
        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "languages":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['status']) && $_POST['status'] != ""):
            $whereClauses[] = "languages.status = :status";
            $params['status'] = $_POST['status'];
        endif;

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "languages.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "languages.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "languages.name LIKE :search OR languages.code LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM languages $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                languages.id,
                languages.name, 
                languages.code, 
                languages.status, 
                languages.created,
                languages.is_default
            FROM languages
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "language_variables":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "language_variables.code LIKE :search OR language_variables.translate LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(DISTINCT code) AS unique_code_count FROM language_variables $where" );
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                language_variables.id,
                language_variables.code, 
                language_variables.created
            FROM language_variables
            $where GROUP BY code
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "users":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        $whereClauses[] = "users.id != :user";
        $params['user'] = 1;

        if(isset($_POST['user_permissions']) && $_POST['user_permissions'] != ""):
            $whereClauses[] = "users.permission = :user_permissions";
            $params['user_permissions'] = $_POST['user_permissions'];
        endif;

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "users.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "users.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "users.name LIKE :search OR users.email LIKE :search OR users.username LIKE :search OR users.surname LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM users $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                users.id,
                users.name,
                users.surname,
                users.username, 
                users.email, 
                users.created,
                user_permissions.name AS permission_name
            FROM users
            INNER JOIN user_permissions ON user_permissions.id = users.permission
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "user_permissions":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        $whereClauses[] = "user_permissions.id != :permission";
        $params['permission'] = 1;

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "user_permissions.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "user_permissions.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "user_permissions.name LIKE :search OR user_permissions.authority LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM user_permissions $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                user_permissions.id,
                user_permissions.name,
                user_permissions.authority, 
                user_permissions.created
            FROM user_permissions
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "user_notifications":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if($search != ""):
            $whereClauses[] = "user_notifications.title LIKE :search OR user_notifications.description LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM user_notifications $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                user_notifications.id,
                user_notifications.title,
                user_notifications.description, 
                user_notifications.created,
                user_notifications.status
            FROM user_notifications
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "modules":
    
        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if($search != ""):
            $whereClauses[] = "name LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM content_modules $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                id,
                name,
                type,
                created
            FROM content_modules
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);
        
    break;

    case "banners":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "banners.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "banners.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "banners.name LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM banners $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                banners.id,
                banners.name,
                banners.created
            FROM banners
            $where
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);


    break;

    case "feedbacks":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "feedback.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "feedback.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            // json içinde arama yapılacak
            $whereClauses[] =  "feedback.json LIKE :search";
            $params['search'] = "%$search%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısı
        $total = $db->prepare("SELECT COUNT(*) FROM feedback $where");
        $total->execute($params);
        $total = $total->fetchColumn();


        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT * FROM feedback
            $where
            $orderBy
            LIMIT $start, $length 
        ");

        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);
        
        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "category_contents":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['theme']) && $_POST['theme'] != ""):
            $whereClauses[] = "contents.theme = :theme";
            $params['theme'] = $_POST['theme'];
        endif;

        if(isset($_POST['status']) && $_POST['status'] != ""):
            $whereClauses[] = "contents.status = :status";
            $params['status'] = $_POST['status'];
        endif;

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "contents.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "contents.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if($search != ""):
            $whereClauses[] = "content_translations.name LIKE :search";
            $params['search'] = "%$search%";
        else:
            if(isset($_POST['language']) && $_POST['language'] != ""):
                $whereClauses[] = "content_translations.language = :language";
                $params['language'] = $_POST['language'];
            endif;
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM contents LEFT JOIN content_translations ON content_translations.content = contents.id $where AND contents.type = :type");
        $total->execute(array_merge($params, ['type' => $type]));
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT 
                contents.id,
                contents.parent,
                content_translations.name, 
                contents.theme, 
                contents.created, 
                contents.sort, 
                contents.status
            FROM contents
            LEFT JOIN content_translations 
                ON content_translations.content = contents.id
            $where 
            AND contents.type = :type
            $orderBy
            LIMIT $start, $length
        ");

        $query->execute(array_merge($params, ['type' => $type]));
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        ## Eğer type içinde category varsa
        if(strpos($type, "category") !== false):
            foreach($rows as $key => $row):
                $parentNames = [];
                $currentContent = $row;

                while($currentContent['parent'] != null):
                    $parentQuery = $db->prepare("SELECT name FROM content_translations WHERE content_translations.content = :parent LIMIT 1");
                    $parentQuery->execute(['parent' => $currentContent['parent']]);
                    $parent = $parentQuery->fetch(PDO::FETCH_ASSOC);

                    if($parent):
                        array_unshift($parentNames, $parent['name']);
                    endif;

                    $currentContentQuery = $db->prepare("SELECT parent FROM contents WHERE id = :id");

                    $currentContentQuery->execute(['id' => $currentContent['parent']]);
                    $currentContent = $currentContentQuery->fetch(PDO::FETCH_ASSOC);
                endwhile;

                if(!empty($parentNames)):
                    $rows[$key]['name'] = implode(' > ', $parentNames) . ' > ' . $row['name'];
                endif;

            endforeach;
        endif;

        ## Sonuçları datatablela gönderiyoruz
        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

    case "logs":

        ## Boş data oluşturuyoruz
        $data = array();

        ## Sırasıyla sütunları tanımlıyoruz
        $orderColumnIndex = ($_POST['order'][0]['column'] ?? 0);
        $orderDir = ($_POST['order'][0]['dir'] ?? 'asc');
        $orderColumnName = ($_POST['columns'][$orderColumnIndex]['data'] ?? 'id');
        $orderBy = "ORDER BY $orderColumnName $orderDir";

        ## start ve length değerlerini alıyoruz
        $start = isset($_POST['start']) ? intval($_POST['start']) : 0;
        $length = isset($_POST['length']) ? intval($_POST['length']) : 10;

        ## Sıralama değerlerini alıyoruz
        $order = isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0;
        $dir = isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'], ['asc', 'desc']) ? $_POST['order'][0]['dir'] : 'asc';

        ## Arama değerlerini alıyoruz
        $search = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

        ## Genel sorguyu oluşturuyoruz
        $whereClauses = [];
        $params = [];

        if(isset($_POST['start_date']) && $_POST['start_date'] != ""):
            $whereClauses[] = "user_records.created >= :start_date";
            $params['start_date'] = $_POST['start_date'];
        endif;

        if(isset($_POST['end_date']) && $_POST['end_date'] != ""):
            $whereClauses[] = "user_records.created <= :end_date";
            $params['end_date'] = $_POST['end_date'];
        endif;

        if(isset($_POST['id']) && $_POST['id'] != ""):
            if(strpos($_POST['id'], ',') !== false):
                $ids = explode(',', $_POST['id']);
                $placeholders = [];
                foreach($ids as $k => $id) {
                    $placeholder = ":id" . $k;
                    $placeholders[] = $placeholder;
                    $params[$placeholder] = trim($id);
                }
                $whereClauses[] = "user_records.id IN (" . implode(',', $placeholders) . ")";
            else:
                $whereClauses[] = "user_records.id = :id";
                $params[':id'] = $_POST['id'];
            endif;
        endif;

        if(isset($_POST['user']) && $_POST['user'] != ""):
            $whereClauses[] = "user_records.user = :user";
            $params['user'] = $_POST['user'];
        endif;

        if(isset($_POST['table_name']) && $_POST['table_name'] != ""):
            $whereClauses[] = "user_records.table_name LIKE :table_name";
            $params['table_name'] = "%" . $_POST['table_name'] . "%";
        endif;

        if(isset($_POST['type']) && $_POST['type'] != ""):
            $whereClauses[] = "user_records.type LIKE :type";
            $params['type'] = "%" . $_POST['type'] . "%";
        endif;

        if(isset($_POST['ip_address']) && $_POST['ip_address'] != ""):
            $whereClauses[] = "user_records.ip_address LIKE :ip_address";
            $params['ip_address'] = "%" . $_POST['ip_address'] . "%";
        endif;

        if(isset($_POST['detail']) && $_POST['detail'] != ""):
            $whereClauses[] = "user_records.detail LIKE :detail";
            $params['detail'] = "%" . $_POST['detail'] . "%";
        endif;

        $where = count($whereClauses) > 0 ? "WHERE " . implode(" AND ", $whereClauses) : "";

        ## Toplam kayıt sayısını alıyoruz
        $total = $db->prepare("SELECT COUNT(*) FROM user_records $where");
        $total->execute($params);
        $total = $total->fetchColumn();

        ## Sorguyu oluşturuyoruz
        $query = $db->prepare("
            SELECT * FROM user_records
            $where
            $orderBy
            LIMIT $start, $length
        ");
        $query->execute($params);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            "draw" => intval($_POST['draw']),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        ]);

    break;

endswitch;