<form class="row gy-3 ajax-form" action="toplu-e-posta">
    <div class="col-sm-9">
        <div class="card">
            <div class="card-header"><?=$title?></div>
            <div class="card-body">
                <div class="row gy-3 align-items-center">

                    <div class="col-sm-2"><label id="to">Kime</label></div>
                    <div class="col-sm-10">
                        <textarea class="form-control" placeholder="example@company.com" name="to" id="to" rows="5"></textarea>
                    </div>
                    <div class="col-sm-2"><label id="subject" >Konu Başlığı</label></div>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="subject" id="subject" placeholder="Konu Başlığı" zorunlu>
                    </div>
                    <div class="col-sm-2"><label id="subject" >Dosyalar</label></div>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" name="files[]" id="files" multiple>
                    </div>
                    <div class="col-sm-2"></div>
                    <div class="col-sm-10">
                        <textarea class="tinymce-email" name="message" id="message" rows="10"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card mb-3">
            <div class="card-header">Gönder</div>
            <div class="card-body">
                <button class="btn btn-primary icon w-100">
                    <div><i class="las la-paper-plane"></i></div>
                    <div>Gönder</div>
                </button>    
            </div>
        </div>
        <div class="card">
            <div class="card-header">Grup Seçimi</div>
            <div class="card-body">
               <div class="gruplar" id="ajax_gruplar">
                     <!-- ajax -->
               </div>
                <div class="text-center mt-3">
                    <small class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#newGroup" >--- yeni oluştur ---</small>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- new group -->
<div class="modal fade" id="newGroup" tabindex="-1" aria-labelledby="newGroupLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="toplu-e-posta-grup-olustur">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="newGroupLabel">Yeni Grup Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Grup Adı</label>
                    <input type="text" class="form-control" name="name" id="name" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="emails" class="form-label">E-Posta Adresleri</label>
                    <textarea class="form-control" name="emails" id="emails" rows="5" zorunlu></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Oluştur</button>
            </div>
        </form>
    </div>
</div>

<!-- edit group -->
<div class="modal fade" id="editGroup" tabindex="-1" aria-labelledby="editGroupLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="toplu-e-posta-grup-guncelle">
            <input type="hidden" name="id">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="editGroupLabel">Grup Düzenle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Grup Adı</label>
                    <input type="text" class="form-control" name="name" id="name" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="emails" class="form-label">E-Posta Adresleri</label>
                    <textarea class="form-control" name="emails" id="emails" rows="5" zorunlu></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Güncelle</button>
            </div>
        </form>
    </div>
    <script>
        $('#editGroup').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var id = button.data('edit');
            $.ajax({
                url: "/baykus/ajax",
                type: "POST",
                data: {
                    action: "veri-oku",
                    type: "fetch",
                    table: "newsletters",
                    where: "id",
                    value: id
                },
                success: function(response){
                    let grup = JSON.parse(response);
                    $("#editGroup input[name='id']").val(grup.id);
                    $("#editGroup input[name='name']").val(grup.name);
                    $("#editGroup textarea[name='emails']").val(grup.emails.replace(/,/g, "\r\n")); 
                }
            });
        });
    </script>
</div>

<script>
    function newslettersAjaxGroups(){
        $.ajax({
            url: "/baykus/ajax",
            type: "POST",
            data: {
                action: "veri-oku",
                type: "fetchAll",
                table: "newsletters[id,name,count]",
                where: "emails[!]",
                value: "0",
                order: true,
                orderColumn: "count",
                orderType: "DESC"
            },
            success: function(response){
                let gruplar = JSON.parse(response);
                let html = "";
                gruplar.forEach(grup => {
                    html += `<div class="item">
                        <div class="checkbox"><input type="checkbox" id="${grup.id}" value="${grup.id}" name="group[]" ></div>
                        <div class="label"><label for="${grup.id}" value="${grup.id}">${grup.name} (${grup.count})</label></div>
                        <div class="edit"><i class="las la-edit" data-bs-toggle="modal" data-bs-target="#editGroup" data-edit="${grup.id}"></i></div>
                        <div class="delete" table="newsletters" where="id" value="${grup.id}" data-delete><i class="las la-trash"></i></div>
                    </div>`;
                });
                $("#ajax_gruplar").html(html);
            }
        });
    }
    newslettersAjaxGroups();
</script>

<script>
    $(document).ready(function() {

        tinymce.init({
            selector: '.tinymce-email',
            height: 400,
            menubar: false,
            language: 'tr',
            skin: isDarkTheme ? 'oxide-dark' : 'oxide',
            content_css: isDarkTheme ? 'dark' : '',
            entity_encoding : "raw",
            plugins: 'lists link image table code',
            toolbar: 'undo redo | h1 h2 h3 styleselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image code',
            images_upload_url: '/view/backend/assets/library/tinymce/upload.php',
            images_upload_base_path: '<?=website?>/',
            content_style: "img { width: 100%; height: auto; }",
            relative_urls: false,
            remove_script_host: false,
            convert_urls: true,
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save();
                    $("#content_html").val(editor.getContent());
                });
            },
        });

    });
</script>