<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
            </div>
            <div class="card-body">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>IP Address</th>
                            <th>Table Name</th>
                            <th>Type</th>
                            <th>Created</th>
                            <th>Prosess</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="id" class="form-label">ID</label>
                            <input type="text" name="id" id="id" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="user" class="form-label">User ID</label>
                            <input type="text" name="user" id="user" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="table_name" class="form-label">table_name</label>
                            <input type="text" name="table_name" id="table_name" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="type" class="form-label">type</label>
                            <input type="text" name="type" id="type" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="mb-3">
                            <label for="ip_address" class="form-label">ip_address</label>
                            <input type="text" name="ip_address" id="ip_address" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="mb-3">
                            <label for="detail" class="form-label">detail</label>
                            <input type="text" name="detail" id="detail" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                "id": $('#id').val(),
                "user": $('#user').val(),
                "table_name": $('#table_name').val(),
                "type": $('#type').val(),
                "ip_address": $('#ip_address').val(),
                "detail": $('#detail').val(),
                "start_date": $('#start_date').val(),
                "end_date": $('#end_date').val()
            };
        }
        $('select').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "logs",
                        "id": filters.id,
                        "user": filters.user,
                        "table_name": filters.table_name,
                        "type": filters.type,
                        "ip_address": filters.ip_address,
                        "detail": filters.detail,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date
                    });
                }
            },
            "order": [[0, "desc"]],
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "user" },
                { "data": "ip_address" },
                { "data": "table_name" },
                { "data": "type" },
                { "data": "created" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center",
                    "orderable": true,
                    "searchable": true,
                   
                },
                {
                    "targets": 1,
                    "className": "text-start",
                    "orderable": true,
                    "searchable": true,
                    "render": function(data, type, row) {
                        return `<span class="badge bg-primary">${data}</span>`;
                    }
                },
                {
                    "targets": 2,
                    "className": "text-start",
                },
                {
                    "targets": 3,
                    "className": "text-left",
                    "searchable": true
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "searchable": true
                },
                {
                    "targets": 5,
                    "className": "text-center",
                    "orderable": true,
                    "searchable": true,
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": -1,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        const detailStr = encodeURIComponent(JSON.stringify(row.detail));
                        return  `<button class="btn btn-sm btn-primary" onclick="viewLog('${detailStr}')"><i class="las la-eye"></i> Görüntüle</button>`;
                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>

<script>
    function viewLog(jsonStr) {
        var detail = JSON.parse(decodeURIComponent(jsonStr));
        swal.fire({
            title: 'Log Detayları',
            html: detail,
            showCloseButton: true,
            showConfirmButton: false,
            customClass: {
                popup: 'swal-wide'
            }
        });
    }
    $(document).on('keyup', '#id, #user, #table_name, #type, #ip_address, #detail, #start_date, #end_date', function() {
        $('#filter-button').click();
    });
</script>