<div class="card mb-3">
    <div class="card-header">Genel Ayarlar</div>
    <div class="card-body">
        <div class="row gx-4 gy-3">

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="logos" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-image"></i></div>
                    <div class="txt">
                        <strong>Logo Ayarları</strong>
                        <p>Web sitenizin logosunu hızlıca değiştirin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="contacts" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-phone"></i></div>
                    <div class="txt">
                        <strong>İletişim Bilgileri</strong>
                        <p>İletişim bilgilerinizi kolayca güncelleyin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="socials" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-share-alt"></i></div>
                    <div class="txt">
                        <strong>Sosyal Medya Bağlantıları</strong>
                        <p>Sosyal medya hesaplarınızı yönetin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="stores" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-map-marker"></i></div>
                    <div class="txt">
                        <strong>Mağazalar ve Şubeler</strong>
                        <p>Mağazalarınızı ekleyin ve yönetin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="banks" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-credit-card"></i></div>
                    <div class="txt">
                        <strong>Banka Hesapları</strong>
                        <p>Banka hesap bilgilerinizi kolayca yönetin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="dashboard" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-tachometer-alt"></i></div>
                    <div class="txt">
                        <strong>Gösterge Paneli Ayarları</strong>
                        <p>Gösterge paneli widget'larını düzenleyin.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">Entegrasyon Ayarları</div>
    <div class="card-body">
        <div class="row gx-4 gy-3">

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="smtp" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-envelope"></i></div>
                    <div class="txt">
                        <strong>SMTP Ayarları</strong>
                        <p>E-posta gönderimi için SMTP yapılandırmalarınızı düzenleyin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="sms" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-sms"></i></div>
                    <div class="txt">
                        <strong>SMS Ayarları</strong>
                        <p>SMS entegrasyon ayarlarınızı kolayca yapılandırın.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="payment" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-money-check-alt"></i></div>
                    <div class="txt">
                        <strong>Ödeme Entegrasyonu</strong>
                        <p>Ödeme sistemlerinizi bağlayın ve yönetin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="currency" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-dollar-sign"></i></div>
                    <div class="txt">
                        <strong>Kur Entegrasyonu</strong>
                        <p>Kur entegrasyon ayarlarınızı düzenleyin.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">Güvenlik Ayarları</div>
    <div class="card-body">
        <div class="row gx-4 gy-3">

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="manager_path" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-cogs"></i></div>
                    <div class="txt">
                        <strong>Panel Erişim Adresi</strong>
                        <p>Yönetim paneli erişim adresini özelleştirin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="captcha" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-shield-alt"></i></div>
                    <div class="txt">
                        <strong>Captcha Ayarları</strong>
                        <p>Web sitenizi bot saldırılarına karşı koruyun.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="ip_ban" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-lock"></i></div>
                    <div class="txt">
                        <strong>IP Engelleme</strong>
                        <p>İstenmeyen IP adreslerini engelleyin.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">Doğrulama Araçları</div>
    <div class="card-body">
        <div class="row gx-4 gy-3">

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="google_analytics" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-chart-line"></i></div>
                    <div class="txt">
                        <strong>Google Analytics</strong>
                        <p>Google Analytics izleme kodunuzu ekleyin</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="google_tag_manager" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-tag"></i></div>
                    <div class="txt">
                        <strong>Google Tag Manager</strong>
                        <p>Tag Manager kodlarınızı kolayca ekleyin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="head_body_footer" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-terminal"></i></div>
                    <div class="txt">
                        <strong>Head, Body ve Footer</strong>
                        <p>Web sitenize özel kodlar ekleyerek özelleştirin.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">Ek Ayarlar</div>
    <div class="card-body">
        <div class="row gx-4 gy-3">

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="css_js" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-file-code"></i></div>
                    <div class="txt">
                        <strong>Özel CSS ve JS</strong>
                        <p>Web sitenizin görünümünü ve davranışını özelleştirin.</p>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-4 col-md-6">
                <div data="maintenance" class="item-template-1 user-select-none cursor-pointer">
                    <div class="icon"><i class="la la-tools"></i></div>
                    <div class="txt">
                        <strong>Bakım Modu</strong>
                        <p>Web sitenizi bakım moduna alın.</p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<div class="modal fade" id="settings" tabindex="-1" aria-labelledby="modal_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form class="ajax-form modal-content" action="genel-ayarlar" >
            <input type="hidden" name="type">
            <input type="hidden" name="save" value="1" >
            <div class="modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
        <script>
            $(document).ready(function() {
                $('.item-template-1').click(function() {
                    var type = $(this).attr('data');
                    $.ajax({
                        type: 'POST',
                        url: "/baykus/ajax",
                        data: {action:"genel-ayarlar",type:type},
                        dataType: 'json',
                        success: function(data)
                        {
                            $('#settings').find('input[name="type"]').val(type);
                            $('#settings').find('.modal-body').html(data);
                            $('#settings').modal('show');
                        }
                    });
                });
                $('#settings').on('shown.bs.modal', function (e) {
                    $('[code]').each(function(i, block) {
                        var editor = CodeMirror.fromTextArea(block, {
                            mode: "htmlmixed",
                            lineNumbers: true,
                            search: true,
                            height: "200"
                        });
                    });
                    $('[css]').each(function(i, block) {
                        var editor = CodeMirror.fromTextArea(block, {
                            mode: "css",
                            height: "200",
                            lineNumbers: true,
                        });
                    });
                    $('[js]').each(function(i, block) {
                        var editor = CodeMirror.fromTextArea(block, {
                            mode: "javascript",
                            height: "200",
                            lineNumbers: true,
                        });
                    });
                    $('[json]').each(function(i, block) {
                        var editor = CodeMirror.fromTextArea(block, {
                            mode: "application/json",
                            height: "200",
                            lineNumbers: true,
                        });
                    });
                });
            });
        </script>
    </div>
</div>