<form class="row gy-3 ajax-form" action="toplu-sms">
    <div class="col-sm-9">
        <div class="card">
            <div class="card-header"><?=$title?></div>
            <div class="card-body">
                <div class="row gy-3 align-items-center">
                    <div class="col-sm-2"><label id="to">Kime</label></div>
                    <div class="col-sm-10">
                        <textarea class="form-control" placeholder="+90 532 307 19 99<?="\r"?>+90 532 000 00 00" name="to" id="to" rows="5"></textarea>
                    </div>
                    <div class="col-sm-2"><label id="message" >Mesajınız</label></div>
                    <div class="col-sm-10">
                        <textarea class="form-control" name="message" id="message" rows="5" zorunlu></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card mb-3">
            <div class="card-header">Gönder</div>
            <div class="card-body">
                <button class="btn btn-primary icon w-100">
                    <div><i class="las la-paper-plane"></i></div>
                    <div>Gönder</div>
                </button>    
            </div>
        </div>
        <div class="card">
            <div class="card-header">Grup Seçimi</div>
            <div class="card-body">
               <div class="gruplar" id="ajax_gruplar">
                     <!-- ajax -->
               </div>
                <div class="text-center mt-3">
                    <small class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#newGroup" >--- yeni oluştur ---</small>
                </div>
            </div>
        </div>
        <div class="card mt-3">
            <div class="card-header">Güncelle</div>
            <div class="card-body">
                <button id="btnCronUpdate" class="btn btn-warning w-100" type="button">Güncelle</button>
            </div>
        </div>
    </div>
</form>

<!-- new group -->
<div class="modal fade" id="newGroup" tabindex="-1" aria-labelledby="newGroupLabel" aria-hidden="true">
    <div class="modal-dialog">

<script>
    // Run cronjob via GET and reload page when the Güncelle button is clicked
    $(document).ready(function(){
        $(document).on('click', '#btnCronUpdate', function(e){
            e.preventDefault();
            var btn = $(this);
            btn.prop('disabled', true).addClass('loading');
            $.get('/cronjob')
            .done(function(){
                // successful - reload
                location.reload();
            })
            .fail(function(){
                btn.prop('disabled', false).removeClass('loading');
                Swal.fire({
                    icon: 'error',
                    title: 'Hata',
                    html: 'Güncelleme çalıştırılamadı. Lütfen tekrar deneyin.',
                    showConfirmButton: false,
                    timerProgressBar: true,
                    timer: 3000,
                });
            });
        });
    });
</script>
        <form class="ajax-form modal-content" action="toplu-sms-grup-olustur">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="newGroupLabel">Yeni Grup Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Grup Adı</label>
                    <input type="text" class="form-control" name="name" id="name" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="emails" class="form-label">Telefon Numaraları</label>
                    <textarea class="form-control" name="phones" id="phones" rows="5" zorunlu></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Oluştur</button>
            </div>
        </form>
    </div>
</div>

<!-- edit group -->
<div class="modal fade" id="editGroup" tabindex="-1" aria-labelledby="editGroupLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="toplu-sms-grup-guncelle">
            <input type="hidden" name="id">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="editGroupLabel">Grup Düzenle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Grup Adı</label>
                    <input type="text" class="form-control" name="name" id="name" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="emails" class="form-label">Telefon Numaraları</label>
                    <textarea class="form-control" name="phones" id="phones" rows="5" zorunlu></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Güncelle</button>
            </div>
        </form>
    </div>
    <script>
        $('#editGroup').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var id = button.data('edit');
            $.ajax({
                url: "/baykus/ajax",
                type: "POST",
                data: {
                    action: "veri-oku",
                    type: "fetch",
                    table: "newsletters",
                    where: "id",
                    value: id
                },
                success: function(response){
                    let grup = JSON.parse(response);
                    $("#editGroup input[name='id']").val(grup.id);
                    $("#editGroup input[name='name']").val(grup.name);
                    $("#editGroup textarea[name='phones']").val(grup.phones.replace(/,/g, "\r\n")); 
                }
            });
        });
    </script>
</div>

<script>
    function newslettersAjaxGroups(){
        $.ajax({
            url: "/baykus/ajax",
            type: "POST",
            data: {
                action: "veri-oku",
                type: "fetchAll",
                table: "newsletters[id,name,count]",
                where: "phones[!]",
                value: "0",
                order: true,
                orderColumn: "count",
                orderType: "DESC"
            },
            success: function(response){
                let gruplar = JSON.parse(response);
                let html = "";
                gruplar.forEach(grup => {
                    html += `<div class="item">
                        <div class="checkbox"><input type="checkbox" id="${grup.id}" value="${grup.id}" name="group[]" ></div>
                        <div class="label"><label for="${grup.id}" value="${grup.id}">${grup.name} (${grup.count})</label></div>
                        <div class="edit"><i class="las la-edit" data-bs-toggle="modal" data-bs-target="#editGroup" data-edit="${grup.id}"></i></div>
                        <div class="delete" table="newsletters" where="id" value="${grup.id}" data-delete><i class="las la-trash"></i></div>
                    </div>`;
                });
                $("#ajax_gruplar").html(html);
            }
        });
    }
    newslettersAjaxGroups();
</script>
