<button class="btn btn-sm btn-light icon mb-3" onclick="window.history.back()">
    <div><i class="las la-arrow-left"></i></div>
    <div>Geri Dön</div>
</button>

<button class="btn btn-sm btn-primary icon mb-3" onclick="add_container(<?=$id?>)" >
    <div class="las la-plus"></div>
    <div>Kapsayıcı</div>
</button>

<button class="btn btn-sm btn-warning icon mb-3" onclick="window.location.href='<?='/'.manager_path.'/content/modules'?>'">
    <div><i class="las la-cube"></i></div>
    <div>Modüller</div>
</button>

<div id="containers" >
    <?php foreach(fetchAll("content_layouts",array("content"=> $id),array("sort"=>"ASC","created"=>"ASC")) as $container): ?>
        <div class="card mb-3" id="content_layouts_<?=$container->id?>">
            <div class="card-header">
                <div class="left"><?=$container->class?></div>
                <div class="actions">
                    <button class="btn btn-sm btn-light icon square" onclick="add_update_module_layout(<?=$container->id?>)"><i class="las la-plus"></i></button>
                    <button class="btn btn-sm btn-light icon square" onclick="update_layout(<?=$container->id?>)"><i class="las la-edit"></i></button>
                    <button class="btn btn-sm btn-light icon square" table="content_layouts" where="id" value="<?=$container->id?>" data-delete><i class="las la-trash"></i></button>
                    <button class="btn btn-sm btn-light icon square container_move"><i class="las la-arrows-alt"></i></button>
                </div>
            </div>
            <div class="card-body">
                <div class="row gy-4 container_items" id="<?=$container->id?>" >
                    <?php if($container->json): ?>
                    <?php foreach(json_decode($container->json) as $key => $jsonItem): $module = fetch("content_modules[id,name]",array("id"=>$jsonItem->module)); ?>
                        <div class="<?=$jsonItem->class?>">
                            <div class="card" id="card-<?=$container->id?>-<?=$key?>">
                            <div class="card-header">
                                    <div class="left"><small><?=$jsonItem->class?></small></div>
                                    <div class="actions">
                                        <button class="btn btn-sm btn-light icon square" onclick="add_update_module_layout(<?=$container->id?>,<?=$key?>)">
                                            <i class="las la-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-light icon square" onclick="deleteModule(<?=$container->id?>,<?=$key?>)">
                                            <i class="las la-trash"></i>
                                        </button>
                                        <button class="btn btn-sm btn-light icon square move">
                                            <i class="las la-arrows-alt"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="module-name"><?=$module->name?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12">
                            <div class="alert alert-warning mb-0">Bu alana modül ekleyebilirsiniz.</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach ?>
</div>

<!-- kapsayıcı sürükleme -->
<script>
    new Sortable(document.getElementById('containers'), {
        animation: 150,
        handle: '.container_move',
        onEnd: function (evt) {
            var ids = [];
            var items = document.querySelectorAll('#containers .card');
            items.forEach(function(item) {
                var containerId = item.id.split('_')[2]; 
                ids.push(containerId);
            });
            $.ajax({
                type: 'POST',
                url: '/baykus/ajax',
                data: {
                    action: "veri-sira-guncelle",
                    table: 'content_layouts',
                    where: "id",
                    value: ids,
                }
            })
        }
    });
</script>

<!-- kapsayıcı düzeneleme -->
<div class="modal fade" id="content_layout_update" tabindex="-1" role="dialog" aria-labelledby="content_layout_update_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <form class="ajax-form modal-content" action="kapsayici-duzenle" >
            <div class="modal-header">
                <h5 class="modal-title" id="content_layout_update_label">Kapsayıcı Düzenle</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-bs-dismiss="modal"> 
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="class" class="form-label">Class Name</label>
                    <input type="text" class="form-control" name="class" id="class" required>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" id="id">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
    <script>
        function update_layout(id){
            $.ajax({
                type: "post",
                url: "/baykus/ajax",
                data: {
                    action: 'veri-oku',
                    table: 'content_layouts[id,class]',
                    where: 'id',
                    type: 'fetch',
                    value: id
                },
                dataType: "json",
                success: function(response){
                    $('#content_layout_update').modal('show');
                    $('#id').val(response.id);
                    $('#class').val(response.class);
                }
            })
        }
    </script>
</div>

<!-- kapsayıcı modül ekleme ve düzenleme -->
<div class="modal fade" id="content_layout_module" tabindex="-1" role="dialog" aria-labelledby="content_layout_module_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <form class="ajax-form modal-content" action="kapsayiciya-modul-olustur" >
            <div class="modal-header">
                <h5 class="modal-title" id="content_layout_module_label">Modül Ekle</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-bs-dismiss="modal"> 
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="class" class="form-label d-block">Class</label>
                    <input type="text" class="form-control" name="data[class][]" value="col-12" required>
                </div>
                <div class="mb-3">
                    <label for="class" class="form-label">Modül</label>
                    <select class="form-control" name="data[module][]"  required>
                        <option value="">Seçiniz</option>
                        <?php foreach(fetchAll("content_modules[id,name]") as $module): ?>
                            <option value="<?=$module->id?>"><?=$module->name?></option>
                        <?php endforeach ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" >
                <input type="hidden" name="key">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
    <script>
        function add_update_module_layout(id,key)
        {
            // eğer key gelmiyorsa
            if(key == undefined){
                $('#content_layout_module').modal('show');
                $('#content_layout_module form').attr('action','kapsayici-modul-olustur');
                $('#content_layout_module form').find('input[name=id]').val(id);
            }else{
                $.ajax({
                    type: "post",
                    url: "/baykus/ajax",
                    data: {
                        action: 'kapsayici-modul-oku',
                        content: id,
                        key: key,
                    },
                    dataType: "json",
                    success: function(response){
                        $('#content_layout_module form').attr('action','kapsayici-modul-guncelle');
                        $('#content_layout_module form').find('input[name=id]').val(id);
                        $('#content_layout_module form select[name="data[module][]"]').val(response.module);
                        $('#content_layout_module form input[name="data[class][]"]').val(response.class);
                        $('#content_layout_module form input[name=key]').val(key);
                        $('#content_layout_module').modal('show');
                    }
                })
            }
        }
    </script>
</div>

<!-- kapsayici modül silme -->
<script>
    function deleteModule(containerId, key) {
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu işlemi geri alamazsınız!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, Hemen!',
            cancelButtonText: 'Hayır, Vazgeç!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: "post",
                    url: "/baykus/ajax",
                    data: {
                        action: 'kapsayici-modul-sil',
                        content: containerId,
                        key: key,
                    },
                    success: function(response) {
                        $('#card-' + containerId + '-' + key).parent().remove();
                    }
                });
            }
        })
    }
</script>

<!-- kapsayıcı modül sıralama -->
<script>
    $(document).ready(function () {
        $('.container_items').each(function () {
            const kapsayici = this;
            new Sortable(kapsayici, {
                animation: 150,
                ghostClass: 'ghostClass',
                handle: '.move',
                onEnd(evt) {
                    const order = Array.from(evt.to.querySelectorAll('.card')).map(el => ({
                        id: el.id.split('-')[2]
                    }));
                    $.post('/baykus/ajax', {
                        action: "kapsayici-modul-sira-guncelle",
                        content: evt.to.id,
                        value: order,
                    })
                    .done(function (response) {
                        window.location.reload();
                    })
                }
            });
        });
    });
</script>