<div class="row gy-4">
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Modül Oluştur</div>
            <form action="modul-olustur" class="card-body ajax-form">
                <div class="mb-3">
                    <label for="name" class="form-label">Modül Adı</label>
                    <input type="text" class="form-control" name="name" required>
                </div>
                <div class="mb-3">
                    <label for="type" class="form-label">Modül Türü</label>
                    <select id="type" class="form-control" name="type" required>
                        <option value=""></option>
                        <option value="services">---> Services</option>
                        <option value="blogs">---> Blogs</option>
                        <option value="products">---> Products</option>
                        <option value="banner">---> Banners</option>
                        <option value="categories">---> Categories</option>
                        <option value="html">---> HTML</option>
                        <option value="breadcrumb">---> Breadcrumb</option>
                        <option value="newsletter">---> Newsletter</option>
                    </select>
                </div>
                <div class="text-end mt-3">
                    <button type="submit" class="btn btn-primary icon"><i class="las la-save"></i> Oluştur</button>
                </div>
            </form>
        </div>
    </div>
    <div class="col-sm-9">
        <div class="card">
            <div class="card-header"><?=$title?></div>
            <div class="card-body">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Adı</th>
                        <th>Türü</th>
                        <th>Oluşturulma</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>

            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": { action: "modules" }
            },
            "order": [[0, "desc"]],
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                {"data": "id"},
                {"data": "name"},
                {"data": "type"},
                {"data": "created"},
                {"data": "id"}
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center"
                },
                {
                    "targets": 1,
                    "className": "text-start"
                },
                {
                    "targets": 2,
                    "className": "text-start",
                },
                {
                    "targets": 3,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": 4,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="editModule(${data})">
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="content_modules" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;

                    }
                }
            ]
        });
    });
</script>

<script>
    function editModule(id)
    {
        modal =  `
            <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <form class="ajax-form modal-content" action="modul-guncelle" >
                        <input type="hidden" name="id" value="${id}">
                        <input type="hidden" name="save" value="1">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="exampleModalLabel"></h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                            <button type="submit" class="btn btn-primary">Kaydet</button>
                        </div>
                    </form>
                </div>
            </div>
        `;
        $('body').append(modal);
        $('#exampleModal').modal('show');
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: { action: 'modul-guncelle', id: id },
            dataType: 'json',
            success: function(response) {
                $('#exampleModalLabel').text('Modül Düzenle');
                $('.modal-body').html(response);
            }
        });
        $('#exampleModal').on('hidden.bs.modal', function (e) {
            $(this).remove();
        });
        $('#exampleModal').on('shown.bs.modal', function (e) {
            $('[code]').each(function(i, block) {
                var editor = CodeMirror.fromTextArea(block, {
                    mode: "htmlmixed",
                    lineNumbers: true,
                    height: "200"
                });
            });
        });
    }
</script>