<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="contents" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Oluştur</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <td><div class="cb"><input class="check-all" type="checkbox"></div></td>
                            <th><i class="las la-id-badge"></i> ID</th>
                            <th><i class="las la-user"></i> Ad</th>
                            <th><i class="las la-id-card"></i> Soyad</th>
                            <th class="text-center"><i class="las la-venus-mars"></i> Cinsiyet</th>
                            <th class="text-center"><i class="las la-phone"></i> Telefon</th>
                            <th class="text-center"><i class="las la-birthday-cake"></i> Doğum Tarihi</th>
                            <th class="text-end"><i class="las la-cog"></i> İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="theme" class="form-label">Randevusu Yaklaşanlar</label>
                    <select name="theme" class="form-select" id="theme">
                        <option value=""></option>
                        <option value="1">Son 7 Gün</option>
                        <option value="2">Son 15 Gün</option>
                        <option value="3">Son 30 Gün</option>
                    </select>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                theme: $('#theme').val()
            };
        }

        $('input,select').change(function() {
            $('#filter-button').click();
        });

        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "customers",
                        "theme": filters.theme,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "id" },
                { "data": "first_name" },
                { "data": "last_name" },
                { "data": "gender" },
                { "data": "phone" },
                { "data": "dob" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "orderable": false,
                    "searchable": false,
                    "className": "text-center",
                    "render": function(data) {
                       return `<div class="cb"><input class="check-item" type="checkbox" value="${data}"></div>`;
                    }
                },
                {
                    "targets": 1,
                    "className": "text-center",
                    "render": function(data) {
                        return data;
                    }
                },
                {
                    "targets": 2,
                    "className": "text-left"
                },
                {
                    "targets": 3,
                    "className": "text-left"
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "render": function(data) {
                       
                        // F = Kadın, M = Erkek, O = Diğer
                        if (data === 'F') return '<span class="badge bg-pink">Kadın</span>';
                        if (data === 'O') return '<span class="badge bg-secondary">Diğer</span>';
                        if (data === 'M') return '<span class="badge bg-primary">Erkek</span>';

                    }
                },
                {
                    "targets": 5,
                    "className": "text-center"
                },
                {
                    "targets": 6,
                    "className": "text-center",
                    "render": function(data) {
                        if (!data) return '';
                        return `<span title="${data}">${data.slice(0,10)}</span>`;
                    }
                },
                {
                    "targets": 7,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="update(${data})" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="customers" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;

                    }
                }
            ]
        });

        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });

    function update(id)
    {
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                action: "veri-oku",
                type: "fetch",
                table: "customers",
                where: "id",
                value: id
            },
            success: function(response) {
                var data = JSON.parse(response);
                $('#edit-modal #id').val(data.id);
                $('#edit-modal #first_name').val(data.first_name || data.name || '');
                $('#edit-modal #last_name').val(data.last_name || '');
                $('#edit-modal #gender').val(data.gender || '');
                $('#edit-modal #phone').val(data.phone || '');
                $('#edit-modal #dob').val(data.dob || '');
                $('#edit-modal #status').val(typeof data.status !== 'undefined' ? data.status : 1);
                $('#edit-modal').modal('show');
            }
        })
    }
</script>

<style>
    .bg-pink {
        background-color: #e83e8c;
        color: white;
    }
</style>

<!-- create modal -->
<div class="modal fade" id="create-modal" tabindex="-1" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="musteri-olustur" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="createModalLabel">Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="first_name" class="form-label">Ad</label>
                    <input type="text" name="first_name" id="first_name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="last_name" class="form-label">Soyad</label>
                    <input type="text" name="last_name" id="last_name" class="form-control">
                </div>
                <div class="mb-3">
                    <label for="gender" class="form-label">Cinsiyet</label>
                    <select name="gender" id="gender" class="form-control">
                        <option value="">Seçiniz</option>
                        <option value="M">Erkek</option>
                        <option value="F">Kadın</option>
                        <option value="O">Diğer</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon</label>
                    <input type="text" name="phone" id="phone" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="dob" class="form-label">Doğum Tarihi</label>
                    <input type="date" name="dob" id="dob" class="form-control">
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Durumu</label>
                    <select name="status" id="status" class="form-control" >
                        <option value="1">Aktif</option>
                        <option value="0">Pasif</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- edit modal -->
<div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="musteri-guncelle" >
            <input type="hidden" name="id" id="id">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="editModalLabel">Düzenle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="first_name" class="form-label">Ad</label>
                    <input type="text" name="first_name" id="first_name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="last_name" class="form-label">Soyad</label>
                    <input type="text" name="last_name" id="last_name" class="form-control">
                </div>
                <div class="mb-3">
                    <label for="gender" class="form-label">Cinsiyet</label>
                    <select name="gender" id="gender" class="form-control">
                        <option value="">Seçiniz</option>
                        <option value="M">Erkek</option>
                        <option value="F">Kadın</option>
                        <option value="O">Diğer</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon</label>
                    <input type="text" name="phone" id="phone" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="dob" class="form-label">Doğum Tarihi</label>
                    <input type="date" name="dob" id="dob" class="form-control">
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Durumu</label>
                    <select name="status" id="status" class="form-control" >
                        <option value="1">Aktif</option>
                        <option value="0">Pasif</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>