<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="contents" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Oluştur</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Adı</th>
                            <th>Kodu</th>
                            <th>Durumu</th>
                            <td>Oluşturulma</td>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="mb-3">
                            <label for="status" class="form-label">Durumu</label>
                            <select name="status" id="status" class="form-control">
                                <option value="">Tümü</option>
                                <option value="1">Aktif</option>
                                <option value="0">Pasif</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                status: $('#status').val()
            };
        }
        $('input,select').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "languages",
                        "theme": filters.theme,
                        "status": filters.status,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date,
                        "language": filters.language
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "name" },
                { "data": "code" },
                { "data": "status" },
                { "data": "created" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "orderable": false,
                    "searchable": false,
                    "className": "text-center",
                    "render": function(data) {
                       return data;
                    }
                },
                {
                    "targets": 1,
                    "className": "text-center"
                },
                {
                    "targets": 2,
                    "className": "text-left"
                },
                {
                    "targets": 3,
                    "className": "text-center",
                    "render": function(data, type, row) {
                        let badge = data == 1 
                            ? `<span class="badge bg-success">Aktif</span>` 
                            : `<span class="badge bg-danger">Pasif</span>`;

                        if (row.is_default == 1) {
                            badge += ` <span class="badge bg-primary">Default</span>`;
                        }

                        return badge;
                    }
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": 5,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="update(${data})" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="languages" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                        

                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>

<!-- create modal -->
<div class="modal fade" id="create-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="dil-olustur" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="code" class="form-label">Kodu</label>
                    <input type="text" name="code" id="code" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="phone_code" class="form-label">Telefon Alan Kodu</label>
                    <input type="text" name="phone_code" id="phone_code" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Durumu</label>
                    <select name="status" id="status" class="form-control" >
                        <option value="1">Aktif</option>
                        <option value="0">Pasif</option>
                    </select>
                </div>
                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="is_default" name="is_default">
                    <label class="form-check-label" for="is_default">Varsayılan Dil</label>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- edit modal -->
<div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="dil-guncelle" >
            <input type="hidden" name="id" id="id">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Düzenle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="code" class="form-label">Kodu</label>
                    <input type="text" name="code" id="code" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="phone_code" class="form-label">Telefon Alan Kodu</label>
                    <input type="text" name="phone_code" id="phone_code" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Durumu</label>
                    <select name="status" id="status" class="form-control" >
                        <option value="1">Aktif</option>
                        <option value="0">Pasif</option>
                    </select>
                </div>
                <div class="mb-3 form-check">
                    <input type="checkbox" class="form-check-input" id="is_default_edit" name="is_default">
                    <label class="form-check-label" for="is_default_edit">Varsayılan Dil</label>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
    <script>
        function update(id)
        {
            $.ajax({
                url: '/baykus/ajax',
                type: 'POST',
                data: {
                    action: "veri-oku",
                    type: "fetch",
                    table: "languages",
                    where: "id",
                    value: id
                },
                success: function(response) {
                    var data = JSON.parse(response);
                    $('#edit-modal #id').val(data.id);
                    $('#edit-modal #name').val(data.name);
                    $('#edit-modal #code').val(data.code);
                    $('#edit-modal #phone_code').val(data.phone_code);
                    $('#edit-modal #status').val(data.status);
                    $('#edit-modal #is_default_edit').prop('checked',data.is_default == 1);
                    $('#edit-modal').modal('show');
                }
            })
        }
    </script>
</div>