<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="contents" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Oluştur</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Anahtar</th>
                            <td>Oluşturulma</td>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
            };
        }
        // input change
        $('#start_date, #end_date').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "language_variables",
                        "theme": filters.theme,
                        "status": filters.status,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date,
                        "language": filters.language
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "code" },
                { "data": "created" },
                { "data": "id" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center"
                },
                {
                    "targets": 1,
                    "className": "text-center"
                },
                {
                    "targets": 2,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": 3,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data,type,row) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="update('${row.code}')" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="language_variables" where="code" value="${row.code}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>

<!-- create modal -->
<div class="modal fade" id="create-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="degisken-olustur" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="code" class="form-label">Anahtar</label>
                    <input type="text" name="code" id="code" class="form-control" zorunlu>
                </div>
                <?php foreach($dil_secenekleri as $dil): ?>
                <div class="mb-3">
                    <label for="translate_<?=$dil->id?>" class="form-label">[<?=$dil->code?>] Çeviri</label>
                    <textarea rows="5" name="translate_<?=$dil->id?>" id="translate_<?=$dil->id?>" class="form-control" ></textarea>
                </div>
                <?php endforeach ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- update modal -->
<div class="modal fade" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="degisken-guncelle" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Güncelle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="code" class="form-label">Anahtar</label>
                    <input type="text" name="code_c" id="code_c" class="form-control" disabled >
                    <input type="text" name="code" id="code" class="form-control" hidden>
                </div>
                <?php foreach($dil_secenekleri as $dil): ?>
                <div class="mb-3">
                    <label for="translate_<?=$dil->id?>" class="form-label">[<?=$dil->code?>] Çeviri</label>
                    <textarea rows="5" name="translate_<?=$dil->id?>" id="translate_<?=$dil->id?>" class="form-control"></textarea>
                </div>
                <?php endforeach ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
        <script>
            function update(code) {
                $.ajax({
                    url: '/baykus/ajax',
                    type: 'POST',
                    data: {
                        action: 'veri-oku',
                        type: "fetchAll",
                        table: "language_variables[id,code,translate,language]",
                        where: "code",
                        value: code
                    },
                    dataType: 'json',
                    success: function(response){
                        $('#update-modal input').val('');
                        $('#update-modal textarea').val('');
                        $('#update-modal input[name="code"]').val(response[0].code);
                        $('#update-modal input[name="code_c"]').val(response[0].code);
                        response.forEach(function(item) {
                            $('#update-modal textarea[name="translate_'+item.language+'"]').val(item.translate);
                        });
                        $('#update-modal').modal('show');
                    }
                });
            }
        </script>
    </div>
</div>