<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Sayfa Bulunamadı</title>
    <link rel="stylesheet" href="/view/backend/assets/css/baykus.css">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #1266a1;
            margin: 0;
        }
        .error-container {
            background: rgba(255,255,255,0.95);
            border-radius: 18px;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.37);
            padding: 48px 32px 40px 32px;
            text-align: center;
            max-width: 420px;
            width: 100%;
        }
        .error-code {
            font-size: 7rem;
            font-weight: 900;
            color: #257ebd;
            letter-spacing: 2px;
            margin-bottom: 0.5rem;
        }
        .error-title {
            font-size: 2.2rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 1rem;
        }
        .error-desc {
            font-size: 1.1rem;
            color: #555;
            margin-bottom: 2rem;
        }
        .error-actions a {
            display: inline-block;
            background: #257ebd;
            color: #fff;
            padding: 12px 32px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
        }
        .error-actions a:hover {
            background: #1266a1;
        }
        @media (max-width: 600px) {
            .error-container { padding: 32px 8px; }
            .error-code { font-size: 4rem; }
        }
        .power-by {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 0.9rem;
            color: #fff;
        }
        .power-by a {
            color: #fff;
            text-decoration: underline;
        }
        .power-by a:hover {
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-code">404</div>
        <div class="error-title">Sayfa Bulunamadı</div>
        <div class="error-desc">Sayfa silinmiş, taşınmış veya hiç var olmamış olabilir.</div>
        <div class="error-actions">
            <a href="/">Ana Sayfa'ya Dön</a>
        </div>
        
    </div>
    <div class="power-by">
        <p>Powered by <a href="https://baykus.pro" target="_blank" >Baykuş</a></p>
    </div>
</body>
</html>