<?php

## Öncelikle token kontrolü yapalım
$session = fetch("user_sessions",array("token" => isset($_COOKIE["manager"]) ? $_COOKIE["manager"] : null ,"ip_address" => $_SERVER["REMOTE_ADDR"], "status" => 1));

## Eğer token yanlış ise
if(!$session):
    header("Location: /".manager_path."/logout");
    exit;
endif;

## Eğer token doğru ise
$user = fetch("users",array("id" => $session->user));

## Eğer kullanıcı yok ise
if(!$user):
    echo "Bu kullanıcıya ait bilgiler bulunamadı.";
    echo "<a href='/".manager_path."/logout'>Çıkış Yap</a>";
    exit;
endif;

## Eğer kullanıcı var ise
$permission = fetch("user_permissions",array("id" => $user->permission));
$authority = $permission->authority;

## Eğer yetki yok ise
if(!$permission):
    echo "Bu kullanıcıya ait yetki bulunamadı.";
    echo "<a href='/".manager_path."/logout'>Çıkış Yap</a>";
    exit;
endif;

## Son online zamanı güncelleyelim
update("users",array("online" => date("Y-m-d H:i:s")),array("id" => $user->id),0);

## Kullanıcı resmi
$apiAvatans = "https://ui-avatars.com/api/?background=212529&color=ffffff&name=";
$apiAvatans .= $user->name." ".$user->surname;
if(!$user->image):
    $user->image = $apiAvatans;
else:
    $user->image = website.$user->image;
endif;

$currency = fetch("integrations", array("name" => "currency"));
if ($currency):
   $currency = json_decode($currency->json);
   // Virgül yerine nokta kullanarak dönüştürme işlemi
   $USD = isset($currency->USD) ? (float) str_replace(",", ".", $currency->USD) : 0.00;
   $EUR = isset($currency->EUR) ? (float) str_replace(",", ".", $currency->EUR) : 0.00;
   $XAU = isset($currency->XAU) ? (float) str_replace(",", ".", $currency->XAU) : 0.00;
else:
   $USD = 0.00;
   $EUR = 0.00;
   $XAU = 0.00;
endif;

$USD = number_format($USD, 2);
$EUR = number_format($EUR, 2);
$XAU = number_format($XAU, 2);

ipBanControl();