<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="contents" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Oluştur</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Adı Soyadı</th>
                            <td>Kullanıcı Adı</td>
                            <td>Yetki Grubu</td>
                            <td>Oluşturma</td>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label for="user_permissions" class="form-label">Yetki Grubu</label>
                            <select name="user_permissions" id="user_permissions" class="form-control">
                                <option value="">--- seç ---</option>
                                <?php foreach(fetchAll("user_permissions[id,name]",array("id[!]"=>1)) as $yetki): ?>
                                    <option value="<?=$yetki->id?>"><?=$yetki->name?></option>
                                <?php endforeach ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
                user_permissions: $('#user_permissions').val(),
            };
        }
        $('#start_date , #end_date').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "users",
                        "theme": filters.theme,
                        "status": filters.status,
                        "start_date": filters.start_date,
                        "end_date": filters.end_date,
                        "user_permissions": filters.user_permissions,
                        "language": filters.language
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "name" },
                { "data": "username" },
                { "data": "permission_name" },
                { "data": "created" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center"
                },
                {
                    "targets": 1,
                    "className": "text-start",
                    "render": function(data,type,row) {
                        return `${row.name} ${row.surname}`;
                    }
                },
                {
                    "targets": 2,
                    "className": "text-start"
                },
                {
                    "targets": 3,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span class="badge bg-primary">${data}</span>`;
                    }
                },
                {
                    "targets": 4,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets": 5,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="update(${data})" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="users" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>

<!-- create modal -->
<div class="modal fade" id="create-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="kullanici-olustur" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="surname" class="form-label">Soyadı</label>
                    <input type="text" name="surname" id="surname" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">E-Posta Adresi</label>
                    <input type="text" name="email" id="email" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon Numarası</label>
                    <input type="text" name="phone" id="phone" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="username" class="form-label">Kullanıcı Adı</label>
                    <input type="text" name="username" id="username" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Parolası</label>
                    <input type="text" name="password" id="password" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="username" class="form-label">Yetki Grubu</label>
                    <select name="permission" class="form-control" required>
                        <option value="" >--- seç ---</option>
                        <?php foreach(fetchAll("user_permissions[id,name]",array("id[!]"=>1)) as $yetki): ?>
                            <option value="<?=$yetki->id?>"><?=$yetki->name?></option>
                        <?php endforeach ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Çoklu Oturum Açabilirmi ?</label>
                    <select name="multiple" class="form-control" required>
                        <option value="0">Hayır</option>
                        <option value="1">Evet</option>
                    </select>
                    <small class="text-muted d-block mt-2">
                        Birden fazla cihazdan oturum açabilsin istiyorsanız "Evet" seçeneğini seçiniz.
                    </small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- update modal -->
<div class="modal fade" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content" action="kullanici-guncelle" >
            <input type="hidden" name="id" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Güncelle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="surname" class="form-label">Soyadı</label>
                    <input type="text" name="surname" id="surname" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">E-Posta Adresi</label>
                    <input type="text" name="email" id="email" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon Numarası</label>
                    <input type="text" name="phone" id="phone" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="username" class="form-label">Kullanıcı Adı</label>
                    <input type="text" name="username" id="username" class="form-control" zorunlu>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Parolası</label>
                    <input type="text" name="password" id="password" class="form-control">
                    <small>Parola değişikliği yapmak istemiyorsanız boş bırakabilirsiniz.</small>
                </div>
                <div class="mb-3">
                    <label for="username" class="form-label">Yetki Grubu</label>
                    <select name="permission" class="form-control" required>
                        <option value="" >--- seç ---</option>
                        <?php foreach(fetchAll("user_permissions[id,name]",array("id[!]"=>1)) as $yetki): ?>
                            <option value="<?=$yetki->id?>"><?=$yetki->name?></option>
                        <?php endforeach ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Çoklu Oturum Açabilirmi ?</label>
                    <select name="multiple" class="form-control" required>
                        <option value="0">Hayır</option>
                        <option value="1">Evet</option>
                    </select>
                    <small class="text-muted d-block mt-2">
                        Birden fazla cihazdan oturum açabilsin istiyorsanız "Evet" seçeneğini seçiniz.
                    </small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
        <script>
            function update(id) {
                $.ajax({
                    url: '/baykus/ajax',
                    type: 'POST',
                    data: {
                        action: 'veri-oku',
                        type: "fetch",
                        table: "users",
                        where: "id",
                        value: id
                    },
                    dataType: 'json',
                    success: function(data){
                        $('#update-modal input[name="password"]').val('');
                        $('#update-modal input[name="id"]').val(data.id);
                        $('#update-modal input[name="name"]').val(data.name);
                        $('#update-modal input[name="surname"]').val(data.surname);
                        $('#update-modal input[name="email"]').val(data.email);
                        $('#update-modal input[name="phone"]').val(data.phone);
                        $('#update-modal input[name="username"]').val(data.username);
                        $('#update-modal select[name="permission"]').val(data.permission);
                        $('#update-modal select[name="multiple"]').val(data.multiple);
                        $('#update-modal').modal('show');
                    }
                });
            }
        </script>
    </div>
</div>