<div id="calendar">
    <script>
        let calendar;
        let events = <?=$events?>;
        $(document).ready(function () {
            const calendarEl = document.getElementById('calendar');
            calendar = new FullCalendar.Calendar(calendarEl, {
                height: 780,
                initialView: 'dayGridMonth',
                editable: true,
                selectable: true,
                longPressDelay: 1,
                locale: 'tr',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,listMonth'
                },
                buttonText: {
                    today: 'Bugün',
                    month: 'Takvim',
                    week: 'Hafta',
                    day: 'Gün',
                    list: 'Liste'
                },
                events: events,
                select: function (info) {
                    console.log('select')
                    const currentMoment = moment();
                    const startDate = moment(info.startStr);
                    const endDate = moment(info.endStr);
                    const start = startDate.format('YYYY-MM-DD') + 'T' + currentMoment.format('HH:mm');
                    const end = endDate.subtract(1, 'seconds').format('YYYY-MM-DDTHH:mm');
                    $('#exampleModalLabel').text('Not Oluştur');
                    $('#button-text').text('Oluştur');
                    $('#button-text').parent().attr('onclick', 'create()');
                    $('#name').val('');
                    $('#name').focus();
                    $('#description').val('');
                    $('#edit-color-danger').prop('checked', true);
                    $('#remember').val(0);
                    $('#reminder').val('');
                    $('#reminder-div').hide(0);
                    $('#start').val(start);
                    $('#end').val(end);
                    $("[data-delete]").hide(0);
                    $('#calendarModal').modal('show');
                },
                eventClick: function (info) {
                    console.log('eventClick')
                    const id = info.event.id;
                    const title = info.event.title;
                    const description = info.event.extendedProps.description;
                    const color = info.event.backgroundColor;
                    const start = moment(info.event.startStr).format('YYYY-MM-DDTHH:mm');
                    const end = moment(info.event.endStr).format('YYYY-MM-DDTHH:mm');
                    const remember = info.event.extendedProps.remember;
                    const reminder = info.event.extendedProps.reminder_time;
                    $('#exampleModalLabel').text('Not Düzenle');
                    $('#button-text').text('Kaydet');
                    $('#button-text').parent().attr('onclick', 'update(' + id + ')');
                    $('#name').val(title);
                    $('#description').val(description);
                    if (color == 'var(--bs-danger)') {
                        $('#edit-color-danger').prop('checked', true);
                    } else if (color == 'var(--bs-success)') {
                        $('#edit-color-success').prop('checked', true);
                    } else if (color == 'var(--bs-primary)') {
                        $('#edit-color-primary').prop('checked', true);
                    }
                    $('#remember').val(remember);
                    if (remember == 1) {
                        $('#reminder').val(reminder);
                        $('#reminder-div').show(0);
                    } else {
                        $('#reminder').val('');
                        $('#reminder-div').hide(0);
                    }
                    $('#start').val(start);
                    $('#end').val(end);
                    $('[data-delete]').show(0);
                    $('[data-delete]').attr('value', id);
                    $('#calendarModal').modal('show');
                },
                eventDrop: function (info) {
                    const id = info.event.id;
                    const title = info.event.title;
                    const description = info.event.extendedProps.description;
                    const color = info.event.backgroundColor;
                    const start = moment(info.event.startStr).format('YYYY-MM-DD HH:mm:ss');
                    const end = moment(info.event.endStr).format('YYYY-MM-DD HH:mm:ss');
                    const remember = info.event.extendedProps.remember;
                    const reminder = info.event.extendedProps.reminder_time;
                    $.ajax({
                        url: '/baykus/ajax',
                        type: 'POST',
                        data: {
                            id: id,
                            title: title,
                            description: description,
                            color: color,
                            start: start,
                            end: end,
                            remember: remember,
                            reminder_time: reminder,
                            action: 'takvim-not-guncelle'
                        }
                    });
                },
            });
            calendar.render();
        });
    </script>
</div>

<!-- Modal İçeriği -->
<div class="modal fade" id="calendarModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel"></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="color" class="form-label">Renk</label>
                    <div class="color-options">
                        <label class="color-option" for="edit-color-danger">
                            <input type="radio" name="color" id="edit-color-danger" value="var(--bs-danger)">
                            <span class="color-circle" style="background-color: var(--bs-danger);"></span>
                        </label>
                        <label class="color-option" for="edit-color-success">
                            <input type="radio" name="color" id="edit-color-success" value="var(--bs-success)">
                            <span class="color-circle" style="background-color: var(--bs-success);"></span>
                        </label>
                        <label class="color-option" for="edit-color-primary">
                            <input type="radio" name="color" id="edit-color-primary" value="var(--bs-primary)">
                            <span class="color-circle" style="background-color: var(--bs-primary);"></span>
                        </label>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="name" class="form-label">Başlık</label>
                    <input type="text" class="form-control" id="name" name="name" required>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Açıklama</label>
                    <textarea class="form-control" id="description" name="description" required></textarea>
                </div>
                <div class="mb-3">
                    <label for="remember" class="form-label">Hatırlatılsın mı?</label>
                    <select class="form-control" id="remember" name="remember" required>
                        <option value="0">Hayır</option>
                        <option value="1">Evet</option>
                    </select>
                </div>
                <div class="mb-3" style="display:none" id="reminder-div">
                    <label for="reminder" class="form-label">Hatırlatma Saati</label>
                    <input type="time" class="form-control" id="reminder" name="reminder">
                </div>
                <div class="row gy-3">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start" class="form-label">Başlangıç Tarihi</label>
                            <input type="datetime-local" class="form-control" id="start" name="start" required>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end" class="form-label">Bitiş Tarihi</label>
                            <input type="datetime-local" class="form-control" id="end" name="end" required>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="la la-close"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="button" class="btn btn-danger icon" table="user_calendar" where="id" value="" data-delete style="display:none">
                    <div><i class="la la-trash"></i></div>
                    <div>Sil</div>
                </button>
                <button type="button" class="btn btn-primary icon">
                    <div><i class="la la-check"></i></div>
                    <div id="button-text"></div>
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    $('#remember').change(function () {
        if ($(this).val() == 1) {
            $('#reminder-div').show(0);
            var currentMoment = moment();
            var reminder = currentMoment.format('HH:mm');
            $('#reminder').val(reminder);
        } else {
            $('#reminder').val('');
            $('#reminder-div').hide(0);
        }
    });
    $('#name').keyup(function () {
        if ($(this).val() == '') {
            $(this).addClass("is-invalid");
        } else {
            $(this).removeClass("is-invalid");
        }
    });
</script>

<script>
    function create()
    {
        var title = $('#name').val();
        var description = $('#description').val();
        var color = $('input[name="color"]:checked').val();
        var start = $('#start').val();
        var end = $('#end').val();
        var remember = $('#remember').val();
        var reminder = $('#reminder').val();
        if (title == '') {
            $('#name').addClass("is-invalid");
            $('#name').focus();
            return;
        }
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                title: title,
                description: description,
                color: color,
                start: start,
                end: end,
                remember: remember,
                reminder_time: reminder,
                action: 'takvim-not-olustur'
            },
            success: function (response) {
                $('#calendarModal').modal('hide');
                calendar.addEvent({
                    id: response,
                    title: title,
                    description: description,
                    start: start,
                    end: end,
                    color: color,
                    extendedProps: {
                        remember: remember,
                        reminder_time: reminder
                    }
                });
                calendar.refetchEvents();
            }
        });
    }

    function update(id)
    {
        var title = $('#name').val();
        var description = $('#description').val();
        var color = $('input[name="color"]:checked').val();
        var start = $('#start').val();
        var end = $('#end').val();
        var remember = $('#remember').val();
        var reminder = $('#reminder').val();
        if (title == '') {
            $('#name').addClass("is-invalid");
            $('#name').focus();
            return;
        }
        $.ajax({
            url: '/baykus/ajax',
            type: 'POST',
            data: {
                id: id,
                title: title,
                description: description,
                color: color,
                start: start,
                end: end,
                remember: remember,
                reminder_time: reminder,
                action: 'takvim-not-guncelle'
            },
            success: function () {
                $('#calendarModal').modal('hide');
                var event = calendar.getEventById(id);
                event.setProp('title', title);
                event.setExtendedProp('description', description);
                event.setProp('backgroundColor', color);
                event.setProp('borderColor', color);
                event.setStart(start);
                event.setEnd(end);
                event.setExtendedProp('remember', remember);
                event.setExtendedProp('reminder_time', reminder);
                calendar.refetchEvents();
            }
        });
    }
</script>
