<div class="row gy-4">
    <div class="col-sm-9">
        <div class="card ">
            <div class="card-header">
                <div class="left">
                    <?=$title?>
                </div>
                <div class="actions">
                    <button class="btn btn-sm btn-danger icon selected-item-showcase" table="contents" where="id" data-delete-multiple>
                        <div><i class="las la-trash"></i></div>
                        <div> (<span class="total-selected-items">0</span>) Seçilenleri Sil</div>
                    </button>
                    <button class="btn btn-sm btn-light icon" data-bs-toggle="modal" data-bs-target="#create-modal">
                        <div><i class="las la-plus"></i></div>
                        <div>Yeni Oluştur</div>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <input type="hidden" id="checked-inputs" multiple-ids>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <td>Grup Adı</td>
                            <td>Oluşturma</td>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-3">
        <div class="card">
            <div class="card-header">Filtrele</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="start_date" class="form-label">Başlangıç Tarihi</label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label for="end_date" class="form-label">Bitiş Tarihi</label>
                            <input type="date" name="end_date" id="end_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="mb-3 mt-3 text-end">
                    <button class="btn btn-warning" id="filter-button" ><i class="las la-filter"></i> Filtrele</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        function getFilterParams() {
            return {
                start_date: $('#start_date').val(),
                end_date: $('#end_date').val(),
            };
        }
        $('#start_date, #end_date').change(function() {
            $('#filter-button').click();
        });
        var table = $('table').DataTable({
            "processing": true,
            "serverSide": true,
            "responsive": true,
            "drawCallback": onTablePaginate,
            "ajax": {
                "url": "/baykus/datatable",
                "type": "POST",
                "data": function(d) {
                    var filters = getFilterParams();
                    return Object.assign(d, {
                        "action": "user_permissions",
                        "start_date": filters.start_date,
                        "end_date": filters.end_date,
                    });
                }
            },
            "order": false,
            "language": {
                "url": "/view/backend/assets/library/datatable/datatable-tr.json"
            },
            "columns": [
                { "data": "id" },
                { "data": "name" },
                { "data": "created" },
                { "data": "id" }
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "className": "text-center"
                },
                {
                    "targets": 1,
                    "className": "text-center"
                },
                {
                    "targets": 2,
                    "className": "text-center",
                    "render": function(data) {
                        return `<span title="${timeAgo(data)} oluşturuldu.">${data.slice(0, -3)}</span>`;
                    }
                },
                {
                    "targets":3,
                    "className": "text-end",
                    "orderable": false,
                    "searchable": false,
                    "render": function(data) {
                        return `
                            <button class="btn btn-sm btn-primary icon" onclick="update(${data})" >
                                <div><i class="las la-edit"></i></div>
                                <div>Düzenle</div>
                            </button>
                            <button class="btn btn-sm btn-danger icon" table="user_permissions" where="id" value="${data}" data-delete>
                                <div><i class="las la-trash"></i></div>
                                <div>Sil</div>
                            </button>
                        `;
                    }
                }
            ]
        });
        $('#filter-button').click(function() {
            table.ajax.reload();
        });
    });
</script>

<!-- create modal -->
<div class="modal fade" id="create-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content user-select-none" action="yetki-grubu-olustur" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Oluştur</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="row gy-3">
                    <div class="col-12 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" name="tumunuSec[]" id="tumunuSec">
                            <label class="form-check-label" for="tumunuSec" >Tümünü Seç</label>
                        </div>
                    </div>
                    <?php foreach($perm_set as $key => $perm): ?>
                        <div class="col-sm-4">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" name="authority[]" value="<?=$perm?>" id="<?=$key?>">
                                <label class="form-check-label" for="<?=$key?>"><?=$perm?></label>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
        <script>
        $(document).ready(function () {
            $('#create-modal #tumunuSec').change(function () {
                let isChecked = $(this).prop('checked');
                $('#create-modal input[name="authority[]"]').prop('checked', isChecked);
            });
            $('#create-modal input[name="authority[]"]').change(function () {
                let allChecked = $('#create-modal input[name="authority[]"]:checked').length === $('#create-modal input[name="authority[]"]').length;
                $('#create-modal #tumunuSec').prop('checked', allChecked);
            });
        });
    </script>
    </div>
</div>

<!-- update modal -->
<div class="modal fade" id="update-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="ajax-form modal-content user-select-none" action="yetki-grubu-guncelle" >
            <input type="hidden" name="id" >
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Güncelle</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="name" class="form-label">Adı</label>
                    <input type="text" name="name" id="name" class="form-control" zorunlu>
                </div>
                <div class="row gy-3">
                    <div class="col-12 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" role="switch" name="tumunuSec[]" id="tumunuSec-2">
                            <label class="form-check-label" for="tumunuSec-2" >Tümünü Seç</label>
                        </div>
                    </div>
                    <?php foreach($perm_set as $key => $perm): ?>
                        <div class="col-sm-4">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" name="authority[]" value="<?=$perm?>" id="<?=$key?>-2">
                                <label class="form-check-label" for="<?=$key?>-2"><?=$perm?></label>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary icon" data-bs-dismiss="modal">
                    <div><i class="las la-times"></i></div>
                    <div>Kapat</div>
                </button>
                <button type="submit" class="btn btn-primary icon">
                    <div><i class="las la-save"></i></div>
                    <div>Kaydet</div>
                </button>
            </div>
        </form>
        <script>
            function update(id) {
                $.ajax({
                    url: '/baykus/ajax',
                    type: 'POST',
                    data: {
                        action: 'veri-oku',
                        type: "fetch",
                        table: "user_permissions",
                        where: "id",
                        value: id
                    },
                    dataType: 'json',
                    success: function(data){
                        $('#update-modal input[name="authority[]"]').prop('checked', false);
                        $('#update-modal input[name="id"]').val(data.id);
                        $('#update-modal input[name="name"]').val(data.name);
                        var authority = data.authority.split(',');
                        authority.forEach(function(perm) {
                            $('#update-modal input[name="authority[]"][value="'+perm+'"]').prop('checked', true);
                        });
                        $('#update-modal').modal('show');
                    }
                });
            }
            $(document).ready(function () {
                $('#update-modal #tumunuSec-2').change(function () {
                    let isChecked = $(this).prop('checked');
                    $('#update-modal input[name="authority[]"]').prop('checked', isChecked);
                });
                $('#update-modal input[name="authority[]"]').change(function () {
                    let allChecked = $('#update-modal input[name="authority[]"]:checked').length === $('#update-modal input[name="authority[]"]').length;
                    $('#update-modal #tumunuSec-2').prop('checked', allChecked);
                });
            });
            $('#update-modal').on('show.bs.modal', function (e) {
                $('#update-modal input[name="authority[]"]').change();
            });
        </script>
    </div>
</div>