<?php

switch($action):

    case "dil-degistir":

        $control = fetch("content_translations[url]",array("content" => $content , "language" => $language));
        if($control):
            echo json_encode(array(
                "status" => "success",
                "location" => $control->url,
                "timer" => 1200
            ));
        else:
            $language = fetch("languages[id,code]",array("id" => $language));
            if($language->id == $default_language->id): $location = "/"; else: $location = "/".$language->code; endif;
            echo json_encode(array(
                "status" => "success",
                "location" => $location,
                "timer" => 1200
            ));
        endif;

    break;

    case "e-bulten":

        ## önce emil değeri geliyormu kontrol et
        if(!isset($email) || empty($email)):
            echo json_encode(array(
                "status" => "error",
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız",
                "description" => "Lütfen e-posta adresinizi giriniz.",
                "timer" => 3000,
                "confirmButtonText" => "Tamam, Teşekkürler"
            ));
            exit;
        endif;

        ## e-posta adresi kontrolü
        if(!filter_var($email, FILTER_VALIDATE_EMAIL)):
            echo json_encode(array(
                "status" => "error",
                "sweetAlert" => true,
                "icon" => "error",
                "title" => "İşlem Başarısız",
                "description" => "Lütfen geçerli bir e-posta adresi giriniz.",
                "timer" => 3000,
                "confirmButtonText" => "Tamam, Teşekkürler"
            ));
            exit;
        endif;

        ## E-bülten kayıt kontrolü
        $control = fetch("newsletters[id]",array("name" =>"E-Bülten"));

        ## Eğer kayıt yoksa
        if(!$control):
            if(create("newsletters",array("name" => "E-Bülten","emails" => $email,"count" => 1))):
                echo json_encode(array(
                    "status" => "success",
                    "sweetAlert" => true,
                    "icon" => "success",
                    "title" => "İşlem Başarılı",
                    "description" => "E-posta adresiniz başarıyla kaydedildi.",
                    "timer" => 3000,
                    "confirmButtonText" => "Tamam, Teşekkürler"
                ));
            endif;    
        endif;

        ## Eğer kayıt varsa
        if($control):
            $control = fetch("newsletters",array("name" =>"E-Bülten"));
            $emailArray = (!empty($control->emails)) ? explode(",",$control->emails) : array();
            if(in_array($email,$emailArray)):
                echo json_encode(array(
                    "status" => "error",
                    "sweetAlert" => true,
                    "icon" => "error",
                    "title" => "İşlem Başarısız",
                    "description" => "E-posta adresiniz zaten kayıtlı.",
                    "timer" => 3000,
                    "confirmButtonText" => "Tamam, Teşekkürler"
                ));
            else:
                $emailArray[] = $email;
                $count = count($emailArray);
                $emailArray = implode(",",$emailArray);
                $emailArray = trim($emailArray,",");
                if(update("newsletters",array("emails" => $emailArray,"count" => $count),array("id" => $control->id))):
                    echo json_encode(array(
                        "status" => "success",
                        "sweetAlert" => true,
                        "icon" => "success",
                        "title" => "İşlem Başarılı",
                        "description" => "E-posta adresiniz başarıyla kaydedildi.",
                        "timer" => 3000,
                        "confirmButtonText" => "Tamam, Teşekkürler"
                    ));
                endif;
            endif;
        endif;
       
    break;

    case "iletisim-formu":

        if ($captcha = fetch("integrations[json]", ["name" => "captcha"])):
            $captcha = json_decode($captcha->json, true);
            if (isset($captcha['status'])):
                if(isset($_POST['g-recaptcha-response'])):
                    $captcha_response = $_POST['g-recaptcha-response'];
                    $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$captcha['secret_key']."&response=".$captcha_response);
                    $response = json_decode($response);
                    if(!$response->success):
                        echo json_encode(array(
                            "status" => "error",
                            "sweetAlert" => true,
                            "icon" => "error",
                            "title" => "İşlem Başarısız",
                            "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                            "timer" => 3000,
                            "confirmButtonText" => "Tamam, Teşekkürler"
                        ));
                        return;
                    endif;
                else:
                    echo json_encode(array(
                        "status" => "error",
                        "sweetAlert" => true,
                        "icon" => "error",
                        "title" => "İşlem Başarısız",
                        "description" => "Lütfen reCAPTCHA doğrulamasını yapınız.",
                        "timer" => 3000,
                        "confirmButtonText" => "Tamam, Teşekkürler"
                    ));
                    return;
                endif;
            endif;
        endif;

        $create = create("feedback",array(
            "json" => json_encode($data),
            "status" => 0,
        ));

        if($create):
            echo json_encode(array(
                "status" => "success",
                "sweetAlert" => true,
                "icon" => "success",
                "title" => "İşlem Başarılı",
                "description" => "Mesajınız başarıyla gönderildi.",
                "formReset" => true,
                "gRecaptchaReset" => ($captcha) ? true : false,
                "timer" => 3000,
                "confirmButtonText" => "Tamam, Teşekkürler"
            ));
        endif;

    break;
    
    case "urun-arama":

        echo json_encode(array(
            "location" => "/arama?search=".$search,
            "timer" => 1200
        ));

    break;

endswitch;