<?php Class frontend  {

    public function ajax()
    {
        global $db;
        extract($_POST);
        $active_languages = fetchAll("languages[id,code,is_default]");
        $default_language = fetch("languages[id,code]",array("is_default"=>1));
        require "view/frontend/common/ajax.php";
    }

    public function page()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/page/detail.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function service()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/service/detail.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function product()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/product/detail.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function blog()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            contents.view,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;

        // view 1 kez arttırsın aynı ip se 
        if(!isset($_COOKIE["blog_view_{$data->id}"])) {
            $updateView = $db->prepare("UPDATE contents SET view = view + 1 WHERE id = :id");
            $updateView->bindValue(":id", $data->id, PDO::PARAM_INT);
            $updateView->execute();
            setcookie("blog_view_{$data->id}", "1", time() + 3600, "/");
        }

        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/blog/detail.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function reference()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/reference/detail.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function product_category()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/category/product.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }
    
    public function service_category()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/category/service.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }
    
    public function blog_category()
    {
        global $db;
        $dataQuery = "
            SELECT 
            contents.id,
            contents.type,
            contents.theme,
            contents.category,
            contents.image,
            contents.showcase,
            contents.sort,
            contents.parent,
            contents.parent_history,
            contents.status,
            contents.published,
            contents.created,
            contents.updated,
            content_translations.name,
            content_translations.html,
            content_translations.title,
            content_translations.description,
            content_translations.keywords,
            content_translations.is_index,
            content_translations.url,
            content_translations.content,
            content_translations.language
            FROM contents
            INNER JOIN content_translations ON contents.id = content_translations.content
            WHERE content_translations.url = :url
        ";
        $data = $db->prepare($dataQuery);
        $data->bindValue(":url", $_SERVER['SCRIPT_URL'], PDO::PARAM_STR);
        $data->execute();
        $data = $data->fetch(PDO::FETCH_OBJ);
        $title = ($data->title) ? $data->title : $data->name;
        $description = ($data->description) ? $data->description : null;
        $keywords = ($data->keywords) ? $data->keywords : null;
        $image = ($data->image) ? website.$data->image : null;
        $is_index = ($data->is_index) ? "index,follow" : "noindex,nofollow";
        $theme = ($data->theme) ? $data->theme : null;
        $images = fetchAll("files[id,path,sort]", array("master_id"=>$data->id,"file_type[!]"=>"webp"), array("sort"=>"asc"));
        require "view/frontend/common/main.php";
        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        if($data->theme=="custom"): require "view/frontend/layout/custom.php"; endif;
        if(empty($data->theme)): require "view/frontend/category/blog.php"; require "view/frontend/layout/footer.php"; return; endif;
        if($data->theme!="custom"): require "view/frontend/special/{$data->theme}"; endif;
        require "view/frontend/layout/footer.php";
    }

    public function sitemap()
    {
        header("Content-Type: text/xml");
        $pages = fetchAll("content_translations[id,url,content,created,updated]", array("is_index"=>1));
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        foreach ($pages as $page):
            if(fetch("contents[id]", array("id"=>$page->content, "status"=>0))) continue; 
            $url = website . $page->url;
            $lastmod = date("Y-m-d", strtotime($page->updated ? $page->updated : $page->created));
            echo "<url>";
                echo "<loc>$url</loc>";
                echo "<lastmod>$lastmod</lastmod>";
                echo "<priority>0.5</priority>";
            echo "</url>";
        endforeach;
        echo '</urlset>';
    }

    public function hizmetBolgeleri($slug, $id)
    {
        global $db;
        
        $data = [
            "id" => 0,
            "language" => 1,
        ];
        $data = (object) $data;
        require "view/frontend/common/main.php";

        $ilce = fetch("ilceler",array("id"=>$id));

        $title = "İstanbul {$ilce->ilce_adi} Oto Çekici ".$phone;
        $description = "";
        $keywords = "";
        $image = null;
        $is_index = "index,follow";
        $theme = "hizmet_bolgeleri";

        require "view/frontend/layout/head.php";
        require "view/frontend/layout/header.php";
        require "view/frontend/bolgeler/detail.php";
        require "view/frontend/layout/footer.php";
    }

}