<!-- Yapışkan İletişim Butonları -->
<div class="sticky-contact-buttons">
    <?php if(!empty($whatsapp)): ?>
    <a href="https://wa.me/<?=str_replace(array('+', ' ', '(', ')', '-'), '', $whatsapp)?>" target="_blank" rel="noopener noreferrer" class="sticky-btn sticky-whatsapp" aria-label="WhatsApp'tan Yazın" title="WhatsApp'tan Yazın">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
        </svg>
    </a>
    <?php endif; ?>
    
    <?php if(!empty($phone)): ?>
    <a href="tel:<?=$phone?>" class="sticky-btn sticky-phone" aria-label="Bizi Arayın" title="Bizi Arayın: <?=$phone?>">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
        </svg>
    </a>
    <?php endif; ?>
</div>

<footer class="modern-footer" role="contentinfo">
    <div class="footer-top">
        <div class="container">
            <div class="footer-main">
                <div class="footer-brand">
                    <div class="footer-logo">
                        <a href="/" aria-label="Ana sayfa - Loca Spa Masaj"><img src="<?=$logo?>" alt="Loca Spa Masaj - Kırklareli Masaj Salonu"></a>
                    </div>
                    <p class="footer-tagline">Profesyonel Masaj ve Spa Hizmetleri</p>
                    <p class="footer-description">Loca Spa Masaj — Kırklareli'nin en güvenilir ve kaliteli masaj salonu. Rahatlamanın ve dinlenmenin adresi.</p>
                </div>

                <div class="footer-links-group">
                    <div class="footer-column" aria-labelledby="footer-quicklinks">
                        <h4 id="footer-quicklinks" class="footer-title">Hızlı Erişim</h4>
                        <ul class="footer-links">
                            <li><a href="/">Ana Sayfa</a></li>
                            <li><a href="/hizmetlerimiz">Masaj Hizmetlerimiz</a></li>
                            <li><a href="/hakkimizda">Hakkımızda</a></li>
                            <li><a href="/blog">Blog & Makaleler</a></li>
                            <li><a href="/iletisim">Randevu & İletişim</a></li>
                        </ul>
                    </div>

                    <div class="footer-column" aria-labelledby="footer-services">
                        <h4 id="footer-services" class="footer-title">Masaj Türlerimiz</h4>
                        <ul class="footer-links">
                            <li><a href="/hizmetlerimiz#klasik-masaj" title="Klasik Masaj - Kırklareli">Klasik Masaj</a></li>
                            <li><a href="/hizmetlerimiz#aromaterapi" title="Aromaterapi Masaj - Kırklareli">Aromaterapi Masaj</a></li>
                            <li><a href="/hizmetlerimiz#sporcu-masaj" title="Sporcu Masajı - Kırklareli">Sporcu Masajı</a></li>
                            <li><a href="/hizmetlerimiz#hamam" title="Hamam & Kese - Kırklareli">Hamam & Kese</a></li>
                            <li><a href="/hizmetlerimiz#cift-masaj" title="Çift Masajı - Kırklareli">Çift Masajı</a></li>
                            <li><a href="/hizmetlerimiz#refleksoloji" title="Refleksoloji - Kırklareli">Refleksoloji</a></li>
                        </ul>
                    </div>

                    <div class="footer-column" aria-labelledby="footer-regions">
                        <h4 id="footer-regions" class="footer-title">Hizmet Bölgemiz</h4>
                        <div class="regions-content">
                            <p class="region-desc">Kırklareli ve çevre ilçelere profesyonel masaj hizmeti sunuyoruz:</p>
                            <ul class="region-links">
                                <li><a href="/iletisim" title="Loca Spa Masaj - Kırklareli Merkez">Kırklareli Merkez</a></li>
                                <li><a href="/iletisim" title="Loca Spa Masaj - Lüleburgaz">Lüleburgaz</a></li>
                                <li><a href="/iletisim" title="Loca Spa Masaj - Babaeski">Babaeski</a></li>
                                <li><a href="/iletisim" title="Loca Spa Masaj - Vize">Vize</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <div class="footer-bottom-content">
                <p class="footer-copyright">© 2020 - <?=date('Y')?> Loca Spa Masaj. Tüm hakları saklıdır. | Kırklareli'nin En İyi Masaj Salonu</p>
                <div class="footer-credits">
                    <a href="https://baykus.pro" target="_blank" rel="noopener noreferrer">
                        <img src="https://www.baykus.pro/view/frontend/assets/img/logos/logo.svg" alt="Baykus Pro" />
                    </a>
                </div>
            </div>
        </div>
    </div>
</footer>

<!-- footer scripts -->
<script src="/view/backend/assets/library/jquery/jquery.min.js"></script>
<script src="/view/backend/assets/library/sweetalert2/sweetalert2.min.js"></script>
<script src="/view/frontend/layout/required.js"></script>
<script src="/view/frontend/assets/js/app.js"></script>
<script>
    // takip: telefon ve WhatsApp tıklamalarını raporla (Google Analytics dönüşüm)
    document.querySelectorAll('a[href^="tel:"], a[href^="https://wa.me/"]').forEach(function(link) {
        link.addEventListener('click', function(event) {
            if(typeof gtag_report_conversion === 'function'){
                try{ gtag_report_conversion(link.href); }catch(e){ /* ignore */ }
            }
        });
    });
</script>
</body></html>