<!DOCTYPE html>
<html lang="<?=$language->code?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$setting->title?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f1f1f1;
            font-family: 'Poppins', sans-serif;
        }
        .card {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding:50px;
            background-color: #fff;
            max-width: 325px;
            text-align: center;
        }
        @media screen and (max-width: 768px) {
            .card {
                padding: 20px;
            }
        }
        .icon {
            margin-bottom: -10px;
            width: 100px;
        }
        .title {
            font-size: 26px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .description {
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200">
                <rect fill="#000000" stroke="#000000" stroke-width="15" width="30" height="30" x="25" y="85">
                    <animate attributeName="opacity" calcMode="spline" dur="2" values="1;0;1;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="-.4"></animate>
                </rect>
                <rect fill="#000000" stroke="#000000" stroke-width="15" width="30" height="30" x="85" y="85">
                    <animate attributeName="opacity" calcMode="spline" dur="2" values="1;0;1;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="-.2"></animate>
                </rect>
                <rect fill="#000000" stroke="#000000" stroke-width="15" width="30" height="30" x="145" y="85">
                    <animate attributeName="opacity" calcMode="spline" dur="2" values="1;0;1;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="0"></animate>
                </rect>
            </svg>
        </div>
        <div class="title"><?=$setting->title?></div>
        <div class="description"><?=$setting->description?></div>
    </div>
</body>
</html>