$(document).ready(function() {
    $(document).on('submit', '.ajax-form', function() {
        const form = $(this);
        const formData = new FormData(form[0]);
        const action =  form.attr('action');
        formData.append('action', action);
        $.ajax({
            url: '/ajax',
            type: 'POST',
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            beforeSend: function(){
                form.addClass('loading');
            },
            success: function(response)
            {
                form.removeClass('loading');
                const allowOutsideClickResult = response.location || response.refresh || response.back ? false : true;
                if(response.formReset) form[0].reset();
                if(response.closeModal) $('.modal').modal('hide');
                if(response.sweetAlert){
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        html: response.description,
                        timerProgressBar: true,
                        timer: response.timer,
                        showConfirmButton: response.confirmButtonText ? true : false,
                        confirmButtonText: response.confirmButtonText,
                        allowOutsideClick: allowOutsideClickResult,
                        heightAuto: false
                    });
                }
                if(response.refresh) setTimeout(() => { location.reload(); }, response.timer);
                if(response.location) setTimeout(() => { window.location.href = response.location; }, response.timer);
                if(response.back) setTimeout(() => { window.history.back(); }, response.timer);
            },
            error: function(response)
            {
                form.removeClass('loading');
                if(response.status != 200){
                    Swal.fire({
                        icon: 'error',
                        title: 'Hata',
                        html: 'Bir hata oluştu. Lütfen tekrar deneyin.',
                        showConfirmButton: false,
                        timerProgressBar: true,
                        timer: 3000,
                    });
                }
            }
        });
        return false;
    });
});

function changeLanguage(id) {
    const content = document.body.getAttribute('content');
    const language = id;
    $.ajax({
        url: '/ajax',
        type: 'POST',
        data: {
            content: content,
            language: language,
            action: 'dil-degistir'
        },
        dataType: 'json',
        success: function(response) {
            window.location.href = response.location;
        },
        error: function() {
            Swal.fire({
                icon: 'error',
                title: 'Hata',
                html: 'Dil değiştirilemedi. Lütfen tekrar deneyin.',
                showConfirmButton: false,
                timerProgressBar: true,
                timer: 3000,
            });
        }
    });
}