<?php 
    ## $data->name
    ## $data->html
    ## $data->image
    ## $images as $image->path
?>

<div class="page-detail">
    <div class="text-center">
        <h1><?=$data->name?></h1>
    </div>
    <div class="bd-breadcrumb v2 breadcrumb">
        <ol>
            <li><a href="/">Anasayfa</a></li>
            <li><a href="/referanslarimiz">Referanslarımız</a></li>
            <li class="active"><?=$data->name?></li>
        </ol>
    </div>
</div>

<section class="service-detail-page dpy">
    <div class="container" style="max-width:1200px;">
        <div class="row" style="display:flex; flex-wrap:wrap; gap:40px;">
            <!-- Referans Detay -->
            <div class="col-lg-8 col-12" style="flex:2; min-width:320px;">
                <div class="service-detail-box" style="background:#fff; border-radius:12px; box-shadow:0 4px 24px rgba(0,0,0,0.07); padding:32px 28px; margin-bottom:32px;">
                    <?php if($data->image): ?>
                        <img src="<?=$data->image?>" alt="<?=$data->name?>" style="width:100%; max-height:340px; object-fit:cover; border-radius:10px; margin-bottom:24px;">
                    <?php endif; ?>
                    <h1 style="font-size:2.2rem; font-weight:600; margin-bottom:18px; color:#222;"> <?=$data->name?> </h1>
                    <div class="service-content" style="font-size:1.1rem; color:#444; line-height:1.7;">
                        <?= $data->html ?>
                    </div>
                    <?php if(!empty($images)): ?>
                        <div class="reference-gallery" style="margin-top:24px; display:flex; flex-wrap:wrap; gap:16px;">
                            <?php foreach($images as $image): ?>
                                <img src="<?=$image->path?>" alt="<?=$data->name?>" style="width:120px; height:90px; object-fit:cover; border-radius:6px;">
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Diğer Referanslar -->
            <div class="col-lg-4 col-12" style="flex:1; min-width:280px;">
                <div class="other-services-box" style="background:#f8fafd; border-radius:12px; box-shadow:0 2px 12px rgba(0,0,0,0.04); padding:24px 18px;">
                    <h3 style="font-size:1.3rem; font-weight:600; margin-bottom:18px; color:#00b7ff;">Diğer Referanslar</h3>
                    <div class="other-services-list" style="display:flex; flex-direction:column; gap:18px;">
                        <?php
                        $other_references = fetchAll("contents[id,image]", ["type"=>"reference", "status"=>1, "id[!]"=>$data->id], ["sort"=>"asc"], 6);
                        foreach($other_references as $ref):
                            $ref_tr = fetch("content_translations[name,url]", ["content"=>$ref->id, "language"=>$data->language]);
                        ?>
                        <a href="<?=$ref_tr->url?>" class="other-service-card" style="display:flex; align-items:center; gap:14px; background:#fff; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.03); padding:10px 12px; text-decoration:none; color:#222; transition:.2s;">
                            <?php if($ref->image): ?>
                                <img src="<?=$ref->image?>" alt="<?=$ref_tr->name?>" style="width:54px; height:54px; object-fit:cover; border-radius:7px;">
                            <?php endif; ?>
                            <span style="font-weight:500; font-size:1.05rem;"> <?=$ref_tr->name?> </span>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>