<div class="fixle"></div>

<div class="hero-section with-breadcrumb">
    <div class="container">
        <div class="breadcrumb-wrapper">
            <nav class="modern-breadcrumb">
                <a href="/">Anasayfa</a>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M6 12L10 8L6 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <a href="/hizmetlerimiz">Hizmetlerimiz</a>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path d="M6 12L10 8L6 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <span class="active"><?=$data->name?></span>
            </nav>
        </div>
        <div class="hero-content-detail">
            <h1 class="detail-title"><?=$data->name?></h1>
            <p class="detail-subtitle"><?=$data->name?> - Profesyonel güzellik ve bakım hizmeti</p>
        </div>
    </div>
</div>

<section class="service-detail-content">
    <div class="container">
        <div class="detail-grid">
            <div class="main-content">
                <?php if($data->image): ?>
                    <div class="detail-image-wrapper">
                        <img src="<?=$data->image?>" alt="<?=$data->name?>" class="detail-image">
                        <div class="image-overlay"></div>
                    </div>
                <?php endif; ?>
                
                <div class="content-box">
                    <div class="service-html-content">
                        <?= $data->html ?>
                    </div>
                </div>

                <div class="service-cta-box">
                    <div class="cta-box-content">
                        <h3>Hizmet İçin Randevu Almak İster Misiniz?</h3>
                        <p>Profesyonel bakım ve estetik hizmetleri için hemen randevu alabilirsiniz.</p>
                        <div class="cta-box-buttons">
                            <a href="/iletisim" class="cta-box-btn primary">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                    <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                </svg>
                                <span>Randevu Al</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <aside class="sidebar-content">
                <div class="sidebar-box other-services-sidebar">
                    <h3 class="sidebar-title">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <span>Diğer Hizmetlerimiz</span>
                    </h3>
                    <div class="sidebar-services-list">
                        <?php
                        $other_services = fetchAll("contents[id,image]", ["type"=>"service", "status"=>1, "id[!]"=>$data->id], ["sort"=>"asc"], 8);
                        foreach($other_services as $srv):
                            $srv_tr = fetch("content_translations[name,url]", ["content"=>$srv->id, "language"=>$data->language]);
                        ?>
                        <a href="<?=$srv_tr->url?>" class="sidebar-service-item">
                            <?php if($srv->image): ?>
                                <div class="sidebar-service-image">
                                    <img src="<?=$srv->image?>" alt="<?=$srv_tr->name?>">
                                </div>
                            <?php endif; ?>
                            <div class="sidebar-service-info">
                                <span class="sidebar-service-name"><?=$srv_tr->name?></span>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M6 12L10 8L6 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </a>
                        <?php endforeach; ?>
                    </div>
                    <a href="/hizmetlerimiz" class="view-all-services">
                        <span>Diğer Tüm Hizmetler</span>
                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none">
                            <path d="M6.75 13.5L11.25 9L6.75 4.5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>

          
            </aside>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Fade in animation for main content
    const mainContent = document.querySelector('.main-content');
    const sidebarContent = document.querySelector('.sidebar-content');
    
    if (mainContent) {
        mainContent.style.opacity = '0';
        mainContent.style.transform = 'translateY(30px)';
        mainContent.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        
        setTimeout(() => {
            mainContent.style.opacity = '1';
            mainContent.style.transform = 'translateY(0)';
        }, 100);
    }
    
    if (sidebarContent) {
        sidebarContent.style.opacity = '0';
        sidebarContent.style.transform = 'translateY(30px)';
        sidebarContent.style.transition = 'opacity 0.6s ease 0.2s, transform 0.6s ease 0.2s';
        
        setTimeout(() => {
            sidebarContent.style.opacity = '1';
            sidebarContent.style.transform = 'translateY(0)';
        }, 100);
    }

    // Smooth scroll for sidebar links
    const sidebarLinks = document.querySelectorAll('.sidebar-service-item, .view-all-services');
    sidebarLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            if (this.getAttribute('href').startsWith('#')) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            }
        });
    });
});
</script>