<div class="fixle"></div>

<div class="hero-section">
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Blog</h1>
            <p class="hero-subtitle">Loca Spa Masaj'da Sunduğumuz Profesyonel Masaj ve Spa Blog</p>
        </div>
    </div>
</div>

<section class="blogs-content mt-5">
    <div class="container">
        <div class="blogs-grid">
            <div class="main-content-blogs">
                <?php
                $blogs = fetchAll("contents[id,image,created]", ["type"=>"blog", "status"=>1], ["created"=>"desc"], 12);
                if(!empty($blogs)):
                    foreach($blogs as $blog):
                        $blog_tr = fetch("content_translations[name,url,html]", ["content"=>$blog->id]);
                ?>
                <article class="blog-card-modern">
                    <?php if($blog->image): ?>
                        <a href="<?=$blog_tr->url?>" class="blog-card-image">
                            <img src="<?=$blog->image?>" alt="<?=$blog_tr->name?>">
                            <div class="blog-image-overlay"></div>
                        </a>
                    <?php endif; ?>
                    <div class="blog-card-content">
                        <div class="blog-meta">
                            <span class="blog-date">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                    <line x1="16" y1="2" x2="16" y2="6"></line>
                                    <line x1="8" y1="2" x2="8" y2="6"></line>
                                    <line x1="3" y1="10" x2="21" y2="10"></line>
                                </svg>
                                <?=date('d.m.Y', strtotime($blog->created))?>
                            </span>
                        </div>
                        <h2 class="blog-card-title">
                            <a href="<?=$blog_tr->url?>"><?=$blog_tr->name?></a>
                        </h2>
                        <p class="blog-card-excerpt">
                            <?=mb_substr(strip_tags($blog_tr->html), 0, 160, 'UTF-8')?>...
                        </p>
                        <a href="<?=$blog_tr->url?>" class="blog-read-more">
                            <span>Devamını Oku</span>
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none">
                                <path d="M6.75 13.5L11.25 9L6.75 4.5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                </article>
                <?php 
                    endforeach;
                else:
                ?>
                <div class="no-blogs">
                    <p>Henüz yayınlanmış bir yazı bulunmamaktadır.</p>
                </div>
                <?php endif; ?>
            </div>

            <aside class="sidebar-content-blogs">
                <div class="sidebar-box popular-blogs-sidebar">
                    <h3 class="sidebar-title">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="9" cy="7" r="4"></circle>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                        </svg>
                        <span>Popüler Yazılar</span>
                    </h3>
                    <div class="sidebar-blogs-list">
                        <?php
                        $popular_blogs = fetchAll("contents[id,image,view]", ["type"=>"blog", "status"=>1], ["view"=>"desc"], 5);
                        foreach($popular_blogs as $pblog):
                            $pblog_tr = fetch("content_translations[name,url]", ["content"=>$pblog->id]);
                        ?>
                        <a href="<?=$pblog_tr->url?>" class="sidebar-blog-item">
                            <?php if($pblog->image): ?>
                                <div class="sidebar-blog-image">
                                    <img src="<?=$pblog->image?>" alt="<?=$pblog_tr->name?>">
                                </div>
                            <?php endif; ?>
                            <div class="sidebar-blog-info">
                                <span class="sidebar-blog-name"><?=$pblog_tr->name?></span>
                                <div class="sidebar-blog-views">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                    <span><?=$pblog->view ?? 0?> görüntülenme</span>
                                </div>
                            </div>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>

            </aside>
        </div>
    </div>
</section>

<style>
/* Blogs Hero Section - Ortak CSS dosyasından yönetiliyor */

.blogs-intro {
    padding: 0 0 60px 0;
}

.intro-content {
    max-width: 800px;
    margin: 0 auto;
    text-align: center;
}

.intro-content p {
    font-size: 1.1rem;
    line-height: 1.8;
    color: var(--light-text);
}

/* Blogs Content */
.blogs-content {
    padding: 0 0 80px 0;
}

.blogs-grid {
    display: grid;
    grid-template-columns: 1fr 380px;
    gap: 40px;
}

.main-content-blogs {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

/* Blog Card */
.blog-card-modern {
    background: #ffffff;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
    display: grid;
    grid-template-columns: 280px 1fr;
}

.blog-card-modern:hover {
    transform: translateY(-4px);
    box-shadow: 0 12px 40px rgba(102, 185, 81, 0.15);
}

.blog-card-image {
    position: relative;
    height: 100%;
    min-height: 220px;
    overflow: hidden;
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ecf1 100%);
}

.blog-card-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.6s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

.blog-card-modern:hover .blog-card-image img {
    transform: scale(1.08);
}

.blog-image-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(to bottom, transparent 0%, rgba(0, 0, 0, 0.1) 100%);
}

.blog-card-content {
    padding: 30px;
    display: flex;
    flex-direction: column;
}

.blog-meta {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
}

.blog-date {
    display: flex;
    align-items: center;
    gap: 6px;
    color: var(--main-clr);
    font-size: 0.9rem;
    font-weight: 500;
}

.blog-date svg {
    stroke: var(--main-clr);
}

.blog-card-title {
    margin-bottom: 15px;
}

.blog-card-title a {
    color: var(--dark-text);
    font-size: 1.5rem;
    font-weight: 700;
    text-decoration: none;
    line-height: 1.4;
    transition: color 0.3s ease;
    display: block;
}

.blog-card-title a:hover {
    color: var(--main-clr);
}

.blog-card-excerpt {
    color: var(--light-text);
    font-size: 0.95rem;
    line-height: 1.7;
    margin-bottom: 20px;
    flex-grow: 1;
}

.blog-read-more {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: var(--main-clr);
    font-weight: 600;
    font-size: 0.95rem;
    text-decoration: none;
    transition: all 0.3s ease;
    align-self: flex-start;
}

.blog-read-more:hover {
    gap: 12px;
    color: #4a9539;
}

.blog-read-more svg {
    transition: transform 0.3s ease;
}

.blog-read-more:hover svg {
    transform: translateX(3px);
}

/* No Blogs Message */
.no-blogs {
    text-align: center;
    padding: 60px 20px;
    color: var(--light-text);
    font-size: 1.1rem;
}

/* Sidebar */
.sidebar-content-blogs {
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.sidebar-box {
    background: #ffffff;
    border-radius: 16px;
    padding: 30px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
}

.popular-blogs-sidebar {
    position: sticky;
    top: 100px;
}

.sidebar-title {
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--dark-text);
    font-size: 1.2rem;
    font-weight: 700;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid var(--main-clr);
}

.sidebar-title svg {
    stroke: var(--main-clr);
    flex-shrink: 0;
}

.sidebar-blogs-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.sidebar-blog-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: #f8f9fa;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
    border: 1px solid transparent;
}

.sidebar-blog-item:hover {
    background: linear-gradient(135deg, rgba(102, 185, 81, 0.08) 0%, rgba(74, 149, 57, 0.05) 100%);
    border-color: var(--main-clr);
    transform: translateX(5px);
    box-shadow: 0 4px 15px rgba(102, 185, 81, 0.1);
}

.sidebar-blog-image {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    overflow: hidden;
    flex-shrink: 0;
}

.sidebar-blog-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.sidebar-blog-item:hover .sidebar-blog-image img {
    transform: scale(1.1);
}

.sidebar-blog-info {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.sidebar-blog-name {
    color: var(--dark-text);
    font-size: 0.95rem;
    font-weight: 500;
    line-height: 1.4;
}

.sidebar-blog-views {
    display: flex;
    align-items: center;
    gap: 6px;
    color: #999;
    font-size: 0.8rem;
}

.sidebar-blog-views svg {
    stroke: #999;
}

/* CTA Sidebar */
.cta-blogs-sidebar {
    background: linear-gradient(135deg, #2c3e50 0%, #1a252f 100%);
}

.cta-blogs-sidebar .sidebar-title {
    color: #ffffff;
    border-bottom-color: var(--main-clr);
}

.cta-blogs-sidebar .sidebar-title.light svg {
    stroke: var(--main-clr);
}

.cta-sidebar-text {
    color: rgba(255, 255, 255, 0.85);
    font-size: 0.95rem;
    line-height: 1.6;
    margin-bottom: 20px;
}

.cta-sidebar-buttons {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.cta-sidebar-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    padding: 12px 20px;
    border-radius: 10px;
    font-weight: 600;
    font-size: 0.95rem;
    text-decoration: none;
    transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

.cta-sidebar-btn.primary {
    background: var(--main-clr);
    color: #ffffff;
}

.cta-sidebar-btn.primary:hover {
    background: #4a9539;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 185, 81, 0.3);
    color: #ffffff;
}

.cta-sidebar-btn.secondary {
    background: #25D366;
    color: #ffffff;
}

.cta-sidebar-btn.secondary:hover {
    background: #1ebe5a;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(37, 211, 102, 0.3);
    color: #ffffff;
}

/* Responsive Design */
@media (max-width: 1024px) {
    .blogs-grid {
        grid-template-columns: 1fr;
    }

    .popular-blogs-sidebar {
        position: static;
        top: auto;
    }

    .sidebar-content-blogs {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    /* Hero responsive - Ortak CSS dosyasından yönetiliyor */

    .blogs-intro {
        padding: 0 0 40px 0;
    }

    .intro-content p {
        font-size: 1rem;
    }

    .blogs-content {
        padding: 0 0 60px 0;
    }

    .blog-card-modern {
        grid-template-columns: 1fr;
    }

    .blog-card-image {
        height: 220px;
        min-height: 220px;
    }

    .blog-card-content {
        padding: 25px;
    }

    .blog-card-title a {
        font-size: 1.3rem;
    }

    .sidebar-content-blogs {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    /* Hero mobil - Ortak CSS dosyasından yönetiliyor */

    .blog-card-content {
        padding: 20px;
    }

    .blog-card-title a {
        font-size: 1.2rem;
    }

    .sidebar-box {
        padding: 20px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const blogCards = document.querySelectorAll('.blog-card-modern');
    
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);
    
    blogCards.forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(30px)';
        card.style.transition = `opacity 0.6s ease ${index * 0.1}s, transform 0.6s ease ${index * 0.1}s`;
        observer.observe(card);
    });
});
</script>
