<div class="fixle"></div>

<div class="hero-section">
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Randevu & İletişim</h1>
            <p class="hero-subtitle">Loca Spa Masaj'da rahatlama deneyimi için hemen randevu alın. Kırklareli'nin en iyi masaj salonunda sizi bekliyoruz!</p>
        </div>
    </div>
</div>

<section class="contact-content">
    <div class="container">
        <!-- İletişim Bilgileri Kartları -->
        <div class="contact-info-cards">
            <div class="info-card">
                <div class="info-card-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                        <circle cx="12" cy="10" r="3"></circle>
                    </svg>
                </div>
                <h3 class="info-card-title">Adres</h3>
                <p class="info-card-text"><?=$address?></p>
            </div>

            <div class="info-card">
                <div class="info-card-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                    </svg>
                </div>
                <h3 class="info-card-title">Telefon</h3>
                <a href="tel:<?=$phone?>" class="info-card-link"><?=$phone?></a>
            </div>

            <div class="info-card">
                <div class="info-card-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                        <polyline points="22,6 12,13 2,6"></polyline>
                    </svg>
                </div>
                <h3 class="info-card-title">E-Posta</h3>
                <a href="mailto:<?=$email?>" class="info-card-link"><?=$email?></a>
            </div>

        </div>

        <!-- Form ve Sidebar -->
        <div class="contact-grid">
            <div class="contact-main">
                <div class="contact-form-wrapper">
                    <div class="form-header">
                        <h2>Masaj Randevusu Alın</h2>
                        <p>Randevu almak için formu doldurun, size en uygun zamanı hemen ayarlayalım. Kırklareli'nin en iyi masaj salonunda rahatlamanın keyfini çıkarın!</p>
                    </div>
                    
                    <form action="iletisim-formu" class="ajax-form modern-contact-form">
                        <div class="form-row">
                            <div class="form-group full-width">
                                <label for="name">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    <span>Adınız Soyadınız</span>
                                    <span class="required">*</span>
                                </label>
                                <input type="text" id="name" name="data[name]" class="form-input" placeholder="Adınızı ve soyadınızı girin" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="email">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                        <polyline points="22,6 12,13 2,6"></polyline>
                                    </svg>
                                    <span>E-Posta</span>
                                    <span class="required">*</span>
                                </label>
                                <input type="email" id="email" name="data[email]" class="form-input" placeholder="E-posta adresiniz" required>
                            </div>

                            <div class="form-group">
                                <label for="phone">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                                    </svg>
                                    <span>Telefon</span>
                                </label>
                                <input type="tel" id="phone" name="data[phone]" class="form-input" placeholder="Telefon numaranız">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group full-width">
                                <label for="message">
                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                    </svg>
                                    <span>Mesajınız</span>
                                    <span class="required">*</span>
                                </label>
                                <textarea id="message" name="data[message]" class="form-input" rows="5" placeholder="Lütfen durumunuzu ve beklentilerinizi kısaca açıklayın..." required></textarea>
                                <small class="form-hint">Gizliliğiniz bizim için önemlidir. Tüm bilgileriniz güvenle saklanır.</small>
                            </div>
                        </div>

                        <button type="submit" class="form-submit-btn">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="22" y1="2" x2="11" y2="13"></line>
                                <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                            </svg>
                            <span>Formu Gönder</span>
                        </button>
                    </form>
                </div>
            </div>

            <aside class="contact-sidebar">
                <div class="sidebar-box working-hours">
                    <h3 class="sidebar-title">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        <span>Çalışma Saatleri</span>
                    </h3>
                    <div class="working-hours-list">
                        <div class="hours-item">
                            <span class="day">Pazartesi - Cuma</span>
                            <span class="time active">12:00 - 00:00</span>
                        </div>
                        <div class="hours-item">
                            <span class="day">Cumartesi</span>
                            <span class="time active">12:00 - 00:00</span>
                        </div>
                        <div class="hours-item">
                            <span class="day">Pazar</span>
                            <span class="time active">12:00 - 00:00</span>
                        </div>
                    </div>
                </div>


                <div class="sidebar-box map-box">
                    <h3 class="sidebar-title">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                        <span>Konum</span>
                    </h3>
                    <div class="map-wrapper">
                        <iframe src="<?=$map?>" width="100%" height="280" style="border:0; border-radius: 12px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                    <?php 
                        $directions = "https://www.google.com/maps/dir//" . urlencode($address);
                    ?>
                    <a href="<?=$directions?>" target="_blank" class="directions-btn">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polygon points="3 11 22 2 13 21 11 13 3 11"></polygon>
                        </svg>
                        <span>Yol Tarifi Al</span>
                    </a>
                </div>

        
            </aside>
        </div>
    </div>
</section>
    <style>
        /* Contact Form Styling */
        .form-control {
            border: 2px solid #e9ecef !important;
            transition: all 0.3s ease !important;
        }

        .form-control:focus {
            border-color: var(--secondary-clr) !important;
            box-shadow: 0 0 0 3px rgba(0, 183, 255, 0.1) !important;
            outline: none !important;
        }

        .form-group label {
            font-weight: 600;
            color: #1a1a1a;
            font-size: 0.95rem;
        }

        /* Info Cards Hover */
        .info-card {
            cursor: pointer;
        }

        .info-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 32px rgba(0, 183, 255, 0.15);
            border-color: var(--secondary-clr);
            background: linear-gradient(135deg, rgba(0, 183, 255, 0.15) 0%, rgba(0, 217, 255, 0.08) 100%);
        }

        /* Submit Button */
        .contact-submit-btn:hover {
            background: linear-gradient(135deg, #0099cc 0%, #007fa3 100%);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(0, 183, 255, 0.3);
        }

        .contact-submit-btn:active {
            transform: translateY(0);
        }

        /* Contact Boxes */
        .contact-form-box:hover {
            box-shadow: 0 12px 40px rgba(0, 183, 255, 0.12);
            border-color: rgba(0, 183, 255, 0.2);
        }

        .contact-info-box:hover {
            box-shadow: 0 12px 40px rgba(0, 183, 255, 0.12);
            border-color: rgba(0, 183, 255, 0.2);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .contact-page {
                padding-top: 2rem;
                padding-bottom: 2rem;
            }

            .contact-info-cards {
                grid-template-columns: 1fr !important;
            }

            .row {
                flex-direction: column !important;
            }

            .form-group label {
                font-size: 0.9rem;
            }

            .info-card {
                padding: 1.5rem !important;
            }

            .contact-submit-btn {
                padding: 0.85rem 1.5rem !important;
            }
        }

        @media (max-width: 576px) {
            .contact-info-cards {
                gap: 16px;
            }

            .info-card div:first-child {
                font-size: 2rem !important;
            }

            .contact-form-box,
            .contact-info-box {
                padding: 1.5rem 1rem !important;
            }
        }
    </style>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // URL parametrelerini al
            const urlParams = new URLSearchParams(window.location.search);
            const semt = urlParams.get('semt');
            const mahalle = urlParams.get('mahalle');
            
            // Form alanlarını doldur
            if(semt) {
                document.getElementById('semt').value = decodeURIComponent(semt);
            }
            if(mahalle) {
                document.getElementById('mahalle').value = decodeURIComponent(mahalle);
            }
        });
    </script>
</section>