<section class="bd-entry video" >
    <video id="hero-video" autoplay muted loop playsinline>
        <source id="hero-source" src="view/frontend/assets/desktop.mp4" type="video/mp4">
    </video>
    <script>
        (function(){
            var video = document.getElementById('hero-video');
            var source = document.getElementById('hero-source');
            function setVideo(){
                var isMobile = window.matchMedia && window.matchMedia('(max-width: 767px)').matches;
                var src = isMobile ? 'view/frontend/assets/mobile.mp4' : 'view/frontend/assets/desktop.mp4';
                if(source.getAttribute('src') !== src){
                    source.setAttribute('src', src);
                    video.load();
                    video.play().catch(function(){});
                }
            }
            setVideo();
            window.addEventListener('resize', setVideo);
        })();
    </script>
</section>

<?php 
    $hizmetler = "select";
    $hizmetler .= " contents.id, ";
    $hizmetler .= " contents.image, ";
    $hizmetler .= " content_translations.name, ";
    $hizmetler .= " content_translations.html, ";
    $hizmetler .= " content_translations.url ";
    $hizmetler .= " from contents ";
    $hizmetler .= " inner join content_translations on contents.id = content_translations.content ";
    $hizmetler .= " where contents.type = 'service' ";
    $hizmetler .= " and contents.status = 1 ";
    $hizmetler .= " order by contents.created asc";
    $hizmetler_query = $db->query($hizmetler);
    $hizmetler_list = $hizmetler_query->fetchAll(PDO::FETCH_OBJ);
?>

<div class="services-features">
    <div class="container">
        <div class="features-grid">
            <div class="feature-item">
                <div class="feature-icon">🧘‍♀️</div>
                <h3>Uzman Masözler</h3>
                <p>Deneyimli ve sertifikalı masaj terapistleri</p>
            </div>
            <div class="feature-item">
                <div class="feature-icon">✨</div>
                <h3>Hijyenik Ortam</h3>
                <p>Her seans öncesi hijyen ve temizlik garantisi</p>
            </div>
            <div class="feature-item">
                <div class="feature-icon">🌿</div>
                <h3>Doğal Ürünler</h3>
                <p>Kaliteli aromaterapi yağları ve organik ürünler</p>
            </div>
            <div class="feature-item">
                <div class="feature-icon">💆</div>
                <h3>Kişiye Özel</h3>
                <p>İhtiyaçlarınıza göre özelleştirilmiş masaj</p>
            </div>
        </div>
    </div>
</div>

<div class="services-intro">
    <div class="container">
        <div class="intro-content">
            <h2>Kırklareli'de Masaj ve Spa</h2>
            <p>Loca Spa Masaj, Kırklareli'de profesyonel masaj ve spa hizmetleri sunan öncü bir masaj salonudur. Klasik masaj, aromaterapi, sporcu masajı, hamam, kese, çift masajı, refleksoloji ve daha birçok özel masaj tekniğiyle stres ve gerginlikten arınmanızı sağlıyoruz.</p>
            <p>Deneyimli masözlerimiz, hijyenik ortamımız ve kaliteli yağlarımızla size en iyi hizmeti sunuyoruz. İster rahatlamak, ister kaslarınızı gevşetmek, ister kendinize özel bir spa deneyimi yaşamak isteyin - Loca Spa Masaj tam size göre!</p>
        </div>
    </div>
</div>

<div class="services-container">
    <div class="container">
        <?php if(!empty($hizmetler_list)): ?>
            <div class="services-grid">
                <?php foreach($hizmetler_list as $index => $hizmet): ?>
                    <div class="service-card">
                        <?php if(!empty($hizmet->image)): ?>
                            <div class="service-image">
                                <img src="<?= htmlspecialchars($hizmet->image) ?>" alt="<?= htmlspecialchars($hizmet->name) ?>">
                                <div class="service-overlay"></div>
                            </div>
                        <?php endif; ?>
                        <div class="service-content">
                            <h3 class="service-title"><?= htmlspecialchars($hizmet->name) ?></h3>
                            <div class="service-description">
                                <?=mb_substr(strip_tags($hizmet->html), 0, 90, 'UTF-8') ?>...
                            </div>
                            <a href="<?= htmlspecialchars($hizmet->url) ?>" class="service-link">
                                <span>Detaylı Bilgi</span>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="no-services">
                <p>Şu anda görüntülenecek hizmet bulunmamaktadır.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
