<?php 
    $hizmetler = "select";
    $hizmetler .= " contents.id, ";
    $hizmetler .= " contents.image, ";
    $hizmetler .= " content_translations.name, ";
    $hizmetler .= " content_translations.html, ";
    $hizmetler .= " content_translations.url ";
    $hizmetler .= " from contents ";
    $hizmetler .= " inner join content_translations on contents.id = content_translations.content ";
    $hizmetler .= " where contents.type = 'service' ";
    $hizmetler .= " and contents.status = 1 ";
    $hizmetler .= " order by contents.created asc";
    $hizmetler_query = $db->query($hizmetler);
    $hizmetler_list = $hizmetler_query->fetchAll(PDO::FETCH_OBJ);
?>

<div class="fixle"></div>

<div class="hero-section">
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Masaj Hizmetlerimiz</h1>
            <p class="hero-subtitle">Loca Spa Masaj'da Sunduğumuz Profesyonel Masaj ve Spa Hizmetleri</p>
        </div>
    </div>
</div>

<div class="services-container">
    <div class="container">
        <?php if(!empty($hizmetler_list)): ?>
            <div class="services-grid">
                <?php foreach($hizmetler_list as $index => $hizmet): ?>
                    <div class="service-card">
                        <?php if(!empty($hizmet->image)): ?>
                            <div class="service-image">
                                <img src="<?= htmlspecialchars($hizmet->image) ?>" alt="<?= htmlspecialchars($hizmet->name) ?>">
                                <div class="service-overlay"></div>
                            </div>
                        <?php endif; ?>
                        <div class="service-content">
                            <h3 class="service-title"><?= htmlspecialchars($hizmet->name) ?></h3>
                            <div class="service-description">
                                <?=mb_substr(strip_tags($hizmet->html), 0, 90, 'UTF-8') ?>...
                            </div>
                            <a href="<?= htmlspecialchars($hizmet->url) ?>" class="service-link">
                                <span>Detaylı Bilgi</span>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="no-services">
                <p>Şu anda görüntülenecek hizmet bulunmamaktadır.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
